/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import jakarta.servlet.http.HttpServletRequest;
import java.io.StringWriter;
import java.io.Writer;
import org.alfresco.repo.web.scripts.transfer.CommandProcessor;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.json.JSONWriter;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class PrepareTransferCommandProcessor
implements CommandProcessor {
    private static final String MSG_CAUGHT_UNEXPECTED_EXCEPTION = "transfer_service.receiver.caught_unexpected_exception";
    private static Log logger = LogFactory.getLog(PrepareTransferCommandProcessor.class);
    private TransferReceiver receiver;

    @Override
    public int process(WebScriptRequest req, WebScriptResponse resp) {
        String transferRecordId = null;
        WebScriptServletRequest webScriptServletRequest = null;
        Object current = req;
        do {
            if (current instanceof WebScriptServletRequest) {
                webScriptServletRequest = (WebScriptServletRequest)current;
                current = null;
                continue;
            }
            current = current instanceof WrappingWebScriptRequest ? ((WrappingWebScriptRequest)req).getNext() : null;
        } while (current != null);
        HttpServletRequest servletRequest = webScriptServletRequest.getHttpServletRequest();
        String transferId = servletRequest.getParameter("transferId");
        if (transferId == null) {
            logger.debug((Object)"transferId is missing");
            resp.setStatus(400);
            return 400;
        }
        try {
            logger.debug((Object)("prepare transferId: " + transferId));
            this.receiver.prepare(transferId);
            StringWriter stringWriter = new StringWriter(300);
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.startObject();
            jsonWriter.writeValue("transferId", transferRecordId);
            jsonWriter.endObject();
            String response = stringWriter.toString();
            resp.setContentType("application/json");
            resp.setContentEncoding("UTF-8");
            int length = response.getBytes("UTF-8").length;
            resp.addHeader("Content-Length", "" + length);
            resp.setStatus(200);
            resp.getWriter().write(response);
            logger.debug((Object)("prepared transferId: " + transferId));
            return 200;
        }
        catch (Exception ex) {
            logger.debug((Object)"in exception handler", (Throwable)ex);
            this.receiver.end(transferRecordId);
            if (ex instanceof TransferException) {
                throw (TransferException)((Object)ex);
            }
            throw new TransferException(MSG_CAUGHT_UNEXPECTED_EXCEPTION, (Throwable)ex);
        }
    }

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }
}

