/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.Collections;
import junit.framework.TestCase;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.impl.rules.RuleSettingsImpl;
import org.alfresco.rest.api.model.rules.RuleSetting;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class RuleSettingsImplTest
extends TestCase {
    private static final String FOLDER_ID = "dummy-folder-id";
    private static final NodeRef FOLDER_NODE = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-folder-id");
    @InjectMocks
    private RuleSettingsImpl ruleSettings;
    @Mock
    private NodeValidator nodeValidatorMock;
    @Mock
    private NodeService nodeServiceMock;

    @Before
    public void setUp() {
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.eq((Object)FOLDER_ID), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE);
    }

    @Test
    public void testGetRuleSetting_disabled() {
        BDDMockito.given((Object)this.nodeServiceMock.hasAspect(FOLDER_NODE, RuleModel.ASPECT_IGNORE_INHERITED_RULES)).willReturn((Object)true);
        RuleSetting ruleSetting = this.ruleSettings.getRuleSetting(FOLDER_ID, "-isInheritanceEnabled-");
        RuleSetting expected = RuleSetting.builder().key("-isInheritanceEnabled-").value((Object)false).create();
        RuleSettingsImplTest.assertEquals((Object)expected, (Object)ruleSetting);
    }

    @Test
    public void testGetRuleSetting_enabled() {
        BDDMockito.given((Object)this.nodeServiceMock.hasAspect(FOLDER_NODE, RuleModel.ASPECT_IGNORE_INHERITED_RULES)).willReturn((Object)false);
        RuleSetting ruleSetting = this.ruleSettings.getRuleSetting(FOLDER_ID, "-isInheritanceEnabled-");
        RuleSetting expected = RuleSetting.builder().key("-isInheritanceEnabled-").value((Object)true).create();
        RuleSettingsImplTest.assertEquals((Object)expected, (Object)ruleSetting);
    }

    @Test
    public void testGetRuleSetting_unrecognisedKey() {
        Assertions.assertThatExceptionOfType(NotFoundException.class).isThrownBy(() -> this.ruleSettings.getRuleSetting(FOLDER_ID, "-fakeSetting-"));
    }

    @Test
    public void testSetRuleSetting_enable() {
        RuleSetting ruleSetting = RuleSetting.builder().key("-isInheritanceEnabled-").value((Object)true).create();
        RuleSetting actual = this.ruleSettings.setRuleSetting(FOLDER_ID, ruleSetting);
        RuleSettingsImplTest.assertEquals((Object)ruleSetting, (Object)actual);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).removeAspect(FOLDER_NODE, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
    }

    @Test
    public void testSetRuleSetting_disable() {
        RuleSetting ruleSetting = RuleSetting.builder().key("-isInheritanceEnabled-").value((Object)false).create();
        RuleSetting actual = this.ruleSettings.setRuleSetting(FOLDER_ID, ruleSetting);
        RuleSettingsImplTest.assertEquals((Object)ruleSetting, (Object)actual);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).addAspect(FOLDER_NODE, RuleModel.ASPECT_IGNORE_INHERITED_RULES, Collections.emptyMap());
    }

    @Test
    public void testSetRuleSetting_unrecognisedKey() {
        RuleSetting ruleSetting = RuleSetting.builder().key("-fakeSetting-").value((Object)true).create();
        Assertions.assertThatExceptionOfType(NotFoundException.class).isThrownBy(() -> this.ruleSettings.setRuleSetting(FOLDER_ID, ruleSetting));
    }

    @Test
    public void testSetRuleSetting_nonBooleanValue() {
        RuleSetting ruleSetting = RuleSetting.builder().key("-isInheritanceEnabled-").value((Object)123456).create();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.ruleSettings.setRuleSetting(FOLDER_ID, ruleSetting));
    }
}

