/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.util.Collections;
import junit.framework.TestCase;
import org.alfresco.rest.api.search.SearchSQLApiWebscript;
import org.alfresco.rest.api.search.model.SearchSQLQuery;
import org.alfresco.service.cmr.search.SearchParameters;
import org.junit.Test;

public class SearchSQLApiWebscriptTests {
    static SearchSQLApiWebscript webscript = new SearchSQLApiWebscript();

    @Test
    public void testSearchQueryParams() throws Exception {
        String query = "select SITE from alfresco";
        SearchSQLQuery searchQuery = new SearchSQLQuery(query, "solr", Collections.emptyList(), Integer.valueOf(1000), false, "", Collections.emptyList());
        SearchParameters sparams = webscript.buildSearchParameters(searchQuery);
        TestCase.assertNotNull((Object)sparams);
        TestCase.assertEquals((String)query, (String)sparams.getQuery());
        TestCase.assertEquals((boolean)false, (boolean)sparams.isIncludeMetadata());
        TestCase.assertEquals((Object)Collections.EMPTY_LIST, (Object)sparams.getLocales());
        TestCase.assertEquals((String)"solr", (String)((String)sparams.getExtraParameters().get("format")));
        TestCase.assertEquals(null, (String)sparams.getTimezone());
    }

    @Test
    public void testSearchQueryParamsTimezone() throws Exception {
        String query = "select SITE from alfresco";
        SearchSQLQuery searchQuery = new SearchSQLQuery(query, "solr", Collections.emptyList(), Integer.valueOf(1000), false, "Israel", Collections.emptyList());
        SearchParameters sparams = webscript.buildSearchParameters(searchQuery);
        TestCase.assertNotNull((Object)sparams);
        TestCase.assertEquals((String)query, (String)sparams.getQuery());
        TestCase.assertEquals((boolean)false, (boolean)sparams.isIncludeMetadata());
        TestCase.assertEquals((Object)Collections.EMPTY_LIST, (Object)sparams.getLocales());
        TestCase.assertEquals((String)"solr", (String)((String)sparams.getExtraParameters().get("format")));
        TestCase.assertEquals((String)"Israel", (String)sparams.getTimezone());
    }

    @Test
    public void testSearchQueryParamsFormatNull() throws Exception {
        String query = "select SITE from alfresco";
        SearchSQLQuery searchQuery = new SearchSQLQuery(query, "", Collections.emptyList(), Integer.valueOf(1000), false, "", Collections.emptyList());
        SearchParameters sparams = webscript.buildSearchParameters(searchQuery);
        TestCase.assertNotNull((Object)sparams);
        TestCase.assertEquals((String)query, (String)sparams.getQuery());
        TestCase.assertEquals((boolean)false, (boolean)sparams.isIncludeMetadata());
        TestCase.assertEquals((Object)Collections.EMPTY_LIST, (Object)sparams.getLocales());
        TestCase.assertEquals(null, (String)((String)sparams.getExtraParameters().get("format")));
        TestCase.assertEquals(null, (String)sparams.getTimezone());
        searchQuery = new SearchSQLQuery(query, null, Collections.emptyList(), Integer.valueOf(1000), true, "", Collections.emptyList());
        sparams = webscript.buildSearchParameters(searchQuery);
        TestCase.assertNotNull((Object)sparams);
        TestCase.assertEquals((String)query, (String)sparams.getQuery());
        TestCase.assertEquals((boolean)true, (boolean)sparams.isIncludeMetadata());
        TestCase.assertEquals((Object)Collections.EMPTY_LIST, (Object)sparams.getLocales());
        TestCase.assertEquals(null, (String)((String)sparams.getExtraParameters().get("format")));
        TestCase.assertEquals(null, (String)sparams.getTimezone());
    }

    @Test
    public void testSearchQueryNullStmt() throws Exception {
        SearchSQLQuery searchQuery = new SearchSQLQuery(null, "solr", Collections.emptyList(), null, false, null, Collections.emptyList());
        try {
            webscript.buildSearchParameters(searchQuery);
        }
        catch (Exception e) {
            TestCase.assertEquals((boolean)true, (boolean)e.getMessage().contains("Required stmt parameter is missing."));
        }
    }
}

