/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import org.alfresco.rest.api.tests.AbstractTestFixture;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.service.cmr.site.SiteVisibility;

public abstract class EnterpriseTestFixture
extends AbstractTestFixture {
    public static final String WITH_AVATAR = "withAvatar";

    public EnterpriseTestFixture(String[] configLocations, String[] classLocations, int port, String contextPath, String servletName, int numMembersPerSite, boolean cleanup) {
        super(configLocations, classLocations, port, contextPath, servletName, numMembersPerSite, cleanup);
    }

    @Override
    protected void populateTestData() {
        RepoService.SiteInformation siteInfo;
        int i;
        for (i = 1; i <= 2; ++i) {
            RepoService.TestNetwork network = this.repoService.createNetworkWithAlias("acme00" + i, true);
            this.addNetwork(network);
        }
        for (i = 0; i < 5; ++i) {
            siteInfo = new RepoService.SiteInformation("testSite" + i, "Public Test Site" + i, "Public Test Site" + i, SiteVisibility.PUBLIC);
            this.addSite(siteInfo);
        }
        for (i = 5; i < 10; ++i) {
            siteInfo = new RepoService.SiteInformation("testSite" + i, "Private Test Site" + i, "Private Test Site" + i, SiteVisibility.PRIVATE);
            this.addSite(siteInfo);
        }
        this.addPerson(new PersonInfo("David", "Smith", "david.smith", "password", null, "skype", "location", "telephone", "mob", "instant", "google"));
        this.addPerson(new PersonInfo("Bob", "Jones", "bob.jones", "password", null, "skype", "location", "telephone", "mob", "instant", "google"));
        this.addPerson(new PersonInfo("Bill", "Grainger", "bill.grainger", "password", null, "skype", "location", "telephone", "mob", WITH_AVATAR, "google"));
        this.addPerson(new PersonInfo("Jill", "Fry", "jill.fry", "password", null, "skype", "location", "telephone", "mob", "instant", "google"));
        this.addPerson(new PersonInfo("Elvis", "Presley", "elvis.presley", "password", null, "skype", "location", "telephone", "mob", WITH_AVATAR, "google"));
        this.addPerson(new PersonInfo("John", "Lennon", "john.lennon", "password", null, "skype", "location", "telephone", "mob", WITH_AVATAR, "google"));
        this.addPerson(new PersonInfo("George", "Harrison", "george.harrison", "password", null, "skype", "location", "telephone", "mob", "instant", "google"));
        this.addPerson(new PersonInfo("David", "Bowie", "david.bowie", "password", null, "skype", "location", "telephone", "mob", "instant", "google"));
        this.addPerson(new PersonInfo("Ford", "Prefect", "ford.prefect", "password", null, "skype", "location", "telephone", "mob", "instant", "google"));
    }
}

