/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.RepoHealthChecker;
import org.alfresco.rest.api.discovery.DiscoveryApiWebscript;
import org.alfresco.rest.api.probes.ProbeEntityResource;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProbeApiTest
extends AbstractBaseApiTest {
    private static final boolean OK = true;
    private ProbeEntityResource probe;
    private DiscoveryApiWebscript origDiscovery;
    @Mock
    private DiscoveryApiWebscript goodDiscovery;
    @Mock
    private DiscoveryApiWebscript badDiscovery;
    @Mock
    private RepoHealthChecker repoHealthChecker;

    @Override
    @Before
    public void setup() throws Exception {
        this.setRequestContext(null, null, null);
        String beanName = ProbeEntityResource.class.getCanonicalName() + ".get";
        this.probe = (ProbeEntityResource)this.applicationContext.getBean(beanName, ProbeEntityResource.class);
        Mockito.lenient().when((Object)this.badDiscovery.getRepositoryInfo()).thenThrow(AlfrescoRuntimeException.class);
        ((RepoHealthChecker)Mockito.doNothing().when((Object)this.repoHealthChecker)).checkDatabase();
        this.probe.setRepoHealthChecker(this.repoHealthChecker);
        this.origDiscovery = this.probe.setDiscovery(this.badDiscovery);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.probe.setDiscovery(this.origDiscovery);
        super.tearDown();
    }

    @Override
    public String getScope() {
        return "public";
    }

    private void assertResponse(ProbeEntityResource.ProbeType probeType, Boolean ready, String expected, int expectedStatus) throws Exception {
        int i;
        String[] stringArray;
        if (expectedStatus == 200) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "entry";
            stringArray = stringArray2;
            stringArray2[1] = "message";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "error";
            stringArray = stringArray3;
            stringArray3[1] = "briefSummary";
        }
        String[] keys = stringArray;
        this.probe.setDiscovery(ready == null ? null : (ready != false ? this.goodDiscovery : this.badDiscovery));
        HttpResponse response = this.getSingle(ProbeEntityResource.class, probeType.getValue(), null, expectedStatus);
        Object object = response.getJsonResponse();
        for (String key : keys) {
            object = object.get((Object)key);
            Assert.assertNotNull((String)("Missing \"" + key + "\" in json"), (Object)object);
        }
        String message = object.toString();
        if (expectedStatus != 200 && (i = message.indexOf(32)) != -1) {
            message = message.substring(i + 1);
        }
        Assert.assertEquals((Object)expected, (Object)message);
    }

    @Test
    public void testProbes() throws Exception {
        this.assertResponse(ProbeEntityResource.ProbeType.LIVE, true, "liveProbe: Success - Tested", 200);
        this.assertResponse(ProbeEntityResource.ProbeType.READY, null, "readyProbe: Failure - Tested", 503);
        Thread.currentThread();
        Thread.sleep(10000L);
        this.assertResponse(ProbeEntityResource.ProbeType.READY, true, "readyProbe: Success - Tested", 200);
        this.assertResponse(ProbeEntityResource.ProbeType.READY, null, "readyProbe: Success - No test", 200);
        Thread.currentThread();
        Thread.sleep(10000L);
        this.assertResponse(ProbeEntityResource.ProbeType.LIVE, true, "liveProbe: Success - Tested", 200);
        this.assertResponse(ProbeEntityResource.ProbeType.READY, null, "readyProbe: Failure - Tested", 503);
        Thread.currentThread();
        Thread.sleep(10000L);
        this.assertResponse(ProbeEntityResource.ProbeType.READY, true, "readyProbe: Success - Tested", 200);
        this.assertResponse(ProbeEntityResource.ProbeType.LIVE, true, "liveProbe: Success - Tested", 200);
        this.assertResponse(ProbeEntityResource.ProbeType.READY, null, "readyProbe: Success - No test", 200);
        Thread.currentThread();
        Thread.sleep(10000L);
        ((RepoHealthChecker)Mockito.doThrow(AlfrescoRuntimeException.class).when((Object)this.repoHealthChecker)).checkDatabase();
        this.assertResponse(ProbeEntityResource.ProbeType.READY, true, "readyProbe: Failure - Tested", 503);
        this.assertResponse(ProbeEntityResource.ProbeType.READY, true, "readyProbe: Failure - No test", 503);
    }
}

