/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.surf.policy;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.web.scripts.bean.ADMRemoteStore;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;

public class SurfConfigCleaner
extends ADMRemoteStore
implements NodeServicePolicies.BeforeDeleteNodePolicy {
    private PolicyComponent policyComponent;

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour((Object)this, NodeServicePolicies.BeforeDeleteNodePolicy.QNAME.getLocalName()));
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
        NodeRef userFolderNodeRef;
        String userName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
        NodeRef componentsRef = this.getGlobalComponentsNodeRef();
        NodeRef usersFolderRef = this.getGlobalUserFolderNodeRef();
        if (usersFolderRef != null && (userFolderNodeRef = this.nodeService.getChildByName(usersFolderRef, ContentModel.ASSOC_CONTAINS, SurfConfigCleaner.encodePath(userName))) != null) {
            this.nodeService.addAspect(userFolderNodeRef, ContentModel.ASPECT_TEMPORARY, null);
            this.nodeService.deleteNode(userFolderNodeRef);
        }
        if (componentsRef != null) {
            List configNodes = this.getFileNodes(this.fileFolderService.getFileInfo(componentsRef), this.buildUserConfigSearchPattern(userName), true).getPage();
            for (FileInfo fileInfo : configNodes) {
                this.nodeService.addAspect(fileInfo.getNodeRef(), ContentModel.ASPECT_TEMPORARY, null);
                this.nodeService.deleteNode(fileInfo.getNodeRef());
            }
        }
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }
}

