/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.Authorization;
import org.alfresco.repo.web.auth.AuthenticationListener;
import org.alfresco.repo.web.auth.BasicAuthCredentials;
import org.alfresco.repo.web.auth.GuestCredentials;
import org.alfresco.repo.web.auth.TicketCredentials;
import org.alfresco.repo.web.auth.WebCredentials;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class BasicHttpAuthenticatorFactory
implements ServletAuthenticatorFactory {
    private static Log logger = LogFactory.getLog(BasicHttpAuthenticator.class);
    protected AuthenticationService authenticationService;
    protected AuthorityService authorityService;
    protected AuthenticationListener listener;

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setAuthenticationListener(AuthenticationListener listener) {
        this.listener = listener;
    }

    public AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        return new BasicHttpAuthenticator(req, res, this.listener);
    }

    private WebCredentials getCredentials(Authorization auth) {
        if (auth.isTicket()) {
            return new TicketCredentials(auth.getTicket());
        }
        return new BasicAuthCredentials(auth.getUserName(), auth.getPassword());
    }

    public class BasicHttpAuthenticator
    implements Authenticator {
        protected WebScriptServletRequest servletReq;
        protected WebScriptServletResponse servletRes;
        protected String authorization;
        protected String ticket;
        protected AuthenticationListener listener;

        public BasicHttpAuthenticator(WebScriptServletRequest req, WebScriptServletResponse res, AuthenticationListener listener) {
            this.servletReq = req;
            this.servletRes = res;
            HttpServletRequest httpReq = this.servletReq.getHttpServletRequest();
            this.listener = listener;
            this.authorization = httpReq.getHeader("Authorization");
            this.ticket = httpReq.getParameter("alf_ticket");
        }

        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            boolean authorized = false;
            HttpServletResponse res = this.servletRes.getHttpServletResponse();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HTTP Authorization provided: " + (this.authorization != null && this.authorization.length() > 0)));
                logger.debug((Object)("URL ticket provided: " + (this.ticket != null && this.ticket.length() > 0)));
            }
            boolean doNotReportUrlTicketAuthenticationFailed = true;
            if (isGuest && Description.RequiredAuthentication.guest == required) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Authenticating as Guest");
                }
                try {
                    BasicHttpAuthenticatorFactory.this.authenticationService.authenticateAsGuest();
                    this.listener.userAuthenticated(new GuestCredentials());
                    authorized = true;
                }
                catch (AuthenticationException ex) {
                    this.listener.authenticationFailed(new GuestCredentials());
                }
            } else if (null != this.ticket && this.ticket.length() > 0 && (doNotReportUrlTicketAuthenticationFailed = this.isTicketValid())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authenticating (URL argument) ticket " + this.ticket));
                }
                this.listener.userAuthenticated(new TicketCredentials(this.ticket));
                authorized = true;
            } else if (this.authorization != null && this.authorization.length() > 0) {
                String[] authorizationParts = this.authorization.split(" ");
                if (!authorizationParts[0].equalsIgnoreCase("basic")) {
                    throw new WebScriptException(401, "Authorization '" + authorizationParts[0] + "' not supported.");
                }
                String decodedAuthorisation = new String(Base64.decode((String)authorizationParts[1]));
                Authorization auth = new Authorization(decodedAuthorisation);
                try {
                    if (auth.isTicket()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Authenticating (BASIC HTTP) ticket " + auth.getTicket()));
                        }
                        BasicHttpAuthenticatorFactory.this.authenticationService.validate(auth.getTicket());
                        this.listener.userAuthenticated(BasicHttpAuthenticatorFactory.this.getCredentials(auth));
                        authorized = true;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Authenticating (BASIC HTTP) user " + auth.getUserName()));
                        }
                        BasicHttpAuthenticatorFactory.this.authenticationService.authenticate(auth.getUserName(), auth.getPassword().toCharArray());
                        this.listener.userAuthenticated(BasicHttpAuthenticatorFactory.this.getCredentials(auth));
                        authorized = true;
                    }
                }
                catch (AuthenticationException e) {
                    this.listener.authenticationFailed(BasicHttpAuthenticatorFactory.this.getCredentials(auth));
                }
            }
            if (!authorized) {
                if (!doNotReportUrlTicketAuthenticationFailed) {
                    this.listener.authenticationFailed(new TicketCredentials(this.ticket));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Requesting authorization credentials");
                }
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
            }
            return authorized;
        }

        private boolean isTicketValid() {
            try {
                BasicHttpAuthenticatorFactory.this.authenticationService.validate(this.ticket);
                return true;
            }
            catch (AuthenticationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("User ticket is not valid. Passing to the Basic authentication handling. Reqeust information:\n    ticket: " + this.ticket + "\n    request: " + this.servletReq.getQueryString() + "\n    error: " + String.valueOf((Object)e)), (Throwable)e);
                }
                return false;
            }
        }

        public boolean emptyCredentials() {
            return !(this.ticket != null && this.ticket.length() != 0 || this.authorization != null && this.authorization.length() != 0);
        }

        protected boolean isBasicAuthHeaderPresentForAdmin() {
            if (this.authorization == null || this.authorization.isEmpty()) {
                return false;
            }
            String[] authorizationParts = this.authorization.split(" ");
            if (!authorizationParts[0].equalsIgnoreCase("basic")) {
                return false;
            }
            String decodedAuthorisation = new String(Base64.decode((String)authorizationParts[1]));
            Authorization auth = new Authorization(decodedAuthorisation);
            if (auth.isTicket() || auth.getUserName() == null || auth.getUserName().isEmpty()) {
                return false;
            }
            if (AuthenticationUtil.getAdminUserName().equals(auth.getUserName())) {
                return true;
            }
            return (Boolean)AuthenticationUtil.runAsSystem(() -> BasicHttpAuthenticatorFactory.this.authorityService.isAdminAuthority(auth.getUserName()));
        }
    }
}

