/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentLimitProvider;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.model.ClassDefinition;
import org.alfresco.rest.api.model.ConstraintDefinition;
import org.alfresco.rest.api.model.LockInfo;
import org.alfresco.rest.api.model.NodePermissions;
import org.alfresco.rest.api.model.NodeTarget;
import org.alfresco.rest.api.model.PropertyDefinition;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiHttpClient;
import org.alfresco.rest.api.tests.client.data.Association;
import org.alfresco.rest.api.tests.client.data.ContentInfo;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Folder;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.client.data.PathInfo;
import org.alfresco.rest.api.tests.client.data.Rendition;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.api.tests.client.data.UserInfo;
import org.alfresco.rest.api.tests.util.MultiPartBuilder;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.collections.map.MultiValueMap;
import org.json.simple.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeApiTest
extends AbstractSingleNetworkSiteTest {
    private static final String PROP_OWNER = "cm:owner";
    private static final String URL_DELETED_NODES = "deleted-nodes";
    private static final String EMPTY_BODY = "{}";
    protected PermissionService permissionService;
    protected AuthorityService authorityService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private RuleService ruleService;
    private ActionService actionService;
    private String rootGroupName = null;
    private String groupA = null;
    private String groupB = null;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService", PermissionService.class);
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService", NodeService.class);
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService");
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService", RuleService.class);
        this.actionService = (ActionService)this.applicationContext.getBean("ActionService", ActionService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testListChildrenWithinSiteDocLib() throws Exception {
        this.setRequestContext(user1);
        String folder0Name = "f0-testListChildrenWithinSiteDocLib-" + this.RUNID;
        String f0Id = this.createFolder(tDocLibNodeId, folder0Name).getId();
        String folder1 = "folder" + this.RUNID + "_1";
        this.createFolder(f0Id, folder1, null).getId();
        String folder2 = "folder" + this.RUNID + "_2";
        this.createFolder(f0Id, folder2, null).getId();
        String content1 = "content" + this.RUNID + "_1";
        this.createTextFile(f0Id, content1, "The quick brown fox jumps over the lazy dog 1.").getId();
        String content2 = "content" + this.RUNID + "_2";
        this.createTextFile(f0Id, content2, "The quick brown fox jumps over the lazy dog 2.").getId();
        String forum1 = "forum" + this.RUNID + "_1";
        this.createNode(f0Id, forum1, "fm:topic", null);
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        HttpResponse response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, 200);
        List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)4L, (long)nodes.size());
        PublicApiClient.ExpectedPaging expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)4L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)0L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)100L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertFalse((boolean)expectedPaging.getHasMoreItems());
        Map<String, String> orderBy = Collections.singletonMap("orderBy", "isFolder DESC,modifiedAt DESC");
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)4L, (long)nodes.size());
        Assert.assertEquals((Object)folder2, (Object)nodes.get(0).getName());
        Assert.assertTrue((boolean)nodes.get(0).getIsFolder());
        Assert.assertFalse((boolean)nodes.get(0).getIsFile());
        Assert.assertEquals((Object)folder1, (Object)nodes.get(1).getName());
        Assert.assertTrue((boolean)nodes.get(1).getIsFolder());
        Assert.assertFalse((boolean)nodes.get(1).getIsFile());
        Assert.assertEquals((Object)content2, (Object)nodes.get(2).getName());
        Assert.assertFalse((boolean)nodes.get(2).getIsFolder());
        Assert.assertTrue((boolean)nodes.get(2).getIsFile());
        Assert.assertEquals((Object)content1, (Object)nodes.get(3).getName());
        Assert.assertFalse((boolean)nodes.get(3).getIsFolder());
        Assert.assertTrue((boolean)nodes.get(3).getIsFile());
        orderBy = Collections.singletonMap("orderBy", "isFolder ASC,modifiedAt DESC");
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)4L, (long)nodes.size());
        Assert.assertEquals((Object)content2, (Object)nodes.get(0).getName());
        Assert.assertEquals((Object)content1, (Object)nodes.get(1).getName());
        Assert.assertEquals((Object)folder2, (Object)nodes.get(2).getName());
        Assert.assertEquals((Object)folder1, (Object)nodes.get(3).getName());
        orderBy = Collections.singletonMap("orderBy", "isFolder,modifiedAt");
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)4L, (long)nodes.size());
        Assert.assertEquals((Object)content1, (Object)nodes.get(0).getName());
        Assert.assertEquals((Object)content2, (Object)nodes.get(1).getName());
        Assert.assertEquals((Object)folder1, (Object)nodes.get(2).getName());
        Assert.assertEquals((Object)folder2, (Object)nodes.get(3).getName());
        orderBy = Collections.singletonMap("orderBy", "isFolder DESC,modifiedAt DESC");
        paging = this.getPaging(0, 2);
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)folder2, (Object)nodes.get(0).getName());
        Assert.assertEquals((Object)folder1, (Object)nodes.get(1).getName());
        expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)2L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)0L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)2L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertTrue((boolean)expectedPaging.getHasMoreItems());
        paging = this.getPaging(null, 2);
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)folder2, (Object)nodes.get(0).getName());
        Assert.assertEquals((Object)folder1, (Object)nodes.get(1).getName());
        expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)2L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)0L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)2L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertTrue((boolean)expectedPaging.getHasMoreItems());
        paging = this.getPaging(2, 4);
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)content2, (Object)nodes.get(0).getName());
        Assert.assertEquals((Object)content1, (Object)nodes.get(1).getName());
        expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)2L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)2L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)4L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertFalse((boolean)expectedPaging.getHasMoreItems());
        paging = this.getPaging(2, null);
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)content2, (Object)nodes.get(0).getName());
        Assert.assertEquals((Object)content1, (Object)nodes.get(1).getName());
        expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)2L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)2L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)100L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertFalse((boolean)expectedPaging.getHasMoreItems());
        this.setRequestContext(user2);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        this.getAll(this.getNodeChildrenUrl(f0Id), paging, 403);
        this.setRequestContext(user1);
        paging = this.getPaging(-1, 4);
        this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 400);
        paging = this.getPaging(0, 0);
        this.getAll(this.getNodeChildrenUrl(f0Id), paging, orderBy, 400);
    }

    @Test
    public void testListChildrenWithinMyFiles() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String rootChildrenUrl = this.getNodeChildrenUrl("-root-");
        String folder0Name = "folder " + this.RUNID + " 0";
        String folder0Id = this.createFolder(myNodeId, folder0Name, null).getId();
        String childrenUrl = this.getNodeChildrenUrl(folder0Id);
        HashMap<String, Object> props = new HashMap<String, Object>(1);
        props.put("cm:title", "This is folder 1");
        String folder1 = "folder " + this.RUNID + " 1";
        String folder1_Id = this.createFolder(folder0Id, folder1, props).getId();
        String contentF1 = "content" + this.RUNID + " in folder 1";
        String contentF1_Id = this.createTextFile(folder1_Id, contentF1, "The quick brown fox jumps over the lazy dog 1.").getId();
        props = new HashMap(1);
        props.put("cm:title", "This is folder 2");
        String folder2 = "folder " + this.RUNID + " 2";
        String folder2_Id = this.createFolder(folder0Id, folder2, props).getId();
        String contentF2 = "content" + this.RUNID + " in folder 2.txt";
        String contentF2_Id = this.createTextFile(folder2_Id, contentF2, "The quick brown fox jumps over the lazy dog 2.").getId();
        String content1 = "content" + this.RUNID + " 1.txt";
        String content1_Id = this.createTextFile(folder0Id, content1, "The quick brown fox jumps over the lazy dog.").getId();
        props = new HashMap();
        props.put(PROP_OWNER, user1);
        props.put("cm:lastThumbnailModification", Collections.singletonList("doclib:1444660852296"));
        Node nodeUpdate = new Node();
        nodeUpdate.setProperties(props);
        this.put("nodes", content1_Id, RestApiUtil.toJsonAsStringNonNull(nodeUpdate), null, 200);
        List<String> folderIds = Arrays.asList(folder1_Id, folder2_Id);
        List<String> contentIds = Arrays.asList(content1_Id);
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        HttpResponse response = this.getAll(childrenUrl, paging, 200);
        List<Document> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)3L, (long)nodes.size());
        Map<String, String> orderBy = Collections.singletonMap("orderBy", "isFolder DESC,modifiedAt DESC");
        response = this.getAll(childrenUrl, paging, orderBy, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertEquals((Object)folder2, (Object)nodes.get(0).getName());
        Assert.assertEquals((Object)folder1, (Object)nodes.get(1).getName());
        Document node = nodes.get(2);
        Assert.assertEquals((Object)content1, (Object)node.getName());
        Assert.assertEquals((Object)"cm:content", (Object)node.getNodeType());
        Assert.assertEquals((Object)content1_Id, (Object)node.getId());
        UserInfo createdByUser = node.getCreatedByUser();
        Assert.assertEquals((Object)user1, (Object)createdByUser.getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user1), (Object)createdByUser.getDisplayName());
        UserInfo modifiedByUser = node.getModifiedByUser();
        Assert.assertEquals((Object)user1, (Object)modifiedByUser.getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user1), (Object)modifiedByUser.getDisplayName());
        Assert.assertEquals((Object)"text/plain", (Object)node.getContent().getMimeType());
        Assert.assertNotNull((Object)node.getContent().getMimeTypeName());
        Assert.assertNotNull((Object)node.getContent().getEncoding());
        Assert.assertTrue((node.getContent().getSizeInBytes() > 0L ? 1 : 0) != 0);
        Map<String, Object> params = new HashMap<String, String>();
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        for (Node node2 : nodes) {
            Assert.assertNull((String)"There shouldn't be a 'properties' object in the response.", node2.getProperties());
            Assert.assertNull((String)"There shouldn't be a 'isLink' object in the response.", (Object)node2.getIsLink());
            Assert.assertNull((String)"There shouldn't be a 'path' object in the response.", (Object)node2.getPath());
            Assert.assertNull((String)"There shouldn't be a 'aspectNames' object in the response.", node2.getAspectNames());
        }
        params = new HashMap();
        params.put("include", "isLink");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        for (Node node3 : nodes) {
            Assert.assertNotNull((String)"There should be a 'isLink' object in the response.", (Object)node3.getIsLink());
        }
        params = new HashMap();
        params.put("include", "aspectNames,properties,path,isLink");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = jacksonUtil.parseEntries(response.getJsonResponse(), Document.class);
        for (Node node4 : nodes) {
            Assert.assertNotNull((String)"There should be a 'properties' object in the response.", node4.getProperties());
            Assert.assertNotNull((String)"There should be a 'isLink' object in the response.", (Object)node4.getIsLink());
            Assert.assertNotNull((String)"There should be a 'path' object in the response.", (Object)node4.getPath());
            Assert.assertNotNull((String)"There should be a 'aspectNames' object in the response.", node4.getAspectNames());
        }
        params = new HashMap();
        params.put("include", "cm:lastThumbnailModification");
        params.put("orderBy", "isFolder DESC,modifiedAt DESC");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertNull((String)"There shouldn't be a 'properties' object in the response.", nodes.get(0).getProperties());
        Assert.assertNull((String)"There shouldn't be a 'properties' object in the response.", nodes.get(1).getProperties());
        Assert.assertNotNull((String)"There should be a 'properties' object in the response.", nodes.get(2).getProperties());
        Set<Map.Entry<String, Object>> propsSet = nodes.get(2).getProperties().entrySet();
        Assert.assertEquals((long)1L, (long)propsSet.size());
        Map.Entry<String, Object> entry = propsSet.iterator().next();
        Assert.assertEquals((Object)"cm:lastThumbnailModification", (Object)entry.getKey());
        Assert.assertEquals((Object)"doclib:1444660852296", ((List)entry.getValue()).get(0));
        params = new HashMap();
        params.put("where", "(isFolder=true)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.get(0).getIsFolder());
        Assert.assertFalse((boolean)nodes.get(0).getIsFile());
        Assert.assertTrue((boolean)folderIds.contains(nodes.get(0).getId()));
        Assert.assertTrue((boolean)nodes.get(1).getIsFolder());
        Assert.assertFalse((boolean)nodes.get(1).getIsFile());
        Assert.assertTrue((boolean)folderIds.contains(nodes.get(1).getId()));
        params = new HashMap();
        params.put("where", "(isFile=true)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertFalse((boolean)nodes.get(0).getIsFolder());
        Assert.assertTrue((boolean)nodes.get(0).getIsFile());
        Assert.assertTrue((boolean)contentIds.contains(nodes.get(0).getId()));
        params = Collections.singletonMap("relativePath", folder1);
        response = this.getAll(childrenUrl, paging, params, 200);
        JSONObject jsonResponse = response.getJsonResponse();
        nodes = RestApiUtil.parseRestApiEntries(jsonResponse, Document.class);
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertEquals((Object)contentF1_Id, (Object)nodes.get(0).getId());
        JSONObject jsonList = (JSONObject)jsonResponse.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONObject jsonSrcObj = (JSONObject)jsonResponse.get((Object)"source");
        Assert.assertNull((Object)jsonSrcObj);
        params = Collections.singletonMap("relativePath", "User Homes/" + user1 + "/" + folder0Name + "/" + folder2);
        response = this.getAll(rootChildrenUrl, paging, params, 200);
        jsonResponse = response.getJsonResponse();
        nodes = RestApiUtil.parseRestApiEntries(jsonResponse, Document.class);
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertEquals((Object)contentF2_Id, (Object)nodes.get(0).getId());
        jsonList = (JSONObject)jsonResponse.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        jsonSrcObj = (JSONObject)jsonResponse.get((Object)"source");
        Assert.assertNull((Object)jsonSrcObj);
        params = new HashMap();
        params.put("relativePath", "User Homes/" + user1 + "/" + folder0Name + "/" + folder2);
        params.put("includeSource", "true");
        params.put("include", "path,isLink");
        params.put("fields", "id");
        response = this.getAll(rootChildrenUrl, paging, params, 200);
        jsonResponse = response.getJsonResponse();
        nodes = RestApiUtil.parseRestApiEntries(jsonResponse, Document.class);
        Assert.assertEquals((long)1L, (long)nodes.size());
        Document doc = nodes.get(0);
        Assert.assertEquals((Object)contentF2_Id, (Object)doc.getId());
        Assert.assertNotNull((Object)doc.getPath());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)doc.getIsLink());
        Assert.assertNull((Object)doc.getName());
        jsonList = (JSONObject)jsonResponse.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        Folder src = RestApiUtil.parsePojo("source", jsonList, Folder.class);
        Assert.assertEquals((Object)folder2_Id, (Object)src.getId());
        Assert.assertNull((Object)src.getPath());
        Assert.assertNull((Object)src.getIsLink());
        Assert.assertNotNull((Object)src.getName());
        Assert.assertNotNull(src.getAspectNames());
        Assert.assertNotNull(src.getProperties());
        params = Collections.singletonMap("orderBy", "isFolder DESC,cm" + System.currentTimeMillis() + ":modified DESC");
        this.getAll(childrenUrl, paging, params, 400);
        paging = this.getPaging(0, 10);
        this.getAll(this.getNodeChildrenUrl(UUID.randomUUID().toString()), paging, 404);
        this.setRequestContext(user2);
        this.getAll(this.getNodeChildrenUrl(myNodeId), paging, 403);
        this.setRequestContext(user1);
        params = Collections.singletonMap("relativePath", "User Homes/" + user1 + "/unknown");
        this.getAll(rootChildrenUrl, paging, params, 404);
        params = Collections.singletonMap("relativePath", "User Homes/" + user2);
        this.getAll(rootChildrenUrl, paging, params, 404);
        params = Collections.singletonMap("relativePath", "/unknown");
        this.getAll(this.getNodeChildrenUrl(content1_Id), paging, params, 400);
        params = new HashMap();
        params.put("where", "(NOT isFile=true)");
        this.getAll(childrenUrl, paging, params, 400);
    }

    @Test
    public void testGetPathElements_DocLib() throws Exception {
        this.setRequestContext(user1);
        String site1Title = "site-testGetPathElements_DocLib-" + this.RUNID;
        String site1Id = this.createSite(site1Title, SiteVisibility.PRIVATE).getId();
        this.addSiteMember(site1Id, user2, SiteRole.SiteConsumer);
        String site1DocLibNodeId = this.getSiteContainerNodeId(site1Id, "documentLibrary");
        String folderA = "folder" + this.RUNID + "_A";
        String folderA_Id = this.createFolder(site1DocLibNodeId, folderA).getId();
        String folderB = "folder" + this.RUNID + "_B";
        String folderB_Id = this.createFolder(folderA_Id, folderB).getId();
        final NodeRef folderB_Ref = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folderB_Id);
        String folderC = "folder" + this.RUNID + "_C";
        String folderC_Id = this.createFolder(folderB_Id, folderC).getId();
        final NodeRef folderC_Ref = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folderC_Id);
        String content = "content" + this.RUNID;
        String content1_Id = this.createTextFile(folderC_Id, content, "The quick brown fox jumps over the lazy dog.").getId();
        final String tenantDomain = networkOne != null ? networkOne.getId() : "";
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                return (Void)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        NodeApiTest.this.permissionService.setInheritParentPermissions(folderB_Ref, false);
                        NodeApiTest.this.permissionService.setPermission(folderC_Ref, AbstractBaseApiTest.user2, "Consumer", true);
                        return null;
                    }
                }, (String)tenantDomain);
            }
        }, (String)user1);
        Map<String, String> params = Collections.singletonMap("include", "path");
        HttpResponse response = this.getSingle(NodesEntityResource.class, content1_Id, params, 200);
        Document node = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        PathInfo path = node.getPath();
        Assert.assertNotNull((Object)path);
        Assert.assertTrue((boolean)path.getIsComplete());
        Assert.assertNotNull((Object)path.getName());
        Assert.assertFalse((boolean)path.getName().endsWith(content));
        Assert.assertTrue((boolean)path.getName().startsWith("/Company Home"));
        List<PathInfo.ElementInfo> pathElements = path.getElements();
        Assert.assertEquals((long)7L, (long)pathElements.size());
        Assert.assertEquals((Object)"Company Home", (Object)pathElements.get(0).getName());
        Assert.assertEquals((Object)"cm:folder", (Object)pathElements.get(0).getNodeType());
        Assert.assertEquals((Object)"Sites", (Object)pathElements.get(1).getName());
        Assert.assertEquals((Object)"st:sites", (Object)pathElements.get(1).getNodeType());
        Assert.assertEquals((Object)site1Id, (Object)pathElements.get(2).getName());
        Assert.assertEquals((Object)"st:site", (Object)pathElements.get(2).getNodeType());
        Assert.assertTrue((boolean)pathElements.get(2).getAspectNames().contains("cm:titled"));
        Assert.assertFalse((boolean)pathElements.get(2).getAspectNames().contains("sys:undeletable"));
        Assert.assertFalse((boolean)pathElements.get(2).getAspectNames().contains("sys:unmovable"));
        Assert.assertEquals((Object)"documentLibrary", (Object)pathElements.get(3).getName());
        Assert.assertEquals((Object)"cm:folder", (Object)pathElements.get(3).getNodeType());
        Assert.assertTrue((boolean)pathElements.get(3).getAspectNames().contains("st:siteContainer"));
        Assert.assertEquals((Object)folderA, (Object)pathElements.get(4).getName());
        Assert.assertEquals((Object)"cm:folder", (Object)pathElements.get(4).getNodeType());
        Assert.assertEquals((Object)folderB, (Object)pathElements.get(5).getName());
        Assert.assertEquals((Object)"cm:folder", (Object)pathElements.get(5).getNodeType());
        Assert.assertEquals((Object)folderC, (Object)pathElements.get(6).getName());
        Assert.assertEquals((Object)"cm:folder", (Object)pathElements.get(6).getNodeType());
        this.setRequestContext(user2);
        response = this.getSingle(NodesEntityResource.class, content1_Id, params, 200);
        node = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        path = node.getPath();
        Assert.assertNotNull((Object)path);
        Assert.assertFalse((String)"The path is not complete as the user doesn't have permission to access the full path.", (boolean)path.getIsComplete());
        Assert.assertNotNull((Object)path.getName());
        Assert.assertFalse((String)"site consumer (user2) dose not have access to the folderB", (boolean)path.getName().contains(folderB));
        Assert.assertFalse((boolean)path.getName().startsWith("/Company Home"));
        Assert.assertTrue((boolean)path.getName().endsWith(folderC));
        pathElements = path.getElements();
        Assert.assertEquals((long)1L, (long)pathElements.size());
        Assert.assertEquals((Object)folderC, (Object)pathElements.get(0).getName());
        this.setRequestContext(user1);
        this.deleteSite(site1Id, true, 204);
    }

    @Test
    public void testGetNodeInfo() throws Exception {
        this.setRequestContext(user1);
        HttpResponse response = this.getSingle(NodesEntityResource.class, "-root-", null, 200);
        Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String rootNodeId = node.getId();
        response = this.getSingle(NodesEntityResource.class, "-my-", null, 200);
        node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String myFilesNodeId = node.getId();
        Assert.assertNotNull((Object)myFilesNodeId);
        Assert.assertEquals((Object)user1, (Object)node.getName());
        Assert.assertTrue((boolean)node.getIsFolder());
        Assert.assertFalse((boolean)node.getIsFile());
        String userHomesId = node.getParentId();
        String folderA = "folder" + this.RUNID + "_A";
        String folderA_Id = this.createFolder(myFilesNodeId, folderA).getId();
        String folderB = "folder" + this.RUNID + "_B";
        String folderB_Id = this.createFolder(folderA_Id, folderB).getId();
        String title = "test title";
        HashMap<String, String> docProps = new HashMap<String, String>();
        docProps.put("cm:title", title);
        docProps.put(PROP_OWNER, user2);
        String contentName = "content " + this.RUNID + ".txt";
        String content1Id = this.createTextFile(folderB_Id, contentName, "The quick brown fox jumps over the lazy dog.", "UTF-8", docProps).getId();
        Thread.sleep(3000L);
        response = this.getSingle(NodesEntityResource.class, content1Id, null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String content_Id = documentResp.getId();
        UserInfo expectedUser = new UserInfo(user1);
        Document d1 = new Document();
        d1.setId(content_Id);
        d1.setParentId(folderB_Id);
        d1.setName(contentName);
        d1.setNodeType("cm:content");
        ContentInfo ciExpected = new ContentInfo();
        ciExpected.setMimeType("text/plain");
        ciExpected.setMimeTypeName("Plain Text");
        ciExpected.setSizeInBytes(44L);
        ciExpected.setEncoding("ISO-8859-1");
        d1.setContent(ciExpected);
        d1.setCreatedByUser(expectedUser);
        d1.setModifiedByUser(expectedUser);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("cm:title", title);
        props.put("cm:versionLabel", "1.0");
        props.put("cm:versionType", "MAJOR");
        props.put(PROP_OWNER, new UserInfo(user2).toJSON());
        d1.setProperties(props);
        d1.setAspectNames(Arrays.asList("cm:auditable", "cm:titled", "cm:versionable", "cm:author", "cm:ownable"));
        d1.expected(documentResp);
        Map<String, Object> params = Collections.singletonMap("include", "path");
        response = this.getSingle(NodesEntityResource.class, content1Id, params, 200);
        documentResp = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        ArrayList<PathInfo.ElementInfo> elements = new ArrayList<PathInfo.ElementInfo>(5);
        elements.add(new PathInfo.ElementInfo(rootNodeId, "Company Home"));
        elements.add(new PathInfo.ElementInfo(userHomesId, "User Homes"));
        elements.add(new PathInfo.ElementInfo(myFilesNodeId, user1));
        elements.add(new PathInfo.ElementInfo(folderA_Id, folderA));
        elements.add(new PathInfo.ElementInfo(folderB_Id, folderB));
        PathInfo expectedPath = new PathInfo("/Company Home/User Homes/" + user1 + "/" + folderA + "/" + folderB, true, elements);
        d1.setPath(expectedPath);
        d1.expected(documentResp);
        params = Collections.singletonMap("relativePath", "/" + folderA + "/" + folderB);
        response = this.getSingle(NodesEntityResource.class, "-my-", params, 200);
        Folder folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderB_Id, (Object)folderResp.getId());
        params = Collections.singletonMap("relativePath", folderA + "/" + folderB + "/" + contentName);
        response = this.getSingle(NodesEntityResource.class, "-my-", params, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)content_Id, (Object)documentResp.getId());
        String folderC = "folder" + this.RUNID + " \u00a2";
        String folderC_Id = this.createFolder(folderB_Id, folderC).getId();
        params = Collections.singletonMap("relativePath", "/" + folderA + "/" + folderB + "/" + folderC);
        response = this.getSingle(NodesEntityResource.class, "-my-", params, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderC_Id, (Object)folderResp.getId());
        this.getSingle(NodesEntityResource.class, UUID.randomUUID().toString(), null, 404);
        this.setRequestContext(user2);
        this.getSingle(NodesEntityResource.class, myFilesNodeId, null, 403);
        this.setRequestContext(user1);
        params = Collections.singletonMap("relativePath", folderA + "/unknown");
        this.getSingle(NodesEntityResource.class, "-my-", params, 404);
        params = Collections.singletonMap("relativePath", "User Homes/" + user2);
        this.getSingle(NodesEntityResource.class, "-root-", params, 404);
        params = Collections.singletonMap("relativePath", "/unknown");
        this.getSingle(NodesEntityResource.class, content_Id, params, 400);
    }

    @Test
    public void testGetNodeWithKnownAlias() throws Exception {
        this.setRequestContext(user1);
        HttpResponse response = this.getSingle(NodesEntityResource.class, "-root-", null, 200);
        Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)"Company Home", (Object)node.getName());
        Assert.assertNotNull((Object)node.getId());
        Assert.assertNull((Object)node.getPath());
        this.getSingle(NodesEntityResource.class, "testSomeUndefinedAlias", null, 404);
        response = this.getSingle(NodesEntityResource.class, "-my-", null, 200);
        node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String myFilesNodeId = node.getId();
        Assert.assertNotNull((Object)myFilesNodeId);
        Assert.assertEquals((Object)user1, (Object)node.getName());
        Assert.assertTrue((boolean)node.getIsFolder());
        Assert.assertFalse((boolean)node.getIsFile());
        Assert.assertNull((Object)node.getPath());
        response = this.getSingle(NodesEntityResource.class, "-shared-", null, 200);
        node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String sharedFilesNodeId = node.getId();
        Assert.assertNotNull((Object)sharedFilesNodeId);
        Assert.assertEquals((Object)"Shared", (Object)node.getName());
        Assert.assertTrue((boolean)node.getIsFolder());
        Assert.assertFalse((boolean)node.getIsFile());
        Assert.assertNull((Object)node.getPath());
        this.setRequestContext(networkAdmin);
        this.deleteNode(myFilesNodeId);
        this.setRequestContext(user1);
        this.getSingle(NodesEntityResource.class, "-my-", null, 404);
    }

    @Test
    public void testGuessMimeTypeAndEncoding() throws Exception {
        this.setRequestContext(user1);
        String fId = this.createFolder(this.getMyNodeId(), "test-folder-guess-" + this.RUNID).getId();
        Document d = new Document();
        d.setName("my doc");
        d.setNodeType("cm:content");
        HttpResponse response = this.post(this.getNodeChildrenUrl(fId), RestApiUtil.toJsonAsStringNonNull(d), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"application/octet-stream", (Object)documentResp.getContent().getMimeType());
        Assert.assertEquals((Object)"Binary File (Octet Stream)", (Object)documentResp.getContent().getMimeTypeName());
        Assert.assertEquals((long)0L, (long)documentResp.getContent().getSizeInBytes());
        Assert.assertEquals((Object)"UTF-8", (Object)documentResp.getContent().getEncoding());
        d = new Document();
        d.setName("my doc.txt");
        d.setNodeType("cm:content");
        response = this.post(this.getNodeChildrenUrl(fId), RestApiUtil.toJsonAsStringNonNull(d), 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"text/plain", (Object)documentResp.getContent().getMimeType());
        Assert.assertEquals((Object)"Plain Text", (Object)documentResp.getContent().getMimeTypeName());
        Assert.assertEquals((long)0L, (long)documentResp.getContent().getSizeInBytes());
        Assert.assertEquals((Object)"UTF-8", (Object)documentResp.getContent().getEncoding());
        d = new Document();
        d.setName("my doc.pdf");
        d.setNodeType("cm:content");
        response = this.post(this.getNodeChildrenUrl(fId), RestApiUtil.toJsonAsStringNonNull(d), 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"application/pdf", (Object)documentResp.getContent().getMimeType());
        Assert.assertEquals((Object)"Adobe PDF Document", (Object)documentResp.getContent().getMimeTypeName());
        Assert.assertEquals((long)0L, (long)documentResp.getContent().getSizeInBytes());
        Assert.assertEquals((Object)"UTF-8", (Object)documentResp.getContent().getEncoding());
        String fileName = "quick-2.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        ContentInfo contentInfo = document.getContent();
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        fileName = "quick-2.pdf";
        file = this.getResourceFile(fileName);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-2", file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        fileName = "example-1.txt";
        file = this.getResourceFile(fileName);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)contentInfo.getEncoding());
        fileName = "example-2.txt";
        file = this.getResourceFile(fileName);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        fileName = "shift-jis.txt";
        file = this.getResourceFile(fileName);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"Shift_JIS", (Object)contentInfo.getEncoding());
        fileName = "example-1.xml";
        file = this.getResourceFile(fileName);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"text/xml", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)contentInfo.getEncoding());
        fileName = "example-2.xml";
        file = this.getResourceFile(fileName);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"text/xml", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        fileName = "quick.pdf";
        file = this.getResourceFile(fileName);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String docId = document.getId();
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        Document dUpdate = new Document();
        dUpdate.setName("quick.docx");
        response = this.put("nodes", docId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        fileName = "quick.docx";
        file = this.getResourceFile(fileName);
        PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(file);
        response = this.putBinary(this.getNodeContentUrl(docId), payload, null, null, 200);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        fileName = "CMIS-Delete.json";
        file = this.getResourceFile(fileName);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("special-" + GUID.generate(), file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(fId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        this.deleteNode(fId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadToMyFiles() throws Exception {
        this.setRequestContext(user1);
        String folder0Name = "f0-testUploadToMyFiles-" + this.RUNID;
        Folder folderResp = this.createFolder("-my-", folder0Name);
        String f0Id = folderResp.getId();
        String fileName = "quick.pdf";
        File file = this.getResourceFile("quick.pdf");
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HttpResponse response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, 200);
        PublicApiClient.ExpectedPaging pagingResult = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        int numOfNodes = pagingResult.getCount();
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick.pdf", file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        this.post(this.getNodeChildrenUrl(UUID.randomUUID().toString()), reqBody.getBody(), null, reqBody.getContentType(), 404);
        response = this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick.pdf", (Object)document.getName());
        ContentInfo contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        Assert.assertNull((Object)document.getPath());
        response = this.getSingle(NodesEntityResource.class, document.getId(), null, 200);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick.pdf", (Object)document.getName());
        contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, 200);
        pagingResult = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        Assert.assertEquals((long)(numOfNodes + 1), (long)pagingResult.getCount().intValue());
        this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 409);
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, 200);
        pagingResult = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        Assert.assertEquals((String)"Duplicate file name. The file shouldn't have been uploaded.", (long)(numOfNodes + 1), (long)pagingResult.getCount().intValue());
        reqBody = MultiPartBuilder.copy(multiPartBuilder).setAutoRename(true).build();
        response = this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-1.pdf", (Object)document.getName());
        response = this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), "?include=path", reqBody.getContentType(), 201);
        document = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-2.pdf", (Object)document.getName());
        Assert.assertNotNull((Object)document.getPath());
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, 200);
        pagingResult = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        Assert.assertEquals((long)(numOfNodes + 3), (long)pagingResult.getCount().intValue());
        String fileName1 = "quick-1.txt";
        File file1 = this.getResourceFile("quick-1.txt");
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(null, file1)).build();
        response = this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-1.txt", (Object)document.getName());
        Assert.assertEquals((Object)"text/plain", (Object)document.getContent().getMimeType());
        String fileName2 = "quick-2.txt";
        String fileName2b = "quick-2b.txt";
        File file2 = this.getResourceFile("quick-2.txt");
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-2b.txt", file2)).build();
        response = this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-2b.txt", (Object)document.getName());
        Assert.assertEquals((Object)"text/plain", (Object)document.getContent().getMimeType());
        response = this.getSingle(NodesEntityResource.class, "-my-", null, 200);
        Folder user1Home = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        this.setRequestContext(user2);
        File file3 = this.getResourceFile("quick-2.txt");
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-2.txt", file3)).build();
        this.post(this.getNodeChildrenUrl(user1Home.getId()), reqBody.getBody(), null, reqBody.getContentType(), 403);
        this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 403);
        this.setRequestContext(user1);
        response = this.getAll(this.getNodeChildrenUrl(f0Id), paging, 200);
        pagingResult = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        Assert.assertEquals((String)"Access Denied. The file shouldn't have been uploaded.", (long)(numOfNodes + 5), (long)pagingResult.getCount().intValue());
        this.post(this.getNodeChildrenUrl(document.getId()), reqBody.getBody(), null, reqBody.getContentType(), 400);
        reqBody = MultiPartBuilder.create().setAutoRename(true).build();
        this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 400);
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-2.txt", file2)).setAutoRename(true).setNodeType("cm:link").build();
        this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 400);
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-2.txt", file2)).build();
        response = this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-2.txt", (Object)document.getName());
        contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)contentInfo.getEncoding());
        ContentLimitProvider.SimpleFixedLimitProvider limitProvider = (ContentLimitProvider.SimpleFixedLimitProvider)this.applicationContext.getBean("defaultContentLimitProvider", ContentLimitProvider.SimpleFixedLimitProvider.class);
        long defaultSizeLimit = limitProvider.getSizeLimit();
        limitProvider.setSizeLimitString("20000");
        try {
            reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick.pdf", file)).setAutoRename(true).build();
            this.post(this.getNodeChildrenUrl(f0Id), reqBody.getBody(), null, reqBody.getContentType(), 413);
        }
        finally {
            limitProvider.setSizeLimitString(Long.toString(defaultSizeLimit));
        }
    }

    @Test
    public void testUploadToSite() throws Exception {
        this.setRequestContext(user1);
        String fileName = "quick-1.txt";
        File file = this.getResourceFile("quick-1.txt");
        String folderA = "folder" + this.RUNID + "_A";
        String folderA_id = this.createFolder(tDocLibNodeId, folderA).getId();
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HttpResponse response = this.getAll(this.getNodeChildrenUrl(folderA_id), paging, 200);
        PublicApiClient.ExpectedPaging pagingResult = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        int numOfNodes = pagingResult.getCount();
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-1.txt", file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-1.txt", (Object)document.getName());
        ContentInfo contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        response = this.getSingle(NodesEntityResource.class, document.getId(), null, 200);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-1.txt", (Object)document.getName());
        contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        response = this.getAll(this.getNodeChildrenUrl(folderA_id), paging, 200);
        pagingResult = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        Assert.assertEquals((long)(numOfNodes + 1), (long)pagingResult.getCount().intValue());
        this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 409);
        response = this.getAll(this.getNodeChildrenUrl(folderA_id), paging, 200);
        pagingResult = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        Assert.assertEquals((long)(numOfNodes + 1), (long)pagingResult.getCount().intValue());
        this.setRequestContext(user2);
        String fileName2 = "quick-2.txt";
        File file2 = this.getResourceFile("quick-2.txt");
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-2.txt", file2)).build();
        this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 403);
        this.setRequestContext(user1);
        response = this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-2.txt", (Object)document.getName());
        contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        Assert.assertNotNull(document.getProperties());
        Assert.assertNull((Object)document.getProperties().get("cm:title"));
        Assert.assertNull((Object)document.getProperties().get("cm:description"));
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("cm:title", "test title");
        props.put("cm:description", "test description");
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-2.txt", file2)).setAutoRename(true).setProperties(props).build();
        response = this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-2-1.txt", (Object)document.getName());
        contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        Assert.assertNotNull(document.getProperties());
        Assert.assertEquals((Object)"test title", (Object)document.getProperties().get("cm:title"));
        Assert.assertEquals((Object)"test description", (Object)document.getProperties().get("cm:description"));
        props = new HashMap(1);
        props.put("unknownPrefix" + System.currentTimeMillis() + ":description", "test description");
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-2.txt", file2)).setAutoRename(true).setProperties(props).build();
        this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 400);
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-1.txt", file)).setRelativePath("X/Y/Z");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), "?include=path", reqBody.getContentType(), 201);
        document = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-1.txt", (Object)document.getName());
        contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        PathInfo pathInfo = document.getPath();
        Assert.assertNotNull((Object)pathInfo);
        List<PathInfo.ElementInfo> elementInfos = pathInfo.getElements();
        Assert.assertNotNull(elementInfos);
        Assert.assertEquals((long)8L, (long)elementInfos.size());
        Assert.assertEquals((Object)document.getParentId(), (Object)elementInfos.get(7).getId());
        Assert.assertEquals((Object)"Z", (Object)elementInfos.get(7).getName());
        Assert.assertEquals((Object)"Y", (Object)elementInfos.get(6).getName());
        Assert.assertEquals((Object)"X", (Object)elementInfos.get(5).getName());
        Assert.assertEquals((Object)folderA, (Object)elementInfos.get(4).getName());
        reqBody = MultiPartBuilder.copy(multiPartBuilder).setRelativePath("X/Y/Z/" + document.getName()).build();
        this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 409);
        reqBody = MultiPartBuilder.copy(multiPartBuilder).setRelativePath("/X/ Y/Z /CoolFolder/").build();
        response = this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"quick-1.txt", (Object)document.getName());
        contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        response = this.getSingle(NodesEntityResource.class, document.getParentId(), null, 200);
        Folder coolFolder = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)document.getParentId(), (Object)coolFolder.getId());
        Assert.assertEquals((Object)"CoolFolder", (Object)coolFolder.getName());
        reqBody = MultiPartBuilder.copy(multiPartBuilder).setRelativePath("  ").build();
        this.post(this.getNodeChildrenUrl(coolFolder.getId()), reqBody.getBody(), null, reqBody.getContentType(), 409);
        this.setRequestContext(user2);
        reqBody = MultiPartBuilder.copy(multiPartBuilder).setRelativePath("userTwoFolder1/userTwoFolder2").build();
        this.post(this.getNodeChildrenUrl(folderA_id), reqBody.getBody(), null, reqBody.getContentType(), 403);
        this.setRequestContext(user1);
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("invalid:name", file)).build();
        this.post(this.getNodeChildrenUrl(coolFolder.getId()), reqBody.getBody(), null, reqBody.getContentType(), 422);
    }

    @Test
    public void testDelete() throws Exception {
        this.setRequestContext(user1);
        String folder0Name = "f0-testDelete-" + this.RUNID;
        String f0Id = this.createFolder("-my-", folder0Name).getId();
        String content1Id = this.createTextFile(f0Id, "content" + this.RUNID + "_1", "The quick brown fox jumps over the lazy dog.").getId();
        this.deleteNode(content1Id);
        Assert.assertTrue((boolean)this.existsArchiveNode(content1Id));
        this.deleteNode(content1Id, 404);
        String folder1Id = this.createFolder(f0Id, "folder " + this.RUNID + "_1").getId();
        String folder2Id = this.createFolder(folder1Id, "folder " + this.RUNID + "_2").getId();
        String content2Id = this.createTextFile(folder2Id, "content" + this.RUNID + "_2", "The quick brown fox jumps over the lazy dog.").getId();
        this.deleteNode(folder1Id);
        Assert.assertTrue((boolean)this.existsArchiveNode(folder1Id));
        Assert.assertTrue((boolean)this.existsArchiveNode(folder2Id));
        Assert.assertTrue((boolean)this.existsArchiveNode(content2Id));
        this.deleteNode(folder2Id, 404);
        this.deleteNode(content2Id, 404);
        String rootNodeId = this.getRootNodeId();
        this.deleteNode(rootNodeId, 403);
        String folder3Id = this.createFolder(f0Id, "folder " + this.RUNID + "_3").getId();
        String folder4Id = this.createFolder(folder3Id, "folder " + this.RUNID + "_4").getId();
        this.deleteNode(folder3Id, true, 204);
        Assert.assertFalse((boolean)this.existsArchiveNode(folder3Id));
        Assert.assertFalse((boolean)this.existsArchiveNode(folder4Id));
        String sharedNodeId = this.getSharedNodeId();
        final String folder5Id = this.createFolder(sharedNodeId, "folder " + this.RUNID + "_5").getId();
        this.setRequestContext(user2);
        this.deleteNode(folder5Id, 403);
        this.setRequestContext(user1);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PROP_OWNER, user2);
        Node nUpdate = new Node();
        nUpdate.setProperties(props);
        HttpResponse response = this.put("nodes", folder5Id, RestApiUtil.toJsonAsStringNonNull(nUpdate), null, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)user2, ((Map)nodeResp.getProperties().get(PROP_OWNER)).get("id"));
        if (useDefaultNetwork) {
            this.deleteNode(folder5Id, 403);
        }
        final String tenantDomain = networkOne != null ? networkOne.getId() : "";
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                return (Void)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        NodeApiTest.this.permissionService.setPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folder5Id), AbstractBaseApiTest.user1, "Delete", true);
                        return null;
                    }
                }, (String)tenantDomain);
            }
        }, (String)user1);
        this.deleteNode(folder5Id, true, 403);
        this.deleteNode(folder5Id);
        String folder6Id = this.createFolder(sharedNodeId, "folder " + this.RUNID + "_6").getId();
        this.setRequestContext(networkAdmin);
        this.deleteNode(folder6Id, true, 204);
        this.deleteNode(rootNodeId, true, 403);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("relativePath", "/Sites");
        response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String sitesNodeId = nodeResp.getId();
        this.deleteNode(sitesNodeId, true, 403);
        params = new HashMap();
        params.put("relativePath", "/Data Dictionary");
        response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String ddNodeId = nodeResp.getId();
        this.deleteNode(ddNodeId, true, 403);
    }

    private boolean existsArchiveNode(String nodeId) throws Exception {
        boolean result = false;
        HttpResponse response = this.publicApiClient.get(this.getScope(), URL_DELETED_NODES, nodeId, null, null, null);
        if (response != null && response.getStatusCode() == 200) {
            Node node = jacksonUtil.parseEntry(response.getJsonResponse(), Node.class);
            result = node != null && node.getId() != null;
        }
        return result;
    }

    @Test
    public void testMove() throws Exception {
        this.setRequestContext(user1);
        String folder0Name = "f0-testMove-" + this.RUNID;
        String f0Id = this.createFolder("-my-", folder0Name).getId();
        Folder folderResp = this.createFolder(f0Id, "f1");
        String f1Id = folderResp.getId();
        folderResp = this.createFolder(f0Id, "f2");
        String f2Id = folderResp.getId();
        String d1Name = "content" + this.RUNID + "_1";
        String d1Id = this.createTextFile(f1Id, d1Name, "The quick brown fox jumps over the lazy dog 1.").getId();
        String d2Name = "content" + this.RUNID + "_2";
        String d2Id = this.createTextFile(f2Id, d2Name, "The quick brown fox jumps over the lazy dog 2.").getId();
        NodeTarget tgt = new NodeTarget();
        tgt.setTargetParentId(f2Id);
        HttpResponse response = this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)f2Id, (Object)documentResp.getParentId());
        String d1NewName = d1Name + " updated !!";
        tgt = new NodeTarget();
        tgt.setName(d1NewName);
        tgt.setTargetParentId(f1Id);
        response = this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1NewName, (Object)documentResp.getName());
        Assert.assertEquals((Object)f1Id, (Object)documentResp.getParentId());
        tgt = new NodeTarget();
        tgt.setName("new name");
        this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 400);
        tgt = new NodeTarget();
        tgt.setName(d2Name);
        tgt.setTargetParentId(f2Id);
        this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 409);
        tgt = new NodeTarget();
        tgt.setTargetParentId(f2Id);
        this.post("nodes/" + UUID.randomUUID().toString() + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 404);
        tgt = new NodeTarget();
        tgt.setTargetParentId(UUID.randomUUID().toString());
        this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 404);
        tgt = new NodeTarget();
        tgt.setTargetParentId(d2Id);
        this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 400);
        String rootNodeId = this.getRootNodeId();
        folderResp = this.createFolder(f2Id, "f3");
        String f3Id = folderResp.getId();
        tgt = new NodeTarget();
        tgt.setTargetParentId(f3Id);
        this.post("nodes/" + f2Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 400);
        tgt = new NodeTarget();
        tgt.setTargetParentId(rootNodeId);
        this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 403);
        this.setRequestContext(user2);
        String my2NodeId = this.getMyNodeId();
        tgt = new NodeTarget();
        tgt.setTargetParentId(my2NodeId);
        this.post("nodes/" + f1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 403);
        this.setRequestContext(networkAdmin);
        this.post("nodes/" + rootNodeId + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 403);
        this.setRequestContext(user1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("relativePath", "/Sites");
        response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String sitesNodeId = nodeResp.getId();
        this.setRequestContext(networkAdmin);
        this.post("nodes/" + sitesNodeId + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 403);
        this.setRequestContext(user1);
        params = new HashMap();
        params.put("relativePath", "/Data Dictionary");
        response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String ddNodeId = nodeResp.getId();
        this.setRequestContext(networkAdmin);
        this.post("nodes/" + ddNodeId + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 403);
        ArrayList<NodeTarget> nodeDestinations = new ArrayList<NodeTarget>(2);
        NodeTarget nodeTarget = new NodeTarget();
        nodeTarget.setTargetParentId(f1Id);
        nodeDestinations.add(nodeTarget);
        nodeTarget = new NodeTarget();
        nodeTarget.setTargetParentId(f2Id);
        nodeDestinations.add(nodeTarget);
        this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(nodeDestinations), null, 405);
    }

    @Test
    public void testCopy() throws Exception {
        this.setRequestContext(user1);
        Folder folderResp = this.createFolder("-my-", "fsource");
        String sourceId = folderResp.getId();
        folderResp = this.createFolder("-my-", "ftarget");
        String targetId = folderResp.getId();
        String d1Name = "content" + this.RUNID + "_1";
        String d1Id = this.createTextFile(sourceId, d1Name, "The quick brown fox jumps over the lazy dog 1.").getId();
        String d2Name = "content" + this.RUNID + "_2";
        String d2Id = this.createTextFile(sourceId, d2Name, "The quick brown fox jumps over the lazy dog 2.").getId();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("targetParentId", targetId);
        HttpResponse response = this.post("nodes", d1Id, "copy", RestApiUtil.toJsonAsStringNonNull(body).getBytes(), null, null, 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)targetId, (Object)documentResp.getParentId());
        String newD2Name = d2Name + " updated !!";
        body = new HashMap();
        body.put("targetParentId", targetId);
        body.put("name", newD2Name);
        response = this.post("nodes", d2Id, "copy", RestApiUtil.toJsonAsStringNonNull(body).getBytes(), null, null, 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)newD2Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)targetId, (Object)documentResp.getParentId());
        NodeTarget tgt = new NodeTarget();
        tgt.setName("new name");
        this.post("nodes/" + d1Id + "/copy", RestApiUtil.toJsonAsStringNonNull(tgt), null, 400);
        tgt = new NodeTarget();
        tgt.setName(newD2Name);
        tgt.setTargetParentId(targetId);
        this.post("nodes/" + d1Id + "/copy", RestApiUtil.toJsonAsStringNonNull(tgt), null, 409);
        tgt = new NodeTarget();
        tgt.setTargetParentId(sourceId);
        this.post("nodes/" + d1Id + "/copy", RestApiUtil.toJsonAsStringNonNull(tgt), null, 409);
        tgt = new NodeTarget();
        tgt.setTargetParentId(targetId);
        this.post("nodes/" + UUID.randomUUID().toString() + "/copy", RestApiUtil.toJsonAsStringNonNull(tgt), null, 404);
        tgt = new NodeTarget();
        tgt.setTargetParentId(UUID.randomUUID().toString());
        this.post("nodes/" + d1Id + "/copy", RestApiUtil.toJsonAsStringNonNull(tgt), null, 404);
        tgt = new NodeTarget();
        tgt.setTargetParentId(d2Id);
        this.post("nodes/" + d1Id + "/copy", RestApiUtil.toJsonAsStringNonNull(tgt), null, 400);
        String rootNodeId = this.getRootNodeId();
        tgt = new NodeTarget();
        tgt.setTargetParentId(rootNodeId);
        this.post("nodes/" + d1Id + "/copy", RestApiUtil.toJsonAsStringNonNull(tgt), null, 403);
        ArrayList<NodeTarget> nodeDestinations = new ArrayList<NodeTarget>(2);
        NodeTarget nodeTarget = new NodeTarget();
        nodeTarget.setTargetParentId(sourceId);
        nodeDestinations.add(nodeTarget);
        nodeTarget = new NodeTarget();
        nodeTarget.setTargetParentId(targetId);
        nodeDestinations.add(nodeTarget);
        this.post("nodes/" + d1Id + "/copy", RestApiUtil.toJsonAsStringNonNull(nodeDestinations), null, 405);
    }

    @Test
    public void testCopySite() throws Exception {
        this.setRequestContext(user1);
        Folder folderResp = this.createFolder("-my-", "siteCopytarget");
        String targetId = folderResp.getId();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("targetParentId", targetId);
        HttpResponse response = this.getSingle("sites", tSiteId, null, null, 200);
        Site siteResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Site.class);
        String siteNodeId = siteResp.getGuid();
        this.post("nodes/" + siteNodeId + "/copy", RestApiUtil.toJsonAsStringNonNull(body), null, 422);
        this.post("nodes/" + tDocLibNodeId + "/copy", RestApiUtil.toJsonAsStringNonNull(body), null, 422);
    }

    @Test
    public void testMoveCopyBetweenSites() throws Exception {
        this.setRequestContext(user1);
        String site1Title = "site-testMoveCopyBetweenSites1-" + this.RUNID;
        String site1Id = this.createSite(site1Title, SiteVisibility.PUBLIC).getId();
        this.addSiteMember(site1Id, user2, SiteRole.SiteCollaborator);
        String user1SitetDocLibNodeId = this.getSiteContainerNodeId(site1Id, "documentLibrary");
        String user1Folder = "folder" + this.RUNID + "_user1";
        String user1FolderNodeId = this.createFolder(user1SitetDocLibNodeId, user1Folder, null).getId();
        this.setRequestContext(user2);
        String site2Title = "site-testMoveCopyBetweenSites2--" + this.RUNID;
        String site2Id = this.createSite(site2Title, SiteVisibility.PUBLIC).getId();
        this.addSiteMember(site2Id, user1, SiteRole.SiteCollaborator);
        String user2SitetDocLibNodeId = this.getSiteContainerNodeId(site2Id, "documentLibrary");
        String user2Folder1 = "folder1" + this.RUNID + "_user2";
        String user2FolderNodeId = this.createFolder(user1SitetDocLibNodeId, user2Folder1, null).getId();
        String user2Folder2 = "folder2" + this.RUNID + "_user2";
        String user2Folder2NodeId = this.createFolder(user1SitetDocLibNodeId, user2Folder2, null).getId();
        this.setRequestContext(user1);
        NodeTarget target = new NodeTarget();
        target.setTargetParentId(user2SitetDocLibNodeId);
        HttpResponse response = this.post("nodes/" + user2FolderNodeId + "/move", RestApiUtil.toJsonAsStringNonNull(target), null, 200);
        Folder moveFolderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)user2SitetDocLibNodeId, (Object)moveFolderResp.getParentId());
        target = new NodeTarget();
        target.setTargetParentId(user1SitetDocLibNodeId);
        this.post("nodes/" + user2FolderNodeId + "/move", RestApiUtil.toJsonAsStringNonNull(target), null, 403);
        target = new NodeTarget();
        target.setTargetParentId(user2SitetDocLibNodeId);
        response = this.post("nodes/" + user1FolderNodeId + "/move", RestApiUtil.toJsonAsStringNonNull(target), null, 200);
        moveFolderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)user2SitetDocLibNodeId, (Object)moveFolderResp.getParentId());
        target = new NodeTarget();
        target.setTargetParentId(user1SitetDocLibNodeId);
        response = this.post("nodes/" + user1FolderNodeId + "/move", RestApiUtil.toJsonAsStringNonNull(target), null, 200);
        moveFolderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)user1SitetDocLibNodeId, (Object)moveFolderResp.getParentId());
        target = new NodeTarget();
        target.setTargetParentId(user2SitetDocLibNodeId);
        response = this.post("nodes/" + user2Folder2NodeId + "/copy", RestApiUtil.toJsonAsStringNonNull(target), null, 201);
        Folder copyFolderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)user2SitetDocLibNodeId, (Object)copyFolderResp.getParentId());
        this.deleteNode(copyFolderResp.getId(), true, 204);
        this.getSingle("nodes", copyFolderResp.getId(), 404);
        this.setRequestContext(user1);
        this.deleteSite(site1Id, true, 204);
        this.setRequestContext(user2);
        this.deleteSite(site2Id, true, 204);
    }

    @Test
    public void testCreateFolder() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        UserInfo expectedUser = new UserInfo(user1);
        String postUrl = this.getNodeChildrenUrl(myNodeId);
        Folder folderResp = this.createFolder(myNodeId, "f1");
        String f1Id = folderResp.getId();
        Folder f1 = new Folder();
        f1.setName("f1");
        f1.setNodeType("cm:folder");
        f1.setIsFolder(true);
        f1.setParentId(myNodeId);
        f1.setAspectNames(Collections.singletonList("cm:auditable"));
        f1.setCreatedByUser(expectedUser);
        f1.setModifiedByUser(expectedUser);
        f1.expected(folderResp);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("cm:title", "my folder title");
        props.put("cm:description", "my folder description");
        folderResp = this.createFolder(f1Id, "f2", props);
        String f2Id = folderResp.getId();
        Folder f2 = new Folder();
        f2.setName("f2");
        f2.setNodeType("cm:folder");
        f2.setProperties(props);
        f2.setIsFolder(true);
        f2.setParentId(f1Id);
        f2.setAspectNames(Arrays.asList("cm:auditable", "cm:titled"));
        f2.setCreatedByUser(expectedUser);
        f2.setModifiedByUser(expectedUser);
        f2.expected(folderResp);
        Node n = new Node();
        n.setName("fZ");
        n.setNodeType("cm:folder");
        n.setRelativePath("/f1/f2/f3/f4");
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(n), 201);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        response = this.getSingle(NodesEntityResource.class, folderResp.getId(), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderResp.getName(), (Object)"fZ");
        response = this.getSingle(NodesEntityResource.class, folderResp.getParentId(), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderResp.getName(), (Object)"f4");
        response = this.getSingle(NodesEntityResource.class, folderResp.getParentId(), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderResp.getName(), (Object)"f3");
        response = this.getSingle(NodesEntityResource.class, folderResp.getParentId(), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderResp.getName(), (Object)"f2");
        Assert.assertEquals((Object)folderResp.getId(), (Object)f2Id);
        Folder invalid = new Folder();
        invalid.setNodeType("cm:folder");
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 400);
        invalid = new Folder();
        invalid.setName("inv:alid");
        invalid.setNodeType("cm:folder");
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 422);
        invalid = new Folder();
        invalid.setName("my folder");
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 400);
        Document d1 = new Document();
        d1.setName("d1.txt");
        d1.setNodeType("cm:content");
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String d1Id = documentResp.getId();
        Folder f3 = new Folder();
        f3.setName("f3");
        f3.setNodeType("cm:folder");
        this.post(this.getNodeChildrenUrl(d1Id), RestApiUtil.toJsonAsStringNonNull(f3), 422);
        invalid = new Folder();
        invalid.setName("my sys folder");
        invalid.setNodeType("cm:systemfolder");
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 400);
        this.post(this.getNodeChildrenUrl(UUID.randomUUID().toString()), RestApiUtil.toJsonAsStringNonNull(f3), 404);
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(f1), 409);
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(f1), "?autoRename=true", 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"f1-1", (Object)documentResp.getName());
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(f1), "?autoRename=true", 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"f1-2", (Object)documentResp.getName());
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(f1), "?autoRename=false", 409);
        n = new Node();
        n.setName("fX");
        n.setNodeType("cm:folder");
        n.setRelativePath("/f1/f2");
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(n), "?autoRename=true", 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"fX", (Object)documentResp.getName());
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(n), "?autoRename=true", 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"fX-1", (Object)documentResp.getName());
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(n), "?autoRename=false", 409);
        n = new Node();
        n.setName("fX");
        n.setNodeType("cm:folder");
        n.setRelativePath("/f1/inv:alid");
        this.post(this.getNodeChildrenUrl(f2Id), RestApiUtil.toJsonAsStringNonNull(n), 422);
        n = new Node();
        n.setName("fY");
        n.setNodeType("cm:folder");
        n.setRelativePath("d1.txt");
        this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(n), 409);
        props = new HashMap();
        props.put("exif:pixelYDimension", "my unknown property");
        n = new Folder();
        n.setName("fZ");
        n.setNodeType("cm:folder");
        n.setProperties(props);
        this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(n), 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChildrenAssocType() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String fId = null;
        try {
            fId = this.createFolder(myNodeId, "testChildrenAssocType folder").getId();
            Node nodeUpdate = new Node();
            nodeUpdate.setAspectNames(Collections.singletonList("cm:preferences"));
            this.put("nodes", fId, RestApiUtil.toJsonAsStringNonNull(nodeUpdate), null, 200);
            HttpResponse response = this.getAll(this.getNodeChildrenUrl(fId), null, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            Node obj = new Node();
            obj.setName("c1");
            obj.setNodeType("cm:content");
            response = this.post(this.getNodeChildrenUrl(fId), RestApiUtil.toJsonAsStringNonNull(obj), 201);
            Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            String c1Id = nodeResp.getId();
            Assert.assertEquals((Object)fId, (Object)nodeResp.getParentId());
            response = this.getAll(this.getNodeChildrenUrl(fId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            obj = new Node();
            obj.setName("c2");
            obj.setNodeType("cm:content");
            Association assoc = new Association();
            assoc.setAssocType("cm:preferenceImage");
            obj.setAssociation(assoc);
            response = this.post(this.getNodeChildrenUrl(fId), RestApiUtil.toJsonAsStringNonNull(obj), 201);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            String c2Id = nodeResp.getId();
            Assert.assertEquals((Object)fId, (Object)nodeResp.getParentId());
            response = this.getAll(this.getNodeChildrenUrl(fId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("where", "(assocType='cm:contains')");
            params.put("include", "association");
            response = this.getAll(this.getNodeChildrenUrl(fId), null, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)c1Id, (Object)nodes.get(0).getId());
            Assert.assertTrue((boolean)nodes.get(0).getAssociation().getIsPrimary());
            params = new HashMap();
            params.put("where", "(assocType='cm:preferenceImage')");
            params.put("include", "association");
            response = this.getAll(this.getNodeChildrenUrl(fId), null, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)c2Id, (Object)nodes.get(0).getId());
            Assert.assertTrue((boolean)nodes.get(0).getAssociation().getIsPrimary());
            obj = new Node();
            obj.setName("c3");
            obj.setNodeType("cm:content");
            nodeUpdate.setAspectNames(Collections.singletonList("cm:preferences"));
            response = this.post(this.getNodeChildrenUrl(fId), RestApiUtil.toJsonAsStringNonNull(obj), 201);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            String c3Id = nodeResp.getId();
            obj = new Node();
            obj.setName("c4");
            obj.setNodeType("cm:content");
            assoc = new Association();
            assoc.setAssocType("cm:preferenceImage");
            obj.setAssociation(assoc);
            response = this.post(this.getNodeChildrenUrl(c3Id), RestApiUtil.toJsonAsStringNonNull(obj), 201);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)c3Id, (Object)nodeResp.getParentId());
            obj = new Node();
            obj.setName("c5");
            obj.setNodeType("cm:content");
            assoc = new Association();
            assoc.setAssocType("cm:contains");
            obj.setAssociation(assoc);
            this.post(this.getNodeChildrenUrl(c3Id), RestApiUtil.toJsonAsStringNonNull(obj), 422);
        }
        finally {
            if (fId != null) {
                this.deleteNode(fId);
            }
        }
    }

    @Test
    public void testListChildrenIsFileIsFolderFilter() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String fId = this.createFolder(myNodeId, "f1-testUpdateOwner-" + this.RUNID).getId();
        String childrenUrl = this.getNodeChildrenUrl(fId);
        int folderCnt = 2;
        int fileCnt = 3;
        int objCnt = 4;
        ArrayList<String> folderIds = new ArrayList<String>(folderCnt);
        for (int i = 1; i <= folderCnt; ++i) {
            folderIds.add(this.createFolder(fId, "folder " + i + " " + this.RUNID).getId());
        }
        ArrayList<String> fileIds = new ArrayList<String>(fileCnt);
        for (int i = 1; i <= fileCnt; ++i) {
            fileIds.add(this.createTextFile(fId, "file " + i + " " + this.RUNID, "The quick brown fox jumps over the lazy dog " + i).getId());
        }
        ArrayList<String> objIds = new ArrayList<String>(objCnt);
        for (int i = 1; i <= objCnt; ++i) {
            Node obj = new Node();
            obj.setName("obj " + i + " " + this.RUNID);
            obj.setNodeType("cm:cmobject");
            HttpResponse response = this.post(childrenUrl, RestApiUtil.toJsonAsStringNonNull(obj), 201);
            Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            objIds.add(nodeResp.getId());
        }
        ArrayList<String> allIds = new ArrayList<String>(objCnt + folderCnt + fileCnt);
        allIds.addAll(folderIds);
        allIds.addAll(fileIds);
        allIds.addAll(objIds);
        ArrayList<String> folderAndFileIds = new ArrayList<String>(folderCnt + fileCnt);
        folderAndFileIds.addAll(folderIds);
        folderAndFileIds.addAll(fileIds);
        ArrayList<String> notFileIds = new ArrayList<String>(folderCnt + objCnt);
        notFileIds.addAll(folderIds);
        notFileIds.addAll(objIds);
        ArrayList<String> notFolderIds = new ArrayList<String>(fileCnt + objCnt);
        notFolderIds.addAll(fileIds);
        notFolderIds.addAll(objIds);
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HttpResponse response = this.getAll(childrenUrl, paging, null, 200);
        List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, allIds);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("where", "(nodeType='cm:folder')");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, folderIds);
        params = new HashMap();
        params.put("where", "(isFolder=true)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, folderIds);
        params = new HashMap();
        params.put("where", "(isFolder=true AND isFile=false)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, folderIds);
        params = new HashMap();
        params.put("where", "(nodeType='cm:content')");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, fileIds);
        params = new HashMap();
        params.put("where", "(isFile=true)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, fileIds);
        params = new HashMap();
        params.put("where", "(isFile=true AND isFolder=false)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, fileIds);
        params = new HashMap();
        params.put("where", "(nodeType='cm:cmobject')");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, objIds);
        params = new HashMap();
        params.put("where", "(nodeType='cm:cmobject INCLUDESUBTYPES')");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, allIds);
        params = new HashMap();
        params.put("where", "(isFile=false AND isFolder=false)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, objIds);
        params = new HashMap();
        params.put("where", "(isFile=false)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, notFileIds);
        params = new HashMap();
        params.put("where", "(isFolder=false)");
        response = this.getAll(childrenUrl, paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        this.checkNodeIds(nodes, notFolderIds);
        params = new HashMap();
        params.put("where", "(isFile=true AND isFolder=true)");
        this.getAll(childrenUrl, paging, params, 400);
        params = new HashMap();
        params.put("where", "(nodeType='cm:object' AND isFolder=true)");
        this.getAll(childrenUrl, paging, params, 400);
        params = new HashMap();
        params.put("where", "(nodeType='cm:object' AND isFile=true)");
        this.getAll(childrenUrl, paging, params, 400);
    }

    private void checkNodeIds(List<Node> nodes, List<String> nodeIds) {
        Assert.assertEquals((long)nodeIds.size(), (long)nodes.size());
        for (Node node : nodes) {
            Assert.assertTrue((boolean)nodeIds.contains(node.getId()));
        }
    }

    @Test
    public void testLinkCRUD() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        UserInfo expectedUser = new UserInfo(user1);
        String myChildrenUrl = this.getNodeChildrenUrl(myNodeId);
        Folder folderResp = this.createFolder(myNodeId, "f1 " + this.RUNID);
        String f1Id = folderResp.getId();
        Document d1 = new Document();
        d1.setName("d1.txt");
        d1.setNodeType("cm:content");
        HttpResponse response = this.post(this.getNodeChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String d1Id = documentResp.getId();
        folderResp = this.createFolder(myNodeId, "f2 " + this.RUNID);
        String f2Id = folderResp.getId();
        String nodeName = "f1 link";
        String nodeType = "app:folderlink";
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("cm:destination", f1Id);
        Node nodeResp = this.createNode(f2Id, nodeName, nodeType, props);
        String n1Id = nodeResp.getId();
        Node n1 = new Node();
        n1.setName(nodeName);
        n1.setNodeType(nodeType);
        n1.setIsFolder(true);
        n1.setParentId(f2Id);
        n1.setAspectNames(Collections.singletonList("cm:auditable"));
        n1.setProperties(props);
        n1.setCreatedByUser(expectedUser);
        n1.setModifiedByUser(expectedUser);
        n1.expected(nodeResp);
        response = this.getSingle(NodesEntityResource.class, n1Id, null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        n1.expected(nodeResp);
        nodeName = "d1 link";
        nodeType = "app:filelink";
        props = new HashMap();
        props.put("cm:destination", d1Id);
        nodeResp = this.createNode(f2Id, nodeName, nodeType, props);
        String n2Id = nodeResp.getId();
        Node n2 = new Node();
        n2.setName(nodeName);
        n2.setNodeType(nodeType);
        n2.setIsFolder(false);
        n2.setParentId(f2Id);
        n2.setAspectNames(Collections.singletonList("cm:auditable"));
        n2.setProperties(props);
        n2.setCreatedByUser(expectedUser);
        n2.setModifiedByUser(expectedUser);
        n2.expected(nodeResp);
        response = this.getSingle(NodesEntityResource.class, n2Id, null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        n2.expected(nodeResp);
        String updatedName = "f1 link renamed";
        Node nUpdate = new Node();
        nUpdate.setName(updatedName);
        response = this.put("nodes", n1Id, RestApiUtil.toJsonAsStringNonNull(nUpdate), null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        n1.setName(updatedName);
        n1.expected(nodeResp);
        List<String> linkIds = Arrays.asList(n1Id, n2Id);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("where", "(nodeType='cm:link')");
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        response = this.getAll(this.getNodeChildrenUrl(f2Id), paging, params, 200);
        List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)0L, (long)nodes.size());
        params = new HashMap();
        params.put("where", "(nodeType='cm:link INCLUDESUBTYPES')");
        paging = this.getPaging(0, Integer.MAX_VALUE);
        response = this.getAll(this.getNodeChildrenUrl(f2Id), paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)linkIds.size(), (long)nodes.size());
        Assert.assertTrue((boolean)linkIds.contains(nodes.get(0).getId()));
        Assert.assertTrue((boolean)linkIds.contains(nodes.get(1).getId()));
        params = new HashMap();
        params.put("where", "(nodeType='cm:link includeSubTypes')");
        paging = this.getPaging(0, Integer.MAX_VALUE);
        response = this.getAll(this.getNodeChildrenUrl(f2Id), paging, params, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)linkIds.size(), (long)nodes.size());
        Assert.assertTrue((boolean)linkIds.contains(nodes.get(0).getId()));
        Assert.assertTrue((boolean)linkIds.contains(nodes.get(1).getId()));
        this.deleteNode(n1Id);
        this.deleteNode(n1Id, 404);
        Node invalid = new Node();
        invalid.setNodeType("cm:link");
        this.post(myChildrenUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 400);
        invalid = new Node();
        invalid.setName("my node");
        this.post(myChildrenUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 400);
        invalid = new Node();
        invalid.setName("my node");
        invalid.setNodeType("sys:base");
        this.post(myChildrenUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 400);
        this.post(this.getNodeChildrenUrl(f2Id), RestApiUtil.toJsonAsStringNonNull(n2), 409);
        params = new HashMap();
        params.put("where", "(nodeType='my:unknown'");
        this.getAll(this.getNodeChildrenUrl(f2Id), paging, params, 400);
        params = new HashMap();
        params.put("where", "(nodeType='cm:link ')");
        this.getAll(this.getNodeChildrenUrl(f2Id), paging, params, 400);
        params = new HashMap();
        params.put("where", "(nodeType='cm:link blah')");
        this.getAll(this.getNodeChildrenUrl(f2Id), paging, params, 400);
    }

    @Test
    public void testMultipartFormDataUpload() throws Exception {
        this.setRequestContext(user1);
        String fileName = "quick-1.txt";
        File file = this.getResourceFile("quick-1.txt");
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick-1.txt", file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        this.post(this.getNodeChildrenUrl("-my-"), "", null, reqBody.getContentType(), 400);
        this.post(this.getNodeChildrenUrl("-my-"), reqBody.getBody(), null, "multipart/form-data", 415);
    }

    @Test
    public void testCreateEmptyFile() throws Exception {
        this.setRequestContext(user1);
        String folder0Name = "f0-testCreateEmptyFile-" + this.RUNID;
        String f0Id = this.createFolder("-my-", folder0Name).getId();
        UserInfo expectedUser = new UserInfo(user1);
        String postUrl = this.getNodeChildrenUrl(f0Id);
        Document d1 = new Document();
        d1.setName("d1.txt");
        d1.setNodeType("cm:content");
        HttpResponse response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String d1Id = documentResp.getId();
        d1.setIsFolder(false);
        d1.setParentId(f0Id);
        d1.setAspectNames(Collections.singletonList("cm:auditable"));
        d1.setCreatedByUser(expectedUser);
        d1.setModifiedByUser(expectedUser);
        ContentInfo ciExpected = new ContentInfo();
        ciExpected.setMimeType("text/plain");
        ciExpected.setMimeTypeName("Plain Text");
        ciExpected.setSizeInBytes(0L);
        ciExpected.setEncoding("UTF-8");
        d1.setContent(ciExpected);
        d1.expected(documentResp);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("cm:title", "my file title");
        props.put("cm:description", "my file description");
        Document d2 = new Document();
        d2.setName("d2.txt");
        d2.setNodeType("cm:content");
        d2.setProperties(props);
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d2), 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        d2.setIsFolder(false);
        d2.setParentId(f0Id);
        d2.setAspectNames(Arrays.asList("cm:auditable", "cm:titled"));
        d2.setCreatedByUser(expectedUser);
        d2.setModifiedByUser(expectedUser);
        ciExpected = new ContentInfo();
        ciExpected.setMimeType("text/plain");
        ciExpected.setMimeTypeName("Plain Text");
        ciExpected.setSizeInBytes(0L);
        ciExpected.setEncoding("UTF-8");
        d2.setContent(ciExpected);
        d2.expected(documentResp);
        Node n = new Node();
        n.setName("d3.txt");
        n.setNodeType("cm:content");
        n.setRelativePath("/f1/f2");
        response = this.post(this.getNodeChildrenUrl(f0Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        response = this.getSingle(NodesEntityResource.class, documentResp.getId(), null, 200);
        Folder folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderResp.getName(), (Object)"d3.txt");
        response = this.getSingle(NodesEntityResource.class, folderResp.getParentId(), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderResp.getName(), (Object)"f2");
        response = this.getSingle(NodesEntityResource.class, folderResp.getParentId(), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderResp.getName(), (Object)"f1");
        response = this.getSingle(NodesEntityResource.class, folderResp.getParentId(), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)f0Id, (Object)folderResp.getId());
        Document invalid = new Document();
        invalid.setNodeType("cm:content");
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 400);
        invalid = new Document();
        invalid.setName("my file.txt");
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(invalid), 400);
        Document d3 = new Document();
        d3.setName("d3.txt");
        d3.setNodeType("cm:content");
        this.post(this.getNodeChildrenUrl(d1Id), RestApiUtil.toJsonAsStringNonNull(d3), 422);
        this.post(this.getNodeChildrenUrl(UUID.randomUUID().toString()), RestApiUtil.toJsonAsStringNonNull(d3), 404);
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), 409);
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), "?autoRename=true", 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"d1-1.txt", (Object)documentResp.getName());
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), "?autoRename=true", 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"d1-2.txt", (Object)documentResp.getName());
        d1.setName("d1-2.txt");
        response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), "?autoRename=true", 201);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"d1-2-1.txt", (Object)documentResp.getName());
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), "?autoRename=false", 409);
    }

    @Test
    public void testUpdateNodeConcurrentlyUsingInMemoryBacked() throws Exception {
        this.updateNodeConcurrently(1024L);
    }

    @Test
    public void testUpdateNodeConcurrentlyUsingFileBacked() throws Exception {
        this.updateNodeConcurrently(0x500000L);
    }

    private void updateNodeConcurrently(Long contentSize) throws Exception {
        this.setRequestContext(user1);
        String folder0Name = "f0-testUpdateNodeConcurrently-" + this.RUNID;
        String f0Id = this.createFolder("-my-", folder0Name).getId();
        Document d1 = new Document();
        d1.setName("d1.txt");
        d1.setNodeType("cm:content");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("majorVersion", "true");
        Document documentResp = this.createEmptyTextFile(f0Id, d1.getName(), params, 201);
        Assert.assertEquals((Object)"1.0", (Object)documentResp.getProperties().get("cm:versionLabel"));
        String docId = documentResp.getId();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 2; ++i) {
            UpdateNodeRunnable task = new UpdateNodeRunnable(docId, contentSize);
            Thread worker = new Thread(task);
            worker.setName(String.valueOf(i));
            worker.start();
            threads.add(worker);
        }
        int running = 0;
        do {
            running = 0;
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                ++running;
            }
        } while (running > 0);
        HttpResponse response = this.getSingle("nodes", docId, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertTrue((String)"File size is 0 bytes", (documentResp.getContent().getSizeInBytes().intValue() > 0 ? 1 : 0) != 0);
        response = this.getSingle(NodesEntityResource.class, docId + "/content", null, 200);
        byte[] bytes = response.getResponseAsBytes();
        Assert.assertEquals((long)contentSize.intValue(), (long)bytes.length);
    }

    protected Document updateTextFileWithRandomContent(String contentId, Long contentSize, Map<String, String> params) throws Exception {
        return this.updateTextFileWithRandomContent(contentId, contentSize, params, 200);
    }

    protected Document updateTextFileWithRandomContent(String contentId, Long contentSize, Map<String, String> params, int expectedStatus) throws Exception {
        File txtFile = TempFileProvider.createTempFile((String)this.getClass().getSimpleName(), (String)".txt");
        RandomAccessFile file = new RandomAccessFile(txtFile.getPath(), "rw");
        file.setLength(contentSize);
        file.close();
        PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
        HttpResponse response = this.putBinary(this.getNodeContentUrl(contentId), payload, null, params, expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
    }

    @Test
    public void testUpdateNodeInfo() throws Exception {
        this.setRequestContext(user1);
        String folder0Name = "f0-testUpdateNodeInfo-" + this.RUNID;
        String f0Id = this.createFolder("-my-", folder0Name).getId();
        UserInfo expectedUser = new UserInfo(user1);
        String postUrl = this.getNodeChildrenUrl(f0Id);
        String folderName = "My Folder";
        Folder folderResp = this.createFolder(f0Id, folderName);
        String fId = folderResp.getId();
        Folder f1 = new Folder();
        f1.setName(folderName);
        f1.setNodeType("cm:folder");
        f1.setIsFolder(true);
        f1.setParentId(f0Id);
        f1.setAspectNames(Collections.singletonList("cm:auditable"));
        f1.setCreatedByUser(expectedUser);
        f1.setModifiedByUser(expectedUser);
        f1.expected(folderResp);
        Document d1 = new Document();
        d1.setName("d1.txt");
        d1.setNodeType("cm:content");
        HttpResponse response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String dId = documentResp.getId();
        d1.setIsFolder(false);
        d1.setParentId(f0Id);
        d1.setAspectNames(Collections.singletonList("cm:auditable"));
        d1.setCreatedByUser(expectedUser);
        d1.setModifiedByUser(expectedUser);
        ContentInfo ciExpected = new ContentInfo();
        ciExpected.setMimeType("text/plain");
        ciExpected.setMimeTypeName("Plain Text");
        ciExpected.setSizeInBytes(0L);
        ciExpected.setEncoding("UTF-8");
        d1.setContent(ciExpected);
        d1.expected(documentResp);
        Document dUpdate = new Document();
        dUpdate.setName("d1b.txt");
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        d1.setName("d1b.txt");
        d1.expected(documentResp);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("cm:title", "my file title");
        props.put("cm:description", "my file description");
        dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        d1.setProperties(props);
        d1.setAspectNames(Arrays.asList("cm:auditable", "cm:titled"));
        d1.expected(documentResp);
        dUpdate = new Document();
        dUpdate.setAspectNames(Arrays.asList("cm:auditable", "cm:titled", "cm:versionable"));
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        d1.getProperties().put("cm:versionLabel", "1.0");
        d1.getProperties().put("cm:versionType", "MAJOR");
        d1.setAspectNames(Arrays.asList("cm:auditable", "cm:titled", "cm:versionable"));
        d1.expected(documentResp);
        response = this.getSingle("nodes", dId, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        d1.getProperties().put("cm:versionLabel", "1.0");
        d1.getProperties().put("cm:versionType", "MAJOR");
        d1.expected(documentResp);
        dUpdate = new Document();
        dUpdate.setAspectNames(Arrays.asList("cm:auditable", "cm:versionable"));
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        d1.getProperties().remove("cm:title");
        d1.getProperties().remove("cm:description");
        d1.setAspectNames(Arrays.asList("cm:auditable", "cm:versionable"));
        d1.expected(documentResp);
        props = new HashMap();
        props.put("cm:title", "my folder title");
        props.put("cm:description", "my folder description");
        folderName = "My Updated Folder";
        Folder fUpdate = new Folder();
        fUpdate.setProperties(props);
        fUpdate.setName(folderName);
        response = this.put("nodes", fId, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        f1.setName(folderName);
        f1.setAspectNames(Arrays.asList("cm:auditable", "cm:titled"));
        f1.setProperties(props);
        f1.expected(folderResp);
        props = new HashMap();
        props.put("cm:title", null);
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        response = this.put("nodes", fId, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        f1.getProperties().remove("cm:title");
        f1.expected(folderResp);
        fUpdate = new Folder();
        fUpdate.setNodeType("app:glossary");
        response = this.put("nodes", fId, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        f1.setNodeType("app:glossary");
        f1.expected(folderResp);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("majorVersion", "true");
        params.put("comment", "Initial empty file :-)");
        String fileName = "My File";
        Node nodeResp = this.createEmptyTextFile(f0Id, fileName, params, 201);
        Assert.assertEquals((Object)"1.0", (Object)nodeResp.getProperties().get("cm:versionLabel"));
        props = new HashMap();
        props.put("cm:title", "my file title");
        dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)"1.0", (Object)nodeResp.getProperties().get("cm:versionLabel"));
        props = new HashMap();
        props.put("cm:autoVersionOnUpdateProps", true);
        dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)"1.1", (Object)nodeResp.getProperties().get("cm:versionLabel"));
        props = new HashMap();
        props.put("cm:title", "my file title 2");
        dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)"1.2", (Object)nodeResp.getProperties().get("cm:versionLabel"));
        props = new HashMap();
        props.put("cm:title", "my file title 3");
        dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)"1.3", (Object)nodeResp.getProperties().get("cm:versionLabel"));
        props = new HashMap();
        props.put("cm:autoVersionOnUpdateProps", false);
        dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)"1.3", (Object)nodeResp.getProperties().get("cm:versionLabel"));
        props = new HashMap();
        props.put("cm:title", "my file title 4");
        dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)"1.3", (Object)nodeResp.getProperties().get("cm:versionLabel"));
        response = this.getSingle("nodes", "-my-", 200);
        Folder user1MyFolder = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        String user1MyFolderId = user1MyFolder.getId();
        String description = "my folder description " + this.RUNID;
        props = new HashMap();
        props.put("cm:description", description);
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        response = this.put("nodes", "-my-", RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)description, (Object)folderResp.getProperties().get("cm:description"));
        this.setRequestContext(networkAdmin);
        props = new HashMap();
        props.put("cm:description", description);
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        response = this.put("nodes", "-root-", RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)description, (Object)folderResp.getProperties().get("cm:description"));
        props = new HashMap();
        props.put("cm:description", description);
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        response = this.put("nodes", "-shared-", RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)description, (Object)folderResp.getProperties().get("cm:description"));
        this.setRequestContext(user1);
        props = new HashMap();
        props.put("cm:xyz", "my unknown property");
        dUpdate = new Document();
        dUpdate.setProperties(props);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
        ArrayList<String> aspects = new ArrayList<String>(d1.getAspectNames());
        aspects.add("cm:unknownAspect");
        dUpdate = new Document();
        dUpdate.setAspectNames(aspects);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
        dUpdate = new Document();
        dUpdate.setName(folderName);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 409);
        dUpdate = new Document();
        dUpdate.setName("some.txt");
        this.put("nodes", UUID.randomUUID().toString(), RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 404);
        fUpdate = new Folder();
        fUpdate.setNodeType("cm:folder");
        this.put("nodes", fId, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 400);
        folderResp = this.createFolder(f0Id, "folder 2");
        String f2Id = folderResp.getId();
        fUpdate = new Folder();
        fUpdate.setParentId(f2Id);
        this.put("nodes", fId, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 400);
        fUpdate = new Folder();
        fUpdate.setParentId(f0Id);
        this.put("nodes", fId, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        props = new HashMap();
        props.put("exif:pixelYDimension", "my unknown property");
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        this.put("nodes", f2Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 400);
        props = new HashMap();
        props.put("exif:dateTimeOriginal", "25-11-2016");
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        this.put("nodes", f2Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 400);
        props = new HashMap();
        props.put("exif:pixelYDimension", "123");
        props.put("exif:dateTimeOriginal", "2016-11-21T16:26:19.037+0000");
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        this.put("nodes", f2Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        props = new HashMap();
        props.put("cm:description", "my folder description");
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        this.put("nodes", "-root-", RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 403);
        props = new HashMap();
        props.put("cm:description", "my folder description");
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        this.put("nodes", "-shared-", RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 403);
        this.setRequestContext(user2);
        props = new HashMap();
        props.put("cm:description", "my folder description");
        fUpdate = new Folder();
        fUpdate.setProperties(props);
        this.put("nodes", user1MyFolderId, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 403);
    }

    @Test
    public void testUpdateOwner() throws Exception {
        this.setRequestContext(user1);
        String folderName = "f0-testUpdateOwner-" + this.RUNID;
        Folder folderResp = this.createFolder("-shared-", folderName);
        String f0Id = folderResp.getId();
        Assert.assertNull((String)user1, folderResp.getProperties());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PROP_OWNER, user1);
        Folder fUpdate = new Folder();
        fUpdate.setProperties(props);
        HttpResponse response = this.put("nodes", f0Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)user1, ((Map)folderResp.getProperties().get(PROP_OWNER)).get("id"));
        String d1Name = "content1 " + this.RUNID;
        String d1Id = this.createTextFile(f0Id, d1Name, "The quick brown fox jumps over the lazy dog.").getId();
        response = this.getSingle(NodesEntityResource.class, d1Id, null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)2L, (long)documentResp.getProperties().size());
        Assert.assertEquals((Object)"1.0", (Object)documentResp.getProperties().get("cm:versionLabel"));
        Assert.assertEquals((Object)"MAJOR", (Object)documentResp.getProperties().get("cm:versionType"));
        props = new HashMap();
        props.put(PROP_OWNER, user1);
        Document dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", d1Id, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)user1, ((Map)documentResp.getProperties().get(PROP_OWNER)).get("id"));
        props = new HashMap();
        props.put(PROP_OWNER, "unknownusernamedoesnotexist");
        dUpdate = new Document();
        dUpdate.setProperties(props);
        this.put("nodes", d1Id, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
        this.setRequestContext(user2);
        response = this.getSingle("nodes", d1Id, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)user1, ((Map)documentResp.getProperties().get(PROP_OWNER)).get("id"));
        props = new HashMap();
        props.put(PROP_OWNER, user2);
        dUpdate = new Document();
        dUpdate.setProperties(props);
        this.put("nodes", d1Id, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 403);
        props = new HashMap();
        props.put(PROP_OWNER, user1);
        dUpdate = new Document();
        dUpdate.setProperties(props);
        this.put("nodes", d1Id, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 403);
        this.setRequestContext(user1);
        props = new HashMap();
        props.put(PROP_OWNER, user2);
        dUpdate = new Document();
        dUpdate.setProperties(props);
        response = this.put("nodes", d1Id, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)user2, ((Map)documentResp.getProperties().get(PROP_OWNER)).get("id"));
        this.setRequestContext(user2);
        response = this.getSingle("nodes", d1Id, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)user2, ((Map)documentResp.getProperties().get(PROP_OWNER)).get("id"));
        this.setRequestContext(user2);
        this.deleteNode(f0Id, 403);
        this.setRequestContext(user1);
        this.deleteNode(f0Id);
    }

    @Test
    public void testUpdateType() throws Exception {
        this.setRequestContext(user1);
        String folderName = "f0-testUpdateOwner-" + this.RUNID;
        Folder folderResp = this.createFolder("-shared-", folderName);
        String f0Id = folderResp.getId();
        Assert.assertNull((String)user1, folderResp.getProperties());
        Folder fUpdate = new Folder();
        fUpdate.setNodeType(folderResp.getNodeType());
        HttpResponse response = this.put("nodes", f0Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)"cm:folder", (Object)folderResp.getNodeType());
        fUpdate.setNodeType("cm:content");
        this.put("nodes", f0Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 400);
        fUpdate.setNodeType("cm:systemfolder");
        this.put("nodes", f0Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 400);
        fUpdate.setNodeType("fm:forums");
        response = this.put("nodes", f0Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 200);
        folderResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)"fm:forums", (Object)folderResp.getNodeType());
        fUpdate.setNodeType("cm:folder");
        this.put("nodes", f0Id, RestApiUtil.toJsonAsStringNonNull(fUpdate), null, 400);
    }

    @Test
    public void testUpdateFileWithBinaryUpload() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String folderName = "f1-testUpdateFileWithBinaryUpload-" + this.RUNID;
        Folder folderResp = this.createFolder(myNodeId, folderName);
        String f1_nodeId = folderResp.getId();
        String anoNodeName = "another";
        this.createFolder(f1_nodeId, anoNodeName);
        Document doc = new Document();
        String docName = "testdoc.txt";
        doc.setName("testdoc.txt");
        doc.setNodeType("cm:content");
        doc.setProperties(Collections.singletonMap("cm:title", "test title"));
        ContentInfo contentInfo = new ContentInfo();
        doc.setContent(contentInfo);
        HttpResponse response = this.post(this.getNodeChildrenUrl(f1_nodeId), RestApiUtil.toJsonAsStringNonNull(doc), 201);
        Document docResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"testdoc.txt", (Object)docResp.getName());
        Assert.assertNotNull((Object)docResp.getContent());
        Assert.assertEquals((long)0L, (long)docResp.getContent().getSizeInBytes().intValue());
        Assert.assertEquals((Object)"text/plain", (Object)docResp.getContent().getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)docResp.getContent().getEncoding());
        String content = "The quick brown fox jumps over the lazy dog.";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
        PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
        this.putBinary(this.getNodeContentUrl(f1_nodeId), payload, null, null, 400);
        this.putBinary(this.getNodeContentUrl(UUID.randomUUID().toString()), payload, null, null, 404);
        String url = this.getNodeContentUrl(docResp.getId());
        response = this.putBinary(url, payload, null, null, 200);
        docResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"testdoc.txt", (Object)docResp.getName());
        Assert.assertNotNull((Object)docResp.getId());
        Assert.assertNotNull((Object)docResp.getCreatedAt());
        Assert.assertNotNull((Object)docResp.getCreatedByUser());
        Assert.assertNotNull((Object)docResp.getModifiedAt());
        Assert.assertNotNull((Object)docResp.getModifiedByUser());
        Assert.assertFalse((boolean)docResp.getIsFolder());
        Assert.assertTrue((boolean)docResp.getIsFile());
        Assert.assertNull((Object)docResp.getIsLink());
        Assert.assertEquals((Object)"cm:content", (Object)docResp.getNodeType());
        Assert.assertNotNull((Object)docResp.getParentId());
        Assert.assertEquals((Object)f1_nodeId, (Object)docResp.getParentId());
        Assert.assertNotNull(docResp.getProperties());
        Assert.assertNotNull(docResp.getAspectNames());
        contentInfo = docResp.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertNotNull((Object)contentInfo.getEncoding());
        Assert.assertTrue((contentInfo.getSizeInBytes() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        Assert.assertNotNull((Object)contentInfo.getMimeTypeName());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)contentInfo.getEncoding());
        Assert.assertNull((Object)docResp.getPath());
        response = this.getSingle(url, user1, null, 200);
        Assert.assertEquals((Object)content, (Object)response.getResponse());
        content = "The quick brown fox jumps over the lazy dog updated !";
        inputStream = new ByteArrayInputStream(content.getBytes());
        txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
        payload = new PublicApiHttpClient.BinaryPayload(txtFile);
        response = this.putBinary(url + "?include=path", payload, null, null, 200);
        docResp = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)"testdoc.txt", (Object)docResp.getName());
        Assert.assertNotNull((Object)docResp.getContent());
        Assert.assertTrue((docResp.getContent().getSizeInBytes().intValue() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"text/plain", (Object)docResp.getContent().getMimeType());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)docResp.getContent().getEncoding());
        PathInfo pathInfo = docResp.getPath();
        Assert.assertNotNull((Object)pathInfo);
        Assert.assertTrue((boolean)pathInfo.getIsComplete());
        List<PathInfo.ElementInfo> pathElements = pathInfo.getElements();
        Assert.assertNotNull(pathElements);
        Assert.assertTrue((pathElements.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)folderResp.getName(), (Object)pathElements.get(pathElements.size() - 1).getName());
        response = this.getSingle(url, user1, null, 200);
        Assert.assertEquals((Object)content, (Object)response.getResponse());
        content = "The quick brown fox jumps over the lazy dog updated again !";
        inputStream = new ByteArrayInputStream(content.getBytes());
        txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
        payload = new PublicApiHttpClient.BinaryPayload(txtFile);
        String docName2 = "hello-world.txt";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", docName2);
        response = this.putBinary(url, payload, null, params, 200);
        docResp = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)docName2, (Object)docResp.getName());
        response = this.getSingle(url, user1, null, 200);
        Assert.assertEquals((Object)content, (Object)response.getResponse());
        params = new HashMap();
        params.put("name", "hello/world.txt");
        payload = new PublicApiHttpClient.BinaryPayload(txtFile);
        this.putBinary(url, payload, null, params, 422);
        params = new HashMap();
        params.put("name", anoNodeName);
        payload = new PublicApiHttpClient.BinaryPayload(txtFile);
        this.putBinary(url, payload, null, params, 409);
        payload = new PublicApiHttpClient.BinaryPayload(txtFile, "multipart/form-data", null);
        this.putBinary(url, payload, null, null, 415);
        payload = new PublicApiHttpClient.BinaryPayload(txtFile, "/jpeg", null);
        this.putBinary(url, payload, null, null, 415);
    }

    @Test
    public void testDownloadFileContentName() throws Exception {
        this.setRequestContext(user1);
        String fileName = "Test Download (1).txt";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl("-my-"), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Assert.assertEquals((Object)fileName, (Object)document.getName());
        ContentInfo contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        response = this.getSingle(NodesEntityResource.class, contentNodeId + "/content", null, 200);
        String textContent = response.getResponse();
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)textContent);
        Map<String, String> responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)"attachment; filename=\"Test Download (1).txt\"; filename*=UTF-8''Test%20Download%20%281%29.txt", (Object)responseHeaders.get("Content-Disposition"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDownloadFileContentUsingTempFile() throws Exception {
        this.setRequestContext(user1);
        Long contentSize = 0x500000L;
        String fileName = "tempFile.txt";
        File file = null;
        try {
            file = TempFileProvider.createTempFile((String)this.getClass().getSimpleName(), (String)".txt");
            RandomAccessFile rndFile = new RandomAccessFile(file.getPath(), "rw");
            rndFile.setLength(contentSize);
            rndFile.close();
            MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
            MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
            HttpResponse response = this.post(this.getNodeChildrenUrl("-my-"), reqBody.getBody(), null, reqBody.getContentType(), 201);
            Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
            String contentNodeId = document.getId();
            Assert.assertEquals((Object)fileName, (Object)document.getName());
            ContentInfo contentInfo = document.getContent();
            Assert.assertNotNull((Object)contentInfo);
            Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
            response = this.getSingle(NodesEntityResource.class, contentNodeId + "/content", null, 200);
            byte[] bytes = response.getResponseAsBytes();
            Assert.assertEquals((long)contentSize.intValue(), (long)bytes.length);
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void testDownloadFileContentReadPermission() throws Exception {
        this.setRequestContext(user1);
        String fileName = "quick-1.txt";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl("-my-"), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        response = this.getSingle(NodesEntityResource.class, contentNodeId + "/content", null, 200);
        String textContent = response.getResponse();
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)textContent);
        response = this.getSingle(NodesEntityResource.class, contentNodeId + "/versions/1.0/content", null, 200);
        textContent = response.getResponse();
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)textContent);
        this.setRequestContext(user2);
        this.getSingle(NodesEntityResource.class, contentNodeId + "/content", null, 403);
        this.getSingle(NodesEntityResource.class, contentNodeId + "/versions/1.0/content", null, 403);
        this.setRequestContext(user1);
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(user2, "Consumer", AccessStatus.ALLOWED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        response = this.put("nodes", contentNodeId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        this.setRequestContext(user2);
        response = this.getSingle(NodesEntityResource.class, contentNodeId + "/content", null, 200);
        textContent = response.getResponse();
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)textContent);
        response = this.getSingle(NodesEntityResource.class, contentNodeId + "/versions/1.0/content", null, 200);
        textContent = response.getResponse();
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)textContent);
    }

    @Test
    public void testGetNodeWithEmptyProperties() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        Folder folderResp = this.createFolder(myNodeId, "fld1_" + this.RUNID);
        String f1Id = folderResp.getId();
        String nodeName = "f1 link";
        String nodeType = "app:folderlink";
        String propertyName = "cm:destination";
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(propertyName, "");
        Node nodeResp = this.createNode(f1Id, nodeName, nodeType, props);
        String nodeId = nodeResp.getId();
        Node n1 = new Node();
        n1.setName(nodeName);
        n1.setNodeType(nodeType);
        n1.setIsFolder(true);
        n1.setParentId(f1Id);
        n1.setAspectNames(Collections.singletonList("cm:auditable"));
        n1.setProperties(null);
        n1.expected(nodeResp);
        HttpResponse httpResponse = this.getSingle(NodesEntityResource.class, nodeId, null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(httpResponse.getJsonResponse(), Node.class);
        n1.expected(nodeResp);
    }

    @Test
    public void testAllowableOps() throws Exception {
        this.setRequestContext(user1);
        String rootNodeId = this.getRootNodeId();
        String sharedNodeId = this.getSharedNodeId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("relativePath", "/Sites");
        HttpResponse response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String sitesNodeId = nodeResp.getId();
        params = new HashMap();
        params.put("relativePath", "/Data Dictionary");
        response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String ddNodeId = nodeResp.getId();
        params = new HashMap();
        params.put("include", "allowableOperations");
        response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull(nodeResp.getAllowableOperations());
        response = this.getSingle(NodesEntityResource.class, sharedNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)1L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        this.deleteNode(sharedNodeId, 403);
        response = this.getSingle(NodesEntityResource.class, this.getMyNodeId(), params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)4L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("delete"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        nodeResp = this.createFolder(sharedNodeId, "folder 1 - " + this.RUNID);
        String folderId = nodeResp.getId();
        Assert.assertNull(nodeResp.getAllowableOperations());
        response = this.getSingle(NodesEntityResource.class, folderId, null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull(nodeResp.getAllowableOperations());
        response = this.getSingle(NodesEntityResource.class, folderId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)4L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("delete"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        nodeResp = this.createTextFile(folderId, "my file - " + this.RUNID + ".txt", "The quick brown fox jumps over the lazy dog");
        String fileId = nodeResp.getId();
        Assert.assertNull(nodeResp.getAllowableOperations());
        response = this.getSingle(NodesEntityResource.class, fileId, null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull(nodeResp.getAllowableOperations());
        response = this.getSingle(NodesEntityResource.class, fileId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)3L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("delete"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        this.setRequestContext(user2);
        response = this.getSingle(NodesEntityResource.class, folderId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)1L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        this.deleteNode(folderId, 403);
        response = this.getSingle(NodesEntityResource.class, fileId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull(nodeResp.getAllowableOperations());
        this.deleteNode(fileId, 403);
        this.setRequestContext(networkAdmin);
        response = this.publicApiClient.get(NodesEntityResource.class, (Object)folderId, null, params);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)4L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("delete"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        response = this.publicApiClient.get(NodesEntityResource.class, (Object)fileId, null, params);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)3L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("delete"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        response = this.publicApiClient.get(NodesEntityResource.class, (Object)sharedNodeId, null, params);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)4L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("delete"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        response = this.publicApiClient.get(NodesEntityResource.class, (Object)rootNodeId, null, params);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)3L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        this.deleteNode(rootNodeId, 403);
        response = this.publicApiClient.get(NodesEntityResource.class, (Object)sitesNodeId, null, params);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)3L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        this.deleteNode(sitesNodeId, 403);
        response = this.publicApiClient.get(NodesEntityResource.class, (Object)ddNodeId, null, params);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)3L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        this.deleteNode(ddNodeId, 403);
        this.publicApiClient.setRequestContext(null);
        String userId = user1;
        this.setRequestContext(userId);
        response = this.getSingle("sites", tSiteId, null, null, 200);
        Site siteResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Site.class);
        String siteNodeId = siteResp.getGuid();
        response = this.getSingle(NodesEntityResource.class, siteNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)userId, (Object)nodeResp.getCreatedByUser().getId());
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        Assert.assertEquals((long)3L, (long)nodeResp.getAllowableOperations().size());
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("create"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("update"));
        Assert.assertTrue((boolean)nodeResp.getAllowableOperations().contains("updatePermissions"));
        this.deleteNode(siteNodeId, 403);
        this.setRequestContext(user1);
        Node n = new Node();
        n.setName("o1");
        n.setNodeType("cm:cmobject");
        response = this.post(this.getNodeChildrenUrl(folderId), RestApiUtil.toJsonAsStringNonNull(n), 201);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String o1Id = nodeResp.getId();
        params = new HashMap();
        params.put("include", "allowableOperations");
        response = this.getSingle(NodesEntityResource.class, o1Id, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodeResp.getAllowableOperations());
        this.deleteNode(folderId, true, 204);
    }

    @Test
    public void testLock() throws Exception {
        this.setRequestContext(user1);
        Folder folderResp = this.createFolder("-my-", "folder" + this.RUNID);
        String folderId = folderResp.getId();
        LockInfo lockInfo = new LockInfo();
        lockInfo.setTimeToExpire(Integer.valueOf(60));
        lockInfo.setType("FULL");
        lockInfo.setLifetime("PERSISTENT");
        HttpResponse response = this.post(this.getNodeOperationUrl(folderId, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 400);
        String d1Name = "content" + this.RUNID + "_1l";
        Document d1 = this.createTextFile(folderId, d1Name, "The quick brown fox jumps over the lazy dog 1.");
        String d1Id = d1.getId();
        lockInfo = new LockInfo();
        lockInfo.setTimeToExpire(Integer.valueOf(30));
        lockInfo.setType("FULL");
        lockInfo.setLifetime("PERSISTENT");
        response = this.post(this.getNodeOperationUrl(d1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)d1Id, (Object)documentResp.getId());
        Assert.assertEquals((Object)LockType.READ_ONLY_LOCK.toString(), (Object)documentResp.getProperties().get("cm:lockType"));
        Assert.assertNotNull((Object)documentResp.getProperties().get("cm:lockOwner"));
        Assert.assertNull((Object)documentResp.getIsLocked());
        this.deleteNode(d1Id, true, 409);
        TimeUnit.SECONDS.sleep(30L);
        this.deleteNode(d1Id, true, 204);
        String d2Name = "content" + this.RUNID + "_2l";
        Document d2 = this.createTextFile(folderId, d2Name, "The quick brown fox jumps over the lazy dog 2.");
        String d2Id = d2.getId();
        response = this.getSingle("nodes", d2Id, null, null, 200);
        Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull((Object)node.getProperties().get("cm:lockType"));
        Assert.assertNull((Object)node.getProperties().get("cm:lockOwner"));
        Assert.assertNull((Object)node.getIsLocked());
        Map<String, String> params = Collections.singletonMap("include", "isLocked");
        response = this.getSingle("nodes", d2Id, params, null, 200);
        node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull((Object)node.getProperties().get("cm:lockType"));
        Assert.assertNull((Object)node.getProperties().get("cm:lockOwner"));
        Assert.assertFalse((boolean)node.getIsLocked());
        lockInfo = new LockInfo();
        lockInfo.setTimeToExpire(Integer.valueOf(60));
        lockInfo.setType("FULL");
        lockInfo.setLifetime("PERSISTENT");
        response = this.post(this.getNodeOperationUrl(d2Id, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d2Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)d2Id, (Object)documentResp.getId());
        Assert.assertEquals((Object)LockType.READ_ONLY_LOCK.toString(), (Object)documentResp.getProperties().get("cm:lockType"));
        Assert.assertNotNull((Object)documentResp.getProperties().get("cm:lockOwner"));
        Assert.assertNull((Object)documentResp.getIsLocked());
        this.unlock(d2Id);
        this.post(this.getNodeOperationUrl(d2Id, "lock"), EMPTY_BODY, null, 200);
        this.post(this.getNodeOperationUrl(d2Id, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 200);
        this.deleteNode(folderId, true, 409);
        this.updateTextFile(d2Id, "Updated text", null, 409);
        this.unlock(d2Id);
        String folderAName = "folder" + this.RUNID + "_A";
        Folder folderA = this.createFolder("-my-", folderAName);
        String folderAId = folderA.getId();
        Document dA1 = this.createTextFile(folderAId, "content" + this.RUNID + "_A1", "A1 content");
        String dA1Id = dA1.getId();
        lockInfo = new LockInfo();
        lockInfo.setTimeToExpire(Integer.valueOf(60));
        lockInfo.setType("ALLOW_OWNER_CHANGES");
        lockInfo.setLifetime("EPHEMERAL");
        this.post(this.getNodeOperationUrl(dA1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 200);
        params = Collections.singletonMap("include", "aspectNames,properties,isLocked");
        response = this.getSingle("nodes", dA1Id, params, null, 200);
        node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertTrue((boolean)node.getIsLocked());
        this.updateTextFile(node.getId(), "Updated text", null, 200);
        Document dB1 = this.createTextFile(folderAId, "content" + this.RUNID + "_dB1", "dB1 content");
        String dB1Id = dB1.getId();
        lockInfo = new LockInfo();
        lockInfo.setTimeToExpire(Integer.valueOf(-100));
        this.post(this.getNodeOperationUrl(dB1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 200);
        this.setRequestContext(user1);
        Folder folder1Resp = this.createFolder("-shared-", "folder1" + this.RUNID);
        String folder1Id = folder1Resp.getId();
        String f1d1Name = "content f1" + this.RUNID + "_1l";
        Document f1d1 = this.createTextFile(folder1Id, f1d1Name, "The quick brown fox jumps over the lazy dog 1.");
        String f1d1Id = f1d1.getId();
        this.setRequestContext(networkAdmin);
        this.post(this.getNodeOperationUrl(f1d1Id, "lock"), EMPTY_BODY, null, 200);
        this.unlock(f1d1Id);
        lockInfo = new LockInfo();
        this.post(this.getNodeOperationUrl("fakeId", "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 404);
        params = new HashMap<String, String>();
        params.put("relativePath", "/Data Dictionary");
        response = this.getSingle(NodesEntityResource.class, this.getRootNodeId(), params, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        String ddNodeId = nodeResp.getId();
        this.setRequestContext(networkAdmin);
        this.post(this.getNodeOperationUrl(ddNodeId, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 403);
        this.post(this.getNodeOperationUrl(dB1Id, "lock"), EMPTY_BODY, null, 422);
        this.setRequestContext(user1);
        Folder folder2Resp = this.createFolder("-my-", "folder2" + this.RUNID);
        String folder2Id = folder2Resp.getId();
        String f2d1Name = "content f2" + this.RUNID + "_1l";
        Document f2d1 = this.createTextFile(folder2Id, f2d1Name, "The quick brown fox jumps over the lazy dog 1.");
        String f2d1Id = f2d1.getId();
        this.setRequestContext(user2);
        this.post(this.getNodeOperationUrl(f2d1Id, "lock"), EMPTY_BODY, null, 403);
        this.setRequestContext(user1);
        Folder folderC = this.createFolder("-my-", "folder" + this.RUNID + "_C");
        String folderCId = folderC.getId();
        Document dC1 = this.createTextFile(folderCId, "content" + this.RUNID + "_dC1", "dC1 content");
        String dC1Id = dC1.getId();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("type", "FULL123");
        this.post(this.getNodeOperationUrl(dC1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(body), null, 400);
        body = new HashMap();
        body.put("type", "ALLOW_ADD_CHILDREN");
        this.post(this.getNodeOperationUrl(dC1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(body), null, 400);
        body = new HashMap();
        body.put("lifetime", "PERSISTENT123");
        this.post(this.getNodeOperationUrl(dC1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(body), null, 400);
        body = new HashMap();
        body.put("includeChildren", "true");
        this.post(this.getNodeOperationUrl(dC1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(body), null, 400);
        body = new HashMap();
        body.put("timeToExpire", "NaN");
        this.post(this.getNodeOperationUrl(dC1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(body), null, 400);
        body = new HashMap();
        body.put("invalid_property", "true");
        this.post(this.getNodeOperationUrl(dC1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(body), null, 400);
        this.post(this.getNodeOperationUrl(folderId, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 400);
        this.setRequestContext(user1);
        this.unlock(dB1Id);
        this.deleteNode(dB1Id);
        this.deleteNode(folderId);
        this.deleteNode(folderAId);
        this.deleteNode(folderCId);
        this.deleteNode(folder1Id);
        this.deleteNode(folder2Id);
    }

    @Test
    public void testUnlock() throws Exception {
        this.setRequestContext(user1);
        Folder folderResp = this.createFolder("-my-", "folder" + this.RUNID);
        String folderId = folderResp.getId();
        String d1Name = "content" + this.RUNID + "_1l";
        Document d1 = this.createTextFile(folderId, d1Name, "The quick brown fox jumps over the lazy dog 1.");
        String d1Id = d1.getId();
        this.lock(d1Id, EMPTY_BODY);
        HttpResponse response = this.post(this.getNodeOperationUrl(d1Id, "unlock"), null, null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)d1Id, (Object)documentResp.getId());
        Assert.assertNull((Object)documentResp.getProperties().get("cm:lockType"));
        Assert.assertNull((Object)documentResp.getProperties().get("cm:lockOwner"));
        this.lock(d1Id, EMPTY_BODY);
        this.setRequestContext(networkAdmin);
        this.post(this.getNodeOperationUrl(d1Id, "unlock"), null, null, 200);
        this.post(this.getNodeOperationUrl("fakeId", "unlock"), null, null, 404);
        this.lock(d1Id, EMPTY_BODY);
        this.setRequestContext(user2);
        this.post(this.getNodeOperationUrl(d1Id, "unlock"), null, null, 403);
        this.setRequestContext(user1);
        this.post(this.getNodeOperationUrl(folderId, "unlock"), null, null, 422);
        this.setRequestContext(user1);
        this.unlock(d1Id);
        this.deleteNode(folderId);
    }

    @Test
    public void testLockFileCreatedByDeletedUser() throws Exception {
        String user = this.createUser("userRND-" + this.RUNID, "userRNDPassword", networkOne);
        this.setRequestContext(user);
        Folder folderResp = this.createFolder("-my-", "folderRND" + this.RUNID);
        String folderId = folderResp.getId();
        String d1Name = "content" + this.RUNID + "_1l";
        Document d1 = this.createTextFile(folderId, d1Name, "The quick brown fox jumps over the lazy dog 1.");
        String d1Id = d1.getId();
        this.setRequestContext(networkAdmin);
        this.transactionHelper.doInTransaction(() -> {
            this.deleteUser(user, networkOne);
            return null;
        });
        LockInfo lockInfo = new LockInfo();
        lockInfo.setTimeToExpire(Integer.valueOf(30));
        lockInfo.setType("FULL");
        lockInfo.setLifetime("PERSISTENT");
        HttpResponse response = this.post(this.getNodeOperationUrl(d1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)d1Id, (Object)documentResp.getId());
        Assert.assertEquals((Object)LockType.READ_ONLY_LOCK.toString(), (Object)documentResp.getProperties().get("cm:lockType"));
        Assert.assertNotNull((Object)documentResp.getProperties().get("cm:lockOwner"));
        Assert.assertNull((Object)documentResp.getIsLocked());
        Map<String, String> params = Collections.singletonMap("include", "isLocked");
        response = this.getSingle(NodesEntityResource.class, d1Id, params, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)d1Id, (Object)documentResp.getId());
        Assert.assertEquals((Object)LockType.READ_ONLY_LOCK.toString(), (Object)documentResp.getProperties().get("cm:lockType"));
        Assert.assertNotNull((Object)documentResp.getProperties().get("cm:lockOwner"));
        Assert.assertTrue((boolean)documentResp.getIsLocked());
        this.unlock(d1Id);
        response = this.getSingle(NodesEntityResource.class, d1Id, params, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)d1Id, (Object)documentResp.getId());
        Assert.assertEquals(null, (Object)documentResp.getProperties().get("cm:lockType"));
        Assert.assertNull((Object)documentResp.getProperties().get("cm:lockOwner"));
        Assert.assertFalse((boolean)documentResp.getIsLocked());
        this.deleteNode(folderId);
    }

    @Test
    public void testMoveFileCreatedByDeletedUser() throws Exception {
        String user = this.createUser("userTstMove-" + this.RUNID, "userRNDPassword", networkOne);
        this.setRequestContext(user);
        String folder0Name = "f0-testMove-" + this.RUNID;
        String f0Id = this.createFolder("-my-", folder0Name).getId();
        Folder folderResp = this.createFolder(f0Id, "f1");
        String f1Id = folderResp.getId();
        folderResp = this.createFolder(f0Id, "f2");
        String f2Id = folderResp.getId();
        String d1Name = "content" + this.RUNID + "_1";
        String d1Id = this.createTextFile(f1Id, d1Name, "The quick brown fox jumps over the lazy dog 1.").getId();
        this.setRequestContext(networkAdmin);
        this.transactionHelper.doInTransaction(() -> {
            this.deleteUser(user, networkOne);
            return null;
        });
        NodeTarget tgt = new NodeTarget();
        tgt.setTargetParentId(f2Id);
        HttpResponse response = this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1Name, (Object)documentResp.getName());
        Assert.assertEquals((Object)f2Id, (Object)documentResp.getParentId());
        response = this.getSingle(NodesEntityResource.class, d1Id, null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)f2Id, (Object)documentResp.getParentId());
        String d1NewName = d1Name + " updated !!";
        tgt = new NodeTarget();
        tgt.setName(d1NewName);
        tgt.setTargetParentId(f1Id);
        response = this.post("nodes/" + d1Id + "/move", RestApiUtil.toJsonAsStringNonNull(tgt), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)d1NewName, (Object)documentResp.getName());
        Assert.assertEquals((Object)f1Id, (Object)documentResp.getParentId());
        response = this.getSingle(NodesEntityResource.class, d1Id, null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)f1Id, (Object)documentResp.getParentId());
    }

    @Test
    public void testUploadContentDeletedOwner() throws Exception {
        String personToDelete = this.createUser("usertodelete-" + this.RUNID, "userdelPassword", networkOne);
        this.setRequestContext(personToDelete);
        String site1Title = "site-testUploadContentDeadUser_DocLib-" + this.RUNID;
        String site1Id = this.createSite(site1Title, SiteVisibility.PUBLIC).getId();
        String site1DocLibNodeId = this.getSiteContainerNodeId(site1Id, "documentLibrary");
        this.addSiteMember(site1Id, user1, SiteRole.SiteCollaborator);
        Document deadDoc = this.createTextFile(site1DocLibNodeId, "testdeaddoc.txt", "The quick brown fox jumps over the lazy dog 1.");
        String deadDocUrl = this.getNodeContentUrl(deadDoc.getId());
        String content = "Soft you a word or two before you go... I took by the throat the circumcised dog, And smote him, thus.";
        String docName = "goodbye-world.txt";
        HashMap<String, String> params_doc = new HashMap<String, String>();
        params_doc.put("name", docName);
        deadDoc = this.updateFileWithContent(deadDoc.getId(), content, params_doc, 200);
        Assert.assertEquals((String)"person2delete cannot update document", (Object)docName, (Object)deadDoc.getName());
        HttpResponse response = this.getSingle(deadDocUrl, personToDelete, null, 200);
        Assert.assertEquals((String)"person2delete cannot view document", (Object)content, (Object)response.getResponse());
        response = this.getSingle(deadDocUrl, user1, null, 200);
        Assert.assertEquals((String)"user1 cannot view document", (Object)content, (Object)response.getResponse());
        this.transactionHelper.doInTransaction(() -> {
            this.deleteUser(personToDelete, networkOne);
            return null;
        });
        this.setRequestContext(user1);
        content = "This did I fear, but thought he had no weapon; For he was great of heart.";
        this.updateFileWithContent(deadDoc.getId(), content, null, 200);
        response = this.getSingle(deadDocUrl, user1, null, 200);
        Assert.assertEquals((String)"user1 cannot update after owner is deleted", (Object)content, (Object)response.getResponse());
    }

    private Document updateFileWithContent(String docId, String content, Map<String, String> params, int expectedStatus) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
        PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
        HttpResponse response = this.putBinary(this.getNodeContentUrl(docId), payload, null, params, expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
    }

    private void createAuthorityContext(String user) {
        String groupName = "Group_ROOT" + GUID.generate();
        AuthenticationUtil.setRunAsUser((String)user);
        if (this.rootGroupName == null) {
            this.rootGroupName = this.authorityService.getName(AuthorityType.GROUP, groupName);
        }
        if (!this.authorityService.authorityExists(this.rootGroupName)) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            this.rootGroupName = this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
            this.groupA = this.authorityService.createAuthority(AuthorityType.GROUP, "Test_GroupA");
            this.authorityService.addAuthority(this.rootGroupName, this.groupA);
            this.groupB = this.authorityService.createAuthority(AuthorityType.GROUP, "Test_GroupB");
            this.authorityService.addAuthority(this.rootGroupName, this.groupB);
            this.authorityService.addAuthority(this.groupA, user1);
            this.authorityService.addAuthority(this.groupB, user2);
        }
    }

    private void clearAuthorityContext() {
        if (this.authorityService.authorityExists(this.rootGroupName)) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            this.authorityService.deleteAuthority(this.rootGroupName, true);
        }
    }

    @Test
    public void testRetrievePermissions() throws Exception {
        try {
            this.createAuthorityContext(user1);
            this.testRetrieveNodePermissionsSpecialNodes();
            this.testRetrieveNodePermissions();
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    private void testRetrieveNodePermissionsSpecialNodes() throws Exception {
        this.setRequestContext(user1);
        String rootNodeId = this.getRootNodeId();
        String userHome = this.getMyNodeId();
        String sharedFolder = this.getSharedNodeId();
        String sitesNodeId = this.getSitesNodeId();
        String ddNodeId = this.getDataDictionaryNodeId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "permissions");
        HttpResponse response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull((Object)nodeResp.getPermissions());
        response = this.getSingle(NodesEntityResource.class, sitesNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull((Object)nodeResp.getPermissions());
        response = this.getSingle(NodesEntityResource.class, ddNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull((Object)nodeResp.getPermissions());
        response = this.getSingle(NodesEntityResource.class, sharedFolder, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull((Object)nodeResp.getPermissions());
        HashSet<String> expectedSettable = new HashSet<String>(Arrays.asList("Coordinator", "Collaborator", "Contributor", "Consumer", "Editor"));
        response = this.getSingle(NodesEntityResource.class, userHome, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNotNull((Object)nodeResp.getPermissions());
        Assert.assertNotNull((Object)nodeResp.getPermissions().getSettable());
        Assert.assertTrue((String)"Incorrect list of settable permissions returned!", (boolean)nodeResp.getPermissions().getSettable().containsAll(expectedSettable));
        Assert.assertFalse((boolean)nodeResp.getPermissions().getIsInheritanceEnabled());
        this.setRequestContext(networkAdmin);
        response = this.getSingle(NodesEntityResource.class, rootNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertFalse((boolean)nodeResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertNull((Object)nodeResp.getPermissions().getInherited());
        Assert.assertNotNull((Object)nodeResp.getPermissions().getLocallySet());
        Assert.assertTrue((boolean)nodeResp.getPermissions().getLocallySet().contains(new NodePermissions.NodePermission("GROUP_EVERYONE", "Consumer", AccessStatus.ALLOWED.toString())));
        Assert.assertNotNull((Object)nodeResp.getPermissions().getSettable());
        Assert.assertTrue((String)"Incorrect list of settable permissions returned!", (boolean)nodeResp.getPermissions().getSettable().containsAll(expectedSettable));
        response = this.getSingle(NodesEntityResource.class, sitesNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertTrue((boolean)nodeResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertNotNull((Object)nodeResp.getPermissions().getInherited());
        Assert.assertTrue((boolean)nodeResp.getPermissions().getInherited().contains(new NodePermissions.NodePermission("GROUP_EVERYONE", "Consumer", AccessStatus.ALLOWED.toString())));
        Assert.assertNull((Object)nodeResp.getPermissions().getLocallySet());
        Assert.assertNotNull((Object)nodeResp.getPermissions().getSettable());
        Assert.assertTrue((String)"Incorrect list of settable permissions returned!", (boolean)nodeResp.getPermissions().getSettable().containsAll(expectedSettable));
        response = this.getSingle(NodesEntityResource.class, ddNodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertFalse((boolean)nodeResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertNull((Object)nodeResp.getPermissions().getInherited());
        Assert.assertNotNull((Object)nodeResp.getPermissions().getLocallySet());
        Assert.assertTrue((boolean)nodeResp.getPermissions().getLocallySet().contains(new NodePermissions.NodePermission("GROUP_EVERYONE", "Consumer", AccessStatus.ALLOWED.toString())));
        Assert.assertNotNull((Object)nodeResp.getPermissions().getSettable());
        Assert.assertTrue((String)"Incorrect list of settable permissions returned!", (boolean)nodeResp.getPermissions().getSettable().containsAll(expectedSettable));
        response = this.getSingle(NodesEntityResource.class, sharedFolder, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertFalse((boolean)nodeResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertNull((Object)nodeResp.getPermissions().getInherited());
        Assert.assertNotNull((Object)nodeResp.getPermissions().getLocallySet());
        Assert.assertTrue((boolean)nodeResp.getPermissions().getLocallySet().contains(new NodePermissions.NodePermission("GROUP_EVERYONE", "Contributor", AccessStatus.ALLOWED.toString())));
        Assert.assertNotNull((Object)nodeResp.getPermissions().getSettable());
        Assert.assertTrue((String)"Incorrect list of settable permissions returned!", (boolean)nodeResp.getPermissions().getSettable().containsAll(expectedSettable));
        response = this.getSingle(NodesEntityResource.class, userHome, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertFalse((boolean)nodeResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertNull((Object)nodeResp.getPermissions().getInherited());
        Assert.assertNotNull((Object)nodeResp.getPermissions().getLocallySet());
        Assert.assertTrue((boolean)nodeResp.getPermissions().getLocallySet().contains(new NodePermissions.NodePermission("ROLE_OWNER", "All", AccessStatus.ALLOWED.toString())));
        Assert.assertTrue((boolean)nodeResp.getPermissions().getLocallySet().contains(new NodePermissions.NodePermission(user1, "All", AccessStatus.ALLOWED.toString())));
        Assert.assertNotNull((Object)nodeResp.getPermissions().getSettable());
        Assert.assertTrue((String)"Incorrect list of settable permissions returned!", (boolean)nodeResp.getPermissions().getSettable().containsAll(expectedSettable));
    }

    private void testRetrieveNodePermissions() throws Exception {
        this.setRequestContext(user1);
        String postUrl = this.createFolder();
        String docId = this.createDocument(postUrl);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "permissions");
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupB, "Consumer", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        HttpResponse response = this.put("nodes", docId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        response = this.getSingle(NodesEntityResource.class, documentResp.getId(), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertNull((String)"Permissions should not be retrieved unless included!", (Object)documentResp.getPermissions());
        response = this.getSingle(NodesEntityResource.class, documentResp.getId(), params, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertNotNull((Object)documentResp.getPermissions());
        Assert.assertTrue((String)"Locally set permissions were not set properly!", (documentResp.getPermissions().getLocallySet().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Inheritance flag was not retrieved!", (boolean)documentResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertNotNull((Object)documentResp.getPermissions().getInherited());
        Assert.assertTrue((documentResp.getPermissions().getInherited().size() == 2 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)documentResp.getPermissions().getSettable());
        Assert.assertTrue((documentResp.getPermissions().getSettable().size() == 5 ? 1 : 0) != 0);
        HashSet<String> expectedSettable = new HashSet<String>(Arrays.asList("Coordinator", "Collaborator", "Contributor", "Consumer", "Editor"));
        Assert.assertTrue((String)"Incorrect list of settable permissions returned!", (boolean)documentResp.getPermissions().getSettable().containsAll(expectedSettable));
    }

    @Test
    public void testCreateNodePermissions() throws Exception {
        try {
            this.createAuthorityContext(networkAdmin);
            this.setRequestContext(user1);
            this.testCreatePermissionsOnNode();
            this.testCreatePermissionInvalidAuthority();
            this.testCreatePermissionInvalidName();
            this.testCreatePermissionInvalidAccessStatus();
            this.testCreatePermissionAddDuplicate();
            this.testCreatePermissionMissingFields();
            this.testCreatePermissionsPermissionDeniedUser();
            this.testCreatePermissionsSetFalseInheritFromParent();
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    @Test
    public void testUpdateNodePermissions() throws Exception {
        try {
            this.createAuthorityContext(networkAdmin);
            this.setRequestContext(user1);
            this.testUpdatePermissionsOnNode();
            this.testUpdatePermissionInvalidAuthority();
            this.testUpdatePermissionInvalidName();
            this.testUpdatePermissionInvalidAccessStatus();
            this.testUpdatePermissionAddDuplicate();
            this.testUpdatePermissionMissingFields();
            this.testUpdatePermissionsPermissionDeniedUser();
            this.testUpdatePermissionsOnSpecialNodes();
            this.testUpdatePermissionsDefaultInheritFromParent();
            this.testUpdatePermissionsSetFalseInheritFromParent();
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    @Test
    public void testUploadUsingRelativePath() throws Exception {
        this.setRequestContext(user1);
        String site1Title = "site-testGetPathElements_DocLib-" + this.RUNID;
        String site1Id = this.createSite(site1Title, SiteVisibility.PRIVATE).getId();
        this.addSiteMember(site1Id, user2, SiteRole.SiteConsumer);
        String site1DocLibNodeId = this.getSiteContainerNodeId(site1Id, "documentLibrary");
        String folderA = "folder" + this.RUNID + "_A";
        String folderA_Id = this.createFolder(site1DocLibNodeId, folderA).getId();
        String folderB = "folder" + this.RUNID + "_B";
        String folderB_Id = this.createFolder(folderA_Id, folderB).getId();
        NodeRef folderB_Ref = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folderB_Id);
        String folderC = "folder" + this.RUNID + "_C";
        String folderC_Id = this.createFolder(folderB_Id, folderC).getId();
        NodeRef folderC_Ref = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folderC_Id);
        String content = "content" + this.RUNID;
        String content_Id = this.createTextFile(folderC_Id, content, "The quick brown fox jumps over the lazy dog.").getId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "path");
        params.put("relativePath", folderA + "/" + folderB + "/" + folderC);
        HttpResponse response = this.getAll(this.getNodeChildrenUrl(site1DocLibNodeId), null, params, 200);
        List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertEquals((Object)("/" + folderA + "/" + folderB + "/" + folderC), (Object)nodes.get(0).getPath().getRelativePath());
    }

    private void testCreatePermissionsOnNode() throws Exception {
        String postUrl = this.createFolder();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        String dId = this.createDocument(postUrl, nodePermissions);
        this.validatePermissions(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, dId), locallySetPermissions);
        AuthenticationUtil.setRunAsUser((String)user2);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, dId), "Consumer") == AccessStatus.DENIED ? 1 : 0) != 0);
        AuthenticationUtil.setRunAsUser((String)user1);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, dId), "Consumer") == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    private void testCreatePermissionInvalidAuthority() throws Exception {
        String postUrl = this.createFolder();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission("NonExistingAuthority", "Consumer", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        d1.setPermissions(nodePermissions);
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
    }

    private void testCreatePermissionInvalidName() throws Exception {
        String postUrl = this.createFolder();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "InvalidName", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        d1.setPermissions(nodePermissions);
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
    }

    private void testCreatePermissionInvalidAccessStatus() throws Exception {
        String postUrl = this.createFolder();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", "InvalidAccessLevel"));
        nodePermissions.setLocallySet(locallySetPermissions);
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        d1.setPermissions(nodePermissions);
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
    }

    private void testCreatePermissionAddDuplicate() throws Exception {
        String postUrl = this.createFolder();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        d1.setPermissions(nodePermissions);
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
    }

    private void testCreatePermissionMissingFields() throws Exception {
        String postUrl = this.createFolder();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(null, "Consumer", AccessStatus.ALLOWED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        d1.setPermissions(nodePermissions);
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission("", "Consumer", AccessStatus.ALLOWED.toString()));
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, null, AccessStatus.ALLOWED.toString()));
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "", AccessStatus.ALLOWED.toString()));
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 400);
    }

    private void testCreatePermissionsPermissionDeniedUser() throws Exception {
        String postUrl = this.createFolder();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        d1.setPermissions(nodePermissions);
        this.setRequestContext(user2);
        this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), null, 403);
    }

    private void testCreatePermissionsSetFalseInheritFromParent() throws Exception {
        String testFolderUrl = this.createFolder();
        NodePermissions nodePermissions = new NodePermissions();
        nodePermissions.setIsInheritanceEnabled(false);
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        d1.setPermissions(nodePermissions);
        String dId = this.createDocument(testFolderUrl, nodePermissions);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "permissions");
        HttpResponse response = this.getSingle(NodesEntityResource.class, dId, params, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertFalse((String)"Inheritance hasn't been disabled!", (boolean)nodeResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertNull((String)"Permissions were inherited from parent!", (Object)nodeResp.getPermissions().getInherited());
    }

    private void testUpdatePermissionsOnNode() throws Exception {
        String postUrl = this.createFolder();
        String dId = this.createDocument(postUrl);
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        HttpResponse response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        this.validatePermissions(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), locallySetPermissions);
        AuthenticationUtil.setRunAsUser((String)user2);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Consumer") == AccessStatus.DENIED ? 1 : 0) != 0);
        AuthenticationUtil.setRunAsUser((String)user1);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Consumer") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Editor", AccessStatus.ALLOWED.toString()));
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupB, "Consumer", AccessStatus.ALLOWED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        this.validatePermissions(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), locallySetPermissions);
        AuthenticationUtil.setRunAsUser((String)user2);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Consumer") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Editor") == AccessStatus.DENIED ? 1 : 0) != 0);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        AuthenticationUtil.setRunAsUser((String)user1);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Editor") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Write") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        Assert.assertTrue((this.permissionService.hasPermission(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, documentResp.getId()), "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    private void testUpdatePermissionInvalidAuthority() throws Exception {
        String postUrl = this.createFolder();
        String dId = this.createDocument(postUrl);
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission("NonExistingAuthority", "Consumer", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
    }

    private void testUpdatePermissionInvalidName() throws Exception {
        String postUrl = this.createFolder();
        String dId = this.createDocument(postUrl);
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "InvalidName", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
    }

    private void testUpdatePermissionInvalidAccessStatus() throws Exception {
        String postUrl = this.createFolder();
        String dId = this.createDocument(postUrl);
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", "InvalidAccessLevel"));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
    }

    private void testUpdatePermissionAddDuplicate() throws Exception {
        String postUrl = this.createFolder();
        String dId = this.createDocument(postUrl);
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.ALLOWED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
    }

    private void testUpdatePermissionMissingFields() throws Exception {
        String postUrl = this.createFolder();
        String dId = this.createDocument(postUrl);
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(null, "Consumer", AccessStatus.ALLOWED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission("", "Consumer", AccessStatus.ALLOWED.toString()));
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, null, AccessStatus.ALLOWED.toString()));
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
        locallySetPermissions.clear();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "", AccessStatus.ALLOWED.toString()));
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 400);
    }

    private void testUpdatePermissionsPermissionDeniedUser() throws Exception {
        String postUrl = this.createFolder();
        String dId = this.createDocument(postUrl);
        Document dUpdate = new Document();
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Consumer", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        dUpdate.setPermissions(nodePermissions);
        this.setRequestContext(user2);
        this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 403);
    }

    private void testUpdatePermissionsOnSpecialNodes() throws Exception {
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Editor", AccessStatus.ALLOWED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        HttpResponse response = this.getSingle(NodesEntityResource.class, this.getRootNodeId(), null, 200);
        Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        node.setPermissions(nodePermissions);
        this.put("nodes", node.getId(), RestApiUtil.toJsonAsStringNonNull(node), null, 403);
        response = this.getSingle(NodesEntityResource.class, this.getSharedNodeId(), null, 200);
        node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        node.setPermissions(nodePermissions);
        this.put("nodes", node.getId(), RestApiUtil.toJsonAsStringNonNull(node), null, 403);
        response = this.getSingle(NodesEntityResource.class, this.getDataDictionaryNodeId(), null, 200);
        node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        node.setPermissions(nodePermissions);
        this.put("nodes", node.getId(), RestApiUtil.toJsonAsStringNonNull(node), null, 403);
        response = this.getSingle(NodesEntityResource.class, this.getSharedNodeId(), null, 200);
        node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        node.setPermissions(nodePermissions);
        this.put("nodes", node.getId(), RestApiUtil.toJsonAsStringNonNull(node), null, 403);
        HttpResponse responseUserHome = this.getSingle(NodesEntityResource.class, this.getMyNodeId(), null, 200);
        Node nodeUserHome = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        node.setPermissions(nodePermissions);
        this.put("nodes", node.getId(), RestApiUtil.toJsonAsStringNonNull(node), null, 403);
    }

    private void testUpdatePermissionsDefaultInheritFromParent() throws Exception {
        Folder folder = new Folder();
        folder.setName("testFolder" + GUID.generate());
        folder.setNodeType("cm:folder");
        NodePermissions nodePermissions = new NodePermissions();
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(this.groupA, "Editor", AccessStatus.DENIED.toString()));
        nodePermissions.setLocallySet(locallySetPermissions);
        folder.setPermissions(nodePermissions);
        HttpResponse response = this.post(this.getNodeChildrenUrl("-my-"), RestApiUtil.toJsonAsStringNonNull(folder), 201);
        Folder f = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        String docId = this.createDocument(this.getNodeChildrenUrl(f.getId()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "permissions");
        response = this.getSingle(NodesEntityResource.class, docId, params, 200);
        Document docResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertTrue((String)"Inheritance hasn't been enabled!", (boolean)docResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertTrue((String)"Permissions were not inherited from parent!", (docResp.getPermissions().getInherited().size() > 0 ? 1 : 0) != 0);
    }

    private void testUpdatePermissionsSetFalseInheritFromParent() throws Exception {
        String testFolderUrl = this.createFolder();
        String dId = this.createDocument(testFolderUrl);
        Document dUpdate = new Document();
        NodePermissions nodePermissionsUpdate = new NodePermissions();
        nodePermissionsUpdate.setIsInheritanceEnabled(false);
        dUpdate.setPermissions(nodePermissionsUpdate);
        HttpResponse response = this.put("nodes", dId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "permissions");
        response = this.getSingle(NodesEntityResource.class, documentResp.getId(), params, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertFalse((String)"Inheritance hasn't been disabled!", (boolean)nodeResp.getPermissions().getIsInheritanceEnabled());
        Assert.assertNull((String)"Permissions were inherited from parent!", (Object)nodeResp.getPermissions().getInherited());
    }

    @Test
    public void createContentWithAllParametersAccepted() throws Exception {
        this.setRequestContext(user1);
        String folderName = "My Folder" + GUID.generate();
        String myNodeId = this.getMyNodeId();
        Folder folder = new Folder();
        folder.setName(folderName);
        folder.setNodeType("cm:folder");
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(folder), 201);
        Folder folderResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Folder.class);
        Assert.assertEquals((Object)folderName, (Object)folderResponse.getName());
        Assert.assertEquals((Object)"cm:folder", (Object)folderResponse.getNodeType());
        Object fileName = "myfile" + GUID.generate() + ".txt";
        Document document = new Document();
        document.setName((String)fileName);
        document.setNodeType("cm:content");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(document), 201);
        Document documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)fileName, (Object)documentResponse.getName());
        Assert.assertEquals((Object)"cm:content", (Object)documentResponse.getNodeType());
        fileName = "quick-2.pdf";
        File file = this.getResourceFile((String)fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData((String)fileName, file));
        multiPartBuilder.setAutoRename(true);
        multiPartBuilder.setNodeType("cm:content");
        multiPartBuilder.setOverwrite(false);
        multiPartBuilder.setMajorVersion(true);
        multiPartBuilder.setDescription("test");
        multiPartBuilder.setRenditions(Collections.singletonList("doclib"));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        ContentInfo contentInfo = document.getContent();
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
        document.setNodeType("custom:destination");
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData((String)fileName, file));
        multiPartBuilder.setAutoRename(true);
        multiPartBuilder.setNodeType("custom:destination");
        MultiValueMap props = new MultiValueMap();
        props.put("cm:title", "test title");
        props.put("custom:locations", "loc1");
        props.put("custom:locations", "loc2");
        props.put("custom:locations", "loc3");
        multiPartBuilder.setProperties((Map<String, String>)props);
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentInfo = document.getContent();
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)contentInfo.getEncoding());
    }

    @Test
    public void updatePropertiesMultivalueTest() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String fileName = "myfile" + GUID.generate() + ".txt";
        File file = this.getResourceFile("quick-2.pdf");
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setAutoRename(true);
        multiPartBuilder.setNodeType("custom:destination");
        multiPartBuilder.setOverwrite(false);
        multiPartBuilder.setMajorVersion(true);
        multiPartBuilder.setDescription("test");
        multiPartBuilder.setRenditions(Collections.singletonList("doclib"));
        MultiValueMap props = new MultiValueMap();
        props.put("cm:title", "test title");
        props.put("custom:locations", "loc1");
        props.put("custom:locations", "loc2");
        props.put("custom:locations", "loc3");
        multiPartBuilder.setProperties((Map<String, String>)props);
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String jsonUpdate = "{\"name\":\"My Other Folder\",\"nodeType\":\"custom:destination\",\"properties\":{\"cm:title\":\"Folder title\",\"cm:description\":\"This is an important folder\",\"custom:locations\":[\"location X\",\"location Y\"]}}";
        response = this.put("nodes", documentResponse.getId(), jsonUpdate, null, 200);
        Node nodeUpdateResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Map<String, Object> propUpdateResponse = nodeUpdateResponse.getProperties();
        Assert.assertNotNull((Object)propUpdateResponse.get("custom:locations"));
        Assert.assertTrue((((ArrayList)propUpdateResponse.get("custom:locations")).size() == 2 ? 1 : 0) != 0);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList<String> locations = new ArrayList<String>();
        locations.add("location X1");
        properties.put("custom:locations", locations);
        Node nodeUpdate = new Node();
        nodeUpdate.setProperties(properties);
        response = this.put("nodes", documentResponse.getId(), RestApiUtil.toJsonAsStringNonNull(nodeUpdate), null, 200);
        nodeUpdateResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        propUpdateResponse = nodeUpdateResponse.getProperties();
        Assert.assertNotNull((Object)propUpdateResponse.get("custom:locations"));
        Assert.assertTrue((((ArrayList)propUpdateResponse.get("custom:locations")).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void versioningEnabledMultipartNodeCreationTest() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        File file = this.getResourceFile("quick-2.pdf");
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Map<String, Object> documentProperties = documentResponse.getProperties();
        Assert.assertEquals((long)2L, (long)documentProperties.size());
        Assert.assertEquals((Object)"MAJOR", (Object)documentProperties.get("cm:versionType"));
        Assert.assertEquals((Object)"1.0", (Object)documentProperties.get("cm:versionLabel"));
        fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setVersioningEnabled("false");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setMajorVersion(true);
        multiPartBuilder.setVersioningEnabled("false");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setMajorVersion(false);
        multiPartBuilder.setVersioningEnabled("false");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setVersioningEnabled("true");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertEquals((long)2L, (long)documentProperties.size());
        Assert.assertEquals((Object)"MAJOR", (Object)documentProperties.get("cm:versionType"));
        Assert.assertEquals((Object)"1.0", (Object)documentProperties.get("cm:versionLabel"));
        fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setMajorVersion(true);
        multiPartBuilder.setVersioningEnabled("true");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertEquals((long)2L, (long)documentProperties.size());
        Assert.assertEquals((Object)"MAJOR", (Object)documentProperties.get("cm:versionType"));
        Assert.assertEquals((Object)"1.0", (Object)documentProperties.get("cm:versionLabel"));
        fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setMajorVersion(false);
        multiPartBuilder.setVersioningEnabled("true");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertEquals((long)2L, (long)documentProperties.size());
        Assert.assertEquals((Object)"MINOR", (Object)documentProperties.get("cm:versionType"));
        Assert.assertEquals((Object)"0.1", (Object)documentProperties.get("cm:versionLabel"));
        fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setVersioningEnabled("False");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        fileName = "myfile" + String.valueOf(UUID.randomUUID()) + ".txt";
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        multiPartBuilder.setVersioningEnabled("invalid");
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertEquals((Object)"MAJOR", (Object)documentProperties.get("cm:versionType"));
        Assert.assertEquals((Object)"1.0", (Object)documentProperties.get("cm:versionLabel"));
    }

    @Test
    public void versioningEnabledJSONNodeCreationTest() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        Document d1 = new Document();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        d1.setNodeType("cm:content");
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        Document documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Map<String, Object> documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningEnabled", "false");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningEnabled", "false");
        requestHeaders.put("majorVersion", "true");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningEnabled", "false");
        requestHeaders.put("majorVersion", "false");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningEnabled", "true");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertEquals((Object)"MAJOR", (Object)documentProperties.get("cm:versionType"));
        Assert.assertEquals((Object)"1.0", (Object)documentProperties.get("cm:versionLabel"));
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningEnabled", "true");
        requestHeaders.put("majorVersion", "true");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertEquals((Object)"MAJOR", (Object)documentProperties.get("cm:versionType"));
        Assert.assertEquals((Object)"1.0", (Object)documentProperties.get("cm:versionLabel"));
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningEnabled", "true");
        requestHeaders.put("majorVersion", "false");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertEquals((Object)"MINOR", (Object)documentProperties.get("cm:versionType"));
        Assert.assertEquals((Object)"0.1", (Object)documentProperties.get("cm:versionLabel"));
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningEnabled", "False");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningEnabled", "invalid");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
        d1.setName("testDoc" + String.valueOf(UUID.randomUUID()));
        requestHeaders = new HashMap();
        requestHeaders.put("versioningenabled", "true");
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), requestHeaders, null, null, 201);
        documentResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        documentProperties = documentResponse.getProperties();
        Assert.assertNull(documentProperties);
    }

    @Test
    public void testAuditableProperties() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        UserInfo expectedUser = new UserInfo(user1);
        String auditCreator = "unacceptable creator";
        String auditCreated = "unacceptable created";
        String auditModifier = "unacceptable modifier";
        String auditModified = "unacceptable modified";
        String auditAccessed = "unacceptable accessed";
        HashMap<String, Object> auditableProperties = new HashMap<String, Object>();
        auditableProperties.put("cm:creator", auditCreator);
        auditableProperties.put("cm:created", auditCreated);
        auditableProperties.put("cm:modifier", auditModifier);
        auditableProperties.put("cm:modified", auditModified);
        auditableProperties.put("cm:accessed", auditAccessed);
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put("sys:node:uuid", "someRandomID");
        Node node = new Node();
        node.setName("folderName");
        node.setNodeType("cm:folder");
        node.setProperties(auditableProperties);
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(node), 400);
        node.setProperties(systemProperties);
        this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(node), 400);
        node.setProperties(new HashMap<String, Object>());
        response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(node), 201);
        Node createdFolder = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)createdFolder.getCreatedByUser().getId(), (Object)expectedUser.getId());
        this.validateAuditableProperties(auditableProperties, createdFolder);
        createdFolder.setProperties(auditableProperties);
        this.put("nodes", createdFolder.getId(), RestApiUtil.toJsonAsStringNonNull(createdFolder), null, 400);
        HashMap<String, Object> otherProperties = new HashMap<String, Object>();
        otherProperties.put("cm:title", "newTitle");
        createdFolder.setProperties(otherProperties);
        response = this.put("nodes", createdFolder.getId(), RestApiUtil.toJsonAsStringNonNull(createdFolder), null, 200);
        Node updateFolderResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        this.validateAuditableProperties(auditableProperties, updateFolderResponse);
    }

    private void validateAuditableProperties(Map<String, Object> givenProperties, Node node) {
        Assert.assertFalse((boolean)givenProperties.get("cm:creator").equals(node.getCreatedByUser().getDisplayName()));
        Assert.assertFalse((boolean)givenProperties.get("cm:created").equals(node.getCreatedAt().getTime()));
        Assert.assertFalse((boolean)givenProperties.get("cm:modifier").equals(node.getModifiedAt().getTime()));
        Assert.assertFalse((boolean)givenProperties.get("cm:modified").equals(node.getModifiedByUser().getDisplayName()));
    }

    @Test
    public void testPrimaryPath() throws Exception {
        this.setRequestContext(user1);
        AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
        String myNodeId = this.getMyNodeId();
        String nameA = "folder_A";
        String nameA01 = "folder_A01";
        String nameA02 = "folder_A02";
        String nameA03 = "folder_A03";
        String nameB = "folder_B";
        Folder folderA = this.createFolder(myNodeId, nameA);
        Folder folderB = this.createFolder(folderA.getId(), nameB);
        NodeRef folderANodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folderA.getId());
        NodeRef folderBNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folderB.getId());
        folderA.setName(nameA01);
        this.put("nodes", folderA.getId(), RestApiUtil.toJsonAsStringNonNull(folderA), null, 200);
        Path folderAPath = this.nodeService.getPath(folderANodeRef);
        Path.ChildAssocElement pathElement = (Path.ChildAssocElement)folderAPath.last();
        String localNameForFolderA = pathElement.getRef().getQName().getLocalName();
        Assert.assertFalse((boolean)nameA.equals(localNameForFolderA));
        folderA.setName(nameA02);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cm:name", nameA03);
        folderA.setProperties(properties);
        this.put("nodes", folderA.getId(), RestApiUtil.toJsonAsStringNonNull(folderA), null, 200);
        folderAPath = this.nodeService.getPath(folderANodeRef);
        pathElement = (Path.ChildAssocElement)folderAPath.last();
        localNameForFolderA = pathElement.getRef().getQName().getLocalName();
        Assert.assertFalse((boolean)nameA.equals(localNameForFolderA));
        Assert.assertFalse((boolean)nameA03.equals(localNameForFolderA));
        Assert.assertTrue((boolean)nameA02.equals(localNameForFolderA));
        Path folderBPath = this.nodeService.getPath(folderBNodeRef);
        Path.ChildAssocElement pathBLastElement = (Path.ChildAssocElement)folderBPath.last();
        String currentPath = folderBPath.toDisplayPath(this.nodeService, this.permissionService) + "/" + pathBLastElement.getRef().getQName().getLocalName();
        String expectedPath = "/Company Home/User Homes/" + user1 + "/" + nameA02 + "/" + nameB;
        Assert.assertTrue((boolean)currentPath.equals(expectedPath));
    }

    @Test
    public void testPrimaryPathVersion() throws Exception {
        this.setRequestContext(user1);
        AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
        String myNodeId = this.getMyNodeId();
        String folderName = "folder_A";
        Folder folder = this.createFolder(myNodeId, folderName);
        NodeRef folderNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folder.getId());
        String docName = "testDoc" + GUID.generate();
        Document doc = new Document();
        doc.setName(docName);
        doc.setNodeType("cm:content");
        HttpResponse response = this.post(this.getNodeChildrenUrl(folderNodeRef.getId()), RestApiUtil.toJsonAsStringNonNull(doc), 201);
        Document docResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        NodeRef docNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, docResp.getId());
        String expectedPath1 = "/Company Home/User Homes/" + user1 + "/" + folderName + "/" + docName;
        Path docPath1 = this.nodeService.getPath(docNodeRef);
        Path.ChildAssocElement docPathLast1 = (Path.ChildAssocElement)docPath1.last();
        String docLocalName1 = docPathLast1.getRef().getQName().getLocalName();
        String currentPath1 = docPath1.toDisplayPath(this.nodeService, this.permissionService) + "/" + docLocalName1;
        Assert.assertTrue((boolean)docName.equals(docLocalName1));
        Assert.assertTrue((boolean)expectedPath1.equals(currentPath1));
        String docName2 = "testDoc2" + GUID.generate();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", docName2);
        Document docResp2 = this.updateTextFileWithRandomContent(docNodeRef.getId(), 1024L, params);
        NodeRef docNodeRef2 = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, docResp2.getId());
        String expectedPath2 = "/Company Home/User Homes/" + user1 + "/" + folderName + "/" + docName2;
        Path docPath2 = this.nodeService.getPath(docNodeRef2);
        Path.ChildAssocElement docPathLast2 = (Path.ChildAssocElement)docPath2.last();
        String docLocalName2 = docPathLast2.getRef().getQName().getLocalName();
        String currentPath2 = docPath2.toDisplayPath(this.nodeService, this.permissionService) + "/" + docLocalName2;
        Assert.assertFalse((boolean)docLocalName1.equals(docLocalName2));
        Assert.assertTrue((boolean)docName2.equals(docLocalName2));
        Assert.assertFalse((boolean)expectedPath1.equals(currentPath2));
        Assert.assertTrue((boolean)expectedPath2.equals(currentPath2));
    }

    private String getDataDictionaryNodeId() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("relativePath", "/Data Dictionary");
        HttpResponse response = this.getSingle(NodesEntityResource.class, this.getRootNodeId(), params, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        return nodeResp.getId();
    }

    private String getSitesNodeId() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("relativePath", "/Sites");
        HttpResponse response = this.getSingle(NodesEntityResource.class, this.getRootNodeId(), params, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        return nodeResp.getId();
    }

    private String createFolder() throws Exception {
        String folderName = "testPermissionsFolder-" + GUID.generate();
        String folderId = this.createFolder("-my-", folderName).getId();
        return this.getNodeChildrenUrl(folderId);
    }

    private String createDocument(String url) throws Exception {
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        HttpResponse response = this.post(url, RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        return documentResp.getId();
    }

    private String createDocument(String url, NodePermissions perms) throws Exception {
        Document d1 = new Document();
        d1.setName("testDoc" + GUID.generate());
        d1.setNodeType("cm:content");
        d1.setPermissions(perms);
        HttpResponse response = this.post(url, RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        return documentResp.getId();
    }

    private void validatePermissions(NodeRef nodeRef, List<NodePermissions.NodePermission> expectedPermissions) {
        Set permissions = this.permissionService.getAllSetPermissions(nodeRef);
        for (NodePermissions.NodePermission permission : expectedPermissions) {
            String authority = permission.getAuthorityId();
            AccessPermission ap = this.getPermission(permissions, authority);
            Assert.assertNotNull((String)("Permission " + authority + " missing"), (Object)ap);
            Assert.assertEquals((Object)authority, (Object)ap.getAuthority());
            this.comparePermissions(authority, permission, ap);
        }
    }

    private void comparePermissions(String authority, NodePermissions.NodePermission permission, AccessPermission ap) {
        Assert.assertEquals((String)("Wrong permission for " + authority), (Object)permission.getAuthorityId(), (Object)ap.getAuthority());
        Assert.assertEquals((String)("Wrong permission for " + authority), (Object)permission.getName(), (Object)ap.getPermission());
        Assert.assertEquals((String)("Wrong access status for " + authority), (Object)permission.getAccessStatus(), (Object)ap.getAccessStatus().toString());
    }

    private AccessPermission getPermission(Set<AccessPermission> permissions, String expectedAuthority) {
        AccessPermission result = null;
        for (AccessPermission ap : permissions) {
            if (!expectedAuthority.equals(ap.getAuthority())) continue;
            result = ap;
        }
        return result;
    }

    @Override
    public String getScope() {
        return "public";
    }

    @Test
    public void testRetrieveNodeDefinition() throws Exception {
        this.setRequestContext(networkOne.getId(), user1, null);
        String node1 = "nodeSample" + this.RUNID + "_1";
        String node1Type = "cm:content";
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("cm:title", "add aspect property");
        Node node = this.createNode("-my-", node1, node1Type, props);
        String nodeId = node.getId();
        HttpResponse response = this.getSingle(NodesEntityResource.class, nodeId, null, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertNull((String)"Definition should not be retrieved unless included!", (Object)nodeResp.getDefinition());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "definition");
        response = this.getSingle(NodesEntityResource.class, nodeId, params, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        ClassDefinition classDefinition = nodeResp.getDefinition();
        Assert.assertNotNull((Object)classDefinition);
        this.checkDefinitionProperties(classDefinition.getProperties());
    }

    private void checkDefinitionProperties(List<PropertyDefinition> properties) {
        Assert.assertNotNull(properties);
        this.shouldNotContainSystemProperties(properties);
        this.shouldContainParentProperties(properties);
        this.shouldContainAspectProperties(properties);
        PropertyDefinition testProperty = properties.stream().filter(property -> property.getId().equals("cm:name")).findFirst().get();
        Assert.assertNotNull((Object)testProperty);
        Assert.assertEquals((Object)"Name", (Object)testProperty.getTitle());
        Assert.assertEquals((Object)"d:text", (Object)testProperty.getDataType());
        Assert.assertEquals((Object)"Name", (Object)testProperty.getDescription());
        Assert.assertTrue((boolean)testProperty.getIsMandatory());
        Assert.assertTrue((boolean)testProperty.getIsMandatoryEnforced());
        Assert.assertFalse((boolean)testProperty.getIsMultiValued());
        Assert.assertNull((Object)testProperty.getDefaultValue());
        this.checkPropertyConstraints(testProperty.getConstraints());
    }

    private void shouldNotContainSystemProperties(List<PropertyDefinition> properties) {
        Assert.assertTrue((boolean)properties.stream().noneMatch(property -> property.getId().startsWith("sys") || property.getId().equals(ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespaceService))));
    }

    private void shouldContainParentProperties(List<PropertyDefinition> properties) {
        Assert.assertTrue((boolean)properties.stream().anyMatch(property -> property.getId().equals("cm:name")));
    }

    private void shouldContainAspectProperties(List<PropertyDefinition> properties) {
        PropertyDefinition mandatoryAspectProperty = properties.stream().filter(property -> property.getId().equals("cm:created")).findFirst().get();
        Assert.assertNotNull((Object)mandatoryAspectProperty);
        PropertyDefinition nodeAspectProperty = properties.stream().filter(property -> property.getId().equals("cm:title")).findFirst().get();
        Assert.assertNotNull((Object)nodeAspectProperty);
    }

    private void checkPropertyConstraints(List<ConstraintDefinition> constraints) {
        Assert.assertNotNull(constraints);
        ConstraintDefinition constraintDefinition = constraints.stream().filter(constraint -> constraint.getId().equals("cm:filename")).findFirst().get();
        Assert.assertNotNull((Object)constraintDefinition);
        Assert.assertEquals((Object)"REGEX", (Object)constraintDefinition.getType());
        Map constraintParameters = constraintDefinition.getParameters();
        Assert.assertNotNull((Object)constraintParameters);
        Assert.assertNull((Object)constraintDefinition.getDescription());
        Assert.assertNull((Object)constraintDefinition.getTitle());
        Assert.assertEquals((long)2L, (long)constraintParameters.size());
        Assert.assertEquals((Object)"(.*[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$)", constraintParameters.get("expression"));
        Assert.assertFalse((boolean)((Boolean)constraintParameters.get("requiresMatch")));
    }

    @Test
    public void testRequestContentDirectUrl() throws Exception {
        this.setRequestContext(user1);
        String fileName = "quick-1.txt";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl("-my-"), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Assert.assertEquals((Object)fileName, (Object)document.getName());
        ContentInfo contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        HttpResponse dauResponse = this.post(this.getRequestContentDirectUrl(contentNodeId), null, null, null, null, 501);
    }

    @Test
    public void testRequestContentDirectUrlClientErrorResponseForNodes() throws Exception {
        this.enableRestDirectAccessUrls();
        this.setRequestContext(user1);
        HttpResponse nodeDoesNotExistResponse = this.post(this.getRequestContentDirectUrl("non-existing-node-id"), null, 404);
        String folderId = this.createFolder(tDocLibNodeId, "some-folder-name").getId();
        HttpResponse nodeIsNotAFileReponse = this.post(this.getRequestContentDirectUrl(folderId), null, 400);
        this.disableRestDirectAccessUrls();
    }

    @Test
    public void testRequestContentDirectUrlClientErrorResponseForVersions() throws Exception {
        this.enableRestDirectAccessUrls();
        this.setRequestContext(user1);
        String folderNodeId = this.createUniqueFolder(this.getMyNodeId());
        String contentNodeId = this.createUniqueContent(folderNodeId);
        HttpResponse versionIdDoesNotExistReponse = this.post(this.getRequestVersionDirectAccessUrl(contentNodeId, "1.2"), null, null, null, null, 404);
        HttpResponse versionIdInvalidReponse = this.post(this.getRequestVersionDirectAccessUrl(contentNodeId, "invalid-version"), null, null, null, null, 404);
        this.disableRestDirectAccessUrls();
    }

    @Test
    public void testRequestContentDirectUrlClientErrorResponseForRenditions() throws Exception {
        this.enableRestDirectAccessUrls();
        this.setRequestContext(user1);
        String folderNodeId = this.createUniqueFolder(this.getMyNodeId());
        String contentNodeId = this.createUniqueContent(folderNodeId);
        HttpResponse renditionIdDoesNotExistReponse = this.post(this.getRequestRenditionDirectAccessUrl(contentNodeId, "pdf"), null, null, null, null, 404);
        HttpResponse renditionIdInvalidReponse = this.post(this.getRequestRenditionDirectAccessUrl(contentNodeId, "invalid-rendition"), null, null, null, null, 404);
        this.disableRestDirectAccessUrls();
    }

    @Test
    public void testRequestContentDirectUrlClientErrorResponseForDeletion() throws Exception {
        this.enableRestDirectAccessUrls();
        this.setRequestContext(user1);
        String folderNodeId = this.createUniqueFolder(this.getMyNodeId());
        String contentNodeId = this.createUniqueContent(folderNodeId);
        HttpResponse nodeNotDeletedReponse = this.post(this.getRequestArchivedContentDirectUrl(contentNodeId), null, null, null, null, 404);
        this.disableRestDirectAccessUrls();
    }

    @Test
    public void testRequestDeleteRendition() throws Exception {
        this.setRequestContext(networkOne.getId(), user1, null);
        String myNodeId = this.getMyNodeId();
        String renditionName = "pdf";
        String fileName = "quick-1.txt";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder.MultiPartRequest reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).setRenditions(Collections.singletonList(renditionName)).build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Rendition rendition = this.waitAndGetRendition(contentNodeId, null, renditionName);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        this.delete(this.getNodeRenditionIdUrl(contentNodeId, renditionName), null, null, null, null, 204);
        this.delete(this.getNodeRenditionIdUrl(contentNodeId, renditionName), null, null, null, null, 404);
        HttpResponse getResponse = this.getSingle(this.getNodeRenditionIdUrl(contentNodeId, renditionName), null, 200);
        Rendition renditionDeleted = RestApiUtil.parseRestApiEntry(getResponse.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)renditionDeleted);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)renditionDeleted.getStatus()));
    }

    @Test
    public void testRequestVersionDeleteRendition() throws Exception {
        this.setRequestContext(networkOne.getId(), user1, null);
        String myNodeId = this.getMyNodeId();
        String renditionName = "pdf";
        String fileName = "quick-1.txt";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder.MultiPartRequest reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).setRenditions(Collections.singletonList(renditionName)).build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        String content = "The quick brown fox jumps over the lazy dog\n the lazy dog jumps over the quick brown fox";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("comment", "my version ");
        document = this.updateTextFile(contentNodeId, content, params);
        Assert.assertTrue((boolean)document.getAspectNames().contains("cm:versionable"));
        Assert.assertNotNull(document.getProperties());
        Assert.assertEquals((Object)"1.1", (Object)document.getProperties().get("cm:versionLabel"));
        Rendition renditionUpdated = this.createAndGetRendition(contentNodeId, "1.0", renditionName);
        Assert.assertNotNull((Object)renditionUpdated);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)renditionUpdated.getStatus()));
        this.delete(this.getNodeVersionRenditionIdUrl(contentNodeId, "1.0", renditionName), null, null, null, null, 204);
        this.delete(this.getNodeVersionRenditionIdUrl(contentNodeId, "1.0", renditionName), null, null, null, null, 404);
        HttpResponse getResponse = this.getSingle(this.getNodeVersionRenditionIdUrl(contentNodeId, "1.0", renditionName), null, 200);
        Rendition renditionDeleted = RestApiUtil.parseRestApiEntry(getResponse.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)renditionDeleted);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)renditionDeleted.getStatus()));
    }

    @Test
    public void testSiteManagerPermission() throws Exception {
        this.setRequestContext(user1);
        String site1Title = "site-testSiteManagerPermissions_DocLib-" + this.RUNID;
        String site1Id = this.createSite(site1Title, SiteVisibility.PUBLIC).getId();
        this.addSiteMember(site1Id, user2, SiteRole.SiteManager);
        String site1DocLibNodeId = this.getSiteContainerNodeId(site1Id, "documentLibrary");
        String content = "content" + this.RUNID;
        String content1_Id = this.createTextFile(site1DocLibNodeId, content, "The quick brown fox jumps over the lazy dog.").getId();
        NodeRef content1_Ref = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, content1_Id);
        Thread.sleep(3000L);
        this.setRequestContext(user2);
        Node nodeUpdate = new Node();
        NodePermissions nodePerms = new NodePermissions();
        nodePerms.setIsInheritanceEnabled(false);
        nodeUpdate.setPermissions(nodePerms);
        this.put("nodes", content1_Id, RestApiUtil.toJsonAsStringNonNull(nodeUpdate), null, 200);
        HashMap<String, String> params = new HashMap<String, String>();
        HttpResponse response = this.getSingle(NodesEntityResource.class, content1_Id, params, 200);
        Document node = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)node.getId(), (Object)content1_Id);
        this.setRequestContext(user1);
        this.deleteSite(site1Id, true, 204);
    }

    @Test
    public void testRuleAspectAfterUpdate() throws Exception {
        this.setRequestContext(networkOne.getId(), user1, null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
        String folderId = this.createUniqueFolder(this.getMyNodeId());
        NodeRef folderNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, folderId);
        Assert.assertFalse((String)"Folder shouldn't have the rule aspect", (boolean)this.nodeService.hasAspect(folderNodeRef, RuleModel.ASPECT_RULES));
        Rule rule = new Rule();
        rule.setTitle("My Rule");
        rule.setRuleType("inbound");
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        rule.setAction(action);
        this.ruleService.saveRule(folderNodeRef, rule);
        Assert.assertTrue((String)"Folder should have the rule aspect", (boolean)this.nodeService.hasAspect(folderNodeRef, RuleModel.ASPECT_RULES));
        Folder folderUpdate = new Folder();
        folderUpdate.setAspectNames(Arrays.asList(new String[0]));
        this.put("nodes", folderId, RestApiUtil.toJsonAsStringNonNull(folderUpdate), null, 200);
        Assert.assertTrue((String)"Folder should have the rule aspect", (boolean)this.nodeService.hasAspect(folderNodeRef, RuleModel.ASPECT_RULES));
        Assert.assertEquals((String)"Folder should have 1 rule.", (long)1L, (long)this.ruleService.countRules(folderNodeRef));
        this.delete("nodes", folderId, 204);
    }

    private class UpdateNodeRunnable
    implements Runnable {
        private final String docId;
        private final Long contentSize;

        UpdateNodeRunnable(String docId, Long contentSize) {
            this.docId = docId;
            this.contentSize = contentSize;
        }

        @Override
        public void run() {
            NodeApiTest.this.setRequestContext(AbstractBaseApiTest.user1);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("majorVersion", "true");
            Node documentResp = null;
            try {
                documentResp = NodeApiTest.this.updateTextFileWithRandomContent(this.docId, this.contentSize, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(documentResp.getProperties());
            Assert.assertEquals((Object)this.contentSize, (Object)documentResp.getContent().getSizeInBytes());
        }
    }
}

