/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.webdav.LockInfo;

public class LockInfoImpl
implements Serializable,
LockInfo {
    private static final long serialVersionUID = 1L;
    public static final String ADDINFO_WEBDAV_MARKER = "WebDAV_LockInfo";
    private String exclusiveLockToken = null;
    private String scope = null;
    private String depth = null;
    private final Set<String> sharedLockTokens = new HashSet<String>(3);
    private String owner;
    private Date expires;

    public LockInfoImpl() {
    }

    public LockInfoImpl(String token, String scope, String depth) {
        this.exclusiveLockToken = token;
        this.scope = scope;
        this.depth = depth;
    }

    @JsonIgnore
    public boolean isLocked() {
        return this.isExclusive() || this.isShared();
    }

    public void setExclusiveLockToken(String token) {
        if (this.isShared()) {
            throw new IllegalStateException("Cannot add exclusive lock token [" + token + "] to shared lock [" + this.toString() + "]");
        }
        this.exclusiveLockToken = token;
    }

    public String getExclusiveLockToken() {
        return this.exclusiveLockToken;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope == null ? "exclusive" : this.scope;
    }

    public void setDepth(String depth) {
        this.depth = depth;
    }

    public String getDepth() {
        return this.depth;
    }

    public Set<String> getSharedLockTokens() {
        return this.sharedLockTokens;
    }

    public void setSharedLockTokens(Set<String> sharedLockTokens) {
        if (!sharedLockTokens.isEmpty() && this.isExclusive()) {
            throw new IllegalStateException("Cannot add shared lock tokens [" + String.valueOf(sharedLockTokens) + "] to exclusive lock [" + this.toString() + "]");
        }
        this.sharedLockTokens.clear();
        this.sharedLockTokens.addAll(sharedLockTokens);
    }

    public void addSharedLockToken(String token) {
        if (this.isExclusive()) {
            throw new IllegalStateException("Cannot add shared lock token [" + token + "] to exclusive lock [" + this.toString() + "]");
        }
        this.sharedLockTokens.add(token);
    }

    @JsonIgnore
    public boolean isShared() {
        return !this.sharedLockTokens.isEmpty();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("LockInfo[");
        str.append("exclusiveLockToken=");
        str.append(this.getExclusiveLockToken());
        str.append(", scope=");
        str.append(this.getScope());
        str.append(", depth=");
        str.append(this.getDepth());
        str.append(", sharedLockTokens=");
        str.append(this.getSharedLockTokens());
        str.append(", owner=");
        str.append(this.owner);
        str.append(", expires=");
        str.append(this.expires);
        str.append("]");
        return str.toString();
    }

    public String toJSON() {
        String json;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            json = objectMapper.writeValueAsString((Object)this);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to generate JSON for " + this.toString(), e);
        }
        return "WebDAV_LockInfo:" + json;
    }

    public static LockInfo fromJSON(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        if (json != null && json.startsWith(ADDINFO_WEBDAV_MARKER)) {
            try {
                json = json.substring(ADDINFO_WEBDAV_MARKER.length() + 1);
                LockInfo lockInfo = (LockInfo)objectMapper.readValue(json, LockInfoImpl.class);
                return lockInfo;
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unable to parse JSON from [" + json + "]", e);
            }
        }
        throw new IllegalArgumentException("Was not detected WEBDAV_LOCK marker.");
    }

    @JsonIgnore
    public boolean isExpired() {
        if (this.expires == null) {
            return false;
        }
        Date now = this.dateNow();
        return now.after(this.expires);
    }

    @JsonIgnore
    public boolean isExclusive() {
        return this.exclusiveLockToken != null && this.exclusiveLockToken.length() > 0;
    }

    @JsonIgnore
    public String getOwner() {
        return this.owner;
    }

    @JsonIgnore
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @JsonIgnore
    public void setExpires(Date expires) {
        this.expires = expires;
    }

    @JsonIgnore
    public Date getExpires() {
        return this.expires;
    }

    @JsonIgnore
    public long getRemainingTimeoutSeconds() {
        Date expires = this.getExpires();
        if (expires == null) {
            return -1L;
        }
        Date now = this.dateNow();
        long remainingTimeoutInSecondsRoundedUp = (Math.max(expires.getTime() - now.getTime(), 0L) + 999L) / 1000L;
        return remainingTimeoutInSecondsRoundedUp;
    }

    @JsonIgnore
    public void setTimeoutSeconds(int lockTimeoutSecs) {
        if (lockTimeoutSecs == -1) {
            this.setExpires(null);
        } else {
            int timeoutMillis = lockTimeoutSecs * 1000;
            Date now = this.dateNow();
            Date nextExpiry = new Date(now.getTime() + (long)timeoutMillis);
            this.setExpires(nextExpiry);
        }
    }

    @JsonIgnore
    public void setTimeoutMinutes(int lockTimeoutMins) {
        if (lockTimeoutMins != -1) {
            this.setTimeoutSeconds(lockTimeoutMins * 60);
        } else {
            this.setTimeoutSeconds(-1);
        }
    }

    protected Date dateNow() {
        return new Date();
    }
}

