/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.extensions.webscripts.ClassPathStoreResourceResolver;
import org.springframework.util.FileCopyUtils;

public class SiteSurfConfig
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private String configPath;
    private String packageName = "surf-config";
    private String importView;
    private Map<String, String> importContent;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setConfigPath(String configPath) {
        if (!((String)configPath).endsWith("/")) {
            configPath = (String)configPath + "/";
        }
        this.configPath = configPath;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configPath == null) {
            this.setConfigPath("alfresco/bootstrap/site");
        }
        this.importView = this.loadImportView();
        this.importContent = this.loadContent();
    }

    public String getImportView() {
        return this.importView;
    }

    public String getImportContent(String contentPath) {
        return this.importContent.get(contentPath);
    }

    private String loadImportView() throws IOException {
        ClassPathResource importViewResource = new ClassPathResource(this.configPath + this.packageName + ".xml");
        if (!importViewResource.exists()) {
            throw new AlfrescoRuntimeException("Cannot find site config " + importViewResource.getPath());
        }
        return this.convert(importViewResource.getInputStream());
    }

    private Map<String, String> loadContent() throws IOException {
        ClassPathStoreResourceResolver resourceResolver = new ClassPathStoreResourceResolver(this.applicationContext);
        Resource[] contentResources = resourceResolver.getResources("classpath*:" + this.configPath + this.packageName + "/*.*");
        HashMap<String, String> content = new HashMap<String, String>();
        for (Resource contentResource : contentResources) {
            String fileName = contentResource.getFilename();
            if (fileName.startsWith(".")) continue;
            String key = this.packageName + "/" + fileName;
            String value = this.convert(contentResource.getInputStream());
            content.put(key, value);
        }
        return content;
    }

    private String convert(InputStream contentInputStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        FileCopyUtils.copy((InputStream)contentInputStream, (OutputStream)os);
        byte[] bytes = os.toByteArray();
        String content = new String(bytes, "UTF-8");
        return content;
    }
}

