/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceDictionary;
import org.alfresco.rest.framework.core.ResourceInspector;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;

public class ResourceDictionaryBuilder {
    private static Log logger = LogFactory.getLog(ResourceDictionaryBuilder.class);

    private static void processResources(ResourceDictionary rd, Map<ApiScopeKey, Map<Integer, List<ResourceWithMetadata>>> entityApiMap, Map<ApiScopeKey, Map<Integer, List<ResourceWithMetadata>>> relationshipApiMap) {
        logger.debug((Object)"Will process resources ");
        for (Map.Entry<ApiScopeKey, Map<Integer, List<ResourceWithMetadata>>> apiGroupedByNameAndScopeEntry : entityApiMap.entrySet()) {
            logger.debug((Object)("Processing " + String.valueOf(apiGroupedByNameAndScopeEntry.getKey())));
            Map<Integer, List<ResourceWithMetadata>> apiVersions = apiGroupedByNameAndScopeEntry.getValue();
            ArrayList<Integer> versions = new ArrayList<Integer>(apiVersions.keySet());
            logger.debug((Object)("Versions " + String.valueOf(versions)));
            Collections.sort(versions);
            for (int i = 0; i < versions.size(); ++i) {
                Api apiVersion = Api.valueOf(apiGroupedByNameAndScopeEntry.getKey().name, apiGroupedByNameAndScopeEntry.getKey().scope.toString(), Integer.toString((Integer)versions.get(i)));
                Map<String, ResourceWithMetadata> resourcesByApiAndVersion = ResourceDictionaryBuilder.findResources(rd.getAllResources(), apiVersion);
                logger.debug((Object)("Working with api " + String.valueOf(apiVersion)));
                if (i > 0) {
                    logger.debug((Object)"Has previous so adding all entities from previous version ");
                    Api previousVersion = Api.valueOf(apiVersion.getName(), apiVersion.getScope().toString(), Integer.toString(apiVersion.getVersion() - 1));
                    logger.debug((Object)("Previous version is " + String.valueOf(previousVersion)));
                    Map<String, ResourceWithMetadata> resourcesForPreviousVersion = ResourceDictionaryBuilder.findResources(rd.getAllResources(), previousVersion);
                    resourcesByApiAndVersion.putAll(resourcesForPreviousVersion);
                }
                for (ResourceWithMetadata resourceWithMetadata : apiGroupedByNameAndScopeEntry.getValue().get(apiVersion.getVersion())) {
                    resourcesByApiAndVersion.put(resourceWithMetadata.getMetaData().getUniqueId(), resourceWithMetadata);
                }
            }
        }
    }

    private static Map<String, ResourceWithMetadata> findResources(Map<Api, Map<String, ResourceWithMetadata>> allResources, Api api) {
        Map<String, ResourceWithMetadata> resourcesByApiAndVersion = allResources.get(api);
        if (resourcesByApiAndVersion == null) {
            resourcesByApiAndVersion = new HashMap<String, ResourceWithMetadata>();
            allResources.put(api, resourcesByApiAndVersion);
        }
        return resourcesByApiAndVersion;
    }

    private static <T> Map<ApiScopeKey, Map<Integer, List<ResourceWithMetadata>>> parseResources(Collection<Object> resources) {
        HashMap<ApiScopeKey, Map<Integer, List<ResourceWithMetadata>>> apiMap = new HashMap<ApiScopeKey, Map<Integer, List<ResourceWithMetadata>>>();
        for (Object bean : resources) {
            ArrayList<ResourceWithMetadata> resourcesWithMeta;
            List<ResourceMetadata> metaData = ResourceInspector.inspect(bean.getClass());
            Api api = ResourceInspector.inspectApi(bean.getClass());
            if (api == null) {
                throw new PlatformRuntimeException("Invalid resource bean defintion.  No @WebApi defined for package: " + bean.getClass().getPackage().getName());
            }
            ApiScopeKey key = new ApiScopeKey(api);
            HashMap apiVersions = (HashMap)apiMap.get(key);
            if (apiVersions == null) {
                apiVersions = new HashMap();
                apiMap.put(key, apiVersions);
            }
            if ((resourcesWithMeta = (ArrayList<ResourceWithMetadata>)apiVersions.get(api.getVersion())) == null) {
                resourcesWithMeta = new ArrayList<ResourceWithMetadata>();
                apiVersions.put(api.getVersion(), resourcesWithMeta);
            }
            for (ResourceMetadata resourceMeta : metaData) {
                resourcesWithMeta.add(new ResourceWithMetadata(bean, resourceMeta));
            }
        }
        return apiMap;
    }

    public static ResourceDictionary build(Collection<Object> entityResources, Collection<Object> relationshipResources) {
        ArrayList<Object> entitiesAndRelations = new ArrayList<Object>();
        entitiesAndRelations.addAll(entityResources);
        entitiesAndRelations.addAll(relationshipResources);
        Map<ApiScopeKey, Map<Integer, List<ResourceWithMetadata>>> apiMap = ResourceDictionaryBuilder.parseResources(entitiesAndRelations);
        ResourceDictionary rd = new ResourceDictionary();
        ResourceDictionaryBuilder.processResources(rd, apiMap, null);
        ResourceDictionaryBuilder.processTopLevelApis(rd);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)rd.prettyPrint());
        }
        return rd;
    }

    private static void processTopLevelApis(ResourceDictionary rd) {
        ArrayList<Api> apis = new ArrayList<Api>(rd.getAllResources().keySet());
        for (Api api : apis) {
            switch (api.getScope()) {
                case PUBLIC: {
                    rd.getPublicApis().add(api);
                }
                case PRIVATE: {
                    rd.getPrivateApis().add(api);
                }
            }
        }
    }

    public static class ApiScopeKey {
        final String name;
        final Api.SCOPE scope;

        public ApiScopeKey(Api api) {
            this.name = api.getName();
            this.scope = api.getScope();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ApiScopeKey other = (ApiScopeKey)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.scope == other.scope;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ApiScopeKey [name=").append(this.name).append(", scope=").append((Object)this.scope).append("]");
            return builder.toString();
        }
    }
}

