/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericBucket;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.RangeResultMapper;
import org.alfresco.service.cmr.search.RangeParameters;
import org.junit.Test;

public class RangeResultMapperTests {
    @Test
    public void testBuildGenericBucketFromRange() throws Exception {
        GenericBucket response = this.queryWithoutInclude("head");
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\">", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithoutInclude("body");
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\">", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithoutInclude("tail");
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("head", null);
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\">", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("head", "outer");
        TestCase.assertEquals((String)"test:<\"0\" TO \"10\">", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("head", "lower");
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\">", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("head", "upper", "lower");
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("head", "edge", "upper");
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("head", "upper");
        TestCase.assertEquals((String)"test:<\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("body", "lower");
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\">", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("body", "upper");
        TestCase.assertEquals((String)"test:<\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("tail", "lower");
        TestCase.assertEquals((String)"test:[\"0\" TO \"10\">", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("tail", "edge");
        TestCase.assertEquals((String)"test:<\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("tail", "upper");
        TestCase.assertEquals((String)"test:<\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithInclude("head", "before");
        TestCase.assertEquals((String)"test:<\"0\" TO \"10\">", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithIncludeAndOther("head", "outer", "before");
        TestCase.assertEquals((String)"test:<\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
        response = this.queryWithIncludeAndOther("head", "outer", "after");
        TestCase.assertEquals((String)"test:<\"0\" TO \"10\"]", (String)response.getFilterQuery());
        TestCase.assertEquals((String)"false", (String)((String)response.getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)response.getBucketInfo().get("endInclusive")));
    }

    private GenericBucket queryWithInclude(String bucketPosition, String ... includeParam) {
        ArrayList<RangeParameters> ranges = new ArrayList<RangeParameters>();
        if (includeParam != null && includeParam.length >= 1) {
            ArrayList<String> include = new ArrayList<String>();
            for (int i = 0; i < includeParam.length; ++i) {
                include.add(includeParam[i]);
            }
            ranges.add(new RangeParameters("test", "0", "10", "1", true, null, include, null, null));
        }
        HashMap<String, String> facet = new HashMap<String, String>();
        facet.put("bucketPosition", bucketPosition);
        facet.put("label", "test");
        facet.put("count", "11");
        facet.put("start", "0");
        facet.put("end", "10");
        return RangeResultMapper.buildGenericBucketFromRange((String)"test", facet, ranges);
    }

    private Map<String, String> buildFaet(String bucketPosition) {
        HashMap<String, String> facet = new HashMap<String, String>();
        facet.put("bucketPosition", bucketPosition);
        facet.put("label", "test");
        facet.put("count", "11");
        facet.put("start", "0");
        facet.put("end", "10");
        return facet;
    }

    private GenericBucket queryWithIncludeAndOther(String bucketPosition, String includeParam, String otherParam) {
        ArrayList<RangeParameters> ranges = new ArrayList<RangeParameters>();
        ArrayList<String> include = new ArrayList<String>();
        include.add(includeParam);
        ArrayList<String> other = new ArrayList<String>();
        other.add(otherParam);
        ranges.add(new RangeParameters("test", "0", "10", "1", true, other, include, null, null));
        return RangeResultMapper.buildGenericBucketFromRange((String)"test", this.buildFaet(bucketPosition), ranges);
    }

    private GenericBucket queryWithoutInclude(String bucketPosition) {
        ArrayList<RangeParameters> ranges = new ArrayList<RangeParameters>();
        ranges.add(new RangeParameters("test", "0", "10", "1", true, null, null, null, null));
        return RangeResultMapper.buildGenericBucketFromRange((String)"test", this.buildFaet(bucketPosition), ranges);
    }
}

