/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import jakarta.servlet.http.HttpServletRequest;
import java.io.OutputStream;
import org.alfresco.repo.web.scripts.transfer.CommandProcessor;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class PostSnapshotCommandProcessor
implements CommandProcessor {
    private TransferReceiver receiver;
    private static Log logger = LogFactory.getLog(PostSnapshotCommandProcessor.class);
    private static final String MSG_CAUGHT_UNEXPECTED_EXCEPTION = "transfer_service.receiver.caught_unexpected_exception";

    @Override
    public int process(WebScriptRequest req, WebScriptResponse resp) {
        int result = 200;
        WebScriptServletRequest webScriptServletRequest = null;
        Object current = req;
        do {
            if (current instanceof WebScriptServletRequest) {
                webScriptServletRequest = (WebScriptServletRequest)current;
                current = null;
                continue;
            }
            current = current instanceof WrappingWebScriptRequest ? ((WrappingWebScriptRequest)req).getNext() : null;
        } while (current != null);
        if (webScriptServletRequest == null) {
            logger.debug((Object)"bad request, not assignable from");
            resp.setStatus(400);
            return 400;
        }
        HttpServletRequest servletRequest = webScriptServletRequest.getHttpServletRequest();
        String transferId = servletRequest.getParameter("transferId");
        if (transferId == null || !JakartaServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest)) {
            logger.debug((Object)"bad request, not multipart");
            resp.setStatus(400);
            return 400;
        }
        try {
            logger.debug((Object)"about to upload manifest file");
            JakartaServletFileUpload upload = new JakartaServletFileUpload();
            FileItemInputIterator iter = upload.getItemIterator(servletRequest);
            while (iter.hasNext()) {
                FileItemInput item = iter.next();
                if (item.isFormField() || !"manifest".equals(item.getFieldName())) continue;
                logger.debug((Object)"got manifest file");
                this.receiver.saveSnapshot(transferId, item.getInputStream());
            }
            logger.debug((Object)"success");
            resp.setStatus(200);
            try (OutputStream out = resp.getOutputStream();){
                resp.setContentType("text/xml");
                resp.setContentEncoding("utf-8");
                this.receiver.generateRequsite(transferId, out);
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"exception caught", (Throwable)ex);
            if (transferId != null) {
                logger.debug((Object)"ending transfer", (Throwable)ex);
                this.receiver.end(transferId);
            }
            if (ex instanceof TransferException) {
                throw (TransferException)((Object)ex);
            }
            throw new TransferException(MSG_CAUGHT_UNEXPECTED_EXCEPTION, (Throwable)ex);
        }
        return result;
    }

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }
}

