/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class WorkflowModelBuilder {
    public static final String PERSON_LAST_NAME = "lastName";
    public static final String PERSON_FIRST_NAME = "firstName";
    public static final String PERSON_USER_NAME = "userName";
    public static final String PERSON_AVATAR = "avatarUrl";
    public static final String TASK_PROPERTIES = "properties";
    public static final String TASK_PROPERTIY_LABELS = "propertyLabels";
    public static final String TASK_OWNER = "owner";
    public static final String TASK_CREATOR = "creator";
    public static final String TASK_STATE = "state";
    public static final String TASK_DESCRIPTION = "description";
    public static final String TASK_TITLE = "title";
    public static final String TASK_NAME = "name";
    public static final String TASK_URL = "url";
    public static final String TASK_IS_POOLED = "isPooled";
    public static final String TASK_IS_EDITABLE = "isEditable";
    public static final String TASK_IS_REASSIGNABLE = "isReassignable";
    public static final String TASK_IS_CLAIMABLE = "isClaimable";
    public static final String TASK_IS_RELEASABLE = "isReleasable";
    public static final String TASK_ID = "id";
    public static final String TASK_PATH = "path";
    public static final String TASK_DEFINITION = "definition";
    public static final String TASK_OUTCOME = "outcome";
    public static final String TASK_DEFINITION_ID = "id";
    public static final String TASK_DEFINITION_URL = "url";
    public static final String TASK_DEFINITION_TYPE = "type";
    public static final String TASK_DEFINITION_NODE = "node";
    public static final String TASK_WORKFLOW_INSTANCE = "workflowInstance";
    public static final String TASK_WORKFLOW_INSTANCE_ID = "id";
    public static final String TASK_WORKFLOW_INSTANCE_URL = "url";
    public static final String TASK_WORKFLOW_INSTANCE_NAME = "name";
    public static final String TASK_WORKFLOW_INSTANCE_TITLE = "title";
    public static final String TASK_WORKFLOW_INSTANCE_DESCRIPTION = "description";
    public static final String TASK_WORKFLOW_INSTANCE_MESSAGE = "message";
    public static final String TASK_WORKFLOW_INSTANCE_IS_ACTIVE = "isActive";
    public static final String TASK_WORKFLOW_INSTANCE_START_DATE = "startDate";
    public static final String TASK_WORKFLOW_INSTANCE_DUE_DATE = "dueDate";
    public static final String TASK_WORKFLOW_INSTANCE_END_DATE = "endDate";
    public static final String TASK_WORKFLOW_INSTANCE_PRIORITY = "priority";
    public static final String TASK_WORKFLOW_INSTANCE_INITIATOR = "initiator";
    public static final String TASK_WORKFLOW_INSTANCE_CONTEXT = "context";
    public static final String TASK_WORKFLOW_INSTANCE_PACKAGE = "package";
    public static final String TASK_WORKFLOW_INSTANCE_START_TASK_INSTANCE_ID = "startTaskInstanceId";
    public static final String TASK_WORKFLOW_INSTANCE_DEFINITION = "definition";
    public static final String TASK_WORKFLOW_INSTANCE_TASKS = "tasks";
    public static final String TASK_WORKFLOW_INSTANCE_DEFINITION_URL = "definitionUrl";
    public static final String TASK_WORKFLOW_INSTANCE_DIAGRAM_URL = "diagramUrl";
    public static final String TASK_WORKFLOW_INSTANCE_INITIATOR_USERNAME = "userName";
    public static final String TASK_WORKFLOW_INSTANCE_INITIATOR_FIRSTNAME = "firstName";
    public static final String TASK_WORKFLOW_INSTANCE_INITIATOR_LASTNAME = "lastName";
    public static final String TYPE_DEFINITION_NAME = "name";
    public static final String TYPE_DEFINITION_TITLE = "title";
    public static final String TYPE_DEFINITION_DESCRIPTION = "description";
    public static final String TYPE_DEFINITION_URL = "url";
    public static final String WORKFLOW_NODE_NAME = "name";
    public static final String WORKFLOW_NODE_TITLE = "title";
    public static final String WORKFLOW_NODE_DESCRIPTION = "description";
    public static final String WORKFLOW_NODE_IS_TASK_NODE = "isTaskNode";
    public static final String WORKFLOW_NODE_TRANSITIONS = "transitions";
    public static final String WORKFLOW_NODE_TRANSITION_ID = "id";
    public static final String WORKFLOW_NODE_TRANSITION_TITLE = "title";
    public static final String WORKFLOW_NODE_TRANSITION_DESCRIPTION = "description";
    public static final String WORKFLOW_NODE_TRANSITION_IS_DEFAULT = "isDefault";
    public static final String WORKFLOW_NODE_TRANSITION_IS_HIDDEN = "isHidden";
    public static final String WORKFLOW_DEFINITION_ID = "id";
    public static final String WORKFLOW_DEFINITION_URL = "url";
    public static final String WORKFLOW_DEFINITION_NAME = "name";
    public static final String WORKFLOW_DEFINITION_TITLE = "title";
    public static final String WORKFLOW_DEFINITION_DESCRIPTION = "description";
    public static final String WORKFLOW_DEFINITION_VERSION = "version";
    public static final String WORKFLOW_DEFINITION_START_TASK_DEFINITION_URL = "startTaskDefinitionUrl";
    public static final String WORKFLOW_DEFINITION_START_TASK_DEFINITION_TYPE = "startTaskDefinitionType";
    public static final String WORKFLOW_DEFINITION_TASK_DEFINITIONS = "taskDefinitions";
    public static final String TASK_OUTCOME_MESSAGE_PREFIX = "workflowtask.outcome.";
    private final NodeService nodeService;
    private final PersonService personService;
    private final WorkflowService workflowService;
    private final DictionaryService dictionaryService;
    private final AuthenticationService authenticationService;
    private final WorkflowQNameConverter qNameConverter;

    public WorkflowModelBuilder(NamespaceService namespaceService, NodeService nodeService, AuthenticationService authenticationService, PersonService personService, WorkflowService workflowService, DictionaryService dictionaryService) {
        this.nodeService = nodeService;
        this.personService = personService;
        this.workflowService = workflowService;
        this.authenticationService = authenticationService;
        this.qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)namespaceService);
        this.dictionaryService = dictionaryService;
    }

    public Map<String, Object> buildSimple(WorkflowTask task, Collection<String> propertyFilters) {
        String currentUser = this.authenticationService.getCurrentUserName();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", task.getId());
        model.put("url", this.getUrl(task));
        model.put("name", task.getName());
        model.put("title", task.getTitle());
        model.put("description", task.getDescription());
        model.put(TASK_STATE, task.getState().name());
        model.put(TASK_PATH, this.getUrl(task.getPath()));
        model.put(TASK_OUTCOME, this.getOutcome(task));
        model.put(TASK_IS_POOLED, this.isPooled(task.getProperties()));
        model.put(TASK_IS_EDITABLE, this.workflowService.isTaskEditable(task, currentUser, false));
        model.put(TASK_IS_REASSIGNABLE, this.workflowService.isTaskReassignable(task, currentUser, false));
        model.put(TASK_IS_CLAIMABLE, this.workflowService.isTaskClaimable(task, currentUser, false));
        model.put(TASK_IS_RELEASABLE, this.workflowService.isTaskReleasable(task, currentUser, false));
        Serializable owner = (Serializable)task.getProperties().get(ContentModel.PROP_OWNER);
        model.put(TASK_OWNER, this.getPersonModel(owner));
        Serializable creator = (Serializable)task.getProperties().get(ContentModel.PROP_CREATOR);
        model.put(TASK_CREATOR, this.getPersonModel(creator));
        Map<String, Object> propertyModel = this.buildProperties(task, propertyFilters);
        model.put(TASK_PROPERTIES, propertyModel);
        model.put(TASK_PROPERTIY_LABELS, this.buildPropertyLabels(task, propertyModel));
        model.put(TASK_WORKFLOW_INSTANCE, this.buildSimple(task.getPath().getInstance()));
        return model;
    }

    public Map<String, Object> buildDetailed(WorkflowTask workflowTask) {
        Map<String, Object> model = this.buildSimple(workflowTask, null);
        model.put("definition", this.buildTaskDefinition(workflowTask.getDefinition(), workflowTask));
        return model;
    }

    public Map<String, Object> buildSimple(WorkflowInstance workflowInstance) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", workflowInstance.getId());
        model.put("url", this.getUrl(workflowInstance));
        model.put("name", workflowInstance.getDefinition().getName());
        model.put("title", workflowInstance.getDefinition().getTitle());
        model.put("description", workflowInstance.getDefinition().getDescription());
        model.put(TASK_WORKFLOW_INSTANCE_MESSAGE, workflowInstance.getDescription());
        model.put(TASK_WORKFLOW_INSTANCE_IS_ACTIVE, workflowInstance.isActive());
        model.put(TASK_WORKFLOW_INSTANCE_PRIORITY, workflowInstance.getPriority());
        model.put(TASK_WORKFLOW_INSTANCE_DEFINITION_URL, this.getUrl(workflowInstance.getDefinition()));
        if (workflowInstance.getWorkflowPackage() != null) {
            model.put(TASK_WORKFLOW_INSTANCE_PACKAGE, workflowInstance.getWorkflowPackage().toString());
        }
        if (workflowInstance.getContext() != null) {
            model.put(TASK_WORKFLOW_INSTANCE_CONTEXT, workflowInstance.getContext().toString());
        }
        if (workflowInstance.getStartDate() == null) {
            model.put(TASK_WORKFLOW_INSTANCE_START_DATE, workflowInstance.getStartDate());
        } else {
            model.put(TASK_WORKFLOW_INSTANCE_START_DATE, ISO8601DateFormat.format((Date)workflowInstance.getStartDate()));
        }
        if (workflowInstance.getDueDate() == null) {
            model.put(TASK_WORKFLOW_INSTANCE_DUE_DATE, workflowInstance.getDueDate());
        } else {
            model.put(TASK_WORKFLOW_INSTANCE_DUE_DATE, ISO8601DateFormat.format((Date)workflowInstance.getDueDate()));
        }
        if (workflowInstance.getEndDate() == null) {
            model.put(TASK_WORKFLOW_INSTANCE_END_DATE, workflowInstance.getEndDate());
        } else {
            model.put(TASK_WORKFLOW_INSTANCE_END_DATE, ISO8601DateFormat.format((Date)workflowInstance.getEndDate()));
        }
        if (workflowInstance.getInitiator() == null || !this.nodeService.exists(workflowInstance.getInitiator())) {
            model.put(TASK_WORKFLOW_INSTANCE_INITIATOR, null);
        } else {
            model.put(TASK_WORKFLOW_INSTANCE_INITIATOR, this.getPersonModel(this.nodeService.getProperty(workflowInstance.getInitiator(), ContentModel.PROP_USERNAME)));
        }
        return model;
    }

    public Map<String, Object> buildDetailed(WorkflowInstance workflowInstance, boolean includeTasks) {
        Map<String, Object> model = this.buildSimple(workflowInstance);
        String startTaskId = null;
        WorkflowTask startTask = this.workflowService.getStartTask(workflowInstance.getId());
        if (startTask != null) {
            startTaskId = startTask.getId();
        }
        if (this.workflowService.hasWorkflowImage(workflowInstance.getId())) {
            model.put(TASK_WORKFLOW_INSTANCE_DIAGRAM_URL, this.getDiagramUrl(workflowInstance));
        }
        model.put(TASK_WORKFLOW_INSTANCE_START_TASK_INSTANCE_ID, startTaskId);
        model.put("definition", this.buildDetailed(workflowInstance.getDefinition()));
        if (includeTasks) {
            WorkflowTaskQuery tasksQuery = new WorkflowTaskQuery();
            tasksQuery.setTaskState(null);
            tasksQuery.setActive(null);
            tasksQuery.setProcessId(workflowInstance.getId());
            List tasks = this.workflowService.queryTasks(tasksQuery);
            ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(tasks.size());
            for (WorkflowTask task : tasks) {
                results.add(this.buildSimple(task, null));
            }
            model.put(TASK_WORKFLOW_INSTANCE_TASKS, results);
        }
        return model;
    }

    public Map<String, Object> buildSimple(WorkflowDefinition workflowDefinition) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", workflowDefinition.getId());
        model.put("url", this.getUrl(workflowDefinition));
        model.put("name", workflowDefinition.getName());
        model.put("title", workflowDefinition.getTitle());
        model.put("description", workflowDefinition.getDescription());
        model.put(WORKFLOW_DEFINITION_VERSION, workflowDefinition.getVersion());
        return model;
    }

    public Map<String, Object> buildDetailed(WorkflowDefinition workflowDefinition) {
        Map<String, Object> model = this.buildSimple(workflowDefinition);
        model.put(WORKFLOW_DEFINITION_START_TASK_DEFINITION_URL, this.getUrl(workflowDefinition.getStartTaskDefinition().getMetadata()));
        model.put(WORKFLOW_DEFINITION_START_TASK_DEFINITION_TYPE, workflowDefinition.getStartTaskDefinition().getMetadata().getName());
        ArrayList results = new ArrayList();
        for (WorkflowTaskDefinition taskDefinition : this.workflowService.getTaskDefinitions(workflowDefinition.getId())) {
            if (taskDefinition.getId().equals(workflowDefinition.getStartTaskDefinition().getId())) continue;
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("url", this.getUrl(taskDefinition.getMetadata()));
            result.put(TASK_DEFINITION_TYPE, (String)taskDefinition.getMetadata().getName());
            results.add(result);
        }
        model.put(WORKFLOW_DEFINITION_TASK_DEFINITIONS, results);
        return model;
    }

    private Object isPooled(Map<QName, Serializable> properties) {
        Collection actors = (Collection)((Object)properties.get(WorkflowModel.ASSOC_POOLED_ACTORS));
        return actors != null && !actors.isEmpty();
    }

    private Map<String, Object> buildProperties(WorkflowTask task, Collection<String> propertyFilters) {
        List<?> hiddenTransitions;
        Collection<QName> keys;
        Map properties = task.getProperties();
        if (propertyFilters == null || propertyFilters.size() == 0) {
            TypeDefinition taskType = task.getDefinition().getMetadata();
            Map propDefs = taskType.getProperties();
            Map assocDefs = taskType.getAssociations();
            Set propKeys = properties.keySet();
            keys = new HashSet<QName>(propDefs.size() + assocDefs.size() + propKeys.size());
            keys.addAll(propDefs.keySet());
            keys.addAll(assocDefs.keySet());
            keys.addAll(propKeys);
            keys.add(WorkflowModel.PROP_HIDDEN_TRANSITIONS);
        } else {
            keys = this.buildQNameKeys(propertyFilters);
        }
        Map<String, Object> result = this.buildQNameProperties(properties, keys, task);
        if (keys.contains(WorkflowModel.PROP_HIDDEN_TRANSITIONS) && (hiddenTransitions = this.getHiddenTransitions(properties)) != null) {
            result.put(this.qNameConverter.mapQNameToName(WorkflowModel.PROP_HIDDEN_TRANSITIONS), hiddenTransitions);
        }
        return result;
    }

    private Map<String, String> buildPropertyLabels(WorkflowTask task, Map<String, Object> properties) {
        TypeDefinition taskType = task.getDefinition().getMetadata();
        final Map propDefs = taskType.getProperties();
        return CollectionUtils.transform(properties, (Function)new Function<Map.Entry<String, Object>, Pair<String, String>>(){

            public Pair<String, String> apply(Map.Entry<String, Object> entry) {
                String propName = entry.getKey();
                PropertyDefinition propDef = (PropertyDefinition)propDefs.get(WorkflowModelBuilder.this.qNameConverter.mapNameToQName(propName));
                if (propDef != null) {
                    List constraints = propDef.getConstraints();
                    for (ConstraintDefinition constraintDef : constraints) {
                        Constraint constraint = constraintDef.getConstraint();
                        if (!(constraint instanceof ListOfValuesConstraint)) continue;
                        ListOfValuesConstraint listConstraint = (ListOfValuesConstraint)constraint;
                        String label = listConstraint.getDisplayLabel(String.valueOf(entry.getValue()), (MessageLookup)WorkflowModelBuilder.this.dictionaryService);
                        return new Pair((Object)propName, (Object)label);
                    }
                }
                return null;
            }
        });
    }

    private Map<String, Object> buildQNameProperties(Map<QName, Serializable> properties, Collection<QName> keys, WorkflowTask task) {
        Map propDefs = task.getDefinition().getMetadata().getProperties();
        HashMap<String, Object> model = new HashMap<String, Object>();
        for (QName key : keys) {
            Object value = this.convertValue(properties.get(key));
            String strKey = this.qNameConverter.mapQNameToName(key);
            PropertyDefinition propDef = (PropertyDefinition)propDefs.get(key);
            if (value == null && propDef != null) {
                value = propDef.getDefaultValue();
            }
            model.put(strKey, value);
        }
        return model;
    }

    private Object convertValue(Object value) {
        if (value == null || value instanceof Boolean || value instanceof Number || value instanceof String) {
            return value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList<Object> results = new ArrayList<Object>(collection.size());
            for (Object obj : collection) {
                results.add(this.convertValue(obj));
            }
            return results;
        }
        return DefaultTypeConverter.INSTANCE.convert(String.class, value);
    }

    private Collection<QName> buildQNameKeys(Collection<String> keys) {
        return CollectionUtils.transform(keys, (Function)new Function<String, QName>(){

            public QName apply(String name) {
                return WorkflowModelBuilder.this.qNameConverter.mapNameToQName(name);
            }
        });
    }

    private Map<String, Object> getPersonModel(Serializable nameSer) {
        if (!(nameSer instanceof String)) {
            return null;
        }
        String name = (String)((Object)nameSer);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("userName", name);
        if (this.personService.personExists(name)) {
            NodeRef person = this.personService.getPerson(name);
            Map properties = this.nodeService.getProperties(person);
            model.put("firstName", properties.get(ContentModel.PROP_FIRSTNAME));
            model.put("lastName", properties.get(ContentModel.PROP_LASTNAME));
            List avatar = this.nodeService.getTargetAssocs(person, (QNamePattern)ContentModel.ASSOC_AVATAR);
            if (avatar != null && !avatar.isEmpty()) {
                model.put(PERSON_AVATAR, this.getAvatarUrl(((AssociationRef)avatar.get(0)).getTargetRef()));
            }
        }
        return model;
    }

    private Map<String, Object> buildTaskDefinition(WorkflowTaskDefinition workflowTaskDefinition, WorkflowTask workflowTask) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", workflowTaskDefinition.getId());
        model.put("url", this.getUrl(workflowTaskDefinition));
        model.put(TASK_DEFINITION_TYPE, this.buildTypeDefinition(workflowTaskDefinition.getMetadata()));
        model.put(TASK_DEFINITION_NODE, this.buildWorkflowNode(workflowTaskDefinition.getNode(), workflowTask));
        return model;
    }

    private Map<String, Object> buildTypeDefinition(TypeDefinition typeDefinition) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("name", typeDefinition.getName());
        model.put("title", typeDefinition.getTitle((MessageLookup)this.dictionaryService));
        model.put("description", typeDefinition.getDescription((MessageLookup)this.dictionaryService));
        model.put("url", this.getUrl(typeDefinition));
        return model;
    }

    private Map<String, Object> buildWorkflowNode(WorkflowNode workflowNode, WorkflowTask workflowTask) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("name", workflowNode.getName());
        model.put("title", workflowNode.getTitle());
        model.put("description", workflowNode.getDescription());
        model.put(WORKFLOW_NODE_IS_TASK_NODE, workflowNode.isTaskNode());
        ArrayList<Map<String, Object>> transitions = new ArrayList<Map<String, Object>>();
        List<?> hiddenTransitions = this.getHiddenTransitions(workflowTask.getProperties());
        for (WorkflowTransition workflowTransition : workflowNode.getTransitions()) {
            Map<String, Object> transitionModel = this.buildTransition(workflowTransition, hiddenTransitions);
            transitions.add(transitionModel);
        }
        model.put(WORKFLOW_NODE_TRANSITIONS, transitions);
        return model;
    }

    private Map<String, Object> buildTransition(WorkflowTransition workflowTransition, List<?> hiddenTransitions) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String id = workflowTransition.getId();
        model.put("id", id == null ? "" : id);
        model.put("title", workflowTransition.getTitle());
        model.put("description", workflowTransition.getDescription());
        model.put(WORKFLOW_NODE_TRANSITION_IS_DEFAULT, workflowTransition.isDefault());
        model.put(WORKFLOW_NODE_TRANSITION_IS_HIDDEN, this.isHiddenTransition(id, hiddenTransitions));
        return model;
    }

    private List<?> getHiddenTransitions(Map<QName, Serializable> properties) {
        Serializable hiddenSer = properties.get(WorkflowModel.PROP_HIDDEN_TRANSITIONS);
        if (hiddenSer instanceof List) {
            return (List)((Object)hiddenSer);
        }
        if (hiddenSer instanceof String) {
            if (((String)((Object)hiddenSer)).isEmpty()) {
                return Collections.emptyList();
            }
            String hiddenStr = (String)((Object)hiddenSer);
            return Arrays.asList(hiddenStr.split(","));
        }
        if (hiddenSer == null) {
            return Collections.emptyList();
        }
        return null;
    }

    private boolean isHiddenTransition(String transitionId, List<?> hiddenTransitions) {
        if (hiddenTransitions == null) {
            return false;
        }
        return hiddenTransitions.contains(transitionId);
    }

    private String getOutcome(WorkflowTask task) {
        String outcomeId;
        String outcomeLabel = null;
        if (task.getState().equals((Object)WorkflowTaskState.COMPLETED) && (outcomeId = (String)task.getProperties().get(WorkflowModel.PROP_OUTCOME)) != null) {
            WorkflowTransition[] transitions;
            for (WorkflowTransition transition : transitions = task.getDefinition().getNode().getTransitions()) {
                if (transition.getId() == null || !transition.getId().equals(outcomeId)) continue;
                outcomeLabel = transition.getTitle();
                break;
            }
            if (outcomeLabel == null) {
                String translatedOutcome = I18NUtil.getMessage((String)(TASK_OUTCOME_MESSAGE_PREFIX + outcomeId));
                outcomeLabel = translatedOutcome != null ? translatedOutcome : outcomeId;
            }
        }
        return outcomeLabel;
    }

    private String getUrl(WorkflowTask task) {
        return "api/task-instances/" + task.getId();
    }

    private String getUrl(WorkflowDefinition workflowDefinition) {
        return "api/workflow-definitions/" + workflowDefinition.getId();
    }

    private String getUrl(WorkflowTaskDefinition workflowTaskDefinition) {
        return "api/task-definitions/" + workflowTaskDefinition.getId();
    }

    private String getUrl(TypeDefinition typeDefinition) {
        return "api/classes/" + this.qNameConverter.mapQNameToName(typeDefinition.getName());
    }

    private String getUrl(WorkflowPath path) {
        return "api/workflow-paths/" + path.getId();
    }

    private String getUrl(WorkflowInstance workflowInstance) {
        return "api/workflow-instances/" + workflowInstance.getId();
    }

    private String getDiagramUrl(WorkflowInstance workflowInstance) {
        return "api/workflow-instances/" + workflowInstance.getId() + "/diagram";
    }

    private String getAvatarUrl(NodeRef avatarRef) {
        return "api/node/" + avatarRef.toString().replace("://", "/") + "/content/thumbnails/avatar";
    }
}

