/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.mapper.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.CompositeCondition;
import org.alfresco.rest.api.model.rules.ConditionOperator;
import org.alfresco.rest.api.model.rules.SimpleCondition;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionCondition;
import org.apache.commons.collections.CollectionUtils;

@Experimental
public class RestRuleCompositeConditionModelMapper
implements RestModelMapper<CompositeCondition, ActionCondition> {
    private final RestModelMapper<SimpleCondition, ActionCondition> simpleConditionMapper;

    public RestRuleCompositeConditionModelMapper(RestModelMapper<SimpleCondition, ActionCondition> simpleConditionMapper) {
        this.simpleConditionMapper = simpleConditionMapper;
    }

    @Override
    public CompositeCondition toRestModel(Collection<ActionCondition> actionConditions) {
        if (CollectionUtils.isEmpty(actionConditions)) {
            return null;
        }
        List filteredActions = actionConditions.stream().filter(Objects::nonNull).filter(c -> !"no-condition".equals(c.getActionConditionDefinitionName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredActions)) {
            return null;
        }
        CompositeCondition conditions = new CompositeCondition();
        conditions.setCompositeConditions(new ArrayList<CompositeCondition>());
        filteredActions.stream().collect(Collectors.groupingBy(ActionCondition::getInvertCondition)).forEach((inverted, actionConditionsPart) -> Optional.ofNullable(this.ofActionConditions((List<ActionCondition>)actionConditionsPart, (boolean)inverted, ConditionOperator.AND)).ifPresent(compositeCondition -> conditions.getCompositeConditions().add((CompositeCondition)compositeCondition)));
        if (CollectionUtils.isEmpty(conditions.getCompositeConditions())) {
            conditions.setCompositeConditions(null);
        }
        return conditions;
    }

    @Override
    public List<ActionCondition> toServiceModels(CompositeCondition compositeCondition) {
        ArrayList<ActionCondition> actionConditions = new ArrayList<ActionCondition>();
        if (compositeCondition == null) {
            return actionConditions;
        }
        if (CollectionUtils.isNotEmpty(compositeCondition.getSimpleConditions())) {
            compositeCondition.getSimpleConditions().forEach(simpleCondition -> actionConditions.add(this.mapSimpleCondition((SimpleCondition)simpleCondition, compositeCondition.isInverted())));
        }
        if (CollectionUtils.isNotEmpty(compositeCondition.getCompositeConditions())) {
            compositeCondition.getCompositeConditions().forEach(condition -> actionConditions.addAll(this.toServiceModels((CompositeCondition)condition)));
        }
        return actionConditions;
    }

    private ActionCondition mapSimpleCondition(SimpleCondition simpleCondition, boolean inverted) {
        ActionCondition actionCondition = this.simpleConditionMapper.toServiceModel(simpleCondition);
        actionCondition.setInvertCondition(inverted);
        return actionCondition;
    }

    private CompositeCondition ofActionConditions(List<ActionCondition> actionConditions, boolean inverted, ConditionOperator conditionOperator) {
        if (CollectionUtils.isEmpty(actionConditions)) {
            return null;
        }
        return this.ofSimpleConditions(this.simpleConditionMapper.toRestModels((ActionCondition)actionConditions), inverted, conditionOperator);
    }

    private CompositeCondition ofSimpleConditions(List<SimpleCondition> simpleConditions, boolean inverted, ConditionOperator conditionOperator) {
        return this.of(simpleConditions, null, inverted, conditionOperator);
    }

    private CompositeCondition of(List<SimpleCondition> simpleConditions, List<CompositeCondition> compositeConditions, boolean inverted, ConditionOperator conditionOperator) {
        if (CollectionUtils.isEmpty(simpleConditions) && CollectionUtils.isEmpty(compositeConditions)) {
            return null;
        }
        return CompositeCondition.builder().inverted(inverted).booleanMode(conditionOperator).simpleConditions(simpleConditions).compositeConditions(compositeConditions).create();
    }
}

