/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.rules.ActionParameterConverter;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class ActionParameterConverterTest {
    private static final String VERSIONABLE = "versionable";
    private static final String VERSIONABLE_ASPECT = "cm:versionable";
    private static final String CHECKOUT = "checkout";
    private static final String CHECKOUT_ASPECT = "cm:checkout";
    private static final String CONTAINS = "contains";
    private static final String CONTAINS_ASPECT = "cm:contains";
    private static final String CLASSIFIABLE = "generalclassifiable";
    private static final String CLASSIFIABLE_ASPECT = "cm:generalclassifiable";
    private static final String IDENTIFIER = "identifier";
    private static final String IDENTIFIER_ASPECT = "cm:identifier";
    private static final String DUMMY_FOLDER_NODE_ID = "dummy://folder/node";
    private static final NodeRef DUMMY_FOLDER_NODE = new NodeRef("dummy://folder/node");
    private static final String DUMMY_SCRIPT_NODE_ID = "dummy://script/ref";
    private static final NodeRef DUMMY_SCRIPT_NODE = new NodeRef("dummy://script/ref");
    @Mock
    private DictionaryService dictionaryService;
    @Mock
    private ActionService actionService;
    @Mock
    private NamespaceService namespaceService;
    @Mock
    private PermissionService permissionService;
    @Mock
    private Nodes nodes;
    @Mock
    private ActionDefinition actionDefinition;
    @Mock
    private ParameterDefinition actionDefinitionParam1;
    @Mock
    private ParameterDefinition actionDefinitionParam2;
    @Mock
    private ParameterDefinition actionDefinitionParam3;
    @Mock
    private DataTypeDefinition dataTypeDefinition1;
    @Mock
    private DataTypeDefinition dataTypeDefinition2;
    @Mock
    private DataTypeDefinition dataTypeDefinition3;
    @InjectMocks
    private ActionParameterConverter objectUnderTest;

    @Before
    public void setUp() {
        BDDMockito.given((Object)this.nodes.validateOrLookupNode(DUMMY_FOLDER_NODE_ID)).willReturn((Object)DUMMY_FOLDER_NODE);
        BDDMockito.given((Object)this.nodes.validateOrLookupNode(DUMMY_SCRIPT_NODE_ID)).willReturn((Object)DUMMY_SCRIPT_NODE);
        BDDMockito.given((Object)this.permissionService.hasReadPermission(DUMMY_FOLDER_NODE)).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.permissionService.hasReadPermission(DUMMY_SCRIPT_NODE)).willReturn((Object)AccessStatus.ALLOWED);
    }

    @Test
    public void testAddAspectConversion() {
        String name = "add-features";
        String aspectNameKey = "aspect-name";
        Map<String, String> params = Map.of("aspect-name", VERSIONABLE_ASPECT);
        BDDMockito.given((Object)this.actionService.getActionDefinition("add-features")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("aspect-name")).willReturn((Object)this.actionDefinitionParam1);
        QName qname = DataTypeDefinition.QNAME;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)qname);
        BDDMockito.given((Object)this.dictionaryService.getDataType(qname)).willReturn((Object)this.dataTypeDefinition1);
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI((String)ArgumentMatchers.any())).willReturn((Object)"http://www.alfresco.org/model/dictionary/1.0");
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "add-features");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("add-features");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("aspect-name");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(qname);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceService).should()).getNamespaceURI((String)ArgumentMatchers.any());
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoMoreInteractions();
        Serializable convertedParam = (Serializable)convertedParams.get("aspect-name");
        Assert.assertTrue((boolean)(convertedParam instanceof QName));
        Assert.assertEquals((Object)VERSIONABLE, (Object)((QName)convertedParam).getLocalName());
        Assert.assertEquals((Object)VERSIONABLE_ASPECT, (Object)((QName)convertedParam).getPrefixString());
        Assert.assertEquals((Object)"http://www.alfresco.org/model/dictionary/1.0", (Object)((QName)convertedParam).getNamespaceURI());
    }

    @Test
    public void testCopyConversion() {
        String name = "copy";
        String destinationFolderKey = "destination-folder";
        String deepCopyKey = "deep-copy";
        Map<String, Boolean> params = Map.of("destination-folder", DUMMY_FOLDER_NODE_ID, "deep-copy", true);
        BDDMockito.given((Object)this.actionService.getActionDefinition("copy")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("destination-folder")).willReturn((Object)this.actionDefinitionParam1);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("deep-copy")).willReturn((Object)this.actionDefinitionParam2);
        QName nodeRef = DataTypeDefinition.NODE_REF;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)nodeRef);
        QName bool = DataTypeDefinition.BOOLEAN;
        BDDMockito.given((Object)this.actionDefinitionParam2.getType()).willReturn((Object)bool);
        BDDMockito.given((Object)this.dictionaryService.getDataType(nodeRef)).willReturn((Object)this.dataTypeDefinition1);
        BDDMockito.given((Object)this.dictionaryService.getDataType(bool)).willReturn((Object)this.dataTypeDefinition2);
        BDDMockito.given((Object)this.dataTypeDefinition2.getJavaClassName()).willReturn((Object)Boolean.class.getName());
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "copy");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("copy");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("destination-folder");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("deep-copy");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should(Mockito.times((int)2))).getDataType(bool);
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(nodeRef);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoInteractions();
        Serializable convertedCopyParam = (Serializable)convertedParams.get("destination-folder");
        Assert.assertTrue((boolean)(convertedCopyParam instanceof NodeRef));
        Assert.assertEquals((Object)DUMMY_FOLDER_NODE, (Object)convertedCopyParam);
        Serializable convertedDeepCopyParam = (Serializable)convertedParams.get("deep-copy");
        Assertions.assertThat((boolean)(convertedDeepCopyParam instanceof Boolean)).isTrue();
        Assert.assertTrue((boolean)((Boolean)convertedDeepCopyParam));
    }

    @Test
    public void testExecuteScriptConversion() {
        String name = "script";
        String executeScriptKey = "script-ref";
        Map<String, String> params = Map.of("script-ref", DUMMY_SCRIPT_NODE_ID);
        BDDMockito.given((Object)this.actionService.getActionDefinition("script")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("script-ref")).willReturn((Object)this.actionDefinitionParam1);
        QName scriptNodeRef = DataTypeDefinition.NODE_REF;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)scriptNodeRef);
        BDDMockito.given((Object)this.dictionaryService.getDataType(scriptNodeRef)).willReturn((Object)this.dataTypeDefinition1);
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "script");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("script");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("script-ref");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(scriptNodeRef);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoInteractions();
        Serializable convertedCopyParam = (Serializable)convertedParams.get("script-ref");
        Assert.assertTrue((boolean)(convertedCopyParam instanceof NodeRef));
        Assert.assertEquals((Object)DUMMY_SCRIPT_NODE, (Object)convertedCopyParam);
    }

    @Test
    public void testMoveConversion() {
        String name = "move";
        String destinationFolderKey = "destination-folder";
        Map<String, String> params = Map.of("destination-folder", DUMMY_FOLDER_NODE_ID);
        BDDMockito.given((Object)this.actionService.getActionDefinition("move")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("destination-folder")).willReturn((Object)this.actionDefinitionParam1);
        QName nodeRef = DataTypeDefinition.NODE_REF;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.dictionaryService.getDataType(nodeRef)).willReturn((Object)this.dataTypeDefinition1);
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "move");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("move");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("destination-folder");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(nodeRef);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoInteractions();
        Serializable convertedCopyParam = (Serializable)convertedParams.get("destination-folder");
        Assert.assertTrue((boolean)(convertedCopyParam instanceof NodeRef));
        Assert.assertEquals((Object)DUMMY_FOLDER_NODE, (Object)convertedCopyParam);
    }

    @Test
    public void testCheckInConversion() {
        String name = "check-in";
        String descriptionKey = "description";
        String minorChangeKey = "minorChange";
        String description = "dummy description";
        Map<String, Boolean> params = Map.of("description", description, "minorChange", true);
        BDDMockito.given((Object)this.actionService.getActionDefinition("check-in")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("description")).willReturn((Object)this.actionDefinitionParam1);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("minorChange")).willReturn((Object)this.actionDefinitionParam2);
        QName text = DataTypeDefinition.TEXT;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)text);
        QName bool = DataTypeDefinition.BOOLEAN;
        BDDMockito.given((Object)this.actionDefinitionParam2.getType()).willReturn((Object)bool);
        BDDMockito.given((Object)this.dictionaryService.getDataType(text)).willReturn((Object)this.dataTypeDefinition1);
        BDDMockito.given((Object)this.dataTypeDefinition1.getJavaClassName()).willReturn((Object)String.class.getName());
        BDDMockito.given((Object)this.dictionaryService.getDataType(bool)).willReturn((Object)this.dataTypeDefinition2);
        BDDMockito.given((Object)this.dataTypeDefinition2.getJavaClassName()).willReturn((Object)Boolean.class.getName());
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "check-in");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("check-in");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("description");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("minorChange");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should(Mockito.times((int)2))).getDataType(bool);
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should(Mockito.times((int)2))).getDataType(text);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoInteractions();
        Serializable convertedDescriptionParam = (Serializable)convertedParams.get("description");
        Assert.assertTrue((boolean)(convertedDescriptionParam instanceof String));
        Assert.assertEquals((Object)description, (Object)convertedDescriptionParam);
        Serializable convertedMinorChangeParam = (Serializable)convertedParams.get("minorChange");
        Assert.assertTrue((boolean)(convertedMinorChangeParam instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)convertedMinorChangeParam));
    }

    @Test
    public void testCheckOutConversion() {
        String name = "check-out";
        String destinationFolderKey = "destination-folder";
        String assocNameKey = "assoc-name";
        String assocTypeKey = "assoc-type";
        Map<String, String> params = Map.of("destination-folder", DUMMY_FOLDER_NODE_ID, "assoc-name", CHECKOUT_ASPECT, "assoc-type", CONTAINS_ASPECT);
        BDDMockito.given((Object)this.actionService.getActionDefinition("check-out")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("destination-folder")).willReturn((Object)this.actionDefinitionParam1);
        QName nodeRef = DataTypeDefinition.NODE_REF;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("assoc-name")).willReturn((Object)this.actionDefinitionParam2);
        QName qname = DataTypeDefinition.QNAME;
        BDDMockito.given((Object)this.actionDefinitionParam2.getType()).willReturn((Object)qname);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("assoc-type")).willReturn((Object)this.actionDefinitionParam3);
        BDDMockito.given((Object)this.actionDefinitionParam3.getType()).willReturn((Object)qname);
        BDDMockito.given((Object)this.dictionaryService.getDataType(nodeRef)).willReturn((Object)this.dataTypeDefinition1);
        BDDMockito.given((Object)this.dictionaryService.getDataType(qname)).willReturn((Object)this.dataTypeDefinition2);
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI((String)ArgumentMatchers.any())).willReturn((Object)"http://www.alfresco.org/model/dictionary/1.0");
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "check-out");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("check-out");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("destination-folder");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("assoc-name");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("assoc-type");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should(Mockito.times((int)2))).getDataType(qname);
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(nodeRef);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceService).should(Mockito.times((int)2))).getNamespaceURI((String)ArgumentMatchers.any());
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoMoreInteractions();
        Serializable convertedDestinationParam = (Serializable)convertedParams.get("destination-folder");
        Assert.assertTrue((boolean)(convertedDestinationParam instanceof NodeRef));
        Assert.assertEquals((Object)DUMMY_FOLDER_NODE, (Object)convertedDestinationParam);
        Serializable convertedAssocNameParam = (Serializable)convertedParams.get("assoc-name");
        Assert.assertTrue((boolean)(convertedAssocNameParam instanceof QName));
        Assert.assertEquals((Object)CHECKOUT, (Object)((QName)convertedAssocNameParam).getLocalName());
        Assert.assertEquals((Object)CHECKOUT_ASPECT, (Object)((QName)convertedAssocNameParam).getPrefixString());
        Assert.assertEquals((Object)"http://www.alfresco.org/model/dictionary/1.0", (Object)((QName)convertedAssocNameParam).getNamespaceURI());
        Serializable convertedAssocTypeParam = (Serializable)convertedParams.get("assoc-type");
        Assert.assertTrue((boolean)(convertedAssocTypeParam instanceof QName));
        Assert.assertEquals((Object)CONTAINS, (Object)((QName)convertedAssocTypeParam).getLocalName());
        Assert.assertEquals((Object)CONTAINS_ASPECT, (Object)((QName)convertedAssocTypeParam).getPrefixString());
        Assert.assertEquals((Object)"http://www.alfresco.org/model/dictionary/1.0", (Object)((QName)convertedAssocTypeParam).getNamespaceURI());
    }

    @Test
    public void testCategoryLinkConversion() {
        String name = "link-category";
        String categoryAspectKey = "category-aspect";
        String categoryValueKey = "category-value";
        Map<String, String> params = Map.of("category-aspect", CLASSIFIABLE_ASPECT, "category-value", DUMMY_FOLDER_NODE_ID);
        BDDMockito.given((Object)this.actionService.getActionDefinition("link-category")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("category-aspect")).willReturn((Object)this.actionDefinitionParam1);
        QName qname = DataTypeDefinition.QNAME;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)qname);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("category-value")).willReturn((Object)this.actionDefinitionParam2);
        QName nodeRef = DataTypeDefinition.NODE_REF;
        BDDMockito.given((Object)this.actionDefinitionParam2.getType()).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.dictionaryService.getDataType(nodeRef)).willReturn((Object)this.dataTypeDefinition1);
        BDDMockito.given((Object)this.dictionaryService.getDataType(qname)).willReturn((Object)this.dataTypeDefinition2);
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI((String)ArgumentMatchers.any())).willReturn((Object)"http://www.alfresco.org/model/dictionary/1.0");
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "link-category");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("link-category");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("category-aspect");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("category-value");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(qname);
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(nodeRef);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceService).should()).getNamespaceURI((String)ArgumentMatchers.any());
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoMoreInteractions();
        Serializable convertedCatValueParam = (Serializable)convertedParams.get("category-aspect");
        Assert.assertTrue((boolean)(convertedCatValueParam instanceof QName));
        Assert.assertEquals((Object)CLASSIFIABLE, (Object)((QName)convertedCatValueParam).getLocalName());
        Assert.assertEquals((Object)CLASSIFIABLE_ASPECT, (Object)((QName)convertedCatValueParam).getPrefixString());
        Assert.assertEquals((Object)"http://www.alfresco.org/model/dictionary/1.0", (Object)((QName)convertedCatValueParam).getNamespaceURI());
        Serializable convertedDestinationParam = (Serializable)convertedParams.get("category-value");
        Assert.assertTrue((boolean)(convertedDestinationParam instanceof NodeRef));
        Assert.assertEquals((Object)DUMMY_FOLDER_NODE, (Object)convertedDestinationParam);
    }

    @Test
    public void testRemoveAspectConversion() {
        String name = "remove-features";
        String aspectNameKey = "aspect-name";
        Map<String, String> params = Map.of("aspect-name", VERSIONABLE_ASPECT);
        BDDMockito.given((Object)this.actionService.getActionDefinition("remove-features")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("aspect-name")).willReturn((Object)this.actionDefinitionParam1);
        QName qname = DataTypeDefinition.QNAME;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)qname);
        BDDMockito.given((Object)this.dictionaryService.getDataType(qname)).willReturn((Object)this.dataTypeDefinition1);
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI((String)ArgumentMatchers.any())).willReturn((Object)"http://www.alfresco.org/model/dictionary/1.0");
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "remove-features");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("remove-features");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("aspect-name");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(qname);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceService).should()).getNamespaceURI((String)ArgumentMatchers.any());
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoMoreInteractions();
        Serializable convertedParam = (Serializable)convertedParams.get("aspect-name");
        Assert.assertTrue((boolean)(convertedParam instanceof QName));
        Assert.assertEquals((Object)VERSIONABLE, (Object)((QName)convertedParam).getLocalName());
        Assert.assertEquals((Object)VERSIONABLE_ASPECT, (Object)((QName)convertedParam).getPrefixString());
        Assert.assertEquals((Object)"http://www.alfresco.org/model/dictionary/1.0", (Object)((QName)convertedParam).getNamespaceURI());
    }

    @Test
    public void testAddWorkflowConversion() {
        String name = "simple-workflow";
        String approveStepKey = "approve-step";
        String approveFolderKey = "approve-folder";
        String approveMoveKey = "approve-move";
        String rejectStepKey = "reject-step";
        String rejectFolderKey = "reject-folder";
        String rejectMoveKey = "reject-move";
        String approve = "Approve";
        String reject = "Reject";
        Map<String, Boolean> params = Map.of("approve-step", "Approve", "approve-folder", DUMMY_FOLDER_NODE_ID, "approve-move", true, "reject-step", "Reject", "reject-folder", DUMMY_FOLDER_NODE_ID, "reject-move", true);
        BDDMockito.given((Object)this.actionService.getActionDefinition("simple-workflow")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("reject-step")).willReturn((Object)this.actionDefinitionParam1);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("approve-step")).willReturn((Object)this.actionDefinitionParam1);
        QName text = DataTypeDefinition.TEXT;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)text, (Object[])new QName[]{text});
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("reject-folder")).willReturn((Object)this.actionDefinitionParam2);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("approve-folder")).willReturn((Object)this.actionDefinitionParam2);
        QName nodeRef = DataTypeDefinition.NODE_REF;
        BDDMockito.given((Object)this.actionDefinitionParam2.getType()).willReturn((Object)nodeRef, (Object[])new QName[]{nodeRef});
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("reject-move")).willReturn((Object)this.actionDefinitionParam3);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("approve-move")).willReturn((Object)this.actionDefinitionParam3);
        QName bool = DataTypeDefinition.BOOLEAN;
        BDDMockito.given((Object)this.actionDefinitionParam3.getType()).willReturn((Object)bool, (Object[])new QName[]{bool});
        BDDMockito.given((Object)this.dictionaryService.getDataType(nodeRef)).willReturn((Object)this.dataTypeDefinition1);
        BDDMockito.given((Object)this.dictionaryService.getDataType(text)).willReturn((Object)this.dataTypeDefinition2);
        BDDMockito.given((Object)this.dataTypeDefinition2.getJavaClassName()).willReturn((Object)String.class.getName());
        BDDMockito.given((Object)this.dictionaryService.getDataType(bool)).willReturn((Object)this.dataTypeDefinition3);
        BDDMockito.given((Object)this.dataTypeDefinition3.getJavaClassName()).willReturn((Object)Boolean.class.getName());
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "simple-workflow");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("simple-workflow");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("approve-step");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("approve-folder");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("approve-move");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("reject-step");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("reject-folder");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("reject-move");
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should(Mockito.times((int)4))).getDataType(text);
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should(Mockito.times((int)2))).getDataType(nodeRef);
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should(Mockito.times((int)4))).getDataType(bool);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoInteractions();
        Serializable convertedApproveStepParam = (Serializable)convertedParams.get("approve-step");
        Assert.assertTrue((boolean)(convertedApproveStepParam instanceof String));
        Assert.assertEquals((Object)"Approve", (Object)convertedApproveStepParam);
        Serializable convertedRejectStepParam = (Serializable)convertedParams.get("reject-step");
        Assert.assertTrue((boolean)(convertedRejectStepParam instanceof String));
        Assert.assertEquals((Object)"Reject", (Object)convertedRejectStepParam);
        Serializable convertedApproveFolderParam = (Serializable)convertedParams.get("approve-folder");
        Assert.assertTrue((boolean)(convertedApproveFolderParam instanceof NodeRef));
        Assert.assertEquals((Object)DUMMY_FOLDER_NODE, (Object)convertedApproveFolderParam);
        Serializable convertedRejectFolderParam = (Serializable)convertedParams.get("reject-folder");
        Assert.assertTrue((boolean)(convertedRejectFolderParam instanceof NodeRef));
        Assert.assertEquals((Object)DUMMY_FOLDER_NODE, (Object)convertedRejectFolderParam);
        Serializable convertedApproveMoveParam = (Serializable)convertedParams.get("approve-move");
        Assert.assertTrue((boolean)(convertedApproveMoveParam instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)convertedApproveMoveParam));
        Serializable convertedRejectMoveParam = (Serializable)convertedParams.get("reject-move");
        Assert.assertTrue((boolean)(convertedRejectMoveParam instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)convertedRejectMoveParam));
    }

    @Test
    public void testSetPropertyConversion() {
        String name = "set-property-value";
        String propertyNameKey = "property";
        String propertyValueKey = "value";
        String propertyTypeKey = "prop_type";
        String dummy_key_value = "dummy_key_value";
        String propType = "d:text";
        Map<String, String> params = Map.of("property", IDENTIFIER_ASPECT, "value", "dummy_key_value", "prop_type", "d:text");
        BDDMockito.given((Object)this.actionService.getActionDefinition("set-property-value")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("property")).willReturn((Object)this.actionDefinitionParam1);
        QName qname = DataTypeDefinition.QNAME;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)qname);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("value")).willReturn((Object)this.actionDefinitionParam2);
        QName any = DataTypeDefinition.ANY;
        BDDMockito.given((Object)this.actionDefinitionParam2.getType()).willReturn((Object)any);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("prop_type")).willReturn(null);
        BDDMockito.given((Object)this.actionDefinition.getAdhocPropertiesAllowed()).willReturn((Object)true);
        BDDMockito.given((Object)this.dictionaryService.getDataType(qname)).willReturn((Object)this.dataTypeDefinition1);
        BDDMockito.given((Object)this.dictionaryService.getDataType(any)).willReturn((Object)this.dataTypeDefinition2);
        BDDMockito.given((Object)this.dataTypeDefinition2.getJavaClassName()).willReturn((Object)Object.class.getName());
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI((String)ArgumentMatchers.any())).willReturn((Object)"http://www.alfresco.org/model/dictionary/1.0");
        Map convertedParams = this.objectUnderTest.getConvertedParams(params, "set-property-value");
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("set-property-value");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("property");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("value");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getParameterDefintion("prop_type");
        ((ActionDefinition)BDDMockito.then((Object)this.actionDefinition).should()).getAdhocPropertiesAllowed();
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should()).getDataType(qname);
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryService).should(Mockito.times((int)2))).getDataType(any);
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceService).should()).getNamespaceURI((String)ArgumentMatchers.any());
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoMoreInteractions();
        Serializable convertedPropNameParam = (Serializable)convertedParams.get("property");
        Assert.assertTrue((boolean)(convertedPropNameParam instanceof QName));
        Assert.assertEquals((Object)IDENTIFIER, (Object)((QName)convertedPropNameParam).getLocalName());
        Assert.assertEquals((Object)IDENTIFIER_ASPECT, (Object)((QName)convertedPropNameParam).getPrefixString());
        Assert.assertEquals((Object)"http://www.alfresco.org/model/dictionary/1.0", (Object)((QName)convertedPropNameParam).getNamespaceURI());
        Serializable convertedPropValParam = (Serializable)convertedParams.get("value");
        Assert.assertTrue((boolean)(convertedPropValParam instanceof String));
        Assert.assertEquals((Object)"dummy_key_value", (Object)convertedPropValParam);
        Serializable convertedPropTypeParam = (Serializable)convertedParams.get("prop_type");
        Assert.assertTrue((boolean)(convertedPropTypeParam instanceof String));
        Assert.assertEquals((Object)"d:text", (Object)convertedPropTypeParam);
    }

    @Test
    public void testNonExistentNodeParam() {
        String name = "copy";
        Map<String, String> params = Map.of("destination-folder", "non://existent/node");
        BDDMockito.given((Object)this.actionService.getActionDefinition("copy")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("destination-folder")).willReturn((Object)this.actionDefinitionParam1);
        QName nodeRef = DataTypeDefinition.NODE_REF;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.dictionaryService.getDataType(nodeRef)).willReturn((Object)this.dataTypeDefinition1);
        Assertions.assertThatExceptionOfType(EntityNotFoundException.class).isThrownBy(() -> this.objectUnderTest.getConvertedParams(params, "copy"));
    }

    @Test
    public void testNoReadPermissionForNodeParam() {
        String name = "copy";
        String permissionDeniedNodeId = "permission://denied/node";
        Map<String, String> params = Map.of("destination-folder", permissionDeniedNodeId);
        NodeRef permissionDeniedNode = new NodeRef(permissionDeniedNodeId);
        BDDMockito.given((Object)this.nodes.validateOrLookupNode(permissionDeniedNodeId)).willReturn((Object)permissionDeniedNode);
        BDDMockito.given((Object)this.permissionService.hasReadPermission(permissionDeniedNode)).willReturn((Object)AccessStatus.DENIED);
        BDDMockito.given((Object)this.actionService.getActionDefinition("copy")).willReturn((Object)this.actionDefinition);
        BDDMockito.given((Object)this.actionDefinition.getParameterDefintion("destination-folder")).willReturn((Object)this.actionDefinitionParam1);
        QName nodeRef = DataTypeDefinition.NODE_REF;
        BDDMockito.given((Object)this.actionDefinitionParam1.getType()).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.dictionaryService.getDataType(nodeRef)).willReturn((Object)this.dataTypeDefinition1);
        Assertions.assertThatExceptionOfType(EntityNotFoundException.class).isThrownBy(() -> this.objectUnderTest.getConvertedParams(params, "copy"));
    }

    @Test
    public void testNullParamValue() {
        String name = "check-out";
        String destinationFolderKey = "destination-folder";
        String assocNameKey = "assoc-name";
        String assocTypeKey = "assoc-type";
        Map<String, String> params = Map.of("destination-folder", "", "assoc-name", "", "assoc-type", "");
        BDDMockito.given((Object)this.actionService.getActionDefinition("check-out")).willReturn((Object)this.actionDefinition);
        Assert.assertThrows(InvalidArgumentException.class, () -> this.objectUnderTest.getConvertedParams(params, "check-out"));
        ((ActionService)BDDMockito.then((Object)this.actionService).should()).getActionDefinition("check-out");
        BDDMockito.then((Object)this.actionService).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.actionDefinition).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.dictionaryService).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoInteractions();
    }

    @Test
    public void testInvalidActionDefinitionConversion() {
        String invalidName = "dummy-definition";
        Map<String, String> params = Map.of("dummy-key", "dummy-value");
        BDDMockito.given((Object)this.actionService.getActionDefinition("dummy-definition")).willReturn(null);
        Assert.assertThrows(NotFoundException.class, () -> this.objectUnderTest.getConvertedParams(params, "dummy-definition"));
        BDDMockito.given((Object)this.actionService.getActionDefinition("dummy-definition")).willThrow(NotFoundException.class);
        Assert.assertThrows(NotFoundException.class, () -> this.objectUnderTest.getConvertedParams(params, "dummy-definition"));
    }

    @Test
    public void testQnameServiceModelParamConversion() {
        BDDMockito.given((Object)this.namespaceService.getPrefixes((String)ArgumentMatchers.any())).willReturn(List.of("cm"));
        String qname = "{cm-dummy-prefix}audio";
        QName qnameParam = QName.createQName((String)"{cm-dummy-prefix}audio");
        Serializable convertedParam = this.objectUnderTest.convertParamFromServiceModel((Serializable)qnameParam);
        ((NamespaceService)BDDMockito.then((Object)this.namespaceService).should()).getPrefixes((String)ArgumentMatchers.any());
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoMoreInteractions();
        Assert.assertEquals((Object)"cm:audio", (Object)convertedParam);
    }

    @Test
    public void testNodeRefServiceModelParamConversion() {
        NodeRef nodeRefParam = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, DUMMY_FOLDER_NODE_ID);
        Serializable convertedParam = this.objectUnderTest.convertParamFromServiceModel((Serializable)nodeRefParam);
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoInteractions();
        Assert.assertEquals((Object)DUMMY_FOLDER_NODE_ID, (Object)convertedParam);
    }

    @Test
    public void testOtherServiceModelParamConversion() {
        String dummyStringParam = "dummy-param";
        Serializable convertedParam = this.objectUnderTest.convertParamFromServiceModel((Serializable)((Object)dummyStringParam));
        BDDMockito.then((Object)this.namespaceService).shouldHaveNoInteractions();
        Assert.assertEquals((Object)dummyStringParam, (Object)convertedParam);
    }
}

