/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentQuery;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.workflow.api.Deployments;
import org.alfresco.rest.workflow.api.impl.WorkflowRestImpl;

public class DeploymentsImpl
extends WorkflowRestImpl
implements Deployments {
    @Override
    public CollectionWithPagingInfo<org.alfresco.rest.workflow.api.model.Deployment> getDeployments(Paging paging) {
        if (!this.authorityService.isAdminAuthority(AuthenticationUtil.getRunAsUser())) {
            throw new PermissionDeniedException();
        }
        DeploymentQuery query = this.activitiProcessEngine.getRepositoryService().createDeploymentQuery().deploymentCategoryNotEquals("http://alfresco.org/workflows/internal");
        if (this.tenantService.isEnabled() && this.deployWorkflowsInTenant) {
            query.processDefinitionKeyLike("@" + TenantUtil.getCurrentDomain() + "@%");
        }
        query.orderByDeploymenTime().desc();
        List deployments = query.listPage(paging.getSkipCount(), paging.getMaxItems());
        int totalCount = (int)query.count();
        ArrayList<org.alfresco.rest.workflow.api.model.Deployment> page = new ArrayList<org.alfresco.rest.workflow.api.model.Deployment>(deployments.size());
        for (Deployment deployment : deployments) {
            page.add(new org.alfresco.rest.workflow.api.model.Deployment(deployment));
        }
        return CollectionWithPagingInfo.asPaged(paging, page, page.size() + paging.getSkipCount() < totalCount, totalCount);
    }

    @Override
    public org.alfresco.rest.workflow.api.model.Deployment getDeployment(String deploymentId) {
        if (!this.authorityService.isAdminAuthority(AuthenticationUtil.getRunAsUser())) {
            throw new PermissionDeniedException();
        }
        RepositoryService repositoryService = this.activitiProcessEngine.getRepositoryService();
        DeploymentQuery query = repositoryService.createDeploymentQuery().deploymentId(deploymentId);
        if (this.tenantService.isEnabled() && this.deployWorkflowsInTenant) {
            query.processDefinitionKeyLike("@" + TenantUtil.getCurrentDomain() + "@%");
        }
        Deployment deployment = null;
        try {
            deployment = (Deployment)query.singleResult();
        }
        catch (ActivitiException e) {
            throw new InvalidArgumentException("Invalid deployment id: " + deploymentId);
        }
        if (deployment == null) {
            throw new EntityNotFoundException(deploymentId);
        }
        org.alfresco.rest.workflow.api.model.Deployment deploymentRest = new org.alfresco.rest.workflow.api.model.Deployment(deployment);
        return deploymentRest;
    }
}

