/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rule;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.action.access.ActionAccessRestriction;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractRuleWebScript
extends DeclarativeWebScript {
    public static final SimpleDateFormat dateFormate = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
    private static final String RULE_OUTBOUND = "outbound";
    private static final String ACTION_CHECK_OUT = "check-out";
    public static final String CANNOT_CREATE_RULE = "cannot.create.rule.checkout.outbound";
    protected NodeService nodeService;
    protected RuleService ruleService;
    protected DictionaryService dictionaryService;
    protected ActionService actionService;
    protected FileFolderService fileFolderService;
    protected NamespaceService namespaceService;
    private RuntimeActionService runtimeActionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    protected NodeRef parseRequestForNodeRef(WebScriptRequest req) {
        String nodeId;
        String storeId;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        StoreRef storeRef = new StoreRef(storeType, storeId = (String)templateVars.get("store_id"));
        NodeRef nodeRef = new NodeRef(storeRef, nodeId = (String)templateVars.get("id"));
        if (!this.nodeService.exists(nodeRef)) {
            throw new WebScriptException(404, "Unable to find node: " + nodeRef.toString());
        }
        return nodeRef;
    }

    protected Rule parseJsonRule(JSONObject jsonRule) throws JSONException {
        Rule result = new Rule();
        if (!jsonRule.has("title") || jsonRule.getString("title").length() == 0) {
            throw new WebScriptException(400, "Title missing when creating rule");
        }
        result.setTitle(jsonRule.getString("title"));
        result.setDescription(jsonRule.has("description") ? jsonRule.getString("description") : "");
        if (!jsonRule.has("ruleType") || jsonRule.getJSONArray("ruleType").length() == 0) {
            throw new WebScriptException(400, "Rule type missing when creating rule");
        }
        JSONArray types = jsonRule.getJSONArray("ruleType");
        ArrayList<String> ruleTypes = new ArrayList<String>();
        for (int i = 0; i < types.length(); ++i) {
            ruleTypes.add(types.getString(i));
        }
        result.setRuleTypes(ruleTypes);
        result.applyToChildren(jsonRule.has("applyToChildren") ? jsonRule.getBoolean("applyToChildren") : false);
        result.setExecuteAsynchronously(jsonRule.has("executeAsynchronously") ? jsonRule.getBoolean("executeAsynchronously") : false);
        result.setRuleDisabled(jsonRule.has("disabled") ? jsonRule.getBoolean("disabled") : false);
        JSONObject jsonAction = jsonRule.getJSONObject("action");
        ActionImpl ruleAction = this.parseJsonAction(jsonAction);
        result.setAction((Action)ruleAction);
        return result;
    }

    protected ActionImpl parseJsonAction(JSONObject jsonAction) throws JSONException {
        int i;
        Object result = null;
        String actionId = jsonAction.has("id") ? jsonAction.getString("id") : GUID.generate();
        result = jsonAction.getString("actionDefinitionName").equalsIgnoreCase("composite-action") ? new CompositeActionImpl(null, actionId) : new ActionImpl(null, actionId, jsonAction.getString("actionDefinitionName"));
        if (jsonAction.has("actionedUponNode")) {
            NodeRef actionedUponNode = new NodeRef(jsonAction.getString("actionedUponNode"));
            result.setNodeRef(actionedUponNode);
        }
        if (jsonAction.has("description")) {
            result.setDescription(jsonAction.getString("description"));
        }
        if (jsonAction.has("title")) {
            result.setTitle(jsonAction.getString("title"));
        }
        if (jsonAction.has("parameterValues")) {
            JSONObject jsonParameterValues = jsonAction.getJSONObject("parameterValues");
            result.setParameterValues(this.parseJsonParameterValues(jsonParameterValues, result.getActionDefinitionName(), true));
        }
        if (jsonAction.has("executeAsync")) {
            result.setExecuteAsynchronously(jsonAction.getBoolean("executeAsync"));
        }
        if (jsonAction.has("runAsUser")) {
            result.setRunAsUser(jsonAction.getString("runAsUser"));
        }
        if (jsonAction.has("actions")) {
            JSONArray jsonActions = jsonAction.getJSONArray("actions");
            for (i = 0; i < jsonActions.length(); ++i) {
                JSONObject innerJsonAction = jsonActions.getJSONObject(i);
                ActionImpl innerAction = this.parseJsonAction(innerJsonAction);
                result.addAction((Action)innerAction);
            }
        }
        if (jsonAction.has("conditions")) {
            JSONArray jsonConditions = jsonAction.getJSONArray("conditions");
            for (i = 0; i < jsonConditions.length(); ++i) {
                JSONObject jsonCondition = jsonConditions.getJSONObject(i);
                ActionConditionImpl actionCondition = this.parseJsonActionCondition(jsonCondition);
                result.getActionConditions().add(actionCondition);
            }
        }
        if (jsonAction.has("compensatingAction")) {
            ActionImpl compensatingAction = this.parseJsonAction(jsonAction.getJSONObject("compensatingAction"));
            result.setCompensatingAction((Action)compensatingAction);
        }
        return result;
    }

    protected ActionConditionImpl parseJsonActionCondition(JSONObject jsonActionCondition) throws JSONException {
        String id = jsonActionCondition.has("id") ? jsonActionCondition.getString("id") : GUID.generate();
        ActionConditionImpl result = new ActionConditionImpl(id, jsonActionCondition.getString("conditionDefinitionName"));
        if (jsonActionCondition.has("invertCondition")) {
            result.setInvertCondition(jsonActionCondition.getBoolean("invertCondition"));
        }
        if (jsonActionCondition.has("parameterValues")) {
            JSONObject jsonParameterValues = jsonActionCondition.getJSONObject("parameterValues");
            result.setParameterValues(this.parseJsonParameterValues(jsonParameterValues, result.getActionConditionDefinitionName(), false));
        }
        return result;
    }

    protected Map<String, Serializable> parseJsonParameterValues(JSONObject jsonParameterValues, String name, boolean isAction) throws JSONException {
        HashMap<String, Serializable> parameterValues = new HashMap<String, Serializable>();
        JSONArray names = jsonParameterValues.names();
        if (names == null) {
            return null;
        }
        Object definition = null;
        definition = isAction ? this.actionService.getActionDefinition(name) : this.actionService.getActionConditionDefinition(name);
        if (definition == null) {
            throw new AlfrescoRuntimeException("Could not find defintion for action/condition " + name);
        }
        for (int i = 0; i < names.length(); ++i) {
            String propertyName = names.getString(i);
            Object propertyValue = jsonParameterValues.get(propertyName);
            ParameterDefinition paramDef = definition.getParameterDefintion(propertyName);
            if (paramDef == null && !definition.getAdhocPropertiesAllowed()) {
                throw new AlfrescoRuntimeException("Invalid parameter " + propertyName + " for action/condition " + name);
            }
            if (paramDef != null) {
                QName typeQName = paramDef.getType();
                Serializable value = this.convertValue(typeQName, propertyValue);
                parameterValues.put(propertyName, value);
                continue;
            }
            parameterValues.put(propertyName, (Serializable)((Object)propertyValue.toString()));
        }
        return parameterValues;
    }

    private Serializable convertValue(QName typeQName, Object propertyValue) throws JSONException {
        Serializable value = null;
        DataTypeDefinition typeDef = this.dictionaryService.getDataType(typeQName);
        if (typeDef == null) {
            throw new AlfrescoRuntimeException("Action property type definition " + typeQName.toPrefixString() + " is unknown.");
        }
        if (propertyValue instanceof JSONArray) {
            Class<?> javaClass = null;
            String javaClassName = typeDef.getJavaClassName();
            try {
                javaClass = Class.forName(javaClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DictionaryException("Java class " + javaClassName + " of property type " + String.valueOf(typeDef.getName()) + " is invalid", (Throwable)e);
            }
            int length = ((JSONArray)propertyValue).length();
            ArrayList<Serializable> list = new ArrayList<Serializable>(length);
            for (int i = 0; i < length; ++i) {
                list.add(this.convertValue(typeQName, ((JSONArray)propertyValue).get(i)));
            }
            value = list;
        } else {
            value = typeQName.equals((Object)DataTypeDefinition.QNAME) && typeQName.toString().contains(":") ? QName.createQName((String)propertyValue.toString(), (NamespacePrefixResolver)this.namespaceService) : (Serializable)DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(typeQName), propertyValue);
        }
        return value;
    }

    protected void checkRule(Rule rule) {
        List actions = ((CompositeActionImpl)rule.getAction()).getActions();
        this.checkRestrictedAccessActions(actions);
        this.checkRuleOutboundHasNoCheckOutAction(rule, actions);
    }

    private void checkRestrictedAccessActions(List<Action> actions) {
        for (Action action : actions) {
            ActionAccessRestriction.setActionContext((Action)action, (String)"rule");
            this.runtimeActionService.verifyActionAccessRestrictions(action);
        }
    }

    private void checkRuleOutboundHasNoCheckOutAction(Rule rule, List<Action> actions) {
        if (rule.getRuleTypes().contains(RULE_OUTBOUND)) {
            for (Action action : actions) {
                if (!action.getActionDefinitionName().equalsIgnoreCase(ACTION_CHECK_OUT)) continue;
                throw new WebScriptException(CANNOT_CREATE_RULE);
            }
        }
    }
}

