/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.model.Association;
import org.alfresco.rest.api.model.AssociationSource;
import org.alfresco.rest.api.model.Model;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.Aspect;
import org.alfresco.rest.api.tests.client.data.Type;
import org.junit.Before;

public class BaseModelApiTest
extends AbstractBaseApiTest {
    PublicApiClient.ListResponse<Aspect> aspects = null;
    Aspect aspect = null;
    Aspect childAspect = null;
    Aspect smartFilterAspect = null;
    Aspect rescanAspect = null;
    Aspect testAspect = null;
    Aspect testAllAspect = null;
    PublicApiClient.ListResponse<Type> types = null;
    Type type = null;
    Type whitePaperType = null;
    Type docType = null;
    Type publishableType = null;
    Type apiBaseType = null;
    Type apiFileType = null;
    Type apiFileDerivedType = null;
    Type apiForcedType = null;
    Type apiFileDerivedNoArchiveType = null;
    Type apiFolderType = null;
    Type apiOverrideType = null;
    Type apiOverride2Type = null;
    Type apiOverride3Type = null;
    Type apiNamedPropConstraintType = null;
    List<Type> allTypes = null;
    PublicApiClient.Paging paging = this.getPaging(0, 10);
    Map<String, String> otherParams = new HashMap<String, String>();

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Model myCompanyModel = new Model();
        myCompanyModel.setAuthor("Administrator");
        myCompanyModel.setId("mycompany:model");
        myCompanyModel.setNamespaceUri("http://www.mycompany.com/model/finance/1.0");
        myCompanyModel.setNamespacePrefix("mycompany");
        Model scanModel = new Model();
        scanModel.setAuthor("Administrator");
        scanModel.setId("test:scan");
        scanModel.setNamespaceUri("http://www.test.com/model/account/1.0");
        scanModel.setNamespacePrefix("test");
        this.testAspect = new Aspect();
        this.testAspect.setId("mycompany:testAspect");
        this.testAspect.setTitle("Test Aspect");
        this.testAspect.setModel(myCompanyModel);
        this.testAspect.setIsContainer(false);
        this.testAspect.setIncludedInSupertypeQuery(true);
        this.testAspect.setIsArchive(true);
        this.childAspect = new Aspect();
        this.childAspect.setId("mycompany:childAspect");
        this.childAspect.setTitle("Child Aspect");
        this.childAspect.setDescription("Child Aspect Description");
        this.childAspect.setParentId("smf:smartFolder");
        this.childAspect.setModel(myCompanyModel);
        this.childAspect.setIsContainer(false);
        this.childAspect.setIncludedInSupertypeQuery(true);
        this.rescanAspect = new Aspect();
        this.rescanAspect.setId("test:rescan");
        this.rescanAspect.setTitle("rescan");
        this.rescanAspect.setDescription("Doc that required to scan ");
        this.rescanAspect.setModel(scanModel);
        this.rescanAspect.setIsContainer(false);
        this.rescanAspect.setIncludedInSupertypeQuery(true);
        this.smartFilterAspect = new Aspect();
        this.smartFilterAspect.setId("test:smartFilter");
        this.smartFilterAspect.setTitle("Smart filter");
        this.smartFilterAspect.setDescription("Smart Filter");
        this.smartFilterAspect.setParentId("mycompany:testAspect");
        this.smartFilterAspect.setModel(scanModel);
        this.smartFilterAspect.setIsContainer(false);
        this.smartFilterAspect.setIsArchive(true);
        this.smartFilterAspect.setIncludedInSupertypeQuery(true);
        this.whitePaperType = new Type();
        this.whitePaperType.setId("mycompany:whitepaper");
        this.whitePaperType.setTitle("whitepaper");
        this.whitePaperType.setDescription("Whitepaper");
        this.whitePaperType.setParentId("mycompany:doc");
        this.whitePaperType.setModel(myCompanyModel);
        this.whitePaperType.setIsContainer(false);
        this.whitePaperType.setIsArchive(true);
        this.whitePaperType.setIncludedInSupertypeQuery(true);
        this.docType = new Type();
        this.docType.setId("mycompany:doc");
        this.docType.setTitle("doc");
        this.docType.setDescription("Doc");
        this.docType.setParentId("cm:content");
        this.docType.setModel(myCompanyModel);
        this.docType.setIsContainer(false);
        this.docType.setIsArchive(true);
        this.docType.setIncludedInSupertypeQuery(true);
        this.publishableType = new Type();
        this.publishableType.setId("test:publishable");
        this.publishableType.setParentId("mycompany:doc");
        this.publishableType.setIsContainer(false);
        this.publishableType.setIsArchive(true);
        this.publishableType.setIncludedInSupertypeQuery(true);
        Model testModel = new Model();
        testModel.setAuthor("Administrator");
        testModel.setId("api:apiModel");
        testModel.setNamespaceUri("http://www.api.t2/model/1.0");
        testModel.setNamespacePrefix("test2");
        Model apiModel = new Model();
        apiModel.setAuthor("Administrator");
        apiModel.setId("api:apiModel");
        apiModel.setNamespaceUri("http://www.api.t1/model/1.0");
        apiModel.setNamespacePrefix("api");
        AssociationSource testAllAspectSource = new AssociationSource(null, "test2:aspect-all", Boolean.valueOf(true), Boolean.valueOf(true), null);
        AssociationSource testAllAspectTarget = new AssociationSource(null, "api:referenceable", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        Association testAllAspectAssociation = new Association("api:assoc-all", null, null, null, Boolean.valueOf(false), testAllAspectSource, testAllAspectTarget);
        this.testAllAspect = new Aspect();
        this.testAllAspect.setId("test2:aspect-all");
        this.testAllAspect.setTitle("Aspect derived from other namespace");
        this.testAllAspect.setIsArchive(false);
        this.testAllAspect.setIncludedInSupertypeQuery(false);
        this.testAllAspect.setIsContainer(false);
        this.testAllAspect.setModel(testModel);
        this.testAllAspect.setAssociations(Collections.singletonList(testAllAspectAssociation));
        this.testAllAspect.setMandatoryAspects(Arrays.asList("test2:aspect-three", "api:aspect-one", "api:aspect-two"));
        AssociationSource apiBaseSource = new AssociationSource(null, "api:base", Boolean.valueOf(false), Boolean.valueOf(true), null);
        AssociationSource apiBaseTarget = new AssociationSource(null, "api:base", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        Association apiBaseAssociation = new Association("api:assoc1", null, null, Boolean.valueOf(false), Boolean.valueOf(false), apiBaseSource, apiBaseTarget);
        AssociationSource apiChildSource = new AssociationSource(null, "api:base", Boolean.valueOf(true), Boolean.valueOf(true), null);
        AssociationSource apiChildTarget = new AssociationSource(null, "api:referenceable", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        Association apiChildAssociation = new Association("api:childassoc1", null, null, Boolean.valueOf(true), Boolean.valueOf(false), apiChildSource, apiChildTarget);
        AssociationSource apiBaseSource2 = new AssociationSource(null, "api:base", Boolean.valueOf(true), Boolean.valueOf(true), null);
        AssociationSource apiBaseTarget2 = new AssociationSource(null, "api:referenceable", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        Association apiBaseAssociation2 = new Association("api:assoc2", null, null, Boolean.valueOf(false), Boolean.valueOf(false), apiBaseSource2, apiBaseTarget2);
        AssociationSource apiChildPropagateSource = new AssociationSource(null, "api:base", Boolean.valueOf(true), Boolean.valueOf(true), null);
        AssociationSource apiChildPropagateTarget = new AssociationSource(null, "api:referenceable", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        Association apiChildPropagateAssociation = new Association("api:childassocPropagate", null, null, Boolean.valueOf(true), Boolean.valueOf(false), apiChildPropagateSource, apiChildPropagateTarget);
        this.apiBaseType = new Type();
        this.apiBaseType.setId("api:base");
        this.apiBaseType.setTitle("Base");
        this.apiBaseType.setDescription("The Base Type");
        this.apiBaseType.setIncludedInSupertypeQuery(true);
        this.apiBaseType.setIsContainer(true);
        this.apiBaseType.setModel(apiModel);
        this.apiBaseType.setAssociations(Arrays.asList(apiBaseAssociation, apiChildAssociation, apiBaseAssociation2, apiChildPropagateAssociation));
        this.apiBaseType.setMandatoryAspects(Collections.singletonList("api:referenceable"));
        this.apiForcedType = new Type();
        this.apiForcedType.setId("api:enforced");
        this.apiForcedType.setParentId("api:base");
        this.apiForcedType.setIncludedInSupertypeQuery(true);
        this.apiForcedType.setIsContainer(true);
        this.apiForcedType.setModel(apiModel);
        this.apiForcedType.setAssociations(Arrays.asList(apiBaseAssociation2, apiChildPropagateAssociation, apiBaseAssociation, apiChildAssociation));
        this.apiForcedType.setMandatoryAspects(Collections.singletonList("api:referenceable"));
        AssociationSource apiChildSource2 = new AssociationSource(null, "api:file", Boolean.valueOf(false), Boolean.valueOf(true), null);
        AssociationSource apiChildTarget2 = new AssociationSource(null, "api:referenceable", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        Association apiChildAssociation2 = new Association("api:childassoc2", null, null, Boolean.valueOf(true), Boolean.valueOf(false), apiChildSource2, apiChildTarget2);
        this.apiFileType = new Type();
        this.apiFileType.setId("api:file");
        this.apiFileType.setParentId("api:base");
        this.apiFileType.setIsArchive(true);
        this.apiFileType.setIncludedInSupertypeQuery(true);
        this.apiFileType.setIsContainer(true);
        this.apiFileType.setModel(apiModel);
        this.apiFileType.setAssociations(Arrays.asList(apiBaseAssociation2, apiChildAssociation2, apiChildPropagateAssociation, apiBaseAssociation, apiChildAssociation));
        this.apiFileType.setMandatoryAspects(Collections.singletonList("api:referenceable"));
        this.apiFileDerivedType = new Type();
        this.apiFileDerivedType.setId("api:file-derived");
        this.apiFileDerivedType.setParentId("api:file");
        this.apiFileDerivedType.setIsArchive(true);
        this.apiFileDerivedType.setIncludedInSupertypeQuery(true);
        this.apiFileDerivedType.setIsContainer(true);
        this.apiFileDerivedType.setModel(apiModel);
        this.apiFileDerivedType.setAssociations(Arrays.asList(apiBaseAssociation2, apiChildAssociation2, apiChildPropagateAssociation, apiBaseAssociation, apiChildAssociation));
        this.apiFileDerivedType.setMandatoryAspects(Collections.singletonList("api:referenceable"));
        this.apiFileDerivedNoArchiveType = new Type();
        this.apiFileDerivedNoArchiveType.setId("api:file-derived-no-archive");
        this.apiFileDerivedNoArchiveType.setParentId("api:file");
        this.apiFileDerivedNoArchiveType.setIsArchive(false);
        this.apiFileDerivedNoArchiveType.setIncludedInSupertypeQuery(true);
        this.apiFileDerivedNoArchiveType.setIsContainer(true);
        this.apiFileDerivedNoArchiveType.setModel(apiModel);
        this.apiFileDerivedNoArchiveType.setAssociations(Arrays.asList(apiBaseAssociation2, apiChildAssociation2, apiChildPropagateAssociation, apiBaseAssociation, apiChildAssociation));
        this.apiFileDerivedNoArchiveType.setMandatoryAspects(Collections.singletonList("api:referenceable"));
        this.apiFolderType = new Type();
        this.apiFolderType.setId("api:folder");
        this.apiFolderType.setParentId("api:base");
        this.apiFolderType.setIncludedInSupertypeQuery(true);
        this.apiFolderType.setIsContainer(true);
        this.apiFolderType.setModel(apiModel);
        this.apiFolderType.setAssociations(Arrays.asList(apiBaseAssociation2, apiChildPropagateAssociation, apiBaseAssociation, apiChildAssociation));
        this.apiFolderType.setMandatoryAspects(Collections.singletonList("api:referenceable"));
        this.apiOverrideType = new Type();
        this.apiOverrideType.setId("api:overridetype1");
        this.apiOverrideType.setParentId("api:base");
        this.apiOverrideType.setIncludedInSupertypeQuery(true);
        this.apiOverrideType.setIsContainer(false);
        this.apiOverrideType.setModel(apiModel);
        this.apiOverrideType.setAssociations(Collections.emptyList());
        this.apiOverrideType.setMandatoryAspects(Collections.emptyList());
        this.apiOverride2Type = new Type();
        this.apiOverride2Type.setId("api:overridetype2");
        this.apiOverride2Type.setParentId("api:overridetype1");
        this.apiOverride2Type.setIncludedInSupertypeQuery(true);
        this.apiOverride2Type.setIsContainer(false);
        this.apiOverride2Type.setModel(apiModel);
        this.apiOverride2Type.setAssociations(Collections.emptyList());
        this.apiOverride2Type.setMandatoryAspects(Collections.emptyList());
        this.apiOverride3Type = new Type();
        this.apiOverride3Type.setId("api:overridetype3");
        this.apiOverride3Type.setParentId("api:overridetype2");
        this.apiOverride3Type.setIncludedInSupertypeQuery(true);
        this.apiOverride3Type.setIsContainer(false);
        this.apiOverride3Type.setModel(apiModel);
        this.apiOverride3Type.setAssociations(Collections.emptyList());
        this.apiOverride3Type.setMandatoryAspects(Collections.emptyList());
        this.apiNamedPropConstraintType = new Type();
        this.apiNamedPropConstraintType.setId("api:typeWithNamedPropConstraint");
        this.apiNamedPropConstraintType.setTitle("Type with named property-defined constraint.");
        this.apiNamedPropConstraintType.setDescription("A type with a named constraint defined within one of its properties.");
        this.apiNamedPropConstraintType.setParentId("api:overridetype2");
        this.apiNamedPropConstraintType.setIncludedInSupertypeQuery(true);
        this.apiNamedPropConstraintType.setIsContainer(false);
        this.apiNamedPropConstraintType.setModel(apiModel);
        this.apiNamedPropConstraintType.setAssociations(Collections.emptyList());
        this.apiNamedPropConstraintType.setMandatoryAspects(Collections.emptyList());
        this.allTypes = ImmutableList.of((Object)this.apiBaseType, (Object)this.apiForcedType, (Object)this.apiFileType, (Object)this.apiFileDerivedType, (Object)this.apiFileDerivedNoArchiveType, (Object)this.apiFolderType, (Object)this.apiOverrideType, (Object)this.apiOverride2Type, (Object)this.apiOverride3Type, (Object)this.apiNamedPropConstraintType);
    }

    @Override
    public String getScope() {
        return "public";
    }
}

