/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class DiscussionRestApiTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(DiscussionRestApiTest.class);
    private static final String DELETED_REPLY_POST_MARKER = "[[deleted]]";
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private BehaviourFilter policyBehaviourFilter;
    private PermissionService permissionService;
    private PersonService personService;
    private SiteService siteService;
    private NodeService nodeService;
    private NodeService internalNodeService;
    private NodeArchiveService nodeArchiveService;
    private static final String USER_ONE = "UserOneThird";
    private static final String USER_TWO = "UserTwoThird";
    private static final String SITE_SHORT_NAME_DISCUSSION = "DiscussionSiteShortNameThree";
    private static final String COMPONENT_DISCUSSION = "discussions";
    private static final String URL_FORUM_SITE_POST = "/api/forum/post/site/DiscussionSiteShortNameThree/discussions/";
    private static final String URL_FORUM_SITE_POSTS = "/api/forum/site/DiscussionSiteShortNameThree/discussions/posts";
    private static final String URL_FORUM_NODE_POST_BASE = "/api/forum/post/node/";
    private static final String URL_FORUM_NODE_POSTS_BASE = "/api/forum/node/";
    private List<String> posts = new ArrayList<String>(5);
    private NodeRef FORUM_NODE;

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.policyBehaviourFilter = (BehaviourFilter)this.getServer().getApplicationContext().getBean("policyBehaviourFilter");
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("transactionService");
        this.permissionService = (PermissionService)this.getServer().getApplicationContext().getBean("PermissionService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.internalNodeService = (NodeService)this.getServer().getApplicationContext().getBean("nodeService");
        this.nodeArchiveService = (NodeArchiveService)this.getServer().getApplicationContext().getBean("nodeArchiveService");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_DISCUSSION);
        if (siteInfo == null) {
            siteInfo = this.siteService.createSite("DiscussionSitePreset", SITE_SHORT_NAME_DISCUSSION, "DiscussionSiteTitle", "DiscussionSiteDescription", SiteVisibility.PUBLIC);
        }
        final NodeRef siteNodeRef = siteInfo.getNodeRef();
        String forumNodeName = "TestForum";
        this.FORUM_NODE = this.nodeService.getChildByName(siteInfo.getNodeRef(), ContentModel.ASSOC_CONTAINS, "TestForum");
        if (this.FORUM_NODE == null) {
            this.FORUM_NODE = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                public NodeRef execute() throws Throwable {
                    HashMap<QName, String> props = new HashMap<QName, String>(5);
                    props.put(ContentModel.PROP_NAME, "TestForum");
                    props.put(ContentModel.PROP_TITLE, "TestForum");
                    return DiscussionRestApiTest.this.nodeService.createNode(siteNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestForum"), ForumModel.TYPE_FORUM, props).getChildRef();
                }
            });
        }
        this.createUser(USER_ONE, "SiteCollaborator", SITE_SHORT_NAME_DISCUSSION);
        this.createUser(USER_TWO, "SiteContributor", SITE_SHORT_NAME_DISCUSSION);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    protected void tearDown() throws Exception {
        SiteInfo siteInfo;
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        if (this.personService.personExists(USER_ONE)) {
            this.personService.deletePerson(USER_ONE);
        }
        if (this.authenticationService.authenticationExists(USER_ONE)) {
            this.authenticationService.deleteAuthentication(USER_ONE);
        }
        if (this.personService.personExists(USER_TWO)) {
            this.personService.deletePerson(USER_TWO);
        }
        if (this.authenticationService.authenticationExists(USER_TWO)) {
            this.authenticationService.deleteAuthentication(USER_TWO);
        }
        if ((siteInfo = this.siteService.getSite(SITE_SHORT_NAME_DISCUSSION)) != null) {
            RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    DiscussionRestApiTest.this.siteService.deleteSite(DiscussionRestApiTest.SITE_SHORT_NAME_DISCUSSION);
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteCallback);
            this.nodeArchiveService.purgeArchivedNode(this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef()));
        }
    }

    private void createUser(String userName, String role, String siteName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"FirstName123");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"LastName123");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        this.siteService.setMembership(siteName, userName, role);
        this.permissionService.setPermission(this.FORUM_NODE, userName, "Read", true);
        this.permissionService.setPermission(this.FORUM_NODE, userName, "CreateChildren", true);
    }

    private JSONObject createSitePost(String title, String content, int expectedStatus) throws Exception {
        return this.doCreatePost(URL_FORUM_SITE_POSTS, title, content, expectedStatus);
    }

    private JSONObject createNodePost(NodeRef nodeRef, String title, String content, int expectedStatus) throws Exception {
        return this.doCreatePost(this.getPostsUrl(nodeRef), title, content, expectedStatus);
    }

    private JSONObject doCreatePost(String url, String title, String content, int expectedStatus) throws Exception {
        JSONObject post = new JSONObject();
        post.put("title", (Object)title);
        post.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, post.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject item = result.getJSONObject("item");
        this.posts.add(item.getString("name"));
        return item;
    }

    private JSONObject updatePost(NodeRef nodeRef, String title, String content, int expectedStatus) throws Exception {
        return this.doUpdatePost(this.getPostUrl(nodeRef), title, content, expectedStatus);
    }

    private JSONObject updatePost(String name, String title, String content, int expectedStatus) throws Exception {
        return this.doUpdatePost(URL_FORUM_SITE_POST + name, title, content, expectedStatus);
    }

    private JSONObject doUpdatePost(String url, String title, String content, int expectedStatus) throws Exception {
        JSONObject post = new JSONObject();
        post.put("title", (Object)title);
        post.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(url, post.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private JSONObject getPost(String name, int expectedStatus) throws Exception {
        return this.doGetPost(URL_FORUM_SITE_POST + name, expectedStatus);
    }

    private JSONObject getPost(NodeRef nodeRef, int expectedStatus) throws Exception {
        return this.doGetPost(this.getPostUrl(nodeRef), expectedStatus);
    }

    private JSONObject doGetPost(String url, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result.getJSONObject("item");
        }
        return null;
    }

    private JSONObject getReplies(String name, int expectedStatus) throws Exception {
        return this.doGetReplies(this.getRepliesUrl(name), expectedStatus);
    }

    private JSONObject getReplies(NodeRef nodeRef, int expectedStatus) throws Exception {
        return this.doGetReplies(this.getRepliesUrl(nodeRef), expectedStatus);
    }

    private JSONObject doGetReplies(String url, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result;
        }
        return null;
    }

    private JSONObject getPosts(String type, int expectedStatus) throws Exception {
        return this.doGetPosts(URL_FORUM_SITE_POSTS, type, expectedStatus);
    }

    private JSONObject getPosts(NodeRef nodeRef, String type, int expectedStatus) throws Exception {
        return this.doGetPosts(this.getPostsUrl(nodeRef), type, expectedStatus);
    }

    private JSONObject doGetPosts(String baseUrl, String type, int expectedStatus) throws Exception {
        Object url = null;
        if (type == null) {
            url = baseUrl;
        } else if (type == "limit") {
            url = baseUrl + "?pageSize=1";
        } else if (type == "hot") {
            url = baseUrl + "/hot";
        } else if (type == "mine") {
            url = baseUrl + "/myposts";
        } else if (type.startsWith("new")) {
            url = baseUrl + "/" + type;
        } else {
            throw new IllegalArgumentException("Invalid search type " + type);
        }
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest((String)url), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result;
        }
        return null;
    }

    private JSONObject deletePost(String name, int expectedStatus) throws Exception {
        return this.doDeletePost(URL_FORUM_SITE_POST + name, expectedStatus);
    }

    private JSONObject deletePost(NodeRef nodeRef, int expectedStatus) throws Exception {
        return this.doDeletePost(this.getPostUrl(nodeRef), expectedStatus);
    }

    private JSONObject doDeletePost(String url, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(url), 200);
        if (expectedStatus == 200) {
            return new JSONObject(response.getContentAsString());
        }
        return null;
    }

    private String getRepliesUrl(NodeRef nodeRef) {
        return this.getPostUrl(nodeRef) + "/replies";
    }

    private String getRepliesUrl(String postName) {
        return URL_FORUM_SITE_POST + postName + "/replies";
    }

    private String getPostUrl(NodeRef nodeRef) {
        return URL_FORUM_NODE_POST_BASE + nodeRef.toString().replace("://", "/");
    }

    private String getPostsUrl(NodeRef nodeRef) {
        return URL_FORUM_NODE_POSTS_BASE + nodeRef.toString().replace("://", "/") + "/posts";
    }

    private JSONObject createReply(NodeRef nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject reply = new JSONObject();
        reply.put("title", (Object)title);
        reply.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.getRepliesUrl(nodeRef), reply.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private JSONObject updateComment(NodeRef nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject comment = new JSONObject();
        comment.put("title", (Object)title);
        comment.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getPostUrl(nodeRef), comment.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private void pushCreatedDateBack(NodeRef node, int daysAgo) throws Exception {
        Date created = (Date)this.nodeService.getProperty(node, ContentModel.PROP_CREATED);
        Date newCreated = new Date(created.getTime() - (long)(daysAgo * 24 * 60 * 60 * 1000));
        Date published = (Date)this.nodeService.getProperty(node, ContentModel.PROP_PUBLISHED);
        if (published == null) {
            published = created;
        }
        Date newPublished = new Date(published.getTime() - (long)(daysAgo * 24 * 60 * 60 * 1000));
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.internalNodeService.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
        this.internalNodeService.setProperty(node, ContentModel.PROP_MODIFIED, (Serializable)newCreated);
        this.internalNodeService.setProperty(node, ContentModel.PROP_PUBLISHED, (Serializable)newPublished);
        this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
        txn.commit();
        this.nodeService.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
        this.nodeService.setProperty(node, ContentModel.PROP_MODIFIED, (Serializable)newCreated);
        this.nodeService.setProperty(node, ContentModel.PROP_PUBLISHED, (Serializable)newPublished);
        this.nodeService.setProperty(node, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Forced change"));
        for (ChildAssociationRef ref : this.nodeService.getChildAssocs(node)) {
            this.pushCreatedDateBack(ref.getChildRef(), daysAgo);
        }
    }

    public void testCreateForumPost() throws Exception {
        String title = "test";
        String content = "test";
        JSONObject item = this.createSitePost(title, content, 200);
        DiscussionRestApiTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)0, (Object)item.get("replyCount"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("createdOn"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("modifiedOn"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("author"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("permissions"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("url"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("repliesUrl"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("nodeRef"));
        String name = item.getString("name");
        NodeRef nodeRef = new NodeRef(item.getString("nodeRef"));
        item = this.getPost(name, 200);
        DiscussionRestApiTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)0, (Object)item.get("replyCount"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("createdOn"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("modifiedOn"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("author"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("permissions"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("url"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("repliesUrl"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("nodeRef"));
        item = this.getPost(nodeRef, 200);
        DiscussionRestApiTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)0, (Object)item.get("replyCount"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("createdOn"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("modifiedOn"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("author"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("permissions"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("url"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("repliesUrl"));
        DiscussionRestApiTest.assertEquals((String)("Invalid JSON " + String.valueOf(item)), (boolean)true, (boolean)item.has("nodeRef"));
        title = "By Node Title";
        content = "By Node Content";
        item = this.createNodePost(this.FORUM_NODE, title, content, 200);
        DiscussionRestApiTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)0, (Object)item.get("replyCount"));
        nodeRef = new NodeRef(item.getString("nodeRef"));
        item = this.getPost(nodeRef, 200);
        DiscussionRestApiTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)0, (Object)item.get("replyCount"));
    }

    public void testUpdateForumPost() throws Exception {
        String title = "test";
        String content = "test";
        JSONObject item = this.createSitePost(title, content, 200);
        DiscussionRestApiTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)item.has("name"));
        String name = item.getString("name");
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)item.has("nodeRef"));
        NodeRef nodeRef = new NodeRef(item.getString("nodeRef"));
        item = this.getPost(item.getString("name"), 200);
        DiscussionRestApiTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        item = this.getPost(nodeRef, 200);
        DiscussionRestApiTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        String title2 = "updated test";
        String content2 = "test updated";
        item = this.updatePost(name, title2, content2, 200);
        DiscussionRestApiTest.assertEquals((Object)title2, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content2, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)name, (Object)item.get("name"));
        DiscussionRestApiTest.assertEquals((Object)nodeRef.toString(), (Object)item.get("nodeRef"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)item.getBoolean("isUpdated"));
        item = this.getPost(nodeRef, 200);
        DiscussionRestApiTest.assertEquals((Object)title2, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content2, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)name, (Object)item.get("name"));
        DiscussionRestApiTest.assertEquals((Object)nodeRef.toString(), (Object)item.get("nodeRef"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)item.getBoolean("isUpdated"));
        String title3 = "updated 3 test";
        String content3 = "test 3 updated";
        item = this.updatePost(nodeRef, title3, content3, 200);
        DiscussionRestApiTest.assertEquals((Object)title3, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content3, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)name, (Object)item.get("name"));
        DiscussionRestApiTest.assertEquals((Object)nodeRef.toString(), (Object)item.get("nodeRef"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)item.getBoolean("isUpdated"));
        item = this.getPost(nodeRef, 200);
        DiscussionRestApiTest.assertEquals((Object)title3, (Object)item.get("title"));
        DiscussionRestApiTest.assertEquals((Object)content3, (Object)item.get("content"));
        DiscussionRestApiTest.assertEquals((Object)name, (Object)item.get("name"));
        DiscussionRestApiTest.assertEquals((Object)nodeRef.toString(), (Object)item.get("nodeRef"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)item.getBoolean("isUpdated"));
    }

    public void testPermissions() throws Exception {
        JSONObject item = this.createSitePost("test", "test", 200);
        String name = item.getString("name");
        JSONObject perms = item.getJSONObject("permissions");
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)perms.getBoolean("edit"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)perms.getBoolean("reply"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)perms.getBoolean("delete"));
        item = this.getPost(name, 200);
        perms = item.getJSONObject("permissions");
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)perms.getBoolean("edit"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)perms.getBoolean("reply"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)perms.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        item = this.getPost(name, 200);
        perms = item.getJSONObject("permissions");
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)perms.getBoolean("edit"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)perms.getBoolean("reply"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)perms.getBoolean("delete"));
        this.siteService.removeMembership(SITE_SHORT_NAME_DISCUSSION, USER_TWO);
        item = this.getPost(name, 200);
        perms = item.getJSONObject("permissions");
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)perms.getBoolean("edit"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)perms.getBoolean("reply"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)perms.getBoolean("delete"));
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_DISCUSSION);
        siteInfo.setVisibility(SiteVisibility.PRIVATE);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.updateSite(siteInfo);
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(name, 404);
    }

    public void testViewReplyByDeletedUser() throws Exception {
        JSONObject item = this.createSitePost("test", "test", 200);
        String name = item.getString("name");
        NodeRef topicNodeRef = new NodeRef(item.getString("nodeRef"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.createReply(topicNodeRef, "Reply", "By the other user", 200);
        item = this.getReplies(name, 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)item.getJSONArray("items").length());
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.personService.deletePerson(USER_TWO);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        item = this.getReplies(name, 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)item.getJSONArray("items").length());
    }

    public void testAddReply() throws Exception {
        JSONObject item = this.createSitePost("test", "test", 200);
        String topicName = item.getString("name");
        NodeRef topicNodeRef = new NodeRef(item.getString("nodeRef"));
        JSONObject reply = this.createReply(topicNodeRef, "test", "test", 200);
        NodeRef replyNodeRef = new NodeRef(reply.getString("nodeRef"));
        DiscussionRestApiTest.assertEquals((String)"test", (String)reply.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"test", (String)reply.getString("content"));
        JSONObject reply2 = this.createReply(replyNodeRef, "test2", "test2", 200);
        NodeRef reply2NodeRef = new NodeRef(reply2.getString("nodeRef"));
        DiscussionRestApiTest.assertEquals((String)"test2", (String)reply2.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"test2", (String)reply2.getString("content"));
        DiscussionRestApiTest.assertEquals((Object)ForumModel.TYPE_TOPIC, (Object)this.nodeService.getType(topicNodeRef));
        DiscussionRestApiTest.assertEquals((Object)ForumModel.TYPE_POST, (Object)this.nodeService.getType(replyNodeRef));
        DiscussionRestApiTest.assertEquals((Object)ForumModel.TYPE_POST, (Object)this.nodeService.getType(reply2NodeRef));
        DiscussionRestApiTest.assertEquals((Object)topicNodeRef, (Object)this.nodeService.getPrimaryParent(replyNodeRef).getParentRef());
        DiscussionRestApiTest.assertEquals((Object)topicNodeRef, (Object)this.nodeService.getPrimaryParent(reply2NodeRef).getParentRef());
        DiscussionRestApiTest.assertEquals((int)0, (int)this.nodeService.getSourceAssocs(reply2NodeRef, RegexQNamePattern.MATCH_ALL).size());
        DiscussionRestApiTest.assertEquals((int)1, (int)this.nodeService.getTargetAssocs(reply2NodeRef, RegexQNamePattern.MATCH_ALL).size());
        DiscussionRestApiTest.assertEquals((Object)replyNodeRef, (Object)((AssociationRef)this.nodeService.getTargetAssocs(reply2NodeRef, RegexQNamePattern.MATCH_ALL).get(0)).getTargetRef());
        DiscussionRestApiTest.assertEquals((int)1, (int)this.nodeService.getSourceAssocs(replyNodeRef, RegexQNamePattern.MATCH_ALL).size());
        DiscussionRestApiTest.assertEquals((int)1, (int)this.nodeService.getTargetAssocs(replyNodeRef, RegexQNamePattern.MATCH_ALL).size());
        DiscussionRestApiTest.assertEquals((Object)reply2NodeRef, (Object)((AssociationRef)this.nodeService.getSourceAssocs(replyNodeRef, RegexQNamePattern.MATCH_ALL).get(0)).getSourceRef());
        JSONObject result = this.getReplies(topicNodeRef, 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        result = this.getReplies(topicName, 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        item = this.getPost(topicName, 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)item.getInt("totalReplyCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)item.getInt("replyCount"));
    }

    public void testUpdateReply() throws Exception {
        JSONObject item = this.createSitePost("test", "test", 200);
        String postName = item.getString("name");
        NodeRef postNodeRef = new NodeRef(item.getString("nodeRef"));
        DiscussionRestApiTest.assertEquals((String)"test", (String)item.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"test", (String)item.getString("content"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        JSONObject reply = this.createReply(postNodeRef, "rtest", "rtest", 200);
        NodeRef replyNodeRef = new NodeRef(reply.getString("nodeRef"));
        DiscussionRestApiTest.assertEquals((String)"rtest", (String)reply.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"rtest", (String)reply.getString("content"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)reply.getBoolean("isUpdated"));
        JSONObject reply2 = this.updatePost(replyNodeRef, "test2", "test2", 200);
        DiscussionRestApiTest.assertEquals((String)"test2", (String)reply2.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"test2", (String)reply2.getString("content"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)reply2.getBoolean("isUpdated"));
        reply2 = this.getPost(replyNodeRef, 200);
        DiscussionRestApiTest.assertEquals((String)"test2", (String)reply2.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"test2", (String)reply2.getString("content"));
        DiscussionRestApiTest.assertEquals((boolean)true, (boolean)reply2.getBoolean("isUpdated"));
        item = this.getPost(postName, 200);
        DiscussionRestApiTest.assertEquals((String)"test", (String)item.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"test", (String)item.getString("content"));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
    }

    public void testDeleteToplevelPost() throws Exception {
        JSONObject item1 = this.createSitePost("test1", "test1", 200);
        JSONObject item2 = this.createSitePost("test2", "test2", 200);
        String name1 = item1.getString("name");
        NodeRef nodeRef1 = new NodeRef(item1.getString("nodeRef"));
        NodeRef nodeRef2 = new NodeRef(item2.getString("nodeRef"));
        DiscussionRestApiTest.assertEquals((Object)ForumModel.TYPE_TOPIC, (Object)this.nodeService.getType(nodeRef1));
        DiscussionRestApiTest.assertEquals((Object)ForumModel.TYPE_TOPIC, (Object)this.nodeService.getType(nodeRef2));
        this.deletePost(name1, 200);
        this.getPost(name1, 404);
        this.deletePost(nodeRef2, 200);
        this.getPost(nodeRef2, 404);
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)this.nodeService.exists(nodeRef1));
        DiscussionRestApiTest.assertEquals((boolean)false, (boolean)this.nodeService.exists(nodeRef2));
    }

    public void testDeleteReplyPost() throws Exception {
        JSONObject item = this.createSitePost("test", "test", 200);
        String postName = item.getString("name");
        NodeRef postNodeRef = new NodeRef(item.getString("nodeRef"));
        DiscussionRestApiTest.assertEquals((int)0, (int)item.getInt("totalReplyCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)item.getInt("replyCount"));
        JSONObject reply = this.createReply(postNodeRef, "testR", "testR", 200);
        NodeRef replyNodeRef = new NodeRef(reply.getString("nodeRef"));
        String replyName = reply.getString("name");
        DiscussionRestApiTest.assertEquals((String)"testR", (String)reply.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"testR", (String)reply.getString("content"));
        reply = this.getPost(replyNodeRef, 200);
        DiscussionRestApiTest.assertEquals((String)"testR", (String)reply.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"testR", (String)reply.getString("content"));
        this.getPost(replyName, 404);
        item = this.getPost(postName, 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)item.getInt("totalReplyCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)item.getInt("replyCount"));
        this.deletePost(replyNodeRef, 200);
        reply = this.getPost(replyNodeRef, 200);
        DiscussionRestApiTest.assertEquals((Object)DELETED_REPLY_POST_MARKER, (Object)reply.get("title"));
        DiscussionRestApiTest.assertEquals((Object)DELETED_REPLY_POST_MARKER, (Object)reply.get("content"));
        item = this.getPost(postName, 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)item.getInt("totalReplyCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)item.getInt("replyCount"));
    }

    public void testListings() throws Exception {
        JSONObject result = this.getPosts(null, 200);
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        result = this.getPosts("hot", 200);
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        result = this.getPosts("mine", 200);
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        result = this.getPosts("new?numdays=100", 200);
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        result = this.getPosts(this.FORUM_NODE, null, 200);
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        result = this.getPosts(this.FORUM_NODE, "hot", 200);
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        result = this.getPosts(this.FORUM_NODE, "mine", 200);
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        result = this.getPosts(this.FORUM_NODE, "new?numdays=100", 200);
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        JSONObject item = this.createSitePost("SiteTitle1", "Content", 200);
        NodeRef siteTopic1 = new NodeRef(item.getString("nodeRef"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        item = this.createSitePost("SiteTitle2", "Content", 200);
        NodeRef siteTopic2 = new NodeRef(item.getString("nodeRef"));
        item = this.createNodePost(this.FORUM_NODE, "NodeTitle1", "Content", 200);
        NodeRef nodeTopic1 = new NodeRef(item.getString("nodeRef"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
        item = this.createNodePost(this.FORUM_NODE, "NodeTitle2", "Content", 200);
        NodeRef nodeTopic2 = new NodeRef(item.getString("nodeRef"));
        item = this.createNodePost(this.FORUM_NODE, "NodeTitle3", "Content", 200);
        NodeRef nodeTopic3 = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(siteTopic1, "Reply1a", "Content", 200);
        NodeRef siteReply1A = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(siteTopic1, "Reply1b", "Content", 200);
        NodeRef siteReply1B = new NodeRef(item.getString("nodeRef"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        item = this.createReply(siteTopic2, "Reply2a", "Content", 200);
        NodeRef siteReply2A = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(siteTopic2, "Reply2b", "Content", 200);
        NodeRef siteReply2B = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(siteTopic2, "Reply2c", "Content", 200);
        NodeRef siteReply2C = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(siteReply2A, "Reply2aa", "Content", 200);
        NodeRef siteReply2AA = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(siteReply2A, "Reply2ab", "Content", 200);
        NodeRef siteReply2AB = new NodeRef(item.getString("nodeRef"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
        item = this.createReply(siteReply2AA, "Reply2aaa", "Content", 200);
        NodeRef siteReply2AAA = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(nodeTopic1, "ReplyN1a", "Content", 200);
        NodeRef nodeReply1A = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(nodeReply1A, "ReplyN1aa", "Content", 200);
        NodeRef nodeReply1AA = new NodeRef(item.getString("nodeRef"));
        item = this.createReply(nodeReply1AA, "ReplyN1aaa", "Content", 200);
        NodeRef nodeReply1AAA = new NodeRef(item.getString("nodeRef"));
        result = this.getPosts(null, 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle1", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"SiteTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, null, 200);
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle1", (String)result.getJSONArray("items").getJSONObject(2).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle2", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle3", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").getJSONObject(2).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts("mine", 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle1", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, "mine", 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle3", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        result = this.getPosts("new?numdays=2", 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"SiteTitle1", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, "new?numdays=2", 200);
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle3", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle2", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle1", (String)result.getJSONArray("items").getJSONObject(2).getString("title"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").getJSONObject(2).getInt("replyCount"));
        result = this.getPosts("hot", 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"SiteTitle1", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, "hot", 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle1", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        this.pushCreatedDateBack(siteTopic1, 10);
        this.pushCreatedDateBack(siteReply1B, -2);
        this.pushCreatedDateBack(nodeTopic2, 10);
        this.pushCreatedDateBack(nodeTopic3, 4);
        this.pushCreatedDateBack(nodeReply1AAA, -1);
        result = this.getPosts(null, 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle1", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"SiteTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, null, 200);
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle2", (String)result.getJSONArray("items").getJSONObject(2).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle3", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle1", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(2).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts("new?numdays=2", 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, "new?numdays=6", 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle1", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle3", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, "new?numdays=2", 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle1", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts("mine", 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle1", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, "mine", 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"NodeTitle3", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)0, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        result = this.getPosts("hot", 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((String)"SiteTitle1", (String)result.getJSONArray("items").getJSONObject(1).getString("title"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getJSONArray("items").getJSONObject(1).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, "hot", 200);
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle1", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts("limit", 200);
        DiscussionRestApiTest.assertEquals((int)2, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"SiteTitle2", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
        result = this.getPosts(this.FORUM_NODE, "limit", 200);
        DiscussionRestApiTest.assertEquals((int)3, (int)result.getInt("total"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        DiscussionRestApiTest.assertEquals((String)"NodeTitle1", (String)result.getJSONArray("items").getJSONObject(0).getString("title"));
        DiscussionRestApiTest.assertEquals((int)1, (int)result.getJSONArray("items").getJSONObject(0).getInt("replyCount"));
    }

    public void testContributorCanEditReply() throws Exception {
        this.authenticationComponent.setCurrentUser(USER_ONE);
        JSONObject post = this.createSitePost("Can contributors edit replies?", "The title says it all", 200);
        NodeRef postNodeRef = new NodeRef(post.getString("nodeRef"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        JSONObject reply = this.createReply(postNodeRef, "", "Let's see.", 200);
        NodeRef replyNodeRef = new NodeRef(reply.getString("nodeRef"));
        this.updateComment(replyNodeRef, "", "Yes I can", 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        post = this.getPost(postNodeRef, 200);
        DiscussionRestApiTest.assertEquals((String)"Can contributors edit replies?", (String)post.getString("title"));
        DiscussionRestApiTest.assertEquals((String)"The title says it all", (String)post.getString("content"));
        DiscussionRestApiTest.assertEquals((int)1, (int)post.getInt("replyCount"));
        JSONObject replies = this.getReplies(postNodeRef, 200);
        JSONArray items = replies.getJSONArray("items");
        DiscussionRestApiTest.assertEquals((int)1, (int)items.length());
        reply = items.getJSONObject(0);
        DiscussionRestApiTest.assertEquals((String)"Yes I can", (String)reply.getString("content"));
    }

    public void testCreateForumPermission() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String siteName = SITE_SHORT_NAME_DISCUSSION + GUID.generate();
        this.siteService.createSite("ForumSitePreset", siteName, "SiteTitle", "SiteDescription", SiteVisibility.PUBLIC);
        String userName = USER_ONE + GUID.generate();
        this.createUser(userName, "SiteCollaborator", siteName);
        this.checkForumPermissions(siteName);
        this.authenticationComponent.setCurrentUser(userName);
        this.checkForumPermissions(siteName);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.deleteSite(siteName);
        this.authenticationComponent.setCurrentUser(userName);
        siteName = SITE_SHORT_NAME_DISCUSSION + GUID.generate();
        this.siteService.createSite("BlogSitePreset", siteName, "SiteTitle", "SiteDescription", SiteVisibility.PUBLIC);
        this.checkForumPermissions(siteName);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.checkForumPermissions(siteName);
        this.siteService.deleteSite(siteName);
        this.personService.deletePerson(userName);
    }

    private void checkForumPermissions(String siteName) throws Exception {
        String url = "/api/forum/site/" + siteName + "/discussions/posts";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        DiscussionRestApiTest.assertTrue((String)"The user sould have permission to create a new discussion.", (boolean)result.getJSONObject("forumPermissions").getBoolean("create"));
    }
}

