/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import org.alfresco.opencmis.CMISDispatcher;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.springframework.extensions.webscripts.WebScriptRequest;

public interface CMISDispatcherRegistry {
    public void registerDispatcher(Endpoint var1, CMISDispatcher var2);

    public CMISDispatcher getDispatcher(WebScriptRequest var1);

    public static class Endpoint {
        private Binding binding;
        private String version;

        public Endpoint(Binding binding, String version) {
            this.binding = binding;
            this.version = version;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.binding == null ? 0 : this.binding.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Endpoint other = (Endpoint)obj;
            if (this.binding != other.binding) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }

    public static enum Binding {
        atom,
        browser;


        public BindingType getOpenCmisBinding() {
            BindingType bindingType = null;
            if (this == atom) {
                bindingType = BindingType.ATOMPUB;
            } else if (this == browser) {
                bindingType = BindingType.BROWSER;
            }
            return bindingType;
        }
    }
}

