/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.MimeTypeUtil;
import org.alfresco.repo.web.scripts.content.StreamContent;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class ContentInfo
extends StreamContent {
    @Override
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        HashMap<String, String> args = new HashMap<String, String>(0, 1.0f);
        Map templateVars = req.getServiceMatch().getTemplateVars();
        StreamContent.ObjectReference reference = this.createObjectReferenceFromUrl(args, templateVars);
        NodeRef nodeRef = reference.getNodeRef();
        if (nodeRef == null) {
            throw new WebScriptException(404, "Unable to find " + reference.toString());
        }
        QName propertyQName = ContentModel.PROP_CONTENT;
        this.streamContent(req, res, nodeRef, propertyQName, false, null, null);
    }

    protected void streamContentImpl(WebScriptRequest req, WebScriptResponse res, ContentReader reader, NodeRef nodeRef, QName propertyQName, boolean attach, Date modified, String eTag, String attachFileName) throws IOException {
        this.delegate.setAttachment(req, res, attach, attachFileName);
        String mimetype = MimeTypeUtil.determineMimetype(reader, req, this.mimetypeService);
        res.setContentType(mimetype);
        res.setContentEncoding(reader.getEncoding());
        res.setHeader("Content-Length", Long.toString(reader.getSize()));
        Cache cache = new Cache();
        cache.setNeverCache(false);
        cache.setMustRevalidate(true);
        cache.setMaxAge(Long.valueOf(0L));
        cache.setLastModified(modified);
        cache.setETag(eTag);
        res.setCache(cache);
    }
}

