/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.resource.actions.interfaces.ResourceAction;

public class OperationResourceMetaData
extends ResourceMetadata {
    private final Method operationMethod;
    private final boolean noAuthRequired;

    public OperationResourceMetaData(String uniqueId, List<ResourceOperation> operations, Api api, Method operationMethod, boolean noAuthRequired) {
        super(uniqueId, ResourceMetadata.RESOURCE_TYPE.OPERATION, operations, api, null, null, null);
        if (operations.size() != 1) {
            throw new IllegalArgumentException("Only 1 operation per url is supported for an entity");
        }
        this.operationMethod = operationMethod;
        this.noAuthRequired = noAuthRequired;
    }

    public OperationResourceMetaData(String uniqueId, Api api, Set<Class<? extends ResourceAction>> apiDeleted, boolean noAuthRequired) {
        super(uniqueId, ResourceMetadata.RESOURCE_TYPE.OPERATION, null, api, apiDeleted, null, null);
        this.operationMethod = null;
        this.noAuthRequired = noAuthRequired;
    }

    public Method getOperationMethod() {
        return this.operationMethod;
    }

    @Override
    public boolean isNoAuth(Class<? extends ResourceAction> resourceAction) {
        return this.noAuthRequired;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OperationResourceMetaData [api=");
        builder.append(this.getApi());
        builder.append(", uniqueId=");
        builder.append(this.getUniqueId());
        builder.append(", type=");
        builder.append((Object)this.getType());
        builder.append(", parent=");
        builder.append(this.getParentResource());
        builder.append(", operations=");
        builder.append(this.getOperations());
        builder.append(", apiDeleted=");
        builder.append(this.getApiDeleted());
        builder.append(", operationMethod=").append(this.operationMethod);
        builder.append(", noAuthRequired=").append(this.noAuthRequired);
        builder.append("]");
        return builder.toString();
    }
}

