/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.LockInfoImpl;
import org.alfresco.repo.webdav.LockInfoImplTest;
import org.alfresco.repo.webdav.WebDAVLockServiceImpl;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WebDAVLockServiceImplTest {
    private WebDAVLockServiceImpl davLockService;
    @Mock
    private HttpSession session;
    @Mock
    private List<Pair<String, NodeRef>> sessionList;
    @Mock
    private AuthenticationUtil authenticationUtil;
    @Mock
    private TransactionService transactionService;
    @Mock
    private RetryingTransactionHelper txHelper;
    @Mock
    private NodeService nodeService;
    @Mock
    private LockService lockService;
    @Mock
    private CheckOutCheckInService cociService;
    private NodeRef nodeRef1;
    private NodeRef nodeRef2;
    private LockInfoImpl lockInfo1;
    private LockState lockState1;
    private LockInfoImpl lockInfo2;
    private LockState lockState2;

    @Before
    public void setUp() throws Exception {
        this.davLockService = new WebDAVLockServiceImpl();
        this.davLockService.setNodeService(this.nodeService);
        this.davLockService.setCheckOutCheckInService(this.cociService);
        this.davLockService.setCurrentSession(this.session);
        this.davLockService.setLockService(this.lockService);
        this.nodeRef1 = new NodeRef("workspace://SpacesStore/f6e3f82a-cfef-445b-9fca-7986a14181cc");
        this.lockInfo1 = new LockInfoImplTest.LockInfoImplEx();
        this.lockState1 = LockState.createLock((NodeRef)this.nodeRef1, (LockType)LockType.WRITE_LOCK, (String)"user1", null, (Lifetime)Lifetime.EPHEMERAL, null);
        Mockito.when((Object)this.lockService.getLockState(this.nodeRef1)).thenReturn((Object)this.lockState1);
        this.nodeRef2 = new NodeRef("workspace://SpacesStore/a6a4371c-99b9-4618-8cd2-e71d7d96aa87");
        this.lockInfo2 = new LockInfoImplTest.LockInfoImplEx();
        this.lockInfo2.setExclusiveLockToken("a-random-token");
        this.lockInfo2.setDepth("infinity");
        this.lockInfo2.setScope("exclusive");
        this.lockState2 = LockState.createLock((NodeRef)this.nodeRef2, (LockType)LockType.WRITE_LOCK, (String)"user2", (Date)new Date(999L), (Lifetime)Lifetime.EPHEMERAL, (String)this.lockInfo2.toJSON());
        Mockito.when((Object)this.lockService.getLockState(this.nodeRef2)).thenReturn((Object)this.lockState2);
        Mockito.when((Object)this.session.getAttribute("_webdavLockedResources")).thenReturn(this.sessionList);
        this.authenticationUtil = new AuthenticationUtil();
        this.authenticationUtil.afterPropertiesSet();
        AuthenticationUtil.setFullyAuthenticatedUser((String)"some_user_name");
        Mockito.when((Object)this.txHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class), ArgumentMatchers.anyBoolean())).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                RetryingTransactionHelper.RetryingTransactionCallback callback = (RetryingTransactionHelper.RetryingTransactionCallback)args[0];
                callback.execute();
                return null;
            }
        });
        Mockito.when((Object)this.transactionService.getRetryingTransactionHelper()).thenReturn((Object)this.txHelper);
        this.davLockService.setTransactionService(this.transactionService);
    }

    @Test
    public void testSessionDestroyed() {
        ArrayList<Pair> lockedNodes = new ArrayList<Pair>(2);
        lockedNodes.add(new Pair((Object)"some_user_name", (Object)this.nodeRef1));
        lockedNodes.add(new Pair((Object)"another_user_name", (Object)this.nodeRef2));
        Mockito.when((Object)this.sessionList.size()).thenReturn((Object)2);
        Mockito.when(this.sessionList.iterator()).thenReturn(lockedNodes.iterator());
        Mockito.when((Object)this.nodeService.exists(this.nodeRef1)).thenReturn((Object)true);
        Mockito.when((Object)this.nodeService.exists(this.nodeRef2)).thenReturn((Object)true);
        Mockito.when((Object)this.lockService.getLockStatus(this.nodeRef1)).thenReturn((Object)LockStatus.LOCKED);
        Mockito.when((Object)this.lockService.getLockStatus(this.nodeRef2)).thenReturn((Object)LockStatus.LOCKED);
        NodeRef wcNodeRef2 = new NodeRef("workspace://SpacesStore/a6e3f82a-cfef-363d-9fca-3986a14180a0");
        Mockito.when((Object)this.cociService.getWorkingCopy(this.nodeRef2)).thenReturn((Object)wcNodeRef2);
        this.davLockService.sessionDestroyed();
        ((LockService)Mockito.verify((Object)this.lockService)).unlock(this.nodeRef1);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.never())).unlock(this.nodeRef2);
    }

    @Test
    public void lockLessThan24Hours() {
        this.lockInfo1.setTimeoutSeconds(100);
        this.davLockService.lock(this.nodeRef1, (LockInfo)this.lockInfo1);
        ((LockService)Mockito.verify((Object)this.lockService)).lock(this.nodeRef1, LockType.WRITE_LOCK, 100, Lifetime.EPHEMERAL, this.lockInfo1.toJSON());
        Assert.assertEquals((long)86500000L, (long)this.lockInfo1.getExpires().getTime());
    }

    @Test
    public void lockGreaterThan24Hours() {
        int timeout25hours = 90000;
        this.lockInfo1.setTimeoutSeconds(timeout25hours);
        this.davLockService.lock(this.nodeRef1, (LockInfo)this.lockInfo1);
        ((LockService)Mockito.verify((Object)this.lockService)).lock(this.nodeRef1, LockType.WRITE_LOCK, 86400, Lifetime.EPHEMERAL, this.lockInfo1.toJSON());
        ((List)Mockito.verify(this.sessionList)).add(new Pair((Object)"some_user_name", (Object)this.nodeRef1));
        Assert.assertEquals((long)86400L, (long)this.lockInfo1.getRemainingTimeoutSeconds());
    }

    @Test
    public void lockForInfinityTime() {
        this.lockInfo1.setTimeoutSeconds(-1);
        this.davLockService.lock(this.nodeRef1, (LockInfo)this.lockInfo1);
        ((LockService)Mockito.verify((Object)this.lockService)).lock(this.nodeRef1, LockType.WRITE_LOCK, 86400, Lifetime.EPHEMERAL, this.lockInfo1.toJSON());
        ((List)Mockito.verify(this.sessionList)).add(new Pair((Object)"some_user_name", (Object)this.nodeRef1));
        Assert.assertEquals((long)86400L, (long)this.lockInfo1.getRemainingTimeoutSeconds());
    }

    @Test
    public void canUnlock() {
        this.davLockService.unlock(this.nodeRef1);
        ((LockService)Mockito.verify((Object)this.lockService)).unlock(this.nodeRef1);
        ((List)Mockito.verify(this.sessionList)).remove(new Pair((Object)"some_user_name", (Object)this.nodeRef1));
    }

    @Test
    public void canGetLockInfo() {
        NodeRef nodeRef3 = new NodeRef("workspace://SpacesStore/a6a4371c-99b9-4618-8cd2-e71d28374859");
        Mockito.when((Object)this.lockService.getLockState(this.nodeRef1)).thenReturn((Object)this.lockState1);
        Mockito.when((Object)this.lockService.getLockState(this.nodeRef2)).thenReturn((Object)this.lockState2);
        Mockito.when((Object)this.lockService.getLockState(nodeRef3)).thenReturn(null);
        LockInfo lockInfo = this.davLockService.getLockInfo(this.nodeRef1);
        Assert.assertEquals(null, (Object)lockInfo.getExpires());
        Assert.assertEquals((Object)"user1", (Object)lockInfo.getOwner());
        lockInfo = this.davLockService.getLockInfo(this.nodeRef2);
        Assert.assertEquals((Object)new Date(999L), (Object)lockInfo.getExpires());
        Assert.assertEquals((Object)"user2", (Object)lockInfo.getOwner());
        Assert.assertEquals((Object)"a-random-token", (Object)lockInfo.getExclusiveLockToken());
        Assert.assertEquals((Object)"infinity", (Object)lockInfo.getDepth());
        Assert.assertEquals((Object)"exclusive", (Object)lockInfo.getScope());
        lockInfo = this.davLockService.getLockInfo(nodeRef3);
        Assert.assertEquals(null, (Object)lockInfo);
    }

    @Test
    public void mnt13183LockInfo() {
        this.lockService.lock(this.nodeRef1, LockType.WRITE_LOCK, 3600, Lifetime.EPHEMERAL, "lock_info_that_is_not_from_webdav");
        LockInfo lockInfoNodeRef1 = this.davLockService.getLockInfo(this.nodeRef1);
        Assert.assertNull((String)"exclusiveLockToken is null", (Object)lockInfoNodeRef1.getExclusiveLockToken());
        String user = AuthenticationUtil.getFullyAuthenticatedUser();
        this.davLockService.lock(this.nodeRef2, user, 3600);
        LockState lockState2 = this.lockService.getLockState(this.nodeRef2);
        Assert.assertNotNull((String)"lockState is not null", (Object)lockState2);
        String additionalInfo2 = lockState2.getAdditionalInfo();
        Assert.assertNotNull((String)"additionalInfo is not null", (Object)additionalInfo2);
        Assert.assertTrue((String)"Check WEBDAV_LOCK marker", (boolean)additionalInfo2.startsWith("WebDAV_LockInfo"));
    }
}

