/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.query.ListBackedPagingResults;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.tagging.NonExistentTagException;
import org.alfresco.repo.tagging.TagExistsException;
import org.alfresco.repo.tagging.TaggingException;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.Tags;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Tag;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.framework.resource.parameters.where.QueryImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.util.Pair;
import org.alfresco.util.TypeConstraint;
import org.apache.commons.collections.CollectionUtils;

public class TagsImpl
implements Tags {
    public static final String PARAM_INCLUDE_COUNT = "count";
    private static final String PARAM_WHERE_TAG = "tag";
    static final String NOT_A_VALID_TAG = "An invalid parameter has been supplied";
    static final String NO_PERMISSION_TO_MANAGE_A_TAG = "Current user does not have permission to manage a tag";
    private Nodes nodes;
    private NodeService nodeService;
    private TaggingService taggingService;
    private TypeConstraint typeConstraint;
    private AuthorityService authorityService;

    public void setTypeConstraint(TypeConstraint typeConstraint) {
        this.typeConstraint = typeConstraint;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    @Override
    public List<Tag> addTags(String nodeId, List<Tag> tags, Parameters parameters) {
        NodeRef nodeRef = this.nodes.validateOrLookupNode(nodeId);
        if (!this.typeConstraint.matches(nodeRef)) {
            throw new UnsupportedResourceOperationException("Cannot tag this node");
        }
        List tagValues = tags.stream().map(Tag::getTag).collect(Collectors.toList());
        try {
            List tagNodeRefs = this.taggingService.addTags(nodeRef, tagValues);
            ArrayList<Tag> ret = new ArrayList<Tag>(tags.size());
            List tagsCountPairList = this.taggingService.findTaggedNodesAndCountByTagName(nodeRef.getStoreRef());
            Map<String, Long> tagsCountMap = tagsCountPairList.stream().collect(Collectors.toMap(Pair::getFirst, pair -> (long)((Integer)pair.getSecond())));
            for (Pair pair2 : tagNodeRefs) {
                Tag createdTag = new Tag((NodeRef)pair2.getSecond(), (String)pair2.getFirst());
                if (parameters.getInclude().contains(PARAM_INCLUDE_COUNT)) {
                    createdTag.setCount(Optional.ofNullable(tagsCountMap.get(createdTag.getTag())).orElse(0L) + 1L);
                }
                ret.add(createdTag);
            }
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    public void deleteTag(String nodeId, String tagId) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        this.getTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, tagId, null);
        NodeRef existingTagNodeRef = this.validateTag(tagId);
        String tagValue = this.taggingService.getTagName(existingTagNodeRef);
        this.taggingService.removeTag(nodeRef, tagValue);
    }

    @Override
    public void deleteTagById(StoreRef storeRef, String tagId) {
        this.verifyAdminAuthority();
        NodeRef tagNodeRef = this.validateTag(storeRef, tagId);
        String tagValue = this.taggingService.getTagName(tagNodeRef);
        this.taggingService.deleteTag(storeRef, tagValue);
    }

    @Override
    public CollectionWithPagingInfo<Tag> getTags(StoreRef storeRef, Parameters params) {
        Paging paging = params.getPaging();
        Pair sorting = !params.getSorting().isEmpty() ? new Pair((Object)params.getSorting().get((int)0).column, (Object)params.getSorting().get((int)0).asc) : null;
        Map<Integer, Collection<String>> namesFilters = this.resolveTagNamesQuery(params.getQuery());
        Map results = this.taggingService.getTags(storeRef, params.getInclude(), sorting, namesFilters.get(8), namesFilters.get(20));
        List<Tag> tagsList = results.entrySet().stream().map(entry -> new Tag((NodeRef)entry.getKey(), (String)((Object)this.nodeService.getProperty((NodeRef)entry.getKey(), ContentModel.PROP_NAME)))).collect(Collectors.toList());
        if (params.getInclude().contains(PARAM_INCLUDE_COUNT)) {
            tagsList.forEach(tag -> tag.setCount((Long)results.get(tag.getNodeRef())));
        }
        ListBackedPagingResults listBackedPagingResults = new ListBackedPagingResults(tagsList, Util.getPagingRequest(params.getPaging()));
        return CollectionWithPagingInfo.asPaged(paging, listBackedPagingResults.getPage(), listBackedPagingResults.hasMoreItems(), (Integer)listBackedPagingResults.getTotalResultCount().getFirst());
    }

    public NodeRef validateTag(String tagId) {
        NodeRef tagNodeRef = this.nodes.validateNode(tagId);
        return this.checkTagRootAsNodePrimaryParent(tagId, tagNodeRef);
    }

    public NodeRef validateTag(StoreRef storeRef, String tagId) {
        NodeRef tagNodeRef = this.nodes.validateNode(storeRef, tagId);
        return this.checkTagRootAsNodePrimaryParent(tagId, tagNodeRef);
    }

    private Long findCountIfRequested(StoreRef storeRef, String tagName, Parameters parameters) {
        Long count = null;
        if (parameters != null && parameters.getInclude() != null && parameters.getInclude().contains(PARAM_INCLUDE_COUNT)) {
            count = this.taggingService.findCountByTagName(storeRef, tagName);
        }
        return count;
    }

    @Override
    public Tag changeTag(StoreRef storeRef, String tagId, Tag tag, Parameters parameters) {
        try {
            NodeRef existingTagNodeRef = this.validateTag(storeRef, tagId);
            String existingTagName = this.taggingService.getTagName(existingTagNodeRef);
            Long count = this.findCountIfRequested(storeRef, existingTagName, parameters);
            String newTagName = tag.getTag();
            NodeRef newTagNodeRef = this.taggingService.changeTag(storeRef, existingTagName, newTagName);
            return Tag.builder().nodeRef(newTagNodeRef).tag(newTagName).count(count).create();
        }
        catch (NonExistentTagException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (TagExistsException e) {
            throw new ConstraintViolatedException(e.getMessage());
        }
        catch (TaggingException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    public Tag getTag(StoreRef storeRef, String tagId, Parameters parameters) {
        NodeRef tagNodeRef = this.validateTag(storeRef, tagId);
        String tagName = this.taggingService.getTagName(tagNodeRef);
        Long count = this.findCountIfRequested(storeRef, tagName, parameters);
        return Tag.builder().nodeRef(tagNodeRef).tag(tagName).count(count).create();
    }

    @Override
    public CollectionWithPagingInfo<Tag> getTags(String nodeId, Parameters params) {
        NodeRef nodeRef = this.nodes.validateOrLookupNode(nodeId);
        PagingResults results = this.taggingService.getTags(nodeRef, Util.getPagingRequest(params.getPaging()));
        Integer totalItems = (Integer)results.getTotalResultCount().getFirst();
        List page = results.getPage();
        ArrayList<Tag> tags = new ArrayList<Tag>(page.size());
        for (Pair pair : page) {
            tags.add(new Tag((NodeRef)pair.getFirst(), (String)pair.getSecond()));
        }
        return CollectionWithPagingInfo.asPaged(params.getPaging(), tags, results.hasMoreItems(), totalItems == null ? null : Integer.valueOf(totalItems));
    }

    @Override
    public List<Tag> createTags(StoreRef storeRef, List<Tag> tags, Parameters parameters) {
        this.verifyAdminAuthority();
        List tagNames = Optional.ofNullable(tags).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(Tag::getTag).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tagNames)) {
            throw new InvalidArgumentException(NOT_A_VALID_TAG);
        }
        return this.taggingService.createTags(storeRef, tagNames).stream().map(pair -> Tag.builder().tag((String)pair.getFirst()).nodeRef((NodeRef)pair.getSecond()).create()).peek(tag -> {
            if (parameters.getInclude().contains(PARAM_INCLUDE_COUNT)) {
                tag.setCount(0L);
            }
        }).collect(Collectors.toList());
    }

    private void verifyAdminAuthority() {
        if (!this.authorityService.hasAdminAuthority()) {
            throw new PermissionDeniedException(NO_PERMISSION_TO_MANAGE_A_TAG);
        }
    }

    private Map<Integer, Collection<String>> resolveTagNamesQuery(Query namesQuery) {
        if (namesQuery == null || namesQuery == QueryImpl.EMPTY) {
            return Collections.emptyMap();
        }
        Map<Integer, Collection<String>> properties = QueryHelper.resolve(namesQuery).usingOrOperator().withoutNegations().getProperty(PARAM_WHERE_TAG).getExpectedValuesForAnyOf(8, 16, 20).skipNegated();
        return properties.entrySet().stream().collect(Collectors.groupingBy(entry -> {
            if ((Integer)entry.getKey() == 8 || (Integer)entry.getKey() == 16) {
                return 8;
            }
            return 20;
        }, Collectors.flatMapping(entry -> ((Collection)entry.getValue()).stream().map(String::toLowerCase), Collectors.toCollection(HashSet::new))));
    }

    private NodeRef checkTagRootAsNodePrimaryParent(String tagId, NodeRef tagNodeRef) {
        if (tagNodeRef == null || !this.nodeService.getPrimaryParent(tagNodeRef).getParentRef().equals((Object)TaggingService.TAG_ROOT_NODE_REF)) {
            throw new EntityNotFoundException(tagId);
        }
        return tagNodeRef;
    }
}

