/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.LockInfoImpl;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVLockService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebDAVLockServiceImpl
implements WebDAVLockService {
    private static final String LOCKED_RESOURCES = "_webdavLockedResources";
    private static Log logger = LogFactory.getLog(WebDAVLockServiceImpl.class);
    private static ThreadLocal<HttpSession> currentSession = new ThreadLocal();
    private LockService lockService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private CheckOutCheckInService checkOutCheckInService;

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    @Override
    public void setCurrentSession(HttpSession session) {
        currentSession.set(session);
    }

    @Override
    public void sessionDestroyed() {
        HttpSession session = currentSession.get();
        if (session == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Couldn't find current session.");
            }
            return;
        }
        List lockedResources = (List)session.getAttribute(LOCKED_RESOURCES);
        if (lockedResources != null && lockedResources.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + lockedResources.size() + " locked resources for session: " + session.getId()));
            }
            for (Pair lockedResource : lockedResources) {
                String runAsUser = (String)lockedResource.getFirst();
                final NodeRef nodeRef = (NodeRef)lockedResource.getSecond();
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        return (Void)WebDAVLockServiceImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                block10: {
                                    if (WebDAVLockServiceImpl.this.nodeService.exists(nodeRef)) {
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Trying to release lock for: " + String.valueOf(nodeRef)));
                                        }
                                        LockStatus lockStatus = WebDAVLockServiceImpl.this.lockService.getLockStatus(nodeRef);
                                        boolean hasWorkingCopy = WebDAVLockServiceImpl.this.checkOutCheckInService.getWorkingCopy(nodeRef) != null;
                                        boolean isWorkingCopy = WebDAVLockServiceImpl.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
                                        if ((lockStatus.equals((Object)LockStatus.LOCKED) || lockStatus.equals((Object)LockStatus.LOCK_OWNER)) && !hasWorkingCopy && !isWorkingCopy) {
                                            try {
                                                WebDAVLockServiceImpl.this.lockService.unlock(nodeRef);
                                                if (logger.isDebugEnabled()) {
                                                    logger.debug((Object)("Lock was successfully released for: " + String.valueOf(nodeRef)));
                                                }
                                                break block10;
                                            }
                                            catch (Exception e) {
                                                if (logger.isDebugEnabled()) {
                                                    logger.debug((Object)("Unable to unlock " + String.valueOf(nodeRef) + " cause: " + e.getMessage()));
                                                }
                                                break block10;
                                            }
                                        }
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Skip lock releasing for: " + String.valueOf(nodeRef) + " as it is not locked or is checked out"));
                                        }
                                    } else if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Skip lock releasing for an unexisting node: " + String.valueOf(nodeRef)));
                                    }
                                }
                                return null;
                            }
                        }, WebDAVLockServiceImpl.this.transactionService.isReadOnly());
                    }
                }, (String)(runAsUser == null ? AuthenticationUtil.getSystemUserName() : runAsUser));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No locked resources were found for session: " + session.getId()));
        }
    }

    @Override
    public void lock(NodeRef nodeRef, LockInfo lockInfo) {
        int timeout = (int)lockInfo.getRemainingTimeoutSeconds();
        this.lock(nodeRef, lockInfo, timeout);
    }

    @Override
    public void lock(NodeRef nodeRef, String userName, int timeout) {
        LockInfo lockInfo = this.createLock(nodeRef, userName, true);
        this.lock(nodeRef, lockInfo, timeout);
    }

    @Override
    public void lock(NodeRef nodeRef, LockInfo lockInfo, int timeout) {
        boolean performSessionBehavior = false;
        if (timeout > 86400 || timeout == -1) {
            timeout = 86400;
            performSessionBehavior = true;
        }
        this.validateLockTimeout(timeout);
        this.lockInner(nodeRef, lockInfo, timeout);
        if (performSessionBehavior) {
            this.performLockSessionBehavior(nodeRef);
        }
    }

    private void validateLockTimeout(int timeout) {
        if (timeout != -1 && timeout == 0) {
            throw new IllegalArgumentException("Timeout == 0 is treated as permanence for locks. For maximum allowed timeout set -1");
        }
    }

    private void lockInner(NodeRef nodeRef, LockInfo lockInfo, int timeout) {
        lockInfo.setTimeoutSeconds(timeout);
        String additionalInfo = lockInfo.toJSON();
        this.lockService.lock(nodeRef, LockType.WRITE_LOCK, timeout, Lifetime.EPHEMERAL, additionalInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(nodeRef) + " was locked for " + timeout + " seconds."));
        }
    }

    private void performLockSessionBehavior(NodeRef nodeRef) {
        HttpSession session = currentSession.get();
        if (session == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Couldn't find current session.");
            }
            return;
        }
        WebDAVLockServiceImpl.storeObjectInSessionList(session, LOCKED_RESOURCES, new Pair((Object)AuthenticationUtil.getRunAsUser(), (Object)nodeRef));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(nodeRef) + " was added to the session " + session.getId() + " for post expiration processing."));
        }
    }

    @Override
    public void unlock(NodeRef nodeRef) {
        HttpSession session;
        this.lockService.unlock(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(nodeRef) + " was unlocked."));
        }
        if ((session = currentSession.get()) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Couldn't find current session.");
            }
            return;
        }
        boolean removed = WebDAVLockServiceImpl.removeObjectFromSessionList(session, LOCKED_RESOURCES, new Pair((Object)AuthenticationUtil.getRunAsUser(), (Object)nodeRef));
        if (removed && logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(nodeRef) + " was removed from the session " + session.getId()));
        }
    }

    @Override
    public LockInfo getLockInfo(NodeRef nodeRef) {
        LockInfo lockInfo = null;
        LockState lockState = this.lockService.getLockState(nodeRef);
        if (lockState != null) {
            String additionalInfo = lockState.getAdditionalInfo();
            try {
                lockInfo = LockInfoImpl.fromJSON(additionalInfo);
            }
            catch (IllegalArgumentException e) {
                lockInfo = new LockInfoImpl();
            }
            lockInfo.setExpires(lockState.getExpires());
            lockInfo.setOwner(lockState.getOwner());
        }
        return lockInfo;
    }

    @Override
    public boolean isLockedAndReadOnly(NodeRef nodeRef) {
        return this.lockService.isLockedAndReadOnly(nodeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void storeObjectInSessionList(HttpSession session, String listName, Object object) {
        ArrayList<Object> list = null;
        Object object2 = session;
        synchronized (object2) {
            list = (ArrayList<Object>)session.getAttribute(listName);
            if (list == null) {
                list = new ArrayList<Object>();
                session.setAttribute(listName, list);
            }
        }
        object2 = list;
        synchronized (object2) {
            if (!list.contains(object)) {
                list.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean removeObjectFromSessionList(HttpSession session, String listName, Object object) {
        List list = null;
        Object object2 = session;
        synchronized (object2) {
            list = (List)session.getAttribute(listName);
        }
        if (list == null) {
            return false;
        }
        object2 = list;
        synchronized (object2) {
            return list.remove(object);
        }
    }

    private LockInfo createLock(NodeRef nodeRef, String userName, boolean createExclusive) {
        String lockToken = WebDAV.makeLockToken(nodeRef, userName);
        LockInfoImpl lockInfo = new LockInfoImpl();
        if (createExclusive) {
            lockInfo.setExclusiveLockToken(lockToken);
        } else {
            lockInfo.addSharedLockToken(lockToken);
        }
        lockInfo.setDepth(WebDAV.getDepthName(-1));
        String scope = createExclusive ? "exclusive" : "shared";
        lockInfo.setScope(scope);
        lockInfo.setOwner(userName);
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!currentUser.equals(userName)) {
            throw new IllegalStateException("Node is being locked for user " + userName + " by (different/current) user " + currentUser);
        }
        return lockInfo;
    }
}

