/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.search.SearchEngineResultSet;
import org.alfresco.repo.search.impl.solr.SolrJSONResultSet;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericBucket;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericFacetResponse;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.ListMetric;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.Metric;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.PercentileMetric;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.SimpleMetric;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.rest.api.DeletedNodes;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.NodesImpl;
import org.alfresco.rest.api.lookups.PersonPropertyLookup;
import org.alfresco.rest.api.lookups.PropertyLookupRegistry;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.api.nodes.NodeVersionsRelation;
import org.alfresco.rest.api.search.SerializerTestHelper;
import org.alfresco.rest.api.search.context.FacetFieldContext;
import org.alfresco.rest.api.search.context.FacetQueryContext;
import org.alfresco.rest.api.search.context.SearchContext;
import org.alfresco.rest.api.search.context.SearchRequestContext;
import org.alfresco.rest.api.search.context.SpellCheckContext;
import org.alfresco.rest.api.search.impl.ResultMapper;
import org.alfresco.rest.api.search.impl.SearchMapper;
import org.alfresco.rest.api.search.impl.StoreMapper;
import org.alfresco.rest.api.search.model.HighlightEntry;
import org.alfresco.rest.api.search.model.SearchQuery;
import org.alfresco.rest.api.search.model.SearchSQLQuery;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.FieldHighlightParameters;
import org.alfresco.service.cmr.search.GeneralHighlightParameters;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ResultMapperTests {
    static ResultMapper mapper;
    static SearchMapper searchMapper;
    public static final String JSON_REPONSE = "{\"responseHeader\":{\"status\":0,\"QTime\":9},\"_original_parameters_\":\"org.apache.solr.common.params.DefaultSolrParams:{params(df=TEXT&alternativeDic=DEFAULT_DICTIONARY&fl=DBID,score&start=0&fq={!afts}AUTHORITY_FILTER_FROM_JSON&fq={!afts}TENANT_FILTER_FROM_JSON&rows=1000&locale=en_US&wt=json),defaults(carrot.url=id&spellcheck.collateExtendedResults=true&carrot.produceSummary=true&spellcheck.maxCollations=3&spellcheck.maxCollationTries=5&spellcheck.alternativeTermCount=2&spellcheck.extendedResults=false&defType=afts&spellcheck.maxResultsForSuggest=5&spellcheck=false&carrot.outputSubClusters=false&spellcheck.count=5&carrot.title=mltext@m___t@{http://www.alfresco.org/model/content/1.0}title&carrot.snippet=content@s___t@{http://www.alfresco.org/model/content/1.0}content&spellcheck.collate=true)}\",\"_field_mappings_\":{},\"_date_mappings_\":{},\"_range_mappings_\":{},\"_pivot_mappings_\":{},\"_interval_mappings_\":{},\"_stats_field_mappings_\":{},\"_stats_facet_mappings_\":{},\"_facet_function_mappings_\":{},\"response\":{\"numFound\":6,\"start\":0,\"maxScore\":0.7849362,\"docs\":[{\"DBID\":565,\"score\":0.7849362},{\"DBID\":566,\"score\":0.7849362},{\"DBID\":521,\"score\":0.3540957},{\"DBID\":514,\"score\":0.33025497},{\"DBID\":420,\"score\":0.32440513},{\"DBID\":415,\"score\":0.2780319}]},\"facet_counts\":{\"facet_queries\":{\"small\":0,\"large\":0,\"xtra small\":3,\"xtra large\":0,\"medium\":8,\"XX large\":0},\"facet_fields\":{\"content.size\":[\"Big\",8,\"Brown\",3,\"Fox\",5,\"Jumped\",2,\"somewhere\",3]},\"facet_dates\":{},\"facet_ranges\":{\"created\": { \"counts\": [\"2015-09-29T10:45:15.729Z\",0,\"2016-01-07T10:45:15.729Z\",0,\"2016-04-16T10:45:15.729Z\",0,\"2016-07-25T10:45:15.729Z\",0],\"gap\": \"+100DAY\",\"start\": \"2015-09-29T10:45:15.729Z\",\"end\": \"2016-11-02T10:45:15.729Z\"},\"content.size\": {\"counts\": [\"0\",4,\"100\",6,\"200\",3],\"gap\": 100,\"start\": 0,\"end\": 300}},\"facet_pivot\":{\"creator,modifier\":[{\"field\":\"creator\",\"count\":7,\"pivot\":[{\"field\":\"modifier\",\"count\":3,\"value\":\"mjackson\"},{\"field\":\"modifier\",\"count\":4,\"value\":\"admin\"}],\"value\":\"mjackson\"}]},\"facet_intervals\":{\"creator\":{\"last\":4,\"first\":0},\"TheCreated\":{\"earlier\":5,\"lastYear\":0,\"currentYear\":854}}},\"spellcheck\":{\"searchInsteadFor\":\"alfresco\"},\"highlighting\": {  \"_DEFAULT_!800001579e3d1964!800001579e3d1969\": {\"name\": [\"some very <al>long<fresco> name\"],\"title\": [\"title1 is very <al>long<fresco>\"], \"DBID\": \"521\"}, \"_DEFAULT_!800001579e3d1964!800001579e3d196a\": {\"name\": [\"this is some <al>long<fresco> text.  It\", \" has the word <al>long<fresco> in many places\", \".  In fact, it has <al>long<fresco> on some\", \" happens to <al>long<fresco> in this case.\"], \"DBID\": \"1475846153692\"}},\"stats\":{\"stats_fields\":{\"numericLabel\":{\"sumOfSquares\":0,\"min\":null,\"max\":null,\"mean\":\"NaN\",\"percentiles\":[\"0.0\",12,\"0.99\",20.0685], \"count\":0,\"missing\":0,\"sum\":0,\"distinctValues\":[12,13,14,15,16,17,1],\"stddev\":0}, \"creator\":{\"min\":\"System\",\"max\":\"mjackson\",\"count\":\"990\",\"missing\":\"290\"}, \"created\":{\"sumOfSquares\":2.1513045770343806E27,\"min\":\"2011-02-15T20:16:27.080Z\",\"max\":\"2017-04-10T15:06:30.143Z\",\"mean\":\"2016-09-05T04:20:12.898Z\",\"count\":990,\"missing\":290,\"sum\":1.458318720769983E15,\"stddev\":5.6250677994522545E10}}},\"processedDenies\":true, \"lastIndexedTx\":34}";
    public static final Params EMPTY_PARAMS;
    public static final String FROZEN_ID = "frozen";
    public static final String FROZEN_VER = "1.1";
    private static final long VERSIONED_ID = 521L;
    private static SerializerTestHelper helper;
    private static NodesImpl nodes;

    @BeforeClass
    public static void setupTests() {
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        mapUserInfo.put(AuthenticationUtil.getSystemUserName(), new UserInfo(AuthenticationUtil.getSystemUserName(), "sys", "sys"));
        HashMap nodeProps = new HashMap();
        nodes = (NodesImpl)Mockito.mock(NodesImpl.class);
        ServiceRegistry sr = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        DeletedNodes deletedNodes = (DeletedNodes)Mockito.mock(DeletedNodes.class);
        nodes.setServiceRegistry(sr);
        VersionService versionService = (VersionService)Mockito.mock(VersionService.class);
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", "ver desc");
        versionProperties.put("versionType", "v type");
        Mockito.when((Object)versionHistory.getVersion(ArgumentMatchers.anyString())).thenAnswer(invocation -> new VersionImpl(versionProperties, new NodeRef(StoreMapper.STORE_REF_VERSION2_SPACESSTORE, GUID.generate())));
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        Mockito.when((Object)versionService.getVersionHistory((NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn((Object)versionHistory);
        Mockito.when((Object)nodeService.getProperties((NodeRef)ArgumentMatchers.any(NodeRef.class))).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            NodeRef aNode = (NodeRef)args[0];
            if (StoreMapper.STORE_REF_VERSION2_SPACESSTORE.equals((Object)aNode.getStoreRef())) {
                nodeProps.put(Version2Model.PROP_QNAME_FROZEN_NODE_REF, new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, FROZEN_ID + aNode.getId()));
                nodeProps.put(Version2Model.PROP_QNAME_VERSION_LABEL, FROZEN_VER);
            }
            return nodeProps;
        });
        Mockito.when((Object)sr.getVersionService()).thenReturn((Object)versionService);
        Mockito.when((Object)sr.getNodeService()).thenReturn((Object)nodeService);
        Mockito.when((Object)nodes.validateOrLookupNode((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.nullable(String.class))).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            String aNode = (String)args[0];
            if (aNode.endsWith("521")) {
                throw new EntityNotFoundException("521");
            }
            return new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, aNode);
        });
        Mockito.when((Object)nodes.getFolderOrDocument((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.nullable(NodeRef.class), (QName)ArgumentMatchers.nullable(QName.class), (List)ArgumentMatchers.nullable(List.class), (Map)ArgumentMatchers.nullable(Map.class))).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            NodeRef aNode = (NodeRef)args[0];
            if (StoreRef.STORE_REF_ARCHIVE_SPACESSTORE.equals((Object)aNode.getStoreRef())) {
                return null;
            }
            return new Node(aNode, (NodeRef)args[1], nodeProps, mapUserInfo, sr);
        });
        Mockito.when((Object)deletedNodes.getDeletedNode((String)ArgumentMatchers.nullable(String.class), (Parameters)ArgumentMatchers.nullable(Parameters.class), ArgumentMatchers.anyBoolean(), (Map)ArgumentMatchers.nullable(Map.class))).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            String nodeId = (String)args[0];
            if (FROZEN_ID.equals(nodeId)) {
                throw new EntityNotFoundException(nodeId);
            }
            NodeRef aNode = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, nodeId);
            return new Node(aNode, new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, "unknown"), nodeProps, mapUserInfo, sr);
        });
        PersonPropertyLookup propertyLookups = (PersonPropertyLookup)Mockito.mock(PersonPropertyLookup.class);
        Mockito.when((Object)propertyLookups.supports()).thenReturn(Stream.of("creator", "modifier").collect(Collectors.toSet()));
        Mockito.when((Object)propertyLookups.lookup((String)ArgumentMatchers.notNull(String.class))).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            String value = (String)args[0];
            return "mjackson".equals(value) ? "Michael Jackson" : null;
        });
        PropertyLookupRegistry propertyLookupRegistry = new PropertyLookupRegistry();
        propertyLookupRegistry.setLookups(Arrays.asList(propertyLookups));
        mapper = new ResultMapper();
        mapper.setNodes((Nodes)nodes);
        mapper.setStoreMapper(new StoreMapper());
        mapper.setPropertyLookup(propertyLookupRegistry);
        mapper.setDeletedNodes(deletedNodes);
        mapper.setServiceRegistry(sr);
        NodeVersionsRelation nodeVersionsRelation = new NodeVersionsRelation();
        nodeVersionsRelation.setNodes((Nodes)nodes);
        nodeVersionsRelation.setServiceRegistry(sr);
        nodeVersionsRelation.afterPropertiesSet();
        mapper.setNodeVersions(nodeVersionsRelation);
        helper = new SerializerTestHelper();
        searchMapper.setStoreMapper(new StoreMapper());
    }

    @Test
    public void testNoResults() {
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)SearchQuery.EMPTY);
        CollectionWithPagingInfo collection = mapper.toCollectionWithPagingInfo(EMPTY_PARAMS, searchRequest, null, (ResultSet)new EmptyResultSet());
        TestCase.assertNotNull((Object)collection);
        TestCase.assertFalse((boolean)collection.hasMoreItems());
        TestCase.assertTrue((collection.getTotalItems() < 1 ? 1 : 0) != 0);
        TestCase.assertNull((Object)collection.getContext());
    }

    @Test
    @Ignore(value="Disabled MNT-25404 - Invalid test. Assumes multi-store search.")
    public void testToCollectionWithPagingInfo() {
        ResultSet results = this.mockResultSet(Arrays.asList(514L), Arrays.asList(566L, 521L));
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)SearchQuery.EMPTY);
        CollectionWithPagingInfo collectionWithPage = mapper.toCollectionWithPagingInfo(EMPTY_PARAMS, searchRequest, SearchQuery.EMPTY, results);
        TestCase.assertNotNull((Object)collectionWithPage);
        Long found = results.getNumberFound();
        TestCase.assertEquals((int)found.intValue(), (int)collectionWithPage.getTotalItems());
        Node firstNode = (Node)collectionWithPage.getCollection().stream().findFirst().get();
        TestCase.assertNotNull((Object)firstNode.getSearch().getScore());
        TestCase.assertEquals((String)"nodes", (String)firstNode.getLocation());
        collectionWithPage.getCollection().stream().forEach(aNode -> {
            List high = aNode.getSearch().getHighlight();
            if (high != null) {
                TestCase.assertEquals((int)2, (int)high.size());
                HighlightEntry first = (HighlightEntry)high.get(0);
                TestCase.assertNotNull((Object)first.getField());
                TestCase.assertNotNull((Object)first.getSnippets());
            }
        });
        TestCase.assertEquals((long)1L, (long)collectionWithPage.getCollection().stream().filter(node -> "deleted-nodes".equals(node.getLocation())).count());
        TestCase.assertEquals((long)1L, (long)collectionWithPage.getCollection().stream().filter(node -> "versions".equals(node.getLocation())).count());
    }

    @Test
    public void testToSearchContext() {
        ResultSet results = this.mockResultSet(Collections.emptyList(), Collections.emptyList());
        SearchQuery searchQuery = helper.searchQueryFromJson();
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        searchMapper.toSearchParameters(EMPTY_PARAMS, searchQuery, searchRequest);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertEquals((long)34L, (long)searchContext.getConsistency().getlastTxId());
        TestCase.assertEquals((int)6, (int)searchContext.getFacetQueries().size());
        TestCase.assertEquals((int)0, (int)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getCount());
        TestCase.assertEquals((String)"cm:created:bob", (String)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getFilterQuery());
        TestCase.assertEquals((String)"small", (String)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getLabel());
        TestCase.assertEquals((String)"searchInsteadFor", (String)searchContext.getSpellCheck().getType());
        TestCase.assertEquals((int)1, (int)searchContext.getSpellCheck().getSuggestions().size());
        TestCase.assertEquals((String)"alfresco", (String)((String)searchContext.getSpellCheck().getSuggestions().get(0)));
        TestCase.assertEquals((int)1, (int)searchContext.getFacetsFields().size());
        TestCase.assertEquals((String)"content.size", (String)((FacetFieldContext)searchContext.getFacetsFields().get(0)).getLabel());
        List intervalFacets = searchContext.getFacets().stream().filter(f -> f.getType().equals((Object)GenericFacetResponse.FACET_TYPE.interval)).collect(Collectors.toList());
        TestCase.assertEquals((int)2, (int)intervalFacets.size());
        TestCase.assertEquals((String)"creator", (String)((GenericFacetResponse)intervalFacets.get(0)).getLabel());
        TestCase.assertEquals((String)"last", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(0)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"cm:creator:<\"a\" TO \"b\"]", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(0)).getBuckets().get(0)).getFilterQuery());
        Metric[] metrics = ((GenericBucket)((GenericFacetResponse)intervalFacets.get(0)).getBuckets().get(0)).getMetrics().toArray(new Metric[((GenericBucket)((GenericFacetResponse)intervalFacets.get(0)).getBuckets().get(0)).getMetrics().size()]);
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)metrics[0].getType());
        TestCase.assertEquals((Object)"4", metrics[0].getValue().get("count"));
        TestCase.assertNotNull((Object)searchContext.getRequest());
        TestCase.assertEquals((String)"great", (String)searchContext.getRequest().getQuery().getUserQuery());
        TestCase.assertEquals((int)7, (int)searchContext.getFacets().size());
        GenericFacetResponse pivotFacet = (GenericFacetResponse)searchContext.getFacets().get(4);
        TestCase.assertEquals((Object)GenericFacetResponse.FACET_TYPE.pivot, (Object)pivotFacet.getType());
        TestCase.assertEquals((String)"creator", (String)pivotFacet.getLabel());
        TestCase.assertEquals((int)2, (int)pivotFacet.getBuckets().size());
        GenericBucket pivotBucket = (GenericBucket)pivotFacet.getBuckets().get(1);
        TestCase.assertEquals((String)"mjackson", (String)pivotBucket.getLabel());
        TestCase.assertEquals((String)"creator:\"mjackson\"", (String)pivotBucket.getFilterQuery());
        metrics = pivotBucket.getMetrics().toArray(new Metric[pivotBucket.getMetrics().size()]);
        TestCase.assertEquals((String)"{count=7}", (String)metrics[0].getValue().toString());
        TestCase.assertEquals((int)1, (int)pivotBucket.getFacets().size());
        GenericFacetResponse nestedFacet = (GenericFacetResponse)pivotBucket.getFacets().get(0);
        TestCase.assertEquals((Object)GenericFacetResponse.FACET_TYPE.pivot, (Object)nestedFacet.getType());
        TestCase.assertEquals((String)"mylabel", (String)nestedFacet.getLabel());
        TestCase.assertEquals((int)2, (int)nestedFacet.getBuckets().size());
        GenericBucket nestedBucket = (GenericBucket)nestedFacet.getBuckets().get(0);
        TestCase.assertEquals((String)"mjackson", (String)nestedBucket.getLabel());
        TestCase.assertEquals((String)"modifier:\"mjackson\"", (String)nestedBucket.getFilterQuery());
        metrics = nestedBucket.getMetrics().toArray(new Metric[nestedBucket.getMetrics().size()]);
        TestCase.assertEquals((String)"{count=3}", (String)metrics[0].getValue().toString());
        GenericBucket nestedBucket2 = (GenericBucket)nestedFacet.getBuckets().get(1);
        TestCase.assertEquals((String)"admin", (String)nestedBucket2.getLabel());
        TestCase.assertEquals((String)"modifier:\"admin\"", (String)nestedBucket2.getFilterQuery());
        metrics = nestedBucket2.getMetrics().toArray(new Metric[nestedBucket2.getMetrics().size()]);
        TestCase.assertEquals((String)"{count=4}", (String)metrics[0].getValue().toString());
        GenericFacetResponse statsFacet = (GenericFacetResponse)searchContext.getFacets().get(5);
        TestCase.assertEquals((Object)GenericFacetResponse.FACET_TYPE.stats, (Object)statsFacet.getType());
        TestCase.assertEquals((String)"created", (String)statsFacet.getLabel());
        Set statsMetrics = ((GenericBucket)statsFacet.getBuckets().get(0)).getMetrics();
        TestCase.assertEquals((int)8, (int)statsMetrics.size());
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.sumOfSquares, (Object)BigDecimal.valueOf(2.1513045770343806E27))));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.min, (Object)"2011-02-15T20:16:27.080Z")));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.max, (Object)"2017-04-10T15:06:30.143Z")));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.mean, (Object)"2016-09-05T04:20:12.898Z")));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.countValues, (Object)990)));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.missing, (Object)290)));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.sum, (Object)BigDecimal.valueOf(1.458318720769983E15))));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.stddev, (Object)BigDecimal.valueOf(5.6250677994522545E10))));
        statsFacet = (GenericFacetResponse)searchContext.getFacets().get(6);
        TestCase.assertEquals((String)"numericLabel", (String)statsFacet.getLabel());
        statsMetrics = ((GenericBucket)statsFacet.getBuckets().get(0)).getMetrics();
        TestCase.assertEquals((int)7, (int)statsMetrics.size());
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.sumOfSquares, (Object)0)));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.countValues, (Object)0)));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.missing, (Object)0)));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.sum, (Object)0)));
        TestCase.assertTrue((boolean)statsMetrics.contains(new SimpleMetric(Metric.METRIC_TYPE.stddev, (Object)0)));
        JSONArray dVals = new JSONArray(Arrays.asList(12, 13, 14, 15, 16, 17, 1));
        TestCase.assertTrue((boolean)statsMetrics.contains(new ListMetric(Metric.METRIC_TYPE.distinctValues, (Object)dVals)));
        JSONArray pers = new JSONArray(Arrays.asList("0.99", 20.0685, "0.0", 12.0));
        TestCase.assertTrue((boolean)statsMetrics.contains(new PercentileMetric(Metric.METRIC_TYPE.percentiles, (Object)pers)));
        TestCase.assertEquals((String)"min must be excluded because its null", (long)0L, (long)statsMetrics.stream().filter(metric -> Metric.METRIC_TYPE.min.equals((Object)metric.getType())).count());
        TestCase.assertEquals((String)"max must be excluded because its null", (long)0L, (long)statsMetrics.stream().filter(metric -> Metric.METRIC_TYPE.max.equals((Object)metric.getType())).count());
        TestCase.assertEquals((String)"mean must be excluded because its NaN", (long)0L, (long)statsMetrics.stream().filter(metric -> Metric.METRIC_TYPE.mean.equals((Object)metric.getType())).count());
    }

    @Test
    public void testIsNullContext() {
        TestCase.assertTrue((boolean)mapper.isNullContext(new SearchContext(0L, null, null, null, null, null)));
        TestCase.assertFalse((boolean)mapper.isNullContext(new SearchContext(1L, null, null, null, null, null)));
        TestCase.assertFalse((boolean)mapper.isNullContext(new SearchContext(0L, null, null, null, new SpellCheckContext(null, null), null)));
        TestCase.assertFalse((boolean)mapper.isNullContext(new SearchContext(0L, null, Arrays.asList(new FacetQueryContext(null, null, 0)), null, null, null)));
        TestCase.assertFalse((boolean)mapper.isNullContext(new SearchContext(0L, null, null, Arrays.asList(new FacetFieldContext(null, null)), null, null)));
        TestCase.assertFalse((boolean)mapper.isNullContext(new SearchContext(0L, Arrays.asList(new GenericFacetResponse(null, null, null)), null, null, null, null)));
    }

    @Test
    public void testHighlight() {
        SearchParameters sp = new SearchParameters();
        sp.setBulkFetchEnabled(false);
        GeneralHighlightParameters highlightParameters = new GeneralHighlightParameters(null, null, null, null, null, null, null, null);
        sp.setHighlight(highlightParameters);
        TestCase.assertNull((Object)sp.getHighlight().getMergeContiguous());
        TestCase.assertNull((Object)sp.getHighlight().getFields());
        ArrayList<FieldHighlightParameters> fields = new ArrayList<FieldHighlightParameters>(2);
        fields.add(new FieldHighlightParameters(null, null, null, null, null, null));
        fields.add(new FieldHighlightParameters("myfield", null, null, null, "(", ")"));
        highlightParameters = new GeneralHighlightParameters(Integer.valueOf(1), Integer.valueOf(2), null, null, null, Integer.valueOf(50), Boolean.valueOf(true), fields);
        sp.setHighlight(highlightParameters);
        TestCase.assertEquals((int)2, (int)sp.getHighlight().getFields().size());
        TestCase.assertEquals((boolean)true, (boolean)sp.getHighlight().getUsePhraseHighlighter());
        TestCase.assertEquals((int)1, (int)sp.getHighlight().getSnippetCount());
        TestCase.assertEquals((int)50, (int)sp.getHighlight().getMaxAnalyzedChars());
        TestCase.assertEquals((int)2, (int)sp.getHighlight().getFragmentSize());
        TestCase.assertEquals((String)"myfield", (String)((FieldHighlightParameters)sp.getHighlight().getFields().get(1)).getField());
        TestCase.assertEquals((String)"(", (String)((FieldHighlightParameters)sp.getHighlight().getFields().get(1)).getPrefix());
        TestCase.assertEquals((String)")", (String)((FieldHighlightParameters)sp.getHighlight().getFields().get(1)).getPostfix());
    }

    @Test
    public void testInterval() {
        ResultSet results = this.mockResultSet(Collections.emptyList(), Collections.emptyList());
        SearchQuery searchQuery = helper.searchQueryFromJson();
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        List intervalFacets = searchContext.getFacets().stream().filter(f -> f.getType().equals((Object)GenericFacetResponse.FACET_TYPE.interval)).collect(Collectors.toList());
        TestCase.assertEquals((int)2, (int)intervalFacets.size());
        TestCase.assertEquals((String)"creator", (String)((GenericFacetResponse)intervalFacets.get(0)).getLabel());
        TestCase.assertEquals((String)"last", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(0)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"cm:creator:<\"a\" TO \"b\"]", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(0)).getBuckets().get(0)).getFilterQuery());
        Object[] metrics = ((GenericBucket)((GenericFacetResponse)intervalFacets.get(0)).getBuckets().get(0)).getMetrics().toArray();
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)((SimpleMetric)metrics[0]).getType());
        TestCase.assertEquals((Object)"4", ((SimpleMetric)metrics[0]).getValue().get("count"));
        metrics = ((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(0)).getMetrics().toArray();
        TestCase.assertEquals((String)"TheCreated", (String)((GenericFacetResponse)intervalFacets.get(1)).getLabel());
        TestCase.assertEquals((String)"earlier", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"cm:created:[\"*\" TO \"2016\">", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)((SimpleMetric)metrics[0]).getType());
        TestCase.assertEquals((Object)"5", ((SimpleMetric)metrics[0]).getValue().get("count"));
        metrics = ((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(1)).getMetrics().toArray();
        TestCase.assertEquals((String)"lastYear", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(1)).getLabel());
        TestCase.assertEquals((String)"cm:created:[\"2016\" TO \"2017\">", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(1)).getFilterQuery());
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)((SimpleMetric)metrics[0]).getType());
        TestCase.assertEquals((Object)"0", ((SimpleMetric)metrics[0]).getValue().get("count"));
        metrics = ((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(2)).getMetrics().toArray();
        TestCase.assertEquals((String)"currentYear", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(2)).getLabel());
        TestCase.assertEquals((String)"cm:created:[\"NOW/YEAR\" TO \"NOW/YEAR+1YEAR\"]", (String)((GenericBucket)((GenericFacetResponse)intervalFacets.get(1)).getBuckets().get(2)).getFilterQuery());
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)((SimpleMetric)metrics[0]).getType());
        TestCase.assertEquals((Object)"854", ((SimpleMetric)metrics[0]).getValue().get("count"));
    }

    @Test
    public void testRange() {
        ResultSet results = this.mockResultSet(Collections.emptyList(), Collections.emptyList());
        SearchQuery searchQuery = helper.searchQueryFromJson();
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        List rangeFacets = searchContext.getFacets().stream().filter(f -> f.getType().equals((Object)GenericFacetResponse.FACET_TYPE.range)).collect(Collectors.toList());
        TestCase.assertEquals((int)2, (int)rangeFacets.size());
        TestCase.assertEquals((int)4, (int)((GenericFacetResponse)rangeFacets.get(0)).getBuckets().size());
        TestCase.assertEquals((String)"created", (String)((GenericFacetResponse)rangeFacets.get(0)).getLabel());
        TestCase.assertEquals((String)"[2015-09-29T10:45:15.729Z - 2016-01-07T10:45:15.729Z)", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(0)).getBuckets().get(0)).getLabel());
        Object[] metrics1 = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(0)).getBuckets().get(0)).getMetrics().toArray();
        TestCase.assertEquals((Object)"0", ((SimpleMetric)metrics1[0]).getValue().get("count"));
        TestCase.assertEquals((String)"created:[\"2015-09-29T10:45:15.729Z\" TO \"2016-01-07T10:45:15.729Z\">", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(0)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertEquals(null, (String)((String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(0)).getBuckets().get(0)).getBucketInfo().get("count")));
        TestCase.assertEquals((String)"false", (String)((String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(0)).getBuckets().get(0)).getBucketInfo().get("endInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(0)).getBuckets().get(0)).getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((int)3, (int)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().size());
        TestCase.assertEquals((String)"content.size", (String)((GenericFacetResponse)rangeFacets.get(1)).getLabel());
        TestCase.assertEquals((String)"[0 - 100)", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getLabel());
        Object[] metrics = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getMetrics().toArray();
        TestCase.assertEquals((Object)"4", ((SimpleMetric)metrics[0]).getValue().get("count"));
        TestCase.assertEquals((String)"content.size:[\"0\" TO \"100\">", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertEquals(null, (String)((String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getBucketInfo().get("count")));
        Map facetInfo = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getBucketInfo();
        TestCase.assertEquals((String)"0", (String)((String)facetInfo.get("start")));
        TestCase.assertEquals((String)"100", (String)((String)facetInfo.get("end")));
        TestCase.assertEquals((String)"[100 - 200)", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(1)).getLabel());
        metrics = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(1)).getMetrics().toArray();
        TestCase.assertEquals((Object)"6", ((SimpleMetric)metrics[0]).getValue().get("count"));
        facetInfo = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(1)).getBucketInfo();
        TestCase.assertEquals((String)"100", (String)((String)facetInfo.get("start")));
        TestCase.assertEquals((String)"200", (String)((String)facetInfo.get("end")));
        TestCase.assertEquals((String)"content.size:[\"100\" TO \"200\">", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(1)).getFilterQuery());
        TestCase.assertEquals(null, (String)((String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(1)).getBucketInfo().get("count")));
        TestCase.assertEquals((String)"false", (String)((String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getBucketInfo().get("endInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getBucketInfo().get("startInclusive")));
        TestCase.assertEquals((String)"[200 - 300)", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(2)).getLabel());
        metrics = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(2)).getMetrics().toArray();
        TestCase.assertEquals((Object)"3", ((SimpleMetric)metrics[0]).getValue().get("count"));
        facetInfo = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(2)).getBucketInfo();
        TestCase.assertEquals((String)"200", (String)((String)facetInfo.get("start")));
        TestCase.assertEquals((String)"300", (String)((String)facetInfo.get("end")));
        TestCase.assertEquals((String)"content.size:[\"200\" TO \"300\">", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(2)).getFilterQuery());
    }

    @Test
    public void testRangeExclusiec() {
        ResultSet results = this.mockResultSet(Collections.emptyList(), Collections.emptyList());
        String updatedJSON = "{ \"query\": {\"query\": \"g*\",\"userQuery\": \"great\",\"language\": \"afts\"}, \"paging\": {\"maxItems\": \"99\",\"skipCount\": \"4\"},\"includeRequest\": true,\"sort\": {\"type\": \"FIELD\",\"field\": \"cm:title\",\"ascending\": \"true\"},\"templates\": [{\"name\": \"mytemp\",\"template\": \"ATEMP\"}, {\"name\": \"yourtemp\",\"template\": \"%cm:content\"}],\"defaults\": {\"namespace\": \"namesp\",\"defaultFieldName\": \"myfield\",\"defaultFTSOperator\": \"AND\", \"textAttributes\": [\"roy\", \"king\"]},\"filterQueries\": [{\"query\": \"myquery\",\"tags\": [\"tag1\", \"tag2\"]},{\"query\": \"myquery2\"}],\"facetFields\": {\"facets\": [{\"field\": \"cm:creator\",\"prefix\": \"myquery2\",\"sort\": \"COUNT\",\"missing\": \"false\"}, {\"field\": \"modifier\",\"label\": \"mylabel\",\"method\": \"FC\",\"mincount\": \"5\"}, {\"field\": \"owner\",\"label\": \"ownerLabel\"}]},\"facetQueries\": [{\"query\": \"cm:created:bob\",\"label\": \"small\"}],\"pivots\": [{\"key\": \"mylabel\"}],\"ranges\": [{\"field\": \"content.size\",\"start\": \"0\",\"end\": \"300\",\"gap\": \"100\",\"include\":[\"lower\"]}],\"facetIntervals\": {\"sets\": [{ \"label\": \"king\", \"start\": \"1\", \"end\": \"2\",\"startInclusive\": true,\"endInclusive\": false}],\"intervals\": [{\"field\": \"cm:creator\",\"label\": \"creator\",\"sets\": [{\"label\": \"last\",\"start\": \"a\",\"end\": \"b\",\"startInclusive\": false}]},{\"label\":\"TheCreated\",\"field\":\"cm:created\",\"sets\":[{\"label\":\"lastYear\",\"start\":\"2016\",\"end\":\"2017\",\"endInclusive\":false},{\"label\":\"currentYear\",\"start\":\"NOW/YEAR\",\"end\":\"NOW/YEAR+1YEAR\"},{\"label\":\"earlier\",\"start\":\"*\",\"end\":\"2016\",\"endInclusive\":false}]}]},\"stats\": [{\"field\": \"cm:creator\", \"label\": \"mylabel\"}],\"spellcheck\": {\"query\": \"alfrezco\"},\"limits\": {\"permissionEvaluationCount\": \"2000\",\"permissionEvaluationTime\": \"5000\"},\"scope\": { \"locations\": [\"nodes\"]},\"fields\": [\"id\", \"name\"],\"highlight\": {\"prefix\": \"[\",\"postfix\": \"]\",\"snippetCount\": \"20\",\"fragmentSize\": \"10\",\"mergeContiguous\": \"true\",\"maxAnalyzedChars\": \"40\", \"usePhraseHighlighter\": \"true\",\"fields\": [  {\"field\": \"my\", \"snippetCount\": \"23\", \"fragmentSize\": \"5\", \"mergeContiguous\": \"true\", \"prefix\": \"?\", \"postfix\": \"\u00a1\"  },  {\"field\": \"your\", \"snippetCount\": \"3\", \"fragmentSize\": \"15\", \"mergeContiguous\": \"false\", \"prefix\": \"(\", \"postfix\": \")\"  }  ] },\"include\": [\"aspectNames\", \"properties\"]}".replace("lower", "upper");
        SearchQuery searchQuery = helper.extractFromJson(updatedJSON);
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        List rangeFacets = searchContext.getFacets().stream().filter(f -> f.getType().equals((Object)GenericFacetResponse.FACET_TYPE.range)).collect(Collectors.toList());
        TestCase.assertEquals((int)2, (int)rangeFacets.size());
        TestCase.assertEquals((int)4, (int)((GenericFacetResponse)rangeFacets.get(0)).getBuckets().size());
        TestCase.assertEquals((int)3, (int)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().size());
        TestCase.assertEquals((String)"content.size", (String)((GenericFacetResponse)rangeFacets.get(1)).getLabel());
        TestCase.assertEquals((String)"(0 - 100]", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getLabel());
        Object[] metrics = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getMetrics().toArray();
        TestCase.assertEquals((Object)"4", ((SimpleMetric)metrics[0]).getValue().get("count"));
        TestCase.assertEquals((String)"content.size:<\"0\" TO \"100\"]", (String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertEquals(null, (String)((String)((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getBucketInfo().get("count")));
        Map facetInfo = ((GenericBucket)((GenericFacetResponse)rangeFacets.get(1)).getBuckets().get(0)).getBucketInfo();
        TestCase.assertEquals((String)"0", (String)((String)facetInfo.get("start")));
        TestCase.assertEquals((String)"100", (String)((String)facetInfo.get("end")));
        TestCase.assertEquals((String)"false", (String)((String)facetInfo.get("startInclusive")));
        TestCase.assertEquals((String)"true", (String)((String)facetInfo.get("endInclusive")));
    }

    @Test
    public void testFacetingGroupResponse() {
        String jsonQuery = "{\"query\": {\"query\": \"alfresco\"},\"facetQueries\": [{\"query\": \"content.size:[o TO 102400]\", \"label\": \"small\",\"group\":\"foo\"},{\"query\": \"content.size:[102400 TO 1048576]\", \"label\": \"medium\",\"group\":\"foo\"},{\"query\": \"content.size:[1048576 TO 16777216]\", \"label\": \"large\",\"group\":\"foo\"}]}";
        String expectedResponse = "{\"responseHeader\":{\"status\":0,\"QTime\":9},\"_original_parameters_\":\"org.apache.solr.common.params.DefaultSolrParams:{params(df=TEXT&alternativeDic=DEFAULT_DICTIONARY&fl=DBID,score&start=0&fq={!afts}AUTHORITY_FILTER_FROM_JSON&fq={!afts}TENANT_FILTER_FROM_JSON&rows=1000&locale=en_US&wt=json),defaults(carrot.url=id&spellcheck.collateExtendedResults=true&carrot.produceSummary=true&spellcheck.maxCollations=3&spellcheck.maxCollationTries=5&spellcheck.alternativeTermCount=2&spellcheck.extendedResults=false&defType=afts&spellcheck.maxResultsForSuggest=5&spellcheck=false&carrot.outputSubClusters=false&spellcheck.count=5&carrot.title=mltext@m___t@{http://www.alfresco.org/model/content/1.0}title&carrot.snippet=content@s___t@{http://www.alfresco.org/model/content/1.0}content&spellcheck.collate=true)}\",\"_field_mappings_\":{},\"_date_mappings_\":{},\"_range_mappings_\":{},\"_pivot_mappings_\":{},\"_interval_mappings_\":{},\"_stats_field_mappings_\":{},\"_stats_facet_mappings_\":{},\"_facet_function_mappings_\":{},\"response\":{\"numFound\":6,\"start\":0,\"maxScore\":0.7849362,\"docs\":[{\"DBID\":565,\"score\":0.7849362},{\"DBID\":566,\"score\":0.7849362},{\"DBID\":521,\"score\":0.3540957},{\"DBID\":514,\"score\":0.33025497},{\"DBID\":420,\"score\":0.32440513},{\"DBID\":415,\"score\":0.2780319}]},\"spellcheck\":{\"searchInsteadFor\":\"alfresco\"},\"facet_counts\":{\"facet_queries\": {\"small\": 52,\"large\": 0,\"medium\": 0}},\"processedDenies\":true, \"lastIndexedTx\":34}";
        ResultSet results = this.mockResultSet(expectedResponse);
        SearchQuery searchQuery = helper.extractFromJson(jsonQuery);
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertEquals((long)34L, (long)searchContext.getConsistency().getlastTxId());
        TestCase.assertEquals(null, (Object)searchContext.getFacetQueries());
        TestCase.assertEquals((int)1, (int)searchContext.getFacets().size());
        TestCase.assertEquals((int)3, (int)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().size());
        TestCase.assertEquals((String)"small", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"content.size:[o TO 102400]", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertFalse((boolean)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().isEmpty());
        Metric[] metrics = ((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().toArray(new Metric[((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().size()]);
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)metrics[0].getType());
        TestCase.assertEquals((String)"{count=52}", (String)metrics[0].getValue().toString());
    }

    @Test
    public void testFacetingGroupResponseV1() {
        String jsonQuery = "{\"query\": {\"query\": \"alfresco\"}, \"facetFormat\":\"V1\",\"facetQueries\": [{\"query\": \"content.size:[o TO 102400]\", \"label\": \"small\"},{\"query\": \"content.size:[102400 TO 1048576]\", \"label\": \"medium\",\"group\":\"foo\"},{\"query\": \"content.size:[1048576 TO 16777216]\", \"label\": \"large\"}]}";
        String expectedResponse = "{\"responseHeader\":{\"status\":0,\"QTime\":9},\"_original_parameters_\":\"org.apache.solr.common.params.DefaultSolrParams:{params(df=TEXT&alternativeDic=DEFAULT_DICTIONARY&fl=DBID,score&start=0&fq={!afts}AUTHORITY_FILTER_FROM_JSON&fq={!afts}TENANT_FILTER_FROM_JSON&rows=1000&locale=en_US&wt=json),defaults(carrot.url=id&spellcheck.collateExtendedResults=true&carrot.produceSummary=true&spellcheck.maxCollations=3&spellcheck.maxCollationTries=5&spellcheck.alternativeTermCount=2&spellcheck.extendedResults=false&defType=afts&spellcheck.maxResultsForSuggest=5&spellcheck=false&carrot.outputSubClusters=false&spellcheck.count=5&carrot.title=mltext@m___t@{http://www.alfresco.org/model/content/1.0}title&carrot.snippet=content@s___t@{http://www.alfresco.org/model/content/1.0}content&spellcheck.collate=true)}\",\"_field_mappings_\":{},\"_date_mappings_\":{},\"_range_mappings_\":{},\"_pivot_mappings_\":{},\"_interval_mappings_\":{},\"_stats_field_mappings_\":{},\"_stats_facet_mappings_\":{},\"_facet_function_mappings_\":{},\"response\":{\"numFound\":6,\"start\":0,\"maxScore\":0.7849362,\"docs\":[{\"DBID\":565,\"score\":0.7849362},{\"DBID\":566,\"score\":0.7849362},{\"DBID\":521,\"score\":0.3540957},{\"DBID\":514,\"score\":0.33025497},{\"DBID\":420,\"score\":0.32440513},{\"DBID\":415,\"score\":0.2780319}]},\"spellcheck\":{\"searchInsteadFor\":\"alfresco\"},\"facet_counts\":{\"facet_queries\": {\"small\": 52,\"large\": 0,\"medium\": 0}},\"processedDenies\":true, \"lastIndexedTx\":34}";
        ResultSet results = this.mockResultSet(expectedResponse);
        SearchQuery searchQuery = helper.extractFromJson(jsonQuery);
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertEquals((long)34L, (long)searchContext.getConsistency().getlastTxId());
        TestCase.assertEquals(null, (Object)searchContext.getFacetQueries());
        TestCase.assertEquals((int)2, (int)searchContext.getFacets().size());
        TestCase.assertEquals((int)2, (int)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().size());
        TestCase.assertEquals((String)"small", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"content.size:[o TO 102400]", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertFalse((boolean)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().isEmpty());
        Metric[] metrics = ((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().toArray(new Metric[((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().size()]);
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)metrics[0].getType());
        TestCase.assertEquals((String)"{count=52}", (String)metrics[0].getValue().toString());
    }

    @Test
    public void testFacetQueryWithoutGroupResponse() {
        String jsonQuery = "{\"query\": {\"query\": \"alfresco\"},\"facetQueries\": [{\"query\": \"content.size:[0 TO 102400]\", \"label\": \"small\"},{\"query\": \"content.size:[102400 TO 1048576]\", \"label\": \"medium\"},{\"query\": \"content.size:[1048576 TO 16777216]\", \"label\": \"large\"}]}";
        String expectedResponse = "{\"responseHeader\":{\"status\":0,\"QTime\":9},\"_original_parameters_\":\"org.apache.solr.common.params.DefaultSolrParams:{params(df=TEXT&alternativeDic=DEFAULT_DICTIONARY&fl=DBID,score&start=0&fq={!afts}AUTHORITY_FILTER_FROM_JSON&fq={!afts}TENANT_FILTER_FROM_JSON&rows=1000&locale=en_US&wt=json),defaults(carrot.url=id&spellcheck.collateExtendedResults=true&carrot.produceSummary=true&spellcheck.maxCollations=3&spellcheck.maxCollationTries=5&spellcheck.alternativeTermCount=2&spellcheck.extendedResults=false&defType=afts&spellcheck.maxResultsForSuggest=5&spellcheck=false&carrot.outputSubClusters=false&spellcheck.count=5&carrot.title=mltext@m___t@{http://www.alfresco.org/model/content/1.0}title&carrot.snippet=content@s___t@{http://www.alfresco.org/model/content/1.0}content&spellcheck.collate=true)}\",\"_field_mappings_\":{},\"_date_mappings_\":{},\"_range_mappings_\":{},\"_pivot_mappings_\":{},\"_interval_mappings_\":{},\"_stats_field_mappings_\":{},\"_stats_facet_mappings_\":{},\"_facet_function_mappings_\":{},\"response\":{\"numFound\":6,\"start\":0,\"maxScore\":0.7849362,\"docs\":[{\"DBID\":565,\"score\":0.7849362},{\"DBID\":566,\"score\":0.7849362},{\"DBID\":521,\"score\":0.3540957},{\"DBID\":514,\"score\":0.33025497},{\"DBID\":420,\"score\":0.32440513},{\"DBID\":415,\"score\":0.2780319}]},\"spellcheck\":{\"searchInsteadFor\":\"alfresco\"},\"facet_counts\":{\"facet_queries\": {\"small\": 52,\"large\": 0,\"medium\": 0}},\"processedDenies\":true, \"lastIndexedTx\":34}";
        ResultSet results = this.mockResultSet(expectedResponse);
        SearchQuery searchQuery = helper.extractFromJson(jsonQuery);
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertEquals((long)34L, (long)searchContext.getConsistency().getlastTxId());
        TestCase.assertTrue((boolean)searchContext.getFacets().isEmpty());
        TestCase.assertEquals((int)3, (int)searchContext.getFacetQueries().size());
        TestCase.assertEquals((String)"small", (String)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getLabel());
        TestCase.assertEquals((String)"content.size:[0 TO 102400]", (String)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getFilterQuery());
        TestCase.assertEquals((int)52, (int)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getCount());
        TestCase.assertEquals((String)"large", (String)((FacetQueryContext)searchContext.getFacetQueries().get(1)).getLabel());
        TestCase.assertEquals((String)"content.size:[1048576 TO 16777216]", (String)((FacetQueryContext)searchContext.getFacetQueries().get(1)).getFilterQuery());
        TestCase.assertEquals((int)0, (int)((FacetQueryContext)searchContext.getFacetQueries().get(1)).getCount());
        TestCase.assertEquals((String)"medium", (String)((FacetQueryContext)searchContext.getFacetQueries().get(2)).getLabel());
        TestCase.assertEquals((String)"content.size:[102400 TO 1048576]", (String)((FacetQueryContext)searchContext.getFacetQueries().get(2)).getFilterQuery());
        TestCase.assertEquals((int)0, (int)((FacetQueryContext)searchContext.getFacetQueries().get(2)).getCount());
    }

    private ResultSet mockResultSet(String json) {
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        JSONObject jsonObj = new JSONObject(new JSONTokener(json));
        SearchParameters sp = new SearchParameters();
        sp.setBulkFetchEnabled(false);
        SolrJSONResultSet results = new SolrJSONResultSet(jsonObj, sp, nodeService, null, LimitBy.FINAL_SIZE, 10);
        return results;
    }

    private ResultSet mockResultSet(List<Long> archivedNodes, List<Long> versionNodes) {
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        Mockito.when((Object)nodeService.getNodeRef((Long)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            if (archivedNodes.contains(args[0])) {
                return new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, GUID.generate());
            }
            if (versionNodes.contains(args[0])) {
                return new NodeRef(StoreMapper.STORE_REF_VERSION2_SPACESSTORE, GUID.generate() + String.valueOf(args[0]));
            }
            return new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
        });
        SearchParameters sp = new SearchParameters();
        sp.setBulkFetchEnabled(false);
        JSONObject json = new JSONObject(new JSONTokener(JSON_REPONSE));
        SolrJSONResultSet results = new SolrJSONResultSet(json, sp, nodeService, null, LimitBy.FINAL_SIZE, 10);
        return results;
    }

    @Test
    public void facetFormatTest() {
        String jsonQuery = "{\"query\": {\"query\": \"alfresco\"},\"facetQueries\": [{\"query\": \"content.size:[0 TO 102400]\", \"label\": \"small\"},{\"query\": \"content.size:[102400 TO 1048576]\", \"label\": \"medium\"},{\"query\": \"content.size:[1048576 TO 16777216]\", \"label\": \"large\"}],\"facetFormat\":\"V2\"}";
        String expectedResponse = "{\"responseHeader\":{\"status\":0,\"QTime\":9},\"_original_parameters_\":\"org.apache.solr.common.params.DefaultSolrParams:{params(df=TEXT&alternativeDic=DEFAULT_DICTIONARY&fl=DBID,score&start=0&fq={!afts}AUTHORITY_FILTER_FROM_JSON&fq={!afts}TENANT_FILTER_FROM_JSON&rows=1000&locale=en_US&wt=json),defaults(carrot.url=id&spellcheck.collateExtendedResults=true&carrot.produceSummary=true&spellcheck.maxCollations=3&spellcheck.maxCollationTries=5&spellcheck.alternativeTermCount=2&spellcheck.extendedResults=false&defType=afts&spellcheck.maxResultsForSuggest=5&spellcheck=false&carrot.outputSubClusters=false&spellcheck.count=5&carrot.title=mltext@m___t@{http://www.alfresco.org/model/content/1.0}title&carrot.snippet=content@s___t@{http://www.alfresco.org/model/content/1.0}content&spellcheck.collate=true)}\",\"_field_mappings_\":{},\"_date_mappings_\":{},\"_range_mappings_\":{},\"_pivot_mappings_\":{},\"_interval_mappings_\":{},\"_stats_field_mappings_\":{},\"_stats_facet_mappings_\":{},\"_facet_function_mappings_\":{},\"response\":{\"numFound\":6,\"start\":0,\"maxScore\":0.7849362,\"docs\":[{\"DBID\":565,\"score\":0.7849362},{\"DBID\":566,\"score\":0.7849362},{\"DBID\":521,\"score\":0.3540957},{\"DBID\":514,\"score\":0.33025497},{\"DBID\":420,\"score\":0.32440513},{\"DBID\":415,\"score\":0.2780319}]},\"spellcheck\":{\"searchInsteadFor\":\"alfresco\"},\"facet_counts\":{\"facet_queries\": {\"small\": 52,\"large\": 0,\"medium\": 0}},\"processedDenies\":true, \"lastIndexedTx\":34}";
        ResultSet results = this.mockResultSet(expectedResponse);
        SearchQuery searchQuery = helper.extractFromJson(jsonQuery);
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertEquals((long)34L, (long)searchContext.getConsistency().getlastTxId());
        TestCase.assertEquals(null, (Object)searchContext.getFacetQueries());
        TestCase.assertEquals((int)1, (int)searchContext.getFacets().size());
        TestCase.assertEquals((int)3, (int)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().size());
        TestCase.assertEquals((String)"small", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"content.size:[0 TO 102400]", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertFalse((boolean)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().isEmpty());
        Metric[] metrics = ((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().toArray(new Metric[((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().size()]);
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)metrics[0].getType());
        TestCase.assertEquals((String)"{count=52}", (String)metrics[0].getValue().toString());
        jsonQuery = jsonQuery.replace("V2", "V1");
        searchQuery = helper.extractFromJson(jsonQuery);
        results = this.mockResultSet(expectedResponse);
        searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertEquals((long)34L, (long)searchContext.getConsistency().getlastTxId());
        TestCase.assertEquals((int)3, (int)searchContext.getFacetQueries().size());
        TestCase.assertEquals((String)"small", (String)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getLabel());
        TestCase.assertEquals((String)"content.size:[0 TO 102400]", (String)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getFilterQuery());
        TestCase.assertEquals((int)52, (int)((FacetQueryContext)searchContext.getFacetQueries().get(0)).getCount());
        TestCase.assertEquals((String)"large", (String)((FacetQueryContext)searchContext.getFacetQueries().get(1)).getLabel());
        jsonQuery = "{\"query\": {\"query\": \"A*\"},\"facetFields\": {\"facets\": [{\"field\": \"creator\", \"mincount\": 1},{\"field\": \"modifier\", \"mincount\": 1}]},\"facetFormat\":\"V1\"}";
        expectedResponse = "{\"responseHeader\":{\"status\":0,\"QTime\":9},\"_original_parameters_\":\"org.apache.solr.common.params.DefaultSolrParams:{params(df=TEXT&alternativeDic=DEFAULT_DICTIONARY&fl=DBID,score&start=0&fq={!afts}AUTHORITY_FILTER_FROM_JSON&fq={!afts}TENANT_FILTER_FROM_JSON&rows=1000&locale=en_US&wt=json),defaults(carrot.url=id&spellcheck.collateExtendedResults=true&carrot.produceSummary=true&spellcheck.maxCollations=3&spellcheck.maxCollationTries=5&spellcheck.alternativeTermCount=2&spellcheck.extendedResults=false&defType=afts&spellcheck.maxResultsForSuggest=5&spellcheck=false&carrot.outputSubClusters=false&spellcheck.count=5&carrot.title=mltext@m___t@{http://www.alfresco.org/model/content/1.0}title&carrot.snippet=content@s___t@{http://www.alfresco.org/model/content/1.0}content&spellcheck.collate=true)}\",\"_field_mappings_\":{},\"_date_mappings_\":{},\"_range_mappings_\":{},\"_pivot_mappings_\":{},\"_interval_mappings_\":{},\"_stats_field_mappings_\":{},\"_stats_facet_mappings_\":{},\"_facet_function_mappings_\":{},\"response\":{\"numFound\":6,\"start\":0,\"maxScore\":0.7849362,\"docs\":[{\"DBID\":565,\"score\":0.7849362},{\"DBID\":566,\"score\":0.7849362},{\"DBID\":521,\"score\":0.3540957},{\"DBID\":514,\"score\":0.33025497},{\"DBID\":420,\"score\":0.32440513},{\"DBID\":415,\"score\":0.2780319}]},\"spellcheck\":{\"searchInsteadFor\":\"alfresco\"},\"facet_counts\":{\"facet_fields\":{\"creator\":[\"System\",124,\"mjackson\",11,\"abeecher\",4],\"modifier\":[\"System\",124,\"mjackson\",8,\"admin\",7]}},\"processedDenies\":true, \"lastIndexedTx\":34}";
        results = this.mockResultSet(expectedResponse);
        searchQuery = helper.extractFromJson(jsonQuery);
        searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertFalse((boolean)searchContext.getFacetsFields().isEmpty());
        TestCase.assertTrue((boolean)searchContext.getFacets().isEmpty());
        TestCase.assertEquals((String)"creator", (String)((FacetFieldContext)searchContext.getFacetsFields().get(0)).getLabel());
        TestCase.assertEquals((int)3, (int)((FacetFieldContext)searchContext.getFacetsFields().get(0)).getBuckets().size());
        TestCase.assertEquals((int)124, (int)((FacetFieldContext.Bucket)((FacetFieldContext)searchContext.getFacetsFields().get(0)).getBuckets().get(0)).getCount());
        TestCase.assertEquals((String)"creator:\"System\"", (String)((FacetFieldContext.Bucket)((FacetFieldContext)searchContext.getFacetsFields().get(0)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertEquals((String)"System", (String)((FacetFieldContext.Bucket)((FacetFieldContext)searchContext.getFacetsFields().get(0)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"modifier", (String)((FacetFieldContext)searchContext.getFacetsFields().get(1)).getLabel());
        jsonQuery = jsonQuery.replace("V1", "V2");
        searchQuery = helper.extractFromJson(jsonQuery);
        searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertTrue((boolean)searchContext.getFacetsFields().isEmpty());
        TestCase.assertFalse((boolean)searchContext.getFacets().isEmpty());
        TestCase.assertEquals((String)"creator", (String)((GenericFacetResponse)searchContext.getFacets().get(0)).getLabel());
        TestCase.assertEquals((int)3, (int)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().size());
        metrics = ((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().toArray(new Metric[((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().size()]);
        TestCase.assertEquals((String)"{count=124}", (String)metrics[0].getValue().toString());
        TestCase.assertEquals((String)"creator:\"System\"", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertEquals((String)"System", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"modifier", (String)((GenericFacetResponse)searchContext.getFacets().get(1)).getLabel());
    }

    @Test
    public void hasGroupTest() {
        String jsonQuery = "{\"query\": {\"query\": \"alfresco\"},\"facetQueries\": [{\"query\": \"content.size:[0 TO 102400]\", \"label\": \"small\"},{\"query\": \"content.size:[102400 TO 1048576]\", \"label\": \"medium\"},{\"query\": \"content.size:[1048576 TO 16777216]\", \"label\": \"large\"}]}";
        String jsonQueryWithGroup = "{\"query\": {\"query\": \"alfresco\"},\"facetQueries\": [{\"query\": \"content.size:[0 TO 102400]\", \"label\": \"small\"},{\"query\": \"content.size:[102400 TO 1048576]\", \"label\": \"medium\",\"group\":\"foo\"},{\"query\": \"content.size:[1048576 TO 16777216]\", \"label\": \"large\"}]}";
        SearchQuery searchQuery = helper.extractFromJson(jsonQuery);
        TestCase.assertFalse((boolean)ResultMapper.hasGroup((SearchQuery)searchQuery));
        SearchQuery searchQuery2 = helper.extractFromJson(jsonQueryWithGroup);
        TestCase.assertTrue((boolean)ResultMapper.hasGroup((SearchQuery)searchQuery2));
        TestCase.assertFalse((boolean)ResultMapper.hasGroup(null));
        String noFacetQueries = "{\"query\": {\"query\": \"alfresco\"},\"facetQueries\": []}";
        SearchQuery searchQuery3 = helper.extractFromJson(noFacetQueries);
        TestCase.assertFalse((boolean)ResultMapper.hasGroup((SearchQuery)searchQuery3));
    }

    @Test
    public void testFacetingWithPartialGroup() {
        String jsonQuery = "{\"query\": {\"query\": \"alfresco\"},\"facetQueries\": [{\"query\": \"content.size:[o TO 102400]\", \"label\": \"small\",\"group\":\"1\"},{\"query\": \"content.size:[102400 TO 1048576]\", \"label\": \"medium\",\"group\":\"2\"},{\"query\": \"content.size:[1048576 TO 16777216]\", \"label\": \"large\"}]}";
        String expectedResponse = "{\"responseHeader\":{\"status\":0,\"QTime\":9},\"_original_parameters_\":\"org.apache.solr.common.params.DefaultSolrParams:{params(df=TEXT&alternativeDic=DEFAULT_DICTIONARY&fl=DBID,score&start=0&fq={!afts}AUTHORITY_FILTER_FROM_JSON&fq={!afts}TENANT_FILTER_FROM_JSON&rows=1000&locale=en_US&wt=json),defaults(carrot.url=id&spellcheck.collateExtendedResults=true&carrot.produceSummary=true&spellcheck.maxCollations=3&spellcheck.maxCollationTries=5&spellcheck.alternativeTermCount=2&spellcheck.extendedResults=false&defType=afts&spellcheck.maxResultsForSuggest=5&spellcheck=false&carrot.outputSubClusters=false&spellcheck.count=5&carrot.title=mltext@m___t@{http://www.alfresco.org/model/content/1.0}title&carrot.snippet=content@s___t@{http://www.alfresco.org/model/content/1.0}content&spellcheck.collate=true)}\",\"_field_mappings_\":{},\"_date_mappings_\":{},\"_range_mappings_\":{},\"_pivot_mappings_\":{},\"_interval_mappings_\":{},\"_stats_field_mappings_\":{},\"_stats_facet_mappings_\":{},\"_facet_function_mappings_\":{},\"response\":{\"numFound\":6,\"start\":0,\"maxScore\":0.7849362,\"docs\":[{\"DBID\":565,\"score\":0.7849362},{\"DBID\":566,\"score\":0.7849362},{\"DBID\":521,\"score\":0.3540957},{\"DBID\":514,\"score\":0.33025497},{\"DBID\":420,\"score\":0.32440513},{\"DBID\":415,\"score\":0.2780319}]},\"spellcheck\":{\"searchInsteadFor\":\"alfresco\"},\"facet_counts\":{\"facet_queries\": {\"small\": 52,\"large\": 0,\"medium\": 0}},\"processedDenies\":true, \"lastIndexedTx\":34}";
        ResultSet results = this.mockResultSet(expectedResponse);
        SearchQuery searchQuery = helper.extractFromJson(jsonQuery);
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)searchQuery);
        SearchContext searchContext = mapper.toSearchContext((SearchEngineResultSet)results, searchRequest, searchQuery);
        TestCase.assertEquals((long)34L, (long)searchContext.getConsistency().getlastTxId());
        TestCase.assertEquals(null, (Object)searchContext.getFacetQueries());
        TestCase.assertEquals((int)3, (int)searchContext.getFacets().size());
        TestCase.assertEquals((int)1, (int)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().size());
        TestCase.assertEquals((int)1, (int)((GenericFacetResponse)searchContext.getFacets().get(1)).getBuckets().size());
        TestCase.assertEquals((int)1, (int)((GenericFacetResponse)searchContext.getFacets().get(2)).getBuckets().size());
        TestCase.assertEquals((String)"large", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"small", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(1)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"medium", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(2)).getBuckets().get(0)).getLabel());
        TestCase.assertEquals((String)"content.size:[o TO 102400]", (String)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(1)).getBuckets().get(0)).getFilterQuery());
        TestCase.assertFalse((boolean)((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().isEmpty());
        Metric[] metrics = ((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(1)).getBuckets().get(0)).getMetrics().toArray(new Metric[((GenericBucket)((GenericFacetResponse)searchContext.getFacets().get(0)).getBuckets().get(0)).getMetrics().size()]);
        TestCase.assertEquals((Object)Metric.METRIC_TYPE.count, (Object)metrics[0].getType());
        TestCase.assertEquals((String)"{count=52}", (String)metrics[0].getValue().toString());
    }

    @Test
    public void testSqlResponse() {
        JSONObject response = new JSONObject("{\"docs\":[{\"SITE\":\"_REPOSITORY_\"},{\"SITE\":\"surf-config\"},{\"SITE\":\"swsdp\"},{\"EOF\":true,\"RESPONSE_TIME\":96}]}");
        JSONArray docs = response.getJSONArray("docs");
        SearchSQLQuery query = new SearchSQLQuery("select SITE from alfresco group by SITE", null, null, Integer.valueOf(100), false, null, null);
        CollectionWithPagingInfo info = mapper.toCollectionWithPagingInfo(docs, query);
        TestCase.assertEquals((int)100, (int)info.getPaging().getMaxItems());
        TestCase.assertEquals((int)0, (int)info.getPaging().getSkipCount());
        TestCase.assertEquals((boolean)false, (boolean)info.getCollection().isEmpty());
        TestCase.assertEquals((int)3, (int)info.getCollection().size());
        info = mapper.toCollectionWithPagingInfo(new JSONArray(), query);
        TestCase.assertEquals((int)100, (int)info.getPaging().getMaxItems());
        TestCase.assertEquals((int)0, (int)info.getPaging().getSkipCount());
        TestCase.assertEquals((boolean)true, (boolean)info.getCollection().isEmpty());
        TestCase.assertEquals((int)0, (int)info.getCollection().size());
        try {
            mapper.toCollectionWithPagingInfo(null, query);
        }
        catch (Exception e) {
            TestCase.assertNotNull((Object)e);
            TestCase.assertEquals((String)"Solr response is required instead of JSONArray docs was null", (String)e.getMessage());
        }
        try {
            mapper.toCollectionWithPagingInfo(docs, null);
        }
        catch (Exception e) {
            TestCase.assertNotNull((Object)e);
            TestCase.assertEquals((String)"SearchSQLQuery is required", (String)e.getMessage());
        }
    }

    @Test
    public void testGetNode() {
        ResultSetRow mockRow = (ResultSetRow)Mockito.mock(ResultSetRow.class);
        NodeRef nodeRef = new NodeRef("workspace://SpacesStore/testNode");
        Mockito.when((Object)mockRow.getNodeRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)nodes.getFolderOrDocument((NodeRef)ArgumentMatchers.eq((Object)nodeRef), (NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenThrow(new Throwable[]{new PermissionDeniedException()});
        Node node = mapper.getNode(mockRow, EMPTY_PARAMS, null, false);
        TestCase.assertNull((String)"Expected node to be filtered due to permission exception.", (Object)node);
    }

    static {
        searchMapper = new SearchMapper();
        EMPTY_PARAMS = Params.valueOf((String)null, null, null);
    }
}

