/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.constraint.FolderContentsParameterConstraint;
import org.alfresco.rest.api.impl.ActionsImpl;
import org.alfresco.rest.api.impl.rules.ActionParameterConverter;
import org.alfresco.rest.api.model.ActionParameterConstraint;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActionsImplTest {
    private static final String NAME = "name";
    private static final String CONSTRAINT = "constraint";
    private static final String LABEL = "label";
    private static final String DISPLAY = "display ";
    @Mock
    private ActionService actionServiceMock;
    @Mock
    private Parameters parametersMock;
    @Mock
    private ActionParameterConverter parameterConverterMock;
    @InjectMocks
    private ActionsImpl objectUnderTest;

    @Test
    public void testGetSingleActionConstraint() {
        String name = NAME;
        String value = CONSTRAINT;
        String label = LABEL;
        Map<String, String> values = Map.of(CONSTRAINT, LABEL);
        ParameterConstraint testConstraint = this.createTestConstraint(NAME, values);
        BDDMockito.given((Object)this.actionServiceMock.getParameterConstraint(NAME)).willReturn((Object)testConstraint);
        ActionParameterConstraint actualConstraint = this.objectUnderTest.getActionConstraint(NAME);
        BDDMockito.then((Object)this.parametersMock).shouldHaveNoInteractions();
        ((ActionService)BDDMockito.then((Object)this.actionServiceMock).should()).getParameterConstraint(NAME);
        BDDMockito.then((Object)this.actionServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)actualConstraint).isNotNull();
        Assertions.assertThat((String)actualConstraint.getConstraintName()).isEqualTo(testConstraint.getName());
        ActionParameterConstraint.ConstraintData expectedConstraintData = new ActionParameterConstraint.ConstraintData(CONSTRAINT, LABEL);
        ((ListAssert)Assertions.assertThat((List)actualConstraint.getConstraintValues()).isNotNull()).hasSize(1);
        ActionParameterConstraint.ConstraintData actualConstraintData = (ActionParameterConstraint.ConstraintData)actualConstraint.getConstraintValues().get(0);
        Assertions.assertThat((Object)actualConstraintData).usingRecursiveComparison().isEqualTo((Object)expectedConstraintData);
    }

    @Test
    public void testGetSingleActionNodeConstraint() {
        String name = "name1";
        String dummyNodeId = "dummy-node-id";
        String value = "workspace://DummyStore/dummy-node-id";
        Map<String, String> values = Map.of("workspace://DummyStore/dummy-node-id", LABEL);
        FolderContentsParameterConstraint testConstraint = (FolderContentsParameterConstraint)Mockito.mock(FolderContentsParameterConstraint.class);
        BDDMockito.given((Object)testConstraint.getName()).willReturn((Object)"name1");
        BDDMockito.given((Object)testConstraint.getValues()).willReturn(values);
        BDDMockito.given((Object)this.actionServiceMock.getParameterConstraint("name1")).willReturn((Object)testConstraint);
        BDDMockito.given((Object)this.parameterConverterMock.convertParamFromServiceModel((Serializable)ArgumentMatchers.any())).willReturn((Object)"dummy-node-id");
        ActionParameterConstraint actualConstraint = this.objectUnderTest.getActionConstraint("name1");
        BDDMockito.then((Object)this.parametersMock).shouldHaveNoInteractions();
        ((ActionService)BDDMockito.then((Object)this.actionServiceMock).should()).getParameterConstraint("name1");
        BDDMockito.then((Object)this.actionServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)actualConstraint).isNotNull();
        Assertions.assertThat((String)actualConstraint.getConstraintName()).isEqualTo(testConstraint.getName());
        ActionParameterConstraint.ConstraintData expectedConstraintData = new ActionParameterConstraint.ConstraintData("dummy-node-id", LABEL);
        ((ListAssert)Assertions.assertThat((List)actualConstraint.getConstraintValues()).isNotNull()).hasSize(1);
        ActionParameterConstraint.ConstraintData actualConstraintData = (ActionParameterConstraint.ConstraintData)actualConstraint.getConstraintValues().get(0);
        Assertions.assertThat((Object)actualConstraintData).usingRecursiveComparison().isEqualTo((Object)expectedConstraintData);
    }

    @Test
    public void testGetActionConstraintsWithNameFilterNonExistingConstraint() {
        String name = NAME;
        BDDMockito.given((Object)this.actionServiceMock.getParameterConstraint(NAME)).willReturn(null);
        Assertions.assertThatExceptionOfType(NotFoundException.class).isThrownBy(() -> this.objectUnderTest.getActionConstraint(NAME)).withMessageContaining(String.format("Action parameter constraints for name %s do not exist.", NAME));
        BDDMockito.then((Object)this.parametersMock).shouldHaveNoInteractions();
        ((ActionService)BDDMockito.then((Object)this.actionServiceMock).should()).getParameterConstraint(NAME);
        BDDMockito.then((Object)this.actionServiceMock).shouldHaveNoMoreInteractions();
    }

    private ParameterConstraint createTestConstraint(final String name, final Map<String, String> values) {
        return new ParameterConstraint(){

            public String getName() {
                return name;
            }

            public boolean isValidValue(String value) {
                return true;
            }

            public String getValueDisplayLabel(String value) {
                return ActionsImplTest.DISPLAY + name;
            }

            public Map<String, String> getAllowableValues() {
                return values;
            }
        };
    }
}

