/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.rest.api.Activities;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.impl.activities.ActivitySummaryParser;
import org.alfresco.rest.api.model.Activity;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.JSONException;

public class ActivitiesImpl
implements Activities {
    private static final String ACTIVITIES_FORMAT = "json";
    private People people;
    private ActivityService activityService;
    private ActivitySummaryParser activitySummaryParser;
    private TenantService tenantService;
    private Sites sites;

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void setPeople(People people) {
        this.people = people;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setActivitySummaryParser(ActivitySummaryParser activitySummaryParser) {
        this.activitySummaryParser = activitySummaryParser;
    }

    @Override
    public Map<String, Object> getActivitySummary(ActivityFeedEntity entity) throws JSONException {
        Map<String, Object> activitySummary = this.activitySummaryParser.parse(entity.getActivityType(), entity.getActivitySummary());
        return activitySummary;
    }

    private String getSiteId(String siteNetwork) {
        String siteId = siteNetwork;
        int idx = siteNetwork.lastIndexOf("@");
        if (idx != -1) {
            siteId = siteNetwork.substring(idx + 1);
        }
        return siteId;
    }

    @Override
    public CollectionWithPagingInfo<Activity> getUserActivities(String personId, Parameters parameters) {
        personId = this.people.validatePerson(personId);
        Paging paging = parameters.getPaging();
        String siteId = parameters.getParameter("siteId");
        String who = parameters.getParameter("who");
        Activities.ActivityWho activityWho = null;
        if (who != null) {
            try {
                activityWho = Activities.ActivityWho.valueOf(who);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidArgumentException("Parameter who should be one of " + Arrays.toString((Object[])Activities.ActivityWho.values()));
            }
        }
        if (siteId != null && !siteId.equals("")) {
            SiteInfo siteInfo = this.sites.validateSite(siteId);
            if (siteInfo == null) {
                throw new EntityNotFoundException(siteId);
            }
            siteId = siteInfo.getShortName();
        }
        try {
            PagingResults activities = null;
            if (activityWho == null) {
                activities = this.activityService.getPagedUserFeedEntries(personId, siteId, false, false, -1L, Util.getPagingRequest(paging));
            } else if (activityWho.equals((Object)Activities.ActivityWho.me)) {
                activities = this.activityService.getPagedUserFeedEntries(personId, siteId, false, true, -1L, Util.getPagingRequest(paging));
            } else if (activityWho.equals((Object)Activities.ActivityWho.others)) {
                activities = this.activityService.getPagedUserFeedEntries(personId, siteId, true, false, -1L, Util.getPagingRequest(paging));
            } else {
                throw new InvalidArgumentException("Who argument is invalid.");
            }
            List feedEntities = activities.getPage();
            ArrayList<Activity> ret = new ArrayList<Activity>(feedEntities.size());
            for (ActivityFeedEntity entity : feedEntities) {
                String feedSiteId = this.getSiteId(entity.getSiteNetwork());
                String networkId = this.tenantService.getDomain(entity.getSiteNetwork());
                Activity activity = new Activity(entity.getId(), networkId, feedSiteId, entity.getFeedUserId(), entity.getPostUserId(), entity.getPostDate(), entity.getActivityType(), this.getActivitySummary(entity));
                ret.add(activity);
            }
            return CollectionWithPagingInfo.asPaged(paging, ret, activities.hasMoreItems(), (Integer)activities.getTotalResultCount().getFirst());
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("", (Throwable)e);
        }
    }
}

