/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.alfresco.repo.web.scripts.calendar.AbstractCalendarWebScript;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CalendarEntryPost
extends AbstractCalendarWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String eventName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        ResourceBundle rb = this.getResources();
        CalendarEntryDTO entry = new CalendarEntryDTO();
        boolean isAllDay = false;
        try {
            entry.setTitle(this.getOrNull(json, "what"));
            entry.setDescription(this.getOrNull(json, "desc"));
            entry.setLocation(this.getOrNull(json, "where"));
            entry.setSharePointDocFolder(this.getOrNull(json, "docfolder"));
            isAllDay = this.extractDates((CalendarEntry)entry, json);
            if (json.containsKey((Object)"tags")) {
                StringTokenizer st = new StringTokenizer((String)json.get((Object)"tags"), ",");
                while (st.hasMoreTokens()) {
                    entry.getTags().add(st.nextToken());
                }
            }
        }
        catch (JSONException je) {
            String message = rb.getString("calendar.err.invalid.json");
            return this.buildError(MessageFormat.format(message, je.getMessage()));
        }
        entry = this.calendarService.createCalendarEntry(site.getShortName(), (CalendarEntry)entry);
        String dateOpt = this.addActivityEntry("created", (CalendarEntry)entry, site, req, json);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", entry.getTitle());
        result.put("desc", entry.getDescription());
        result.put("where", entry.getLocation());
        result.put("from", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, isAllDay));
        result.put("to", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, isAllDay));
        String legacyDateFormat = "yyyy-MM-dd";
        String legacyTimeFormat = "HH:mm";
        result.put("legacyDateFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, isAllDay, legacyDateFormat));
        result.put("legacyTimeFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, isAllDay, legacyTimeFormat));
        result.put("legacyDateTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, isAllDay, legacyDateFormat));
        result.put("legacyTimeTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, isAllDay, legacyTimeFormat));
        result.put("uri", "calendar/event/" + site.getShortName() + "/" + entry.getSystemName() + dateOpt);
        result.put("tags", entry.getTags());
        result.put("allday", isAllDay);
        result.put("docfolder", entry.getSharePointDocFolder());
        for (String key : result.keySet()) {
            if (result.get(key) != null) continue;
            result.put(key, "");
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("result", result);
        return model;
    }
}

