/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.FavouriteSite;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Test;

public class TestFavouriteSites
extends EnterpriseTestApi {
    @Test
    public void testFavouriteSites() throws Exception {
        FavouriteSite fs;
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().getNetworksIt();
        Assert.assertTrue((boolean)networksIt.hasNext());
        final RepoService.TestNetwork network1 = networksIt.next();
        Assert.assertTrue((boolean)networksIt.hasNext());
        final RepoService.TestNetwork network2 = networksIt.next();
        final ArrayList people = new ArrayList();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network1.createUser();
                people.add(person);
                person = network1.createUser();
                people.add(person);
                person = network1.createUser();
                people.add(person);
                return null;
            }
        }, (String)network1.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network2.createUser();
                people.add(person);
                person = network2.createUser();
                people.add(person);
                return null;
            }
        }, (String)network2.getId());
        final RepoService.TestPerson person1 = (RepoService.TestPerson)people.get(0);
        final RepoService.TestPerson person2 = (RepoService.TestPerson)people.get(1);
        final RepoService.TestPerson person3 = (RepoService.TestPerson)people.get(2);
        RepoService.TestPerson person4 = (RepoService.TestPerson)people.get(3);
        final RepoService.TestPerson person5 = (RepoService.TestPerson)people.get(3);
        RepoService.TestSite testSite = (RepoService.TestSite)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<RepoService.TestSite>(){

            public RepoService.TestSite execute() throws Throwable {
                return (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                    public RepoService.TestSite doWork() throws Exception {
                        RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(GUID.generate(), "", "", SiteVisibility.PUBLIC);
                        return network1.createSite(siteInfo);
                    }
                }, (String)person1.getId(), (String)network1.getId());
            }
        }, false, true);
        RepoService.TestSite testSite1 = (RepoService.TestSite)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<RepoService.TestSite>(){

            public RepoService.TestSite execute() throws Throwable {
                return (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                    public RepoService.TestSite doWork() throws Exception {
                        RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(GUID.generate(), "", "", SiteVisibility.PUBLIC);
                        return network1.createSite(siteInfo);
                    }
                }, (String)person1.getId(), (String)network1.getId());
            }
        }, false, true);
        RepoService.TestSite testSite3 = (RepoService.TestSite)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<RepoService.TestSite>(){

            public RepoService.TestSite execute() throws Throwable {
                return (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                    public RepoService.TestSite doWork() throws Exception {
                        RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(GUID.generate(), "", "", SiteVisibility.PUBLIC);
                        return network1.createSite(siteInfo);
                    }
                }, (String)person1.getId(), (String)network1.getId());
            }
        }, false, true);
        RepoService.TestSite testSite4 = (RepoService.TestSite)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<RepoService.TestSite>(){

            public RepoService.TestSite execute() throws Throwable {
                return (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                    public RepoService.TestSite doWork() throws Exception {
                        RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(GUID.generate(), "", "", SiteVisibility.PUBLIC);
                        return network1.createSite(siteInfo);
                    }
                }, (String)person5.getId(), (String)network2.getId());
            }
        }, false, true);
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        try {
            fs = new FavouriteSite(testSite.getSiteId());
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.create("people", person1.getId(), "favorite-sites", testSite.getSiteId(), fs.toJSON().toString(), "Unable to POST to a favorite-site");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            fs = new FavouriteSite(testSite.getSiteId());
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.update("people", person1.getId(), "favorite-sites", null, fs.toJSON().toString(), "Unable to PUT favorite-sites");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            fs = new FavouriteSite(testSite.getSiteId());
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.update("people", person1.getId(), "favorite-sites", testSite.getSiteId(), fs.toJSON().toString(), "Unable to PUT a favorite-site");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.remove("people", person1.getId(), "favorite-sites", null, "Unable to DELETE favorite-sites");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            fs = new FavouriteSite(testSite.getSiteId());
            sitesProxy.createFavouriteSite("invalid.user", fs);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person4.getId()));
            fs = new FavouriteSite(testSite.getSiteId());
            sitesProxy.createFavouriteSite(person1.getId(), fs);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            fs = new FavouriteSite(testSite.getSiteId());
            sitesProxy.createFavouriteSite(person2.getId(), fs);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        fs = new FavouriteSite(testSite.getSiteId());
        FavouriteSite resp = sitesProxy.createFavouriteSite(person1.getId(), fs);
        fs.expected(resp);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.createFavouriteSite(person1.getId(), new FavouriteSite(testSite.getSiteId()));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
        fs = new FavouriteSite(testSite.getSiteId());
        resp = sitesProxy.createFavouriteSite("-me-", fs);
        fs.expected(resp);
        List expectedFavouriteSites = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<FavouriteSite>>(){

            public List<FavouriteSite> doWork() throws Exception {
                return TestFavouriteSites.this.repoService.getFavouriteSites(person2);
            }
        }, (String)person2.getId(), (String)network1.getId());
        int skipCount = 0;
        int maxItems = Integer.MAX_VALUE;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedFavouriteSites.size(), expectedFavouriteSites.size());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
        sitesProxy.getFavouriteSites(person2.getId(), this.createParams(paging, null));
        fs = new FavouriteSite(testSite1.getSiteId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        FavouriteSite ret = sitesProxy.createFavouriteSite(person1.getId(), fs);
        fs.expected(ret);
        ArrayList<FavouriteSite> expectedFavouriteSites2 = (ArrayList<FavouriteSite>)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<FavouriteSite>>(){

            public List<FavouriteSite> doWork() throws Exception {
                return TestFavouriteSites.this.repoService.getFavouriteSites(person1);
            }
        }, (String)person1.getId(), (String)network1.getId());
        try {
            int skipCount2 = 0;
            int maxItems2 = Integer.MAX_VALUE;
            PublicApiClient.Paging paging2 = this.getPaging(skipCount2, maxItems2, expectedFavouriteSites2.size(), expectedFavouriteSites2.size());
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.getFavouriteSites(GUID.generate(), this.createParams(paging2, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount3 = 0;
            int maxItems3 = Integer.MAX_VALUE;
            PublicApiClient.Paging paging3 = this.getPaging(skipCount3, maxItems3, expectedFavouriteSites2.size(), expectedFavouriteSites2.size());
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), GUID.generate(), "password"));
            sitesProxy.getFavouriteSites(person1.getId(), this.createParams(paging3, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount4 = 0;
            int maxItems4 = 2;
            PublicApiClient.Paging paging4 = this.getPaging(skipCount4, maxItems4, expectedFavouriteSites2.size(), expectedFavouriteSites2.size());
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            PublicApiClient.ListResponse<FavouriteSite> response = sitesProxy.getFavouriteSites(person1.getId(), this.createParams(paging4, null));
            this.checkList(expectedFavouriteSites2, paging4.getExpectedPaging(), response);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount5 = 0;
            int maxItems5 = Integer.MAX_VALUE;
            PublicApiClient.Paging paging5 = this.getPaging(skipCount5, maxItems5, expectedFavouriteSites2.size(), expectedFavouriteSites2.size());
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person4.getId()));
            sitesProxy.getFavouriteSites(person1.getId(), this.createParams(paging5, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        int skipCount6 = 0;
        int maxItems6 = Integer.MAX_VALUE;
        PublicApiClient.Paging paging6 = this.getPaging(skipCount6, maxItems6, expectedFavouriteSites2.size(), expectedFavouriteSites2.size());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        PublicApiClient.ListResponse<FavouriteSite> response = sitesProxy.getFavouriteSites(person1.getId(), this.createParams(paging6, null));
        this.checkList(expectedFavouriteSites2, paging6.getExpectedPaging(), response);
        skipCount6 = expectedFavouriteSites2.size() + 100;
        PublicApiClient.Paging paging7 = this.getPaging(skipCount6, null, expectedFavouriteSites2.size(), expectedFavouriteSites2.size());
        List expected = Collections.emptyList();
        response = sitesProxy.getFavouriteSites(person1.getId(), this.createParams(paging7, null));
        this.checkList(expected, paging7.getExpectedPaging(), response);
        skipCount6 = 0;
        maxItems = Integer.MAX_VALUE;
        paging6 = this.getPaging(skipCount6, maxItems, expectedFavouriteSites2.size(), expectedFavouriteSites2.size());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        response = sitesProxy.getFavouriteSites("-me-", this.createParams(paging6, null));
        this.checkList(expectedFavouriteSites2, paging6.getExpectedPaging(), response);
        this.publicApiClient.setRequestContext(new RequestContext(network2.getId(), person5.getId()));
        expectedFavouriteSites2 = new ArrayList<FavouriteSite>(1);
        FavouriteSite fs2 = new FavouriteSite(testSite4.getSiteId());
        expectedFavouriteSites2.add(fs2);
        FavouriteSite ret2 = sitesProxy.createFavouriteSite(person5.getId(), fs2);
        fs2.expected(ret2);
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedFavouriteSites2.size(), expectedFavouriteSites2.size());
        PublicApiClient.ListResponse<FavouriteSite> response2 = sitesProxy.getFavouriteSites(person5.getId(), this.createParams(paging, null));
        this.checkList(expectedFavouriteSites2, paging.getExpectedPaging(), response2);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person3.getId()));
        fs = new FavouriteSite(testSite);
        sitesProxy.createFavouriteSite(person3.getId(), fs);
        fs = new FavouriteSite(testSite1);
        sitesProxy.createFavouriteSite(person3.getId(), fs);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        fs = new FavouriteSite(testSite);
        sitesProxy.removeFavouriteSite(person1.getId(), fs);
        List expectedFavouriteSites3 = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<FavouriteSite>>(){

            public List<FavouriteSite> doWork() throws Exception {
                return TestFavouriteSites.this.repoService.getFavouriteSites(person1);
            }
        }, (String)person1.getId(), (String)network1.getId());
        int skipCount7 = 0;
        int maxItems7 = Integer.MAX_VALUE;
        PublicApiClient.Paging paging8 = this.getPaging(skipCount7, maxItems7, expectedFavouriteSites3.size(), expectedFavouriteSites3.size());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        PublicApiClient.ListResponse<FavouriteSite> response3 = sitesProxy.getFavouriteSites(person1.getId(), this.createParams(paging8, null));
        Assert.assertFalse((boolean)response3.getList().contains(fs));
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            fs = new FavouriteSite(testSite);
            sitesProxy.removeFavouriteSite(GUID.generate(), fs);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            fs = new FavouriteSite(GUID.generate());
            sitesProxy.removeFavouriteSite(person1.getId(), fs);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            fs = new FavouriteSite(testSite3);
            sitesProxy.removeFavouriteSite(person1.getId(), fs);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person3.getId()));
        fs = new FavouriteSite(testSite1);
        sitesProxy.removeFavouriteSite("-me-", fs);
        expectedFavouriteSites3 = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<FavouriteSite>>(){

            public List<FavouriteSite> doWork() throws Exception {
                return TestFavouriteSites.this.repoService.getFavouriteSites(person3);
            }
        }, (String)person3.getId(), (String)network1.getId());
        skipCount7 = 0;
        maxItems7 = Integer.MAX_VALUE;
        paging8 = this.getPaging(skipCount7, maxItems7, expectedFavouriteSites3.size(), expectedFavouriteSites3.size());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person3.getId()));
        response3 = sitesProxy.getFavouriteSites(person3.getId(), this.createParams(paging8, null));
        Assert.assertFalse((boolean)response3.getList().contains(fs));
    }
}

