/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.web.scripts.archive.AbstractArchivedNodeWebScript;
import org.alfresco.repo.web.scripts.archive.ArchivedNodeState;
import org.alfresco.repo.web.scripts.archive.ArchivedNodesFilter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.ScriptPagingDetails;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ArchivedNodesGet
extends AbstractArchivedNodeWebScript {
    private static final String MAX_ITEMS = "maxItems";
    private static final String SKIP_COUNT = "skipCount";
    private static final String NAME_FILTER = "nf";
    List<ArchivedNodesFilter> nodeFilters = new ArrayList<ArchivedNodesFilter>();

    public void setArchivedNodeFilters(List<ArchivedNodesFilter> nodeFilters) {
        this.nodeFilters = nodeFilters;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        StoreRef storeRef = this.parseRequestForStoreRef(req);
        ScriptPagingDetails paging = new ScriptPagingDetails(this.getIntParameter(req, MAX_ITEMS, 50), this.getIntParameter(req, SKIP_COUNT, 0));
        PagingResults<NodeRef> result = this.getArchivedNodesFrom(storeRef, paging, req.getParameter(NAME_FILTER));
        List nodeRefs = result.getPage();
        ArrayList<ArchivedNodeState> deletedNodes = new ArrayList<ArchivedNodeState>(nodeRefs.size());
        for (NodeRef archivedNode : nodeRefs) {
            ArchivedNodeState state = ArchivedNodeState.create(archivedNode, this.serviceRegistry);
            deletedNodes.add(state);
        }
        model.put("deletedNodes", deletedNodes);
        paging.setTotalItems(deletedNodes.size());
        model.put("paging", ModelUtil.buildPaging((ScriptPagingDetails)paging));
        return model;
    }
}

