/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.List;
import java.util.Set;
import org.alfresco.service.cmr.security.AccessStatus;

public class NodePermissions {
    private Boolean inherit;
    private List<NodePermission> inherited;
    private List<NodePermission> locallySet;
    private Set<String> settable;

    public NodePermissions() {
    }

    public NodePermissions(Boolean inherit, List<NodePermission> inherited, List<NodePermission> locallySet, Set<String> settable) {
        this.inherit = inherit;
        this.inherited = inherited;
        this.locallySet = locallySet;
        this.settable = settable;
    }

    public Boolean getIsInheritanceEnabled() {
        return this.inherit;
    }

    public void setIsInheritanceEnabled(boolean inherit) {
        this.inherit = inherit;
    }

    public List<NodePermission> getInherited() {
        return this.inherited;
    }

    public List<NodePermission> getLocallySet() {
        return this.locallySet;
    }

    public void setLocallySet(List<NodePermission> directPermissions) {
        this.locallySet = directPermissions;
    }

    public Set<String> getSettable() {
        return this.settable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(120);
        sb.append("PathInfo [isInheritanceEnabled=").append(this.inherit).append(", inherited=").append(this.getInherited()).append(", locallySet=").append(this.getLocallySet()).append(", settable=").append(this.getSettable()).append(']');
        return sb.toString();
    }

    public static class NodePermission {
        private String authorityId;
        private String name;
        private String accessStatus;

        public NodePermission() {
        }

        public NodePermission(String authorityId, String name, String accessStatus) {
            this.authorityId = authorityId;
            this.name = name;
            this.accessStatus = accessStatus != null ? accessStatus : AccessStatus.ALLOWED.toString();
        }

        public String getName() {
            return this.name;
        }

        public String getAuthorityId() {
            return this.authorityId;
        }

        public String getAccessStatus() {
            return this.accessStatus;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("NodePermission [authorityId=").append(this.authorityId).append(", name=").append(this.name).append(", accessStatus=").append(this.accessStatus).append(']');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodePermission that = (NodePermission)o;
            if (this.authorityId != null ? !this.authorityId.equals(that.authorityId) : that.authorityId != null) {
                return false;
            }
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            int result = this.authorityId != null ? this.authorityId.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

