/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.ActivitiWorkflowEngine;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.workflow.api.impl.ISO8601Converter;
import org.alfresco.rest.workflow.api.model.FormModelElement;
import org.alfresco.rest.workflow.api.model.Item;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;

public class WorkflowRestImpl {
    protected static final String BPM_PACKAGE = "bpm_package";
    protected TenantService tenantService;
    protected AuthorityService authorityService;
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryService;
    protected NodeService nodeService;
    protected ProcessEngine activitiProcessEngine;
    protected boolean deployWorkflowsInTenant;
    protected List<String> excludeModelTypes = new ArrayList<String>(Arrays.asList("bpm_priority", "bpm_description", "bpm_dueDate"));
    private ActivitiWorkflowEngine activitiWorkflowEngine;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setActivitiProcessEngine(ProcessEngine activitiProcessEngine) {
        this.activitiProcessEngine = activitiProcessEngine;
    }

    public void setDeployWorkflowsInTenant(boolean deployWorkflowsInTenant) {
        this.deployWorkflowsInTenant = deployWorkflowsInTenant;
    }

    public NodeRef getNodeRef(String itemId) {
        NodeRef nodeRef = null;
        nodeRef = !NodeRef.isNodeRef((String)itemId) ? new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, itemId) : new NodeRef(itemId);
        return nodeRef;
    }

    public CollectionWithPagingInfo<Item> getItemsFromProcess(String processId, Paging paging) {
        ActivitiScriptNode packageScriptNode = null;
        try {
            HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.activitiProcessEngine.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(processId).variableName(BPM_PACKAGE).singleResult();
            if (variableInstance == null) {
                throw new EntityNotFoundException(processId);
            }
            packageScriptNode = (ActivitiScriptNode)variableInstance.getValue();
        }
        catch (ActivitiObjectNotFoundException e) {
            throw new EntityNotFoundException(processId);
        }
        ArrayList<Item> page = new ArrayList<Item>();
        if (packageScriptNode != null) {
            List documentList = this.nodeService.getChildAssocs(packageScriptNode.getNodeRef());
            for (ChildAssociationRef childAssociationRef : documentList) {
                Item item = this.createItemForNodeRef(childAssociationRef.getChildRef());
                page.add(item);
            }
        }
        return CollectionWithPagingInfo.asPaged(paging, page, false, page.size());
    }

    public Item getItemFromProcess(String itemId, String processId) {
        NodeRef nodeRef = this.getNodeRef(itemId);
        ActivitiScriptNode packageScriptNode = null;
        try {
            HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.activitiProcessEngine.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(processId).variableName(BPM_PACKAGE).singleResult();
            if (variableInstance == null) {
                throw new EntityNotFoundException(processId);
            }
            packageScriptNode = (ActivitiScriptNode)variableInstance.getValue();
        }
        catch (ActivitiObjectNotFoundException e) {
            throw new EntityNotFoundException(processId);
        }
        Item item = null;
        if (packageScriptNode != null) {
            List documentList = this.nodeService.getChildAssocs(packageScriptNode.getNodeRef());
            for (ChildAssociationRef childAssociationRef : documentList) {
                if (!childAssociationRef.getChildRef().equals((Object)nodeRef)) continue;
                item = this.createItemForNodeRef(childAssociationRef.getChildRef());
                break;
            }
        }
        if (item == null) {
            throw new EntityNotFoundException(itemId);
        }
        return item;
    }

    public Item createItemInProcess(String itemId, String processId) {
        NodeRef nodeRef = this.getNodeRef(itemId);
        ActivitiScriptNode packageScriptNode = null;
        try {
            packageScriptNode = (ActivitiScriptNode)this.activitiProcessEngine.getRuntimeService().getVariable(processId, BPM_PACKAGE);
        }
        catch (ActivitiObjectNotFoundException e) {
            throw new EntityNotFoundException(processId);
        }
        if (packageScriptNode == null) {
            throw new InvalidArgumentException("process doesn't contain a workflow package variable");
        }
        try {
            this.nodeService.getProperties(nodeRef);
        }
        catch (Exception e) {
            throw new EntityNotFoundException("item with id " + nodeRef.toString() + " not found");
        }
        try {
            QName workflowPackageItemId = QName.createQName((String)"wpi", (String)nodeRef.toString());
            this.nodeService.addChild(packageScriptNode.getNodeRef(), nodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, workflowPackageItemId);
        }
        catch (Exception e) {
            throw new ApiException("could not add item to process " + e.getMessage(), e);
        }
        Item responseItem = this.createItemForNodeRef(nodeRef);
        this.activitiWorkflowEngine.dispatchPackageUpdatedEvent((Object)packageScriptNode, null, null, processId, null);
        return responseItem;
    }

    public void deleteItemFromProcess(String itemId, String processId) {
        NodeRef nodeRef = this.getNodeRef(itemId);
        ActivitiScriptNode packageScriptNode = null;
        try {
            packageScriptNode = (ActivitiScriptNode)this.activitiProcessEngine.getRuntimeService().getVariable(processId, BPM_PACKAGE);
        }
        catch (ActivitiObjectNotFoundException e) {
            throw new EntityNotFoundException(processId);
        }
        if (packageScriptNode == null) {
            throw new InvalidArgumentException("process doesn't contain a workflow package variable");
        }
        boolean itemIdFoundInPackage = false;
        List documentList = this.nodeService.getChildAssocs(packageScriptNode.getNodeRef());
        for (ChildAssociationRef childAssociationRef : documentList) {
            if (!childAssociationRef.getChildRef().equals((Object)nodeRef)) continue;
            itemIdFoundInPackage = true;
            break;
        }
        if (!itemIdFoundInPackage) {
            throw new EntityNotFoundException("Item " + itemId + " not found in the process package variable");
        }
        try {
            this.nodeService.removeChild(packageScriptNode.getNodeRef(), nodeRef);
            this.activitiWorkflowEngine.dispatchPackageUpdatedEvent((Object)packageScriptNode, null, null, processId, null);
        }
        catch (InvalidNodeRefException e) {
            throw new EntityNotFoundException("Item " + itemId + " not found");
        }
    }

    public <T> T getParameter(Parameters parameters, String parameterName, Class<T> returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException("ReturnType cannot be null");
        }
        try {
            Object result = null;
            String stringValue = parameters.getParameter(parameterName);
            if (stringValue != null && (result = ConvertUtils.convert((String)stringValue, returnType)) instanceof String) {
                throw new IllegalArgumentException("Unable to convert parameter to type: " + returnType.getName());
            }
            return (T)result;
        }
        catch (ConversionException ce) {
            throw new InvalidArgumentException("Parameter value for '" + parameterName + "' should be a valid " + returnType.getSimpleName());
        }
    }

    public CollectionWithPagingInfo<FormModelElement> getFormModelElements(TypeDefinition type, Paging paging) {
        FormModelElement element;
        Map taskProperties = type.getProperties();
        Set<QName> typesToExclude = this.getTypesToExclude(type);
        ArrayList<FormModelElement> page = new ArrayList<FormModelElement>();
        for (Map.Entry entry : taskProperties.entrySet()) {
            String name = ((QName)entry.getKey()).toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(':', '_');
            if (typesToExclude.contains(((PropertyDefinition)entry.getValue()).getContainerClass().getName()) || this.excludeModelTypes.contains(name)) continue;
            element = new FormModelElement();
            element.setName(name);
            element.setQualifiedName(((QName)entry.getKey()).toString());
            element.setTitle(((PropertyDefinition)entry.getValue()).getTitle((MessageLookup)this.dictionaryService));
            element.setRequired(((PropertyDefinition)entry.getValue()).isMandatory());
            element.setDataType(((PropertyDefinition)entry.getValue()).getDataType().getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
            element.setDefaultValue(((PropertyDefinition)entry.getValue()).getDefaultValue());
            if (((PropertyDefinition)entry.getValue()).getConstraints() != null) {
                for (ConstraintDefinition constraintDef : ((PropertyDefinition)entry.getValue()).getConstraints()) {
                    ListOfValuesConstraint valuesConstraint;
                    Constraint constraint = constraintDef.getConstraint();
                    if (constraint == null || !(constraint instanceof ListOfValuesConstraint) || (valuesConstraint = (ListOfValuesConstraint)constraint).getAllowedValues() == null || valuesConstraint.getAllowedValues().size() <= 0) continue;
                    element.setAllowedValues(valuesConstraint.getAllowedValues());
                }
            }
            page.add(element);
        }
        Map taskAssociations = type.getAssociations();
        for (Map.Entry entry : taskAssociations.entrySet()) {
            if (typesToExclude.contains(((AssociationDefinition)entry.getValue()).getSourceClass().getName())) continue;
            element = new FormModelElement();
            element.setName(((QName)entry.getKey()).toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(':', '_'));
            element.setQualifiedName(((QName)entry.getKey()).toString());
            element.setTitle(((AssociationDefinition)entry.getValue()).getTitle((MessageLookup)this.dictionaryService));
            element.setRequired(((AssociationDefinition)entry.getValue()).isTargetMandatory());
            element.setDataType(((AssociationDefinition)entry.getValue()).getTargetClass().getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
            page.add(element);
        }
        return CollectionWithPagingInfo.asPaged(paging, page, false, page.size());
    }

    protected Set<QName> getTypesToExclude(TypeDefinition taskType) {
        HashSet<QName> typesToExclude = new HashSet<QName>();
        boolean contentClassFound = false;
        for (ClassDefinition parentClassDefinition = taskType.getParentClassDefinition(); parentClassDefinition != null; parentClassDefinition = parentClassDefinition.getParentClassDefinition()) {
            if (contentClassFound) {
                typesToExclude.add(parentClassDefinition.getName());
                continue;
            }
            if (!ContentModel.TYPE_CONTENT.equals((Object)parentClassDefinition.getName())) continue;
            typesToExclude.add(ContentModel.TYPE_CONTENT);
            typesToExclude.addAll(parentClassDefinition.getDefaultAspectNames());
            contentClassFound = true;
        }
        return typesToExclude;
    }

    protected List<HistoricVariableInstance> validateIfUserAllowedToWorkWithProcess(String processId) {
        Task task;
        Object initiator;
        String nodeId;
        List variableInstances = this.activitiProcessEngine.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(processId).list();
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        if (variableInstances != null && variableInstances.size() > 0) {
            for (HistoricVariableInstance variableInstance : variableInstances) {
                variableMap.put(variableInstance.getVariableName(), variableInstance.getValue());
            }
        } else {
            throw new EntityNotFoundException(processId);
        }
        if (this.tenantService.isEnabled()) {
            String tenantDomain = (String)variableMap.get("_tenant_domain");
            if (!TenantUtil.getCurrentDomain().equals(tenantDomain)) {
                throw new PermissionDeniedException("Process is running in another tenant");
            }
        }
        String string = nodeId = (initiator = variableMap.get("initiator")) instanceof ActivitiScriptNode ? ((ActivitiScriptNode)initiator).getNodeRef().getId() : ((NodeRef)initiator).getId();
        if (initiator != null && AuthenticationUtil.getRunAsUser().equals(nodeId)) {
            return variableInstances;
        }
        String username = AuthenticationUtil.getRunAsUser();
        if (this.authorityService.isAdminAuthority(username)) {
            return variableInstances;
        }
        ActivitiScriptNode group = (ActivitiScriptNode)variableMap.get("bpm_groupAssignee");
        if (group != null && (task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processId)).singleResult()) != null && task.getAssignee() == null && this.isUserInGroup(username, group.getNodeRef())) {
            return variableInstances;
        }
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery().processInstanceId(processId)).taskInvolvedUser(AuthenticationUtil.getRunAsUser());
        List taskList = query.list();
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            throw new PermissionDeniedException("user is not allowed to access information about process " + processId);
        }
        return variableInstances;
    }

    protected Item createItemForNodeRef(NodeRef nodeRef) {
        Map properties = this.nodeService.getProperties(nodeRef);
        Item item = new Item();
        String name = (String)properties.get(ContentModel.PROP_NAME);
        String title = (String)properties.get(ContentModel.PROP_TITLE);
        String description = (String)properties.get(ContentModel.PROP_DESCRIPTION);
        Date createdAt = (Date)properties.get(ContentModel.PROP_CREATED);
        String createdBy = (String)properties.get(ContentModel.PROP_CREATOR);
        Date modifiedAt = (Date)properties.get(ContentModel.PROP_MODIFIED);
        String modifiedBy = (String)properties.get(ContentModel.PROP_MODIFIER);
        ContentData contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
        item.setId(nodeRef.getId());
        item.setName(name);
        item.setTitle(title);
        item.setDescription(description);
        item.setCreatedAt(createdAt);
        item.setCreatedBy(createdBy);
        item.setModifiedAt(modifiedAt);
        item.setModifiedBy(modifiedBy);
        if (contentData != null) {
            item.setMimeType(contentData.getMimetype());
            item.setSize(contentData.getSize());
        }
        return item;
    }

    public void setActivitiWorkflowEngine(ActivitiWorkflowEngine activitiWorkflowEngine) {
        this.activitiWorkflowEngine = activitiWorkflowEngine;
    }

    private boolean isUserInGroup(String username, NodeRef group) {
        String groupName = (String)((Object)this.nodeService.getProperty(group, ContentModel.PROP_AUTHORITY_NAME));
        Set groupMembers = this.authorityService.getContainedAuthorities(AuthorityType.USER, groupName, false);
        return groupMembers != null && groupMembers.contains(username);
    }

    static {
        ISO8601Converter dateConverter = new ISO8601Converter();
        ConvertUtils.register((Converter)dateConverter, Date.class);
        ConvertUtils.register((Converter)dateConverter, Calendar.class);
    }
}

