/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.tenant.NetworksService;
import org.alfresco.rest.api.Networks;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Network;
import org.alfresco.rest.api.model.NetworkImpl;
import org.alfresco.rest.api.model.PersonNetwork;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;

public class NetworksImpl
implements Networks {
    private People people;
    private NetworksService networksService;

    public void setPeople(People people) {
        this.people = people;
    }

    public void setNetworksService(NetworksService networksService) {
        this.networksService = networksService;
    }

    @Override
    public Network validateNetwork(String networkId) {
        org.alfresco.repo.tenant.Network network = this.networksService.getNetwork(networkId);
        if (network == null) {
            throw new EntityNotFoundException(networkId);
        }
        NetworkImpl restNetwork = new NetworkImpl(network);
        return restNetwork;
    }

    private PersonNetwork getPersonNetwork(org.alfresco.repo.tenant.Network network) {
        NetworkImpl restNetwork = new NetworkImpl(network);
        PersonNetwork personNetwork = new PersonNetwork(network.getIsHomeNetwork(), restNetwork);
        return personNetwork;
    }

    @Override
    public Network getNetwork(String networkId) {
        Network network = this.validateNetwork(networkId);
        return network;
    }

    @Override
    public PersonNetwork getNetwork(String personId, String networkId) {
        personId = this.people.validatePerson(personId, true);
        Network network = this.validateNetwork(networkId);
        org.alfresco.repo.tenant.Network tenantNetwork = this.networksService.getNetwork(network.getId());
        PersonNetwork personNetwork = this.getPersonNetwork(tenantNetwork);
        return personNetwork;
    }

    @Override
    public CollectionWithPagingInfo<PersonNetwork> getNetworks(String personId, Paging paging) {
        personId = this.people.validatePerson(personId, true);
        PagingResults networks = this.networksService.getNetworks(Util.getPagingRequest(paging));
        ArrayList<PersonNetwork> ret = new ArrayList<PersonNetwork>(networks.getPage().size());
        for (org.alfresco.repo.tenant.Network network : networks.getPage()) {
            PersonNetwork personNetwork = this.getPersonNetwork(network);
            ret.add(personNetwork);
        }
        return CollectionWithPagingInfo.asPaged(paging, ret, networks.hasMoreItems(), (Integer)networks.getTotalResultCount().getFirst());
    }
}

