/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search.impl;

import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreMapper {
    public static final String LIVE_NODES = "nodes";
    public static final String VERSIONS = "versions";
    public static final String DELETED = "deleted-nodes";
    public static final String HISTORY = "history";
    private static Log logger = LogFactory.getLog(StoreMapper.class);
    public static final StoreRef STORE_REF_VERSION2_SPACESSTORE = new StoreRef("workspace", "version2Store");
    public static final StoreRef STORE_REF_HISTORY = new StoreRef("workspace", "history");

    public StoreRef getStoreRef(String store) {
        if (store != null && !store.isEmpty()) {
            switch (store.toLowerCase()) {
                case "nodes": {
                    return StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
                }
                case "versions": {
                    return STORE_REF_VERSION2_SPACESSTORE;
                }
                case "deleted-nodes": {
                    return StoreRef.STORE_REF_ARCHIVE_SPACESSTORE;
                }
                case "history": {
                    return STORE_REF_HISTORY;
                }
            }
        }
        throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": scope allowed values: nodes,deleted-nodes,versions"});
    }

    public String getStore(NodeRef nodeRef) {
        if (nodeRef != null) {
            if (StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.equals((Object)nodeRef.getStoreRef())) {
                return LIVE_NODES;
            }
            if (STORE_REF_VERSION2_SPACESSTORE.equals((Object)nodeRef.getStoreRef())) {
                return VERSIONS;
            }
            if (StoreRef.STORE_REF_ARCHIVE_SPACESSTORE.equals((Object)nodeRef.getStoreRef())) {
                return DELETED;
            }
            if (STORE_REF_HISTORY.equals((Object)nodeRef.getStoreRef())) {
                return HISTORY;
            }
        }
        logger.warn((Object)("Unknown store ref: " + String.valueOf(nodeRef)));
        return null;
    }
}

