/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts;

import java.util.Map;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.DeletedResourceException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.framework.webscripts.AbstractResourceWebScript;
import org.alfresco.rest.framework.webscripts.ParamsExtractor;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.http.HttpMethod;

public class ResourceWebScriptGet
extends AbstractResourceWebScript
implements ParamsExtractor,
RecognizedParamsExtractor {
    private static Log logger = LogFactory.getLog(ResourceWebScriptGet.class);

    public ResourceWebScriptGet() {
        this.setHttpMethod(HttpMethod.GET);
        this.setParamsExtractor(this);
    }

    @Override
    public Params extractParams(ResourceMetadata resourceMeta, WebScriptRequest req) {
        Map<String, String> resourceVars = this.locator.parseTemplateVars(req.getServiceMatch().getTemplateVars());
        String entityId = resourceVars.get("entityId");
        String resourceName = resourceVars.get("relationResource");
        String relationshipId = resourceVars.get("relationshipId");
        String propertyName = resourceVars.get("property");
        String relationship2Id = resourceVars.get("relationship2Id");
        Params.RecognizedParams params = this.getRecognizedParams(req);
        switch (resourceMeta.getType()) {
            case ENTITY: {
                if (StringUtils.isNotBlank((CharSequence)entityId)) {
                    return Params.valueOf(params, entityId, null, req);
                }
                return Params.valueOf(params, null, null, req);
            }
            case RELATIONSHIP: {
                if (StringUtils.isNotBlank((CharSequence)propertyName)) {
                    if (StringUtils.isNotBlank((CharSequence)relationship2Id)) {
                        return Params.valueOf(false, entityId, relationshipId, relationship2Id, null, null, null, params, null, req);
                    }
                    return Params.valueOf(true, entityId, relationshipId, null, null, null, null, params, null, req);
                }
                if (StringUtils.isNotBlank((CharSequence)relationshipId)) {
                    return Params.valueOf(false, entityId, relationshipId, null, null, null, null, params, null, req);
                }
                return Params.valueOf(true, entityId, null, null, null, null, null, params, null, req);
            }
            case PROPERTY: {
                if (!StringUtils.isNotBlank((CharSequence)entityId) || !StringUtils.isNotBlank((CharSequence)resourceName)) break;
                if (StringUtils.isNotBlank((CharSequence)propertyName)) {
                    return Params.valueOf(false, entityId, relationshipId, relationship2Id, null, null, propertyName, params, null, req);
                }
                return Params.valueOf(entityId, null, null, null, resourceName, params, null, req);
            }
        }
        throw new UnsupportedResourceOperationException("GET not supported for Actions");
    }

    @Override
    public Object executeAction(ResourceWithMetadata resource, Params params, WithResponse withResponse) throws Throwable {
        switch (resource.getMetaData().getType()) {
            case ENTITY: {
                if (StringUtils.isBlank((CharSequence)params.getEntityId()) || params.isCollectionResource()) {
                    if (EntityResourceAction.Read.class.isAssignableFrom(resource.getResource().getClass())) {
                        if (resource.getMetaData().isDeleted(EntityResourceAction.Read.class)) {
                            throw new DeletedResourceException("(GET) " + resource.getMetaData().getUniqueId());
                        }
                        EntityResourceAction.Read getter = (EntityResourceAction.Read)resource.getResource();
                        CollectionWithPagingInfo resources = getter.readAll(params);
                        return resources;
                    }
                    if (EntityResourceAction.ReadWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                        if (resource.getMetaData().isDeleted(EntityResourceAction.ReadWithResponse.class)) {
                            throw new DeletedResourceException("(GET) " + resource.getMetaData().getUniqueId());
                        }
                        EntityResourceAction.ReadWithResponse getter = (EntityResourceAction.ReadWithResponse)resource.getResource();
                        CollectionWithPagingInfo resources = getter.readAll(params, withResponse);
                        return resources;
                    }
                    if (EntityResourceAction.DeleteSetWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                        if (resource.getMetaData().isDeleted(EntityResourceAction.DeleteSetWithResponse.class)) {
                            throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                        }
                        EntityResourceAction.DeleteSetWithResponse relationDeleter = (EntityResourceAction.DeleteSetWithResponse)resource.getResource();
                        relationDeleter.deleteSet(params, withResponse);
                        return null;
                    }
                    if (EntityResourceAction.DeleteSet.class.isAssignableFrom(resource.getResource().getClass())) {
                        if (resource.getMetaData().isDeleted(EntityResourceAction.Delete.class)) {
                            throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                        }
                        EntityResourceAction.DeleteSet relationDeleter = (EntityResourceAction.DeleteSet)resource.getResource();
                        relationDeleter.deleteSet(params);
                        return null;
                    }
                    throw new UnsupportedResourceOperationException();
                }
                if (EntityResourceAction.ReadById.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.ReadById.class)) {
                        throw new DeletedResourceException("(GET by id) " + resource.getMetaData().getUniqueId());
                    }
                    EntityResourceAction.ReadById entityGetter = (EntityResourceAction.ReadById)resource.getResource();
                    Object result = entityGetter.readById(params.getEntityId(), params);
                    return result;
                }
                if (EntityResourceAction.ReadByIdWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.ReadByIdWithResponse.class)) {
                        throw new DeletedResourceException("(GET by id) " + resource.getMetaData().getUniqueId());
                    }
                    EntityResourceAction.ReadByIdWithResponse entityGetter = (EntityResourceAction.ReadByIdWithResponse)resource.getResource();
                    Object result = entityGetter.readById(params.getEntityId(), params, withResponse);
                    return result;
                }
                throw new UnsupportedResourceOperationException();
            }
            case RELATIONSHIP: {
                if (StringUtils.isBlank((CharSequence)params.getRelationshipId()) || params.isCollectionResource()) {
                    if (RelationshipResourceAction.Read.class.isAssignableFrom(resource.getResource().getClass())) {
                        if (resource.getMetaData().isDeleted(RelationshipResourceAction.Read.class)) {
                            throw new DeletedResourceException("(GET) " + resource.getMetaData().getUniqueId());
                        }
                        RelationshipResourceAction.Read relationGetter = (RelationshipResourceAction.Read)resource.getResource();
                        CollectionWithPagingInfo relations = relationGetter.readAll(params.getEntityId(), params);
                        return relations;
                    }
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.ReadWithResponse.class)) {
                        throw new DeletedResourceException("(GET) " + resource.getMetaData().getUniqueId());
                    }
                    if (!RelationshipResourceAction.ReadWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                        throw new UnsupportedResourceOperationException();
                    }
                    RelationshipResourceAction.ReadWithResponse relationGetter = (RelationshipResourceAction.ReadWithResponse)resource.getResource();
                    CollectionWithPagingInfo relations = relationGetter.readAll(params.getEntityId(), params, withResponse);
                    return relations;
                }
                if (RelationshipResourceAction.ReadById.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.ReadById.class)) {
                        throw new DeletedResourceException("(GET by id) " + resource.getMetaData().getUniqueId());
                    }
                    RelationshipResourceAction.ReadById relationGetter = (RelationshipResourceAction.ReadById)resource.getResource();
                    Object result = relationGetter.readById(params.getEntityId(), params.getRelationshipId(), params);
                    return result;
                }
                if (RelationshipResourceAction.ReadByIdWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.ReadByIdWithResponse.class)) {
                        throw new DeletedResourceException("(GET by id) " + resource.getMetaData().getUniqueId());
                    }
                    RelationshipResourceAction.ReadByIdWithResponse relationGetter = (RelationshipResourceAction.ReadByIdWithResponse)resource.getResource();
                    Object result = relationGetter.readById(params.getEntityId(), params.getRelationshipId(), params, withResponse);
                    return result;
                }
                throw new UnsupportedResourceOperationException();
            }
            case PROPERTY: {
                if (StringUtils.isNotBlank((CharSequence)params.getEntityId())) {
                    if (BinaryResourceAction.Read.class.isAssignableFrom(resource.getResource().getClass())) {
                        if (resource.getMetaData().isDeleted(BinaryResourceAction.Read.class)) {
                            throw new DeletedResourceException("(GET) " + resource.getMetaData().getUniqueId());
                        }
                        BinaryResourceAction.Read getter = (BinaryResourceAction.Read)resource.getResource();
                        BinaryResource prop = getter.readProperty(params.getEntityId(), params);
                        return prop;
                    }
                    if (BinaryResourceAction.ReadWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                        if (resource.getMetaData().isDeleted(BinaryResourceAction.ReadWithResponse.class)) {
                            throw new DeletedResourceException("(GET) " + resource.getMetaData().getUniqueId());
                        }
                        BinaryResourceAction.ReadWithResponse getter = (BinaryResourceAction.ReadWithResponse)resource.getResource();
                        BinaryResource prop = getter.readProperty(params.getEntityId(), params, withResponse);
                        return prop;
                    }
                    if (RelationshipResourceBinaryAction.Read.class.isAssignableFrom(resource.getResource().getClass())) {
                        if (resource.getMetaData().isDeleted(RelationshipResourceBinaryAction.Read.class)) {
                            throw new DeletedResourceException("(GET) " + resource.getMetaData().getUniqueId());
                        }
                        RelationshipResourceBinaryAction.Read getter = (RelationshipResourceBinaryAction.Read)resource.getResource();
                        BinaryResource prop = getter.readProperty(params.getEntityId(), params.getRelationshipId(), params);
                        return prop;
                    }
                    if (!RelationshipResourceBinaryAction.ReadWithResponse.class.isAssignableFrom(resource.getResource().getClass())) break;
                    if (resource.getMetaData().isDeleted(RelationshipResourceBinaryAction.ReadWithResponse.class)) {
                        throw new DeletedResourceException("(GET) " + resource.getMetaData().getUniqueId());
                    }
                    RelationshipResourceBinaryAction.ReadWithResponse getter = (RelationshipResourceBinaryAction.ReadWithResponse)resource.getResource();
                    BinaryResource prop = getter.readProperty(params.getEntityId(), params.getRelationshipId(), params, withResponse);
                    return prop;
                }
                throw new UnsupportedResourceOperationException();
            }
        }
        throw new UnsupportedResourceOperationException("GET not supported for Actions");
    }
}

