/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Tag
implements Serializable,
ExpectedComparison,
Comparable<Tag> {
    private static final long serialVersionUID = -5730063374759199632L;
    private String nodeId;
    private String id;
    private String tag;

    public Tag(String tag) {
        this.tag = tag;
    }

    public Tag(String id, String tag) {
        this.id = id;
        this.tag = tag;
    }

    public Tag(String nodeId, String id, String tag) {
        this.nodeId = nodeId;
        this.id = id;
        this.tag = tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return "Tag [nodeId=" + this.nodeId + ", id=" + this.id + ", tag=" + this.tag + "]";
    }

    public static Tag parseTag(String nodeId, JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String value = (String)jsonObject.get((Object)"tag");
        Tag tag = new Tag(nodeId, id, value);
        return tag;
    }

    public static PublicApiClient.ListResponse<Tag> parseTags(String nodeId, JSONObject jsonObject) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            tags.add(Tag.parseTag(nodeId, entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<Tag> resp = new PublicApiClient.ListResponse<Tag>(paging, tags);
        return resp;
    }

    public JSONObject toJSON() {
        JSONObject entry = new JSONObject();
        entry.put((Object)"tag", (Object)this.getTag());
        return entry;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(Tag o) {
        return this.tag.compareTo(o.getTag());
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof Tag));
        Tag other = (Tag)o;
        AssertUtil.assertEquals("id", this.id, other.getId());
        AssertUtil.assertEquals("tag", this.tag.toUpperCase(), other.getTag().toUpperCase());
    }
}

