/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.resource.parameters.InvalidSelectException;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.tests.core.ParamsExtender;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RecognizedParamsExtractorTest
implements RecognizedParamsExtractor {
    @Test
    public void getFilterTest() {
        BeanPropertiesFilter theFilter = this.getFilter(null);
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Null passed in so must return the default BeanPropertiesFilter.ALLOW_ALL class", (boolean)BeanPropertiesFilter.AllProperties.class.equals(theFilter.getClass()));
        Assert.assertTrue((boolean)theFilter.isAllowed("bob"));
        Assert.assertTrue((boolean)theFilter.isAllowed("fred"));
        Assert.assertTrue((boolean)theFilter.isAllowed("50"));
        Assert.assertTrue((boolean)theFilter.isAllowed("b.z"));
        theFilter = this.getFilter("bob");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must return the BeanPropertiesFilter class", (boolean)(theFilter instanceof BeanPropertiesFilter));
        Assert.assertTrue((boolean)theFilter.isAllowed("bob"));
        Assert.assertFalse((boolean)theFilter.isAllowed("fred"));
        Assert.assertFalse((boolean)theFilter.isAllowed("50"));
        Assert.assertFalse((boolean)theFilter.isAllowed("b.z"));
        theFilter = this.getFilter("50,fred,b.z");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must return the BeanPropertiesFilter class", (boolean)(theFilter instanceof BeanPropertiesFilter));
        Assert.assertFalse((boolean)theFilter.isAllowed("bob"));
        Assert.assertTrue((boolean)theFilter.isAllowed("fred"));
        Assert.assertTrue((boolean)theFilter.isAllowed("50"));
        Assert.assertTrue((boolean)theFilter.isAllowed("b.z"));
        theFilter = this.getFilter("50,fred,");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must return the BeanPropertiesFilter class", (boolean)(theFilter instanceof BeanPropertiesFilter));
        Assert.assertFalse((boolean)theFilter.isAllowed("bob"));
        Assert.assertTrue((boolean)theFilter.isAllowed("fred"));
        Assert.assertTrue((boolean)theFilter.isAllowed("50"));
        Assert.assertFalse((boolean)theFilter.isAllowed("b.z"));
        theFilter = this.getFilter("50, bob, fred ,");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must return the BeanPropertiesFilter class", (boolean)(theFilter instanceof BeanPropertiesFilter));
        Assert.assertTrue((boolean)theFilter.isAllowed("bob"));
        Assert.assertTrue((boolean)theFilter.isAllowed("fred"));
        Assert.assertTrue((boolean)theFilter.isAllowed("50"));
        Assert.assertFalse((boolean)theFilter.isAllowed("b.z"));
    }

    @Test
    public void getSortingTest() {
        List theSort = this.getSort(null);
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Null passed in so empty sort list should be returned.", (boolean)theSort.isEmpty());
        theSort = this.getSort("name ASC");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((boolean)((SortColumn)theSort.get((int)0)).asc);
        theSort = this.getSort("name ");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((boolean)((SortColumn)theSort.get((int)0)).asc);
        theSort = this.getSort("name DESC");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((!((SortColumn)theSort.get((int)0)).asc ? 1 : 0) != 0);
        theSort = this.getSort("name desc");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((!((SortColumn)theSort.get((int)0)).asc ? 1 : 0) != 0);
        theSort = this.getSort("name,age desc");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((boolean)((SortColumn)theSort.get((int)0)).asc);
        Assert.assertEquals((Object)"age", (Object)((SortColumn)theSort.get((int)1)).column);
        Assert.assertTrue((!((SortColumn)theSort.get((int)1)).asc ? 1 : 0) != 0);
        theSort = this.getSort(" name, age desc");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((boolean)((SortColumn)theSort.get((int)0)).asc);
        Assert.assertEquals((Object)"age", (Object)((SortColumn)theSort.get((int)1)).column);
        Assert.assertTrue((!((SortColumn)theSort.get((int)1)).asc ? 1 : 0) != 0);
        theSort = this.getSort("name DESC, age desc");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((!((SortColumn)theSort.get((int)0)).asc ? 1 : 0) != 0);
        Assert.assertEquals((Object)"age", (Object)((SortColumn)theSort.get((int)1)).column);
        Assert.assertTrue((!((SortColumn)theSort.get((int)1)).asc ? 1 : 0) != 0);
        theSort = this.getSort("age DeSc, name AsC");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"age", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((!((SortColumn)theSort.get((int)0)).asc ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)1)).column);
        Assert.assertTrue((boolean)((SortColumn)theSort.get((int)1)).asc);
        theSort = this.getSort("name asc,");
        Assert.assertNotNull((Object)theSort);
        Assert.assertTrue((String)"Must have a value for column: NAME", (!theSort.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((theSort.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"name", (Object)((SortColumn)theSort.get((int)0)).column);
        Assert.assertTrue((boolean)((SortColumn)theSort.get((int)0)).asc);
        try {
            this.getSort("age asc, name des");
            Assert.fail((String)"Should throw an InvalidArgumentException");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        try {
            this.getSort("age asc name");
            Assert.fail((String)"Should throw an InvalidArgumentException");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIncludeClauseTest() {
        this.getClauseTest("include");
    }

    @Test
    public void getSelectClauseTest() {
        this.getClauseTest("select");
    }

    private void getClauseTest(String paramName) {
        List<String> theClause = this.getCorrectClause(paramName, null);
        Assert.assertNotNull(theClause);
        Assert.assertFalse((String)("Null passed in so nothing in the " + paramName), (theClause.size() > 0 ? 1 : 0) != 0);
        try {
            theClause = this.getCorrectClause(paramName, ",,,");
            Assert.fail((String)"Should throw an InvalidSelectException");
        }
        catch (InvalidSelectException invalidSelectException) {
            // empty catch block
        }
        try {
            theClause = this.getCorrectClause(paramName, "(,,,");
            Assert.fail((String)"Should throw an InvalidSelectException");
        }
        catch (InvalidSelectException invalidSelectException) {
            // empty catch block
        }
        try {
            theClause = this.getCorrectClause(paramName, "(,,,)");
            Assert.fail((String)"Should throw an InvalidSelectException");
        }
        catch (InvalidSelectException invalidSelectException) {
            // empty catch block
        }
        try {
            theClause = this.getCorrectClause(paramName, "x/,z");
            Assert.fail((String)"Should throw an InvalidSelectException");
        }
        catch (InvalidSelectException invalidSelectException) {
            // empty catch block
        }
        try {
            theClause = this.getCorrectClause(paramName, "/x'n,/z");
            Assert.fail((String)"Should throw an InvalidSelectException");
        }
        catch (InvalidSelectException invalidSelectException) {
            // empty catch block
        }
        try {
            theClause = this.getCorrectClause(paramName, "/foo/0");
            Assert.fail((String)"Should throw an InvalidSelectException. Legal identifiers must start with a letter not zero");
        }
        catch (InvalidSelectException invalidSelectException) {
            // empty catch block
        }
        try {
            theClause = this.getCorrectClause(paramName, "/");
            Assert.fail((String)"Should throw an InvalidSelectException. No identifier specified.");
        }
        catch (InvalidSelectException invalidSelectException) {
            // empty catch block
        }
        try {
            theClause = this.getCorrectClause(paramName, "path, isLink");
            Assert.fail((String)"Should throw an InvalidSelectException. No identifier specified.");
        }
        catch (InvalidSelectException invalidSelectException) {
            // empty catch block
        }
        theClause = this.getCorrectClause(paramName, "king/kong");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"king/kong", (Object)theClause.get(0));
        theClause = this.getCorrectClause(paramName, "x,y");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"x", (Object)theClause.get(0));
        Assert.assertEquals((Object)"y", (Object)theClause.get(1));
        theClause = this.getCorrectClause(paramName, "x,/z");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"x", (Object)theClause.get(0));
        Assert.assertEquals((Object)"/z", (Object)theClause.get(1));
        theClause = this.getCorrectClause(paramName, "/b");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"/b", (Object)theClause.get(0));
        theClause = this.getCorrectClause(paramName, "/be,/he");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"/be", (Object)theClause.get(0));
        Assert.assertEquals((Object)"/he", (Object)theClause.get(1));
        theClause = this.getCorrectClause(paramName, "/king/kong");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"/king/kong", (Object)theClause.get(0));
        theClause = this.getCorrectClause(paramName, "/name,/person/age");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"/name", (Object)theClause.get(0));
        Assert.assertEquals((Object)"/person/age", (Object)theClause.get(1));
        theClause = this.getCorrectClause(paramName, "/foo");
        Assert.assertTrue((String)"has a valid select", (theClause.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"/foo", (Object)theClause.get(0));
        theClause = this.getCorrectClause(paramName, "/foo/anArray/x");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"/foo/anArray/x", (Object)theClause.get(0));
        theClause = this.getCorrectClause(paramName, "/foo/anArray/x,/person/age,/eggs/bacon/sausage,/p");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"/foo/anArray/x", (Object)theClause.get(0));
        Assert.assertEquals((Object)"/person/age", (Object)theClause.get(1));
        Assert.assertEquals((Object)"/eggs/bacon/sausage", (Object)theClause.get(2));
        Assert.assertEquals((Object)"/p", (Object)theClause.get(3));
        theClause = this.getCorrectClause(paramName, "/foo/_bar ");
        Assert.assertTrue((String)("has a valid " + paramName), (theClause.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"/foo/_bar", (Object)theClause.get(0));
    }

    private List<String> getCorrectClause(String paramName, String paramValue) {
        if (paramName.equalsIgnoreCase("include")) {
            return this.getIncludeClause(paramValue);
        }
        if (paramName.equalsIgnoreCase("select")) {
            return this.getSelectClause(paramValue);
        }
        Assert.fail((String)("Unexpected clause: " + paramName));
        return null;
    }

    @Test
    public void getRelationFilterTest() {
        Map theFilter = this.getRelationFilter(null);
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Null passed in so nothing to filter.", (boolean)theFilter.isEmpty());
        theFilter = this.getRelationFilter("bob");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must be a single relationship", (theFilter.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Must be a single relationship called bob", (boolean)theFilter.containsKey("bob"));
        BeanPropertiesFilter aFilter = (BeanPropertiesFilter)theFilter.get("bob");
        Assert.assertTrue((String)"No bean properties specified so need a BeanPropertiesFilter.ALLOW_ALL class", (boolean)BeanPropertiesFilter.AllProperties.class.equals(aFilter.getClass()));
        theFilter = this.getRelationFilter("bob,hope");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must be a two relationships", (theFilter.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Must have hope.", (boolean)theFilter.containsKey("hope"));
        aFilter = (BeanPropertiesFilter)theFilter.get("hope");
        Assert.assertTrue((String)"No bean properties specified so need a BeanPropertiesFilter.ALLOW_ALL class", (boolean)BeanPropertiesFilter.AllProperties.class.equals(aFilter.getClass()));
        theFilter = this.getRelationFilter("bob(name),hope");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must be a two relationships", (theFilter.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Must have bob.", (boolean)theFilter.containsKey("bob"));
        aFilter = (BeanPropertiesFilter)theFilter.get("bob");
        Assert.assertTrue((String)"Bean properties specified so must be an BeanPropertiesFilter class", (boolean)BeanPropertiesFilter.class.equals(aFilter.getClass()));
        theFilter = this.getRelationFilter("bob,hope(age,name)");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must be a two relationships", (theFilter.size() == 2 ? 1 : 0) != 0);
        aFilter = (BeanPropertiesFilter)theFilter.get("bob");
        Assert.assertTrue((String)"No bean properties specified so need a BeanPropertiesFilter.ALLOW_ALL class", (boolean)BeanPropertiesFilter.AllProperties.class.equals(aFilter.getClass()));
        aFilter = (BeanPropertiesFilter)theFilter.get("hope");
        Assert.assertTrue((String)"Bean properties specified so must be an BeanPropertiesFilter class", (boolean)BeanPropertiesFilter.class.equals(aFilter.getClass()));
        theFilter = this.getRelationFilter("bob(name,age),nohope,hope(height,width)");
        Assert.assertNotNull((Object)theFilter);
        Assert.assertTrue((String)"Must be a three relationships", (theFilter.size() == 3 ? 1 : 0) != 0);
        aFilter = (BeanPropertiesFilter)theFilter.get("bob");
        Assert.assertTrue((String)"Bean properties specified so must be an BeanPropertiesFilter class", (boolean)BeanPropertiesFilter.class.equals(aFilter.getClass()));
        aFilter = (BeanPropertiesFilter)theFilter.get("nohope");
        Assert.assertTrue((String)"No bean properties specified so need a ReturnAllBeanProperties class", (boolean)BeanPropertiesFilter.AllProperties.class.equals(aFilter.getClass()));
        aFilter = (BeanPropertiesFilter)theFilter.get("hope");
        Assert.assertTrue((String)"Bean properties specified so must be an BeanPropertiesFilter class", (boolean)BeanPropertiesFilter.class.equals(aFilter.getClass()));
    }

    @Test
    public void findPagingTest() {
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn((Object)"34");
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"50");
        Paging pagin = this.findPaging(request);
        Assert.assertNotNull((Object)pagin);
        Assert.assertTrue((pagin.getSkipCount() == 34 ? 1 : 0) != 0);
        Assert.assertTrue((pagin.getMaxItems() == 50 ? 1 : 0) != 0);
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn(null);
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn(null);
        pagin = this.findPaging(request);
        Assert.assertNotNull((Object)pagin);
        Assert.assertTrue((pagin.getSkipCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pagin.getMaxItems() == 100 ? 1 : 0) != 0);
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn((Object)"55");
        pagin = this.findPaging(request);
        Assert.assertNotNull((Object)pagin);
        Assert.assertTrue((pagin.getSkipCount() == 55 ? 1 : 0) != 0);
        Assert.assertTrue((pagin.getMaxItems() == 100 ? 1 : 0) != 0);
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn(null);
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"45");
        pagin = this.findPaging(request);
        Assert.assertNotNull((Object)pagin);
        Assert.assertTrue((pagin.getMaxItems() == 45 ? 1 : 0) != 0);
        Assert.assertTrue((pagin.getSkipCount() == 0 ? 1 : 0) != 0);
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn((Object)"apple");
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"pear");
        try {
            pagin = this.findPaging(request);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn((Object)"0");
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"0");
        try {
            pagin = this.findPaging(request);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn((Object)"0");
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"a");
        try {
            pagin = this.findPaging(request);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn((Object)"s");
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"5");
        try {
            pagin = this.findPaging(request);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn((Object)"0");
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"-2");
        try {
            pagin = this.findPaging(request);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("skipCount")).thenReturn((Object)"-3");
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"5");
        try {
            pagin = this.findPaging(request);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
        request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameter("maxItems")).thenReturn((Object)"5");
        pagin = this.findPaging(request);
        Assert.assertNotNull((Object)pagin);
        Assert.assertTrue((String)"skip count defaults to 0", (pagin.getSkipCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void paramsTest() {
        HashMap<String, List<String>> mockParams = new HashMap<String, List<String>>();
        mockParams.put("age", Arrays.asList("23", "45"));
        mockParams.put("name", Arrays.asList("fred"));
        WebScriptRequest request = this.mockRequest(mockParams);
        Map params = this.getRequestParameters(request);
        Assert.assertNotNull((Object)params);
        Params paramObj = ParamsExtender.valueOf(params);
        Assert.assertNotNull((Object)paramObj);
        String aValue = paramObj.getParameter("age");
        Assert.assertEquals((Object)"23", (Object)aValue);
        aValue = paramObj.getParameter("name");
        Assert.assertEquals((Object)"fred", (Object)aValue);
    }

    private WebScriptRequest mockRequest(final Map<String, List<String>> params) {
        String[] paramNames = params.keySet().toArray(new String[0]);
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getParameterNames()).thenReturn((Object)paramNames);
        Mockito.when((Object)request.getParameterValues(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<String[]>(){

            public String[] answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return ((List)params.get((String)args[0])).toArray(new String[0]);
            }
        });
        return request;
    }
}

