/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.opencmis.BaseUrlGenerator;
import org.alfresco.opencmis.CMISDispatcherRegistry;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.web.scripts.TenantWebScriptServletRequest;
import org.alfresco.service.descriptor.Descriptor;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;

public class CMISHttpServletRequest
extends HttpServletRequestWrapper {
    protected WebScriptRequest req;
    protected String networkId;
    protected String operation;
    protected String id;
    protected String serviceName;
    protected BaseUrlGenerator baseUrlGenerator;
    protected CMISDispatcherRegistry.Binding binding;
    protected Descriptor currentDescriptor;

    public CMISHttpServletRequest(WebScriptRequest req, String serviceName, BaseUrlGenerator baseUrlGenerator, CMISDispatcherRegistry.Binding binding, Descriptor currentDescriptor, TenantAdminService tenantAdminService) {
        super(WebScriptServletRuntime.getHttpServletRequest((WebScriptRequest)req));
        this.req = req;
        this.serviceName = serviceName;
        this.baseUrlGenerator = baseUrlGenerator;
        this.binding = binding;
        String pathInfo = req.getPathInfo();
        WebScriptRequest baseReq = this.getBaseRequest(req);
        if (!pathInfo.startsWith("/cmis") && baseReq instanceof TenantWebScriptServletRequest) {
            String user;
            String domain;
            TenantWebScriptServletRequest servletReq = (TenantWebScriptServletRequest)baseReq;
            String tenant = servletReq.getTenant();
            this.networkId = tenant.equalsIgnoreCase("-default-") ? ((domain = tenantAdminService.getUserDomain(user = AuthenticationUtil.getFullyAuthenticatedUser())) == null || domain.equals("") ? tenant : domain) : tenant;
        }
        Match match = req.getServiceMatch();
        Map templateVars = match.getTemplateVars();
        this.operation = (String)templateVars.get("operation");
        this.id = (String)templateVars.get("id");
        this.addAttributes();
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    private WebScriptRequest getBaseRequest(WebScriptRequest req) {
        WebScriptRequest ret = req;
        while (ret instanceof WrappingWebScriptRequest) {
            WrappingWebScriptRequest wrapping = (WrappingWebScriptRequest)req;
            ret = wrapping.getNext();
        }
        return ret;
    }

    protected void addAttributes() {
        if (this.networkId != null) {
            super.setAttribute("repositoryId", (Object)this.networkId);
        }
        super.setAttribute("serviceName", (Object)this.serviceName);
    }

    public Object getAttribute(String arg0) {
        if (arg0.equals("org.apache.chemistry.opencmis.baseurl")) {
            return this.baseUrlGenerator.getBaseUrl(this.getRequest(), this.networkId, this.binding);
        }
        return super.getAttribute(arg0);
    }

    public Enumeration getAttributeNames() {
        Enumeration e = super.getAttributeNames();
        ArrayList attrNames = new ArrayList();
        while (e.hasMoreElements()) {
            attrNames.add(e.nextElement());
        }
        attrNames.add("org.apache.chemistry.opencmis.baseurl");
        final Iterator it = attrNames.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
    }

    public String getParameter(String arg0) {
        if (arg0.equals("repositoryId")) {
            return this.networkId;
        }
        return super.getParameter(arg0);
    }

    public Map getParameterMap() {
        Map map = super.getParameterMap();
        HashedMap ret = new HashedMap(map);
        if (this.networkId != null) {
            ret.put("repositoryId", new String[]{this.networkId});
        }
        return ret;
    }

    public Enumeration getParameterNames() {
        Enumeration e = super.getParameterNames();
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        if (this.networkId != null) {
            l.add("repositoryId");
        }
        final Iterator it = l.iterator();
        Enumeration ret = new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
        return ret;
    }

    public String getContextPath() {
        String contextPath = this.baseUrlGenerator.getContextPath(this.getRequest());
        return contextPath;
    }

    public String getPathInfo() {
        StringBuilder sb = new StringBuilder("/");
        sb.append(this.networkId == null ? "-default-" : this.networkId);
        if (this.operation != null) {
            sb.append("/");
            sb.append(this.operation);
        }
        return sb.toString();
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        String reqQueryString = super.getQueryString();
        if (this.networkId != null && this.networkId.length() > 0) {
            if (reqQueryString != null) {
                queryString.append(reqQueryString + "&");
            }
            queryString.append("repositoryId=" + this.networkId);
            if (this.operation == null || this.operation.isEmpty()) {
                queryString.append("&cmisselector=");
                queryString.append("repositoryInfo");
            }
            return queryString.toString();
        }
        return reqQueryString;
    }

    public String getRequestURI() {
        String requestURI = this.baseUrlGenerator.getRequestURI(this.getRequest(), this.networkId, this.operation, this.id);
        return requestURI;
    }

    public String getServletPath() {
        String servletPath = this.baseUrlGenerator.getServletPath(this.getRequest());
        return servletPath;
    }
}

