/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class MimetypeDescriptionsGet
extends DeclarativeWebScript {
    public static final String MODEL_MIMETYPES = "mimetypes";
    public static final String MODEL_DEFAULT_EXTENSIONS = "defaultExtensions";
    public static final String MODEL_OTHER_EXTENSIONS = "otherExtensions";
    private MimetypeService mimetypeService;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map mimetypes = this.mimetypeService.getDisplaysByMimetype();
        Map extensions = this.mimetypeService.getMimetypesByExtension();
        Map defaultExtensions = this.mimetypeService.getExtensionsByMimetype();
        HashMap otherExtensions = new HashMap();
        for (String extension : extensions.keySet()) {
            String mimetype;
            if (extension.equals(defaultExtensions.get(mimetype = (String)extensions.get(extension)))) continue;
            if (!otherExtensions.containsKey(mimetype)) {
                otherExtensions.put(mimetype, new ArrayList());
            }
            ((List)otherExtensions.get(mimetype)).add(extension);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_MIMETYPES, mimetypes);
        model.put(MODEL_DEFAULT_EXTENSIONS, defaultExtensions);
        model.put(MODEL_OTHER_EXTENSIONS, otherExtensions);
        return model;
    }
}

