/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.tenant.NetworksService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.SiteMembershipRequests;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.model.Person;
import org.alfresco.rest.api.model.SiteMembershipApproval;
import org.alfresco.rest.api.model.SiteMembershipRejection;
import org.alfresco.rest.api.model.SiteMembershipRequest;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationExceptionForbidden;
import org.alfresco.service.cmr.invitation.InvitationExceptionNotFound;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.ModeratedInvitation;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteMembershipRequestsImpl
implements SiteMembershipRequests {
    private static final Log logger = LogFactory.getLog(SiteMembershipRequestsImpl.class);
    public static final String DEFAULT_ROLE = "SiteConsumer";
    private static final Set<String> LIST_SITE_MEMBERSHIPS_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("siteId", "personId"));
    private People people;
    private Sites sites;
    private SiteService siteService;
    private NodeService nodeService;
    private InvitationService invitationService;
    private NetworksService networksService;

    public void setNetworksService(NetworksService networksService) {
        this.networksService = networksService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPeople(People people) {
        this.people = people;
    }

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    private Invitation getSiteInvitation(String inviteeId, String siteId) {
        InvitationSearchCriteriaImpl criteria = new InvitationSearchCriteriaImpl();
        criteria.setInvitationType(InvitationSearchCriteria.InvitationType.MODERATED);
        criteria.setInvitee(inviteeId);
        criteria.setResourceName(siteId);
        criteria.setResourceType(Invitation.ResourceType.WEB_SITE);
        List invitations = this.invitationService.searchInvitation((InvitationSearchCriteria)criteria);
        if (invitations.size() > 1) {
            throw new AlfrescoRuntimeException("There should be only one outstanding site invitation");
        }
        return invitations.size() == 0 ? null : (Invitation)invitations.get(0);
    }

    private List<Invitation> getSiteInvitations(String inviteeId) {
        InvitationSearchCriteriaImpl criteria = new InvitationSearchCriteriaImpl();
        criteria.setInvitationType(InvitationSearchCriteria.InvitationType.MODERATED);
        criteria.setInvitee(inviteeId);
        criteria.setResourceType(Invitation.ResourceType.WEB_SITE);
        List invitations = this.invitationService.searchInvitation((InvitationSearchCriteria)criteria);
        return invitations;
    }

    private SiteMembershipRequest inviteToModeratedSite(String message, String inviteeId, String siteId, String inviteeRole, String clientName) {
        ModeratedInvitation invitation = this.invitationService.inviteModerated(message, inviteeId, Invitation.ResourceType.WEB_SITE, siteId, inviteeRole, clientName);
        SiteMembershipRequest ret = new SiteMembershipRequest();
        ret.setId(siteId);
        ret.setMessage(message);
        ret.setCreatedAt(invitation.getCreatedAt());
        return ret;
    }

    private SiteMembershipRequest inviteToSite(String siteId, String inviteeId, String inviteeRole, String message) {
        this.siteService.setMembership(siteId, inviteeId, inviteeRole);
        SiteMembershipRequest ret = new SiteMembershipRequest();
        ret.setId(siteId);
        ret.setMessage(message);
        Date createdAt = new Date();
        ret.setCreatedAt(createdAt);
        return ret;
    }

    private SiteMembershipRequest inviteToPublicSite(SiteInfo siteInfo, final String message, final String inviteeId, final String inviteeRole) {
        SiteMembershipRequest siteMembershipRequest = null;
        final String siteId = siteInfo.getShortName();
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        String siteCreator = (String)((Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_CREATOR));
        String siteNetwork = this.networksService.getUserDefaultNetwork(siteCreator);
        siteMembershipRequest = StringUtils.isNotEmpty((CharSequence)siteNetwork) ? (SiteMembershipRequest)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<SiteMembershipRequest>(){

            public SiteMembershipRequest doWork() throws Exception {
                return SiteMembershipRequestsImpl.this.inviteToSite(siteId, inviteeId, inviteeRole, message);
            }
        }, (String)siteCreator, (String)siteNetwork) : (SiteMembershipRequest)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<SiteMembershipRequest>(){

            public SiteMembershipRequest doWork() throws Exception {
                return SiteMembershipRequestsImpl.this.inviteToSite(siteId, inviteeId, inviteeRole, message);
            }
        }, (String)siteCreator);
        return siteMembershipRequest;
    }

    @Override
    public SiteMembershipRequest createSiteMembershipRequest(String inviteeId, SiteMembershipRequest siteInvite) {
        SiteMembershipRequest request = null;
        inviteeId = this.people.validatePerson(inviteeId, true);
        String siteId = siteInvite.getId();
        SiteInfo siteInfo = this.sites.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        siteId = siteInfo.getShortName();
        SiteVisibility siteVisibility = siteInfo.getVisibility();
        if (siteVisibility.equals((Object)SiteVisibility.PRIVATE)) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        boolean isMember = this.siteService.isMember(siteId, inviteeId);
        if (isMember) {
            throw new InvalidArgumentException(inviteeId + " is already a member of site " + siteId);
        }
        Invitation invitation = this.getSiteInvitation(inviteeId, siteId);
        if (invitation != null) {
            throw new InvalidArgumentException(inviteeId + " is already invited to site " + siteId);
        }
        String inviteeRole = DEFAULT_ROLE;
        String message = siteInvite.getMessage();
        if (message == null) {
            message = "";
        }
        if (siteVisibility.equals((Object)SiteVisibility.MODERATED)) {
            request = this.inviteToModeratedSite(message, inviteeId, siteId, DEFAULT_ROLE, null);
        } else if (siteVisibility.equals((Object)SiteVisibility.PUBLIC)) {
            request = this.inviteToPublicSite(siteInfo, message, inviteeId, DEFAULT_ROLE);
        } else {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        return request;
    }

    @Override
    public SiteMembershipRequest createSiteMembershipRequest(String inviteeId, SiteMembershipRequest siteInvite, String client) {
        SiteMembershipRequest request = null;
        inviteeId = this.people.validatePerson(inviteeId, true);
        String siteId = siteInvite.getId();
        SiteInfo siteInfo = this.sites.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        siteId = siteInfo.getShortName();
        SiteVisibility siteVisibility = siteInfo.getVisibility();
        if (siteVisibility.equals((Object)SiteVisibility.PRIVATE)) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        boolean isMember = this.siteService.isMember(siteId, inviteeId);
        if (isMember) {
            throw new InvalidArgumentException(inviteeId + " is already a member of site " + siteId);
        }
        Invitation invitation = this.getSiteInvitation(inviteeId, siteId);
        if (invitation != null) {
            throw new InvalidArgumentException(inviteeId + " is already invited to site " + siteId);
        }
        String inviteeRole = DEFAULT_ROLE;
        String message = siteInvite.getMessage();
        if (message == null) {
            message = "";
        }
        if (siteVisibility.equals((Object)SiteVisibility.MODERATED)) {
            request = this.inviteToModeratedSite(message, inviteeId, siteId, DEFAULT_ROLE, client);
        } else if (siteVisibility.equals((Object)SiteVisibility.PUBLIC)) {
            request = this.inviteToPublicSite(siteInfo, message, inviteeId, DEFAULT_ROLE);
        } else {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        return request;
    }

    @Override
    public SiteMembershipRequest updateSiteMembershipRequest(String inviteeId, SiteMembershipRequest siteInvite) {
        SiteMembershipRequest updatedSiteInvite = null;
        inviteeId = this.people.validatePerson(inviteeId, true);
        String siteId = siteInvite.getId();
        SiteInfo siteInfo = this.sites.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        siteId = siteInfo.getShortName();
        String message = siteInvite.getMessage();
        if (message == null) {
            message = "";
        }
        try {
            ModeratedInvitation updatedInvitation = this.invitationService.updateModeratedInvitation(inviteeId, siteId, message);
            if (updatedInvitation == null) {
                throw new RelationshipResourceNotFoundException(inviteeId, siteId);
            }
            updatedSiteInvite = this.getSiteMembershipRequest(updatedInvitation);
        }
        catch (InvitationExceptionNotFound e) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        if (updatedSiteInvite == null) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        return updatedSiteInvite;
    }

    @Override
    public void cancelSiteMembershipRequest(String inviteeId, String siteId) {
        inviteeId = this.people.validatePerson(inviteeId);
        SiteInfo siteInfo = this.sites.validateSite(siteId);
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        siteId = siteInfo.getShortName();
        Invitation invitation = this.getSiteInvitation(inviteeId, siteId);
        if (invitation == null) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        this.invitationService.cancel(invitation.getInviteId());
    }

    @Override
    public SiteMembershipRequest getSiteMembershipRequest(String inviteeId, final String siteId) {
        inviteeId = this.people.validatePerson(inviteeId);
        SiteInfo siteInfo = (SiteInfo)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<SiteInfo>(){

            public SiteInfo doWork() throws Exception {
                SiteInfo siteInfo = SiteMembershipRequestsImpl.this.sites.validateSite(siteId);
                return siteInfo;
            }
        });
        if (siteInfo == null) {
            throw new RelationshipResourceNotFoundException(inviteeId, siteId);
        }
        if (siteInfo.getVisibility().equals((Object)SiteVisibility.MODERATED)) {
            String normalizedSiteId = siteInfo.getShortName();
            Invitation invitation = this.getSiteInvitation(inviteeId, normalizedSiteId);
            if (invitation == null) {
                throw new RelationshipResourceNotFoundException(inviteeId, normalizedSiteId);
            }
            if (invitation instanceof ModeratedInvitation) {
                ModeratedInvitation moderatedInvitation = (ModeratedInvitation)invitation;
                SiteMembershipRequest siteInvite = this.getSiteMembershipRequest(moderatedInvitation);
                return siteInvite;
            }
            throw new InvalidArgumentException("Expected moderated invitation");
        }
        throw new RelationshipResourceNotFoundException(inviteeId, siteId);
    }

    private SiteMembershipRequest getSiteMembershipRequest(ModeratedInvitation moderatedInvitation) {
        return this.getSiteMembershipRequest(moderatedInvitation, false);
    }

    private SiteMembershipRequest getSiteMembershipRequest(ModeratedInvitation moderatedInvitation, boolean includePersonDetails) {
        SiteMembershipRequest siteMembershipRequest = null;
        Invitation.ResourceType resourceType = moderatedInvitation.getResourceType();
        if (resourceType.equals((Object)Invitation.ResourceType.WEB_SITE)) {
            final String siteId = moderatedInvitation.getResourceName();
            SiteInfo siteInfo = (SiteInfo)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<SiteInfo>(){

                public SiteInfo doWork() throws Exception {
                    SiteInfo siteInfo = SiteMembershipRequestsImpl.this.sites.validateSite(siteId);
                    return siteInfo;
                }
            });
            if (siteInfo == null) {
                throw new EntityNotFoundException(siteId);
            }
            if (siteInfo.getVisibility().equals((Object)SiteVisibility.MODERATED)) {
                siteMembershipRequest = new SiteMembershipRequest();
                String title = siteInfo.getTitle();
                siteMembershipRequest.setTitle(title);
                siteMembershipRequest.setId(siteId);
                siteMembershipRequest.setMessage(moderatedInvitation.getInviteeComments());
                siteMembershipRequest.setCreatedAt(moderatedInvitation.getCreatedAt());
                siteMembershipRequest.setModifiedAt(moderatedInvitation.getModifiedAt());
                if (includePersonDetails) {
                    Person person = this.people.getPerson(moderatedInvitation.getInviteeUserName());
                    siteMembershipRequest.setPerson(person);
                }
            }
        } else {
            logger.warn((Object)("Unexpected resource type " + String.valueOf(resourceType) + " for site membership request"));
        }
        return siteMembershipRequest;
    }

    private List<SiteMembershipRequest> toSiteMembershipRequests(List<Invitation> invitations) {
        return this.toSiteMembershipRequests(invitations, false);
    }

    private List<SiteMembershipRequest> toSiteMembershipRequests(List<Invitation> invitations, boolean includePersonDetails) {
        ArrayList<SiteMembershipRequest> siteMembershipRequests = new ArrayList<SiteMembershipRequest>(invitations.size());
        for (Invitation invitation : invitations) {
            ModeratedInvitation moderatedInvitation;
            SiteMembershipRequest siteMembershipRequest;
            if (!(invitation instanceof ModeratedInvitation) || (siteMembershipRequest = this.getSiteMembershipRequest(moderatedInvitation = (ModeratedInvitation)invitation, includePersonDetails)) == null) continue;
            siteMembershipRequests.add(siteMembershipRequest);
        }
        return siteMembershipRequests;
    }

    private CollectionWithPagingInfo<SiteMembershipRequest> createPagedSiteMembershipRequests(List<SiteMembershipRequest> siteMembershipRequests, Paging paging) {
        int skipCount = paging.getSkipCount();
        int maxItems = paging.getMaxItems();
        int max = skipCount + maxItems + 1;
        Collections.sort(siteMembershipRequests);
        int totalItems = siteMembershipRequests.size();
        if (skipCount >= totalItems) {
            List empty = Collections.emptyList();
            return CollectionWithPagingInfo.asPaged(paging, empty, false, totalItems);
        }
        int end = Math.min(max - 1, totalItems);
        boolean hasMoreItems = totalItems > end;
        siteMembershipRequests = siteMembershipRequests.subList(skipCount, end);
        return CollectionWithPagingInfo.asPaged(paging, siteMembershipRequests, hasMoreItems, totalItems);
    }

    @Override
    public CollectionWithPagingInfo<SiteMembershipRequest> getPagedSiteMembershipRequests(String personId, Paging paging) {
        personId = this.people.validatePerson(personId, true);
        List<Invitation> invitations = this.getSiteInvitations(personId);
        return this.createPagedSiteMembershipRequests(this.toSiteMembershipRequests(invitations), paging);
    }

    @Override
    public CollectionWithPagingInfo<SiteMembershipRequest> getPagedSiteMembershipRequests(Parameters parameters) {
        InvitationSearchCriteriaImpl criteria = new InvitationSearchCriteriaImpl();
        criteria.setInvitationType(InvitationSearchCriteria.InvitationType.MODERATED);
        criteria.setResourceType(Invitation.ResourceType.WEB_SITE);
        Query q = parameters.getQuery();
        if (q != null) {
            String personId;
            MapBasedQueryWalker propertyWalker = this.createSiteMembershipRequestQueryWalker();
            QueryHelper.walk(q, propertyWalker);
            String siteId = propertyWalker.getProperty("siteId", 8, String.class);
            if (siteId != null && !siteId.isEmpty()) {
                criteria.setResourceName(siteId);
            }
            if ((personId = propertyWalker.getProperty("personId", 8, String.class)) != null && !personId.isEmpty()) {
                criteria.setInvitee(personId);
            }
        }
        List invitations = this.invitationService.searchInvitation((InvitationSearchCriteria)criteria);
        return this.createPagedSiteMembershipRequests(this.toSiteMembershipRequests(invitations, true), parameters.getPaging());
    }

    @Override
    public void approveSiteMembershipRequest(String siteId, String inviteeId, SiteMembershipApproval siteMembershipApproval) {
        SiteInfo siteInfo = this.sites.validateSite(siteId);
        if (siteInfo == null) {
            throw new EntityNotFoundException(siteId);
        }
        siteId = siteInfo.getShortName();
        Invitation invitation = this.getSiteInvitation(inviteeId, siteId);
        if (invitation == null || !(invitation instanceof ModeratedInvitation)) {
            throw new RelationshipResourceNotFoundException(siteId, inviteeId);
        }
        ModeratedInvitation moderatedInvitation = (ModeratedInvitation)invitation;
        Invitation.ResourceType resourceType = moderatedInvitation.getResourceType();
        if (!resourceType.equals((Object)Invitation.ResourceType.WEB_SITE) || !SiteVisibility.MODERATED.equals((Object)siteInfo.getVisibility())) {
            throw new RelationshipResourceNotFoundException(siteId, inviteeId);
        }
        try {
            this.invitationService.approve(invitation.getInviteId(), "");
        }
        catch (InvitationExceptionForbidden ex) {
            throw new PermissionDeniedException();
        }
        if (siteMembershipApproval != null && siteMembershipApproval.getRole() != null && !siteMembershipApproval.getRole().isEmpty()) {
            String role = siteMembershipApproval.getRole();
            if (!moderatedInvitation.getRoleName().equals(role)) {
                String currentUserId = AuthenticationUtil.getFullyAuthenticatedUser();
                try {
                    this.addSiteMembership(invitation.getInviteeUserName(), siteId, role, currentUserId);
                }
                catch (UnknownAuthorityException e) {
                    logger.debug((Object)("addSiteMember:  UnknownAuthorityException " + siteId + " person " + invitation.getInviteId() + " role " + role));
                    throw new InvalidArgumentException("Unknown role '" + role + "'");
                }
            }
        }
    }

    @Override
    public void rejectSiteMembershipRequest(String siteId, String inviteeId, SiteMembershipRejection siteMembershipRejection) {
        SiteInfo siteInfo = this.sites.validateSite(siteId);
        if (siteInfo == null) {
            throw new EntityNotFoundException(siteId);
        }
        siteId = siteInfo.getShortName();
        Invitation invitation = this.getSiteInvitation(inviteeId, siteId);
        if (invitation == null || !(invitation instanceof ModeratedInvitation)) {
            throw new RelationshipResourceNotFoundException(siteId, inviteeId);
        }
        ModeratedInvitation moderatedInvitation = (ModeratedInvitation)invitation;
        Invitation.ResourceType resourceType = moderatedInvitation.getResourceType();
        if (!resourceType.equals((Object)Invitation.ResourceType.WEB_SITE) || !SiteVisibility.MODERATED.equals((Object)siteInfo.getVisibility())) {
            throw new RelationshipResourceNotFoundException(siteId, inviteeId);
        }
        String reason = null;
        if (siteMembershipRejection != null && siteMembershipRejection.getComment() != null && !siteMembershipRejection.getComment().isEmpty()) {
            reason = siteMembershipRejection.getComment();
        }
        try {
            this.invitationService.reject(invitation.getInviteId(), reason);
        }
        catch (InvitationExceptionForbidden ex) {
            throw new PermissionDeniedException();
        }
    }

    private MapBasedQueryWalker createSiteMembershipRequestQueryWalker() {
        return new MapBasedQueryWalker(LIST_SITE_MEMBERSHIPS_EQUALS_QUERY_PROPERTIES, null);
    }

    private void addSiteMembership(final String invitee, final String siteName, final String role, String runAsUser) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                SiteMembershipRequestsImpl.this.siteService.setMembership(siteName, invitee, role);
                return null;
            }
        }, (String)runAsUser);
    }
}

