/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tools;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.framework.core.exceptions.ErrorResponse;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.rest.framework.resource.content.ContentInfo;
import org.alfresco.rest.framework.resource.content.ContentInfoImpl;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public interface ResponseWriter {
    public static final String UTF8 = "UTF-8";
    public static final ContentInfo DEFAULT_JSON_CONTENT = new ContentInfoImpl(Format.JSON.mimetype(), "UTF-8", 0L, null);
    public static final Cache CACHE_NEVER = new Cache(new Description.RequiredCache(){

        public boolean getNeverCache() {
            return true;
        }

        public boolean getIsPublic() {
            return false;
        }

        public boolean getMustRevalidate() {
            return true;
        }
    });
    public static final WithResponse DEFAULT_SUCCESS = new WithResponse(200, DEFAULT_JSON_CONTENT, CACHE_NEVER);

    default public Log resWriterLogger() {
        return LogFactory.getLog(this.getClass());
    }

    default public void setContentInfoOnResponse(WebScriptResponse res, ContentInfo contentInfo) {
        if (contentInfo != null) {
            res.setContentType(contentInfo.getMimeType());
            res.setContentEncoding(contentInfo.getEncoding());
            if (res instanceof WrappingWebScriptResponse) {
                WrappingWebScriptResponse wrappedRes = (WrappingWebScriptResponse)res;
                res = wrappedRes.getNext();
            }
            if (res instanceof WebScriptServletResponse) {
                WebScriptServletResponse servletResponse = (WebScriptServletResponse)res;
                if (contentInfo.getLength() > 0L && contentInfo.getLength() > 0L && contentInfo.getLength() < Integer.MAX_VALUE) {
                    servletResponse.getHttpServletResponse().setContentLength((int)contentInfo.getLength());
                }
                if (contentInfo.getLocale() != null) {
                    servletResponse.getHttpServletResponse().setLocale(contentInfo.getLocale());
                }
            }
        }
    }

    default public void setResponse(WebScriptResponse res, int status, Cache cache, ContentInfo contentInfo, Map<String, List<String>> headers) {
        res.setStatus(status);
        if (cache != null) {
            res.setCache(cache);
        }
        this.setContentInfoOnResponse(res, contentInfo);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                for (int i = 0; i < header.getValue().size(); ++i) {
                    if (i == 0) {
                        res.setHeader(header.getKey(), header.getValue().get(i));
                        continue;
                    }
                    res.addHeader(header.getKey(), header.getValue().get(i));
                }
            }
        }
    }

    default public void setResponse(WebScriptResponse res, WithResponse withResponse) {
        this.setResponse(res, withResponse.getStatus(), withResponse.getCache(), withResponse.getContentInfo(), withResponse.getHeaders());
    }

    default public void renderErrorResponse(ErrorResponse errorResponse, WebScriptResponse res, JacksonHelper jsonHelper) throws IOException {
        this.renderErrorResponse(errorResponse, res, null, jsonHelper);
    }

    default public void renderErrorResponse(ErrorResponse errorResponse, WebScriptResponse res, WebScriptRequest req, JacksonHelper jsonHelper) throws IOException {
        String userName;
        String stackMessage = I18NUtil.getMessage((String)"framework.no.stacktrace");
        String logId = GUID.generate();
        final ErrorResponse errorToWrite = new ErrorResponse(errorResponse.getErrorKey(), errorResponse.getStatusCode(), errorResponse.getBriefSummary(), stackMessage, logId, errorResponse.getAdditionalState(), "https://api-explorer.alfresco.com");
        String reqUrl = req != null ? req.getURL() : "unknown";
        String string = userName = AuthenticationUtil.getFullyAuthenticatedUser() != null ? AuthenticationUtil.getFullyAuthenticatedUser() : "unauthenticated user";
        if (500 == errorResponse.getStatusCode() || this.resWriterLogger().isDebugEnabled()) {
            this.resWriterLogger().error((Object)("Exception " + errorToWrite.getLogId() + ". Request " + reqUrl + " executed by " + userName + " returned status code " + errorResponse.getStatusCode() + " with message: " + errorResponse.getBriefSummary() + " - Stack Trace: " + errorResponse.getStackTrace()));
        } else {
            this.resWriterLogger().error((Object)("Exception " + errorToWrite.getLogId() + ". Request " + reqUrl + " executed by user " + userName + " returned status code " + errorResponse.getStatusCode() + " with message: " + errorResponse.getBriefSummary() + " - Increase logging on " + this.getClass().getName() + " for stack trace."));
        }
        this.setContentInfoOnResponse(res, DEFAULT_JSON_CONTENT);
        res.setStatus(errorToWrite.getStatusCode());
        jsonHelper.withWriter(res.getOutputStream(), new JacksonHelper.Writer(){

            @Override
            public void writeContents(JsonGenerator generator, ObjectMapper objectMapper) throws JsonGenerationException, JsonMappingException, IOException {
                JSONObject obj = new JSONObject();
                obj.put((Object)"error", (Object)errorToWrite);
                objectMapper.writeValue(generator, (Object)obj);
            }
        });
    }

    default public void renderException(Exception exception, WebScriptResponse response, ApiAssistant assistant) throws IOException {
        this.renderException(exception, response, null, assistant);
    }

    default public void renderException(Exception exception, WebScriptResponse response, WebScriptRequest request, ApiAssistant assistant) throws IOException {
        this.renderErrorResponse(assistant.resolveException(exception), response, request, assistant.getJsonHelper());
    }

    default public void renderJsonResponse(WebScriptResponse res, final Object toSerialize, JacksonHelper jsonHelper) throws IOException {
        jsonHelper.withWriter(res.getOutputStream(), new JacksonHelper.Writer(){

            @Override
            public void writeContents(JsonGenerator generator, ObjectMapper objectMapper) throws JsonGenerationException, JsonMappingException, IOException {
                objectMapper.writeValue(generator, toSerialize);
            }
        });
    }
}

