/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceInspector;
import org.alfresco.rest.framework.core.ResourceInspectorUtil;
import org.alfresco.rest.framework.core.ResourceLocator;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.jacksonextensions.ExecutionResult;
import org.alfresco.rest.framework.resource.actions.ActionExecutor;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.http.HttpMethod;

public class ResourceWebScriptHelper {
    private static Log logger = LogFactory.getLog(ResourceWebScriptHelper.class);
    private ResourceLocator locator;
    private ActionExecutor executor;

    public static void setUniqueId(Object theObj, String uniqueId) {
        PropertyDescriptor pDesc;
        Method annotatedMethod = ResourceInspector.findUniqueIdMethod(theObj.getClass());
        if (annotatedMethod != null && (pDesc = BeanUtils.findPropertyForMethod((Method)annotatedMethod)) != null) {
            Method writeMethod = pDesc.getWriteMethod();
            if (writeMethod != null) {
                try {
                    writeMethod.invoke(theObj, uniqueId);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unique id set for property: " + pDesc.getName()));
                    }
                }
                catch (IllegalArgumentException error) {
                    logger.warn((Object)"Invocation error", (Throwable)error);
                }
                catch (IllegalAccessException error) {
                    logger.warn((Object)"IllegalAccessException", (Throwable)error);
                }
                catch (InvocationTargetException error) {
                    logger.warn((Object)"InvocationTargetException", (Throwable)error);
                }
            } else {
                logger.warn((Object)("No setter method for property: " + pDesc.getName()));
            }
        }
    }

    public Object processAdditionsToTheResponse(WebScriptResponse res, Api api, String entityCollectionName, Params params, Object objectToWrap) {
        PropertyCheck.mandatory((Object)this, null, (Object)params);
        if (objectToWrap == null) {
            return null;
        }
        if (objectToWrap instanceof CollectionWithPagingInfo) {
            CollectionWithPagingInfo collectionToWrap = (CollectionWithPagingInfo)objectToWrap;
            Object sourceEntity = this.executeIncludedSource(api, params, entityCollectionName, collectionToWrap);
            ArrayList<Object> resultCollection = new ArrayList<Object>(collectionToWrap.getCollection().size());
            if (!collectionToWrap.getCollection().isEmpty()) {
                for (Object obj : collectionToWrap.getCollection()) {
                    resultCollection.add(this.processAdditionsToTheResponse(res, api, entityCollectionName, params, obj));
                }
            }
            return CollectionWithPagingInfo.asPaged(collectionToWrap.getPaging(), resultCollection, collectionToWrap.hasMoreItems(), collectionToWrap.getTotalItems(), sourceEntity, collectionToWrap.getContext());
        }
        if (BeanUtils.isSimpleProperty(objectToWrap.getClass()) || objectToWrap instanceof Collection) {
            return objectToWrap;
        }
        ExecutionResult execRes = new ExecutionResult(objectToWrap, params.getFilter());
        Map<String, Pair<String, Method>> embeddded = ResourceInspector.findEmbeddedResources(objectToWrap.getClass());
        if (embeddded != null && !embeddded.isEmpty()) {
            Map<String, Object> results = this.executeEmbeddedResources(api, params, objectToWrap, embeddded);
            execRes.addEmbedded(results);
        }
        if (params.getRelationsFilter() != null && !params.getRelationsFilter().isEmpty()) {
            Map<String, ResourceWithMetadata> relationshipResources = this.locator.locateRelationResource(api, entityCollectionName, params.getRelationsFilter().keySet(), HttpMethod.GET);
            String uniqueEntityId = ResourceInspector.findUniqueId(objectToWrap);
            Map<String, Object> relatedResources = this.executeRelatedResources(api, params, relationshipResources, uniqueEntityId);
            execRes.addRelated(relatedResources);
        }
        return execRes;
    }

    private Object executeIncludedSource(Api api, Params params, String entityCollectionName, CollectionWithPagingInfo<?> collectionToWrap) {
        if (params.includeSource()) {
            Object result;
            if (collectionToWrap.getSourceEntity() != null) {
                return collectionToWrap.getSourceEntity();
            }
            ResourceWithMetadata res = this.locator.locateEntityResource(api, entityCollectionName, HttpMethod.GET);
            if (res != null && (result = this.executeResource(api, params, params.getEntityId(), null, res)) != null && result instanceof ExecutionResult) {
                return ((ExecutionResult)result).getRoot();
            }
        }
        return null;
    }

    private Map<String, Object> executeEmbeddedResources(Api api, Params params, Object objectToWrap, Map<String, Pair<String, Method>> embeddded) {
        HashMap<String, Object> results = new HashMap<String, Object>(embeddded.size());
        for (Map.Entry<String, Pair<String, Method>> embeddedEntry : embeddded.entrySet()) {
            ResourceWithMetadata res = this.locator.locateEntityResource(api, (String)embeddedEntry.getValue().getFirst(), HttpMethod.GET);
            if (res == null) continue;
            Object id = ResourceInspectorUtil.invokeMethod((Method)embeddedEntry.getValue().getSecond(), objectToWrap);
            if (id != null) {
                Object execEmbeddedResult = this.executeResource(api, params, String.valueOf(id), embeddedEntry.getKey(), res);
                if (execEmbeddedResult == null) continue;
                if (execEmbeddedResult instanceof ExecutionResult) {
                    ((ExecutionResult)execEmbeddedResult).setAnEmbeddedEntity(true);
                }
                results.put(embeddedEntry.getKey(), execEmbeddedResult);
                continue;
            }
            logger.warn((Object)("Cannot embed resource with path " + embeddedEntry.getKey() + ". No unique id because the method annotated with @EmbeddedEntityResource returned null."));
        }
        return results;
    }

    private Map<String, Object> executeRelatedResources(Api api, Params params, Map<String, ResourceWithMetadata> relatedResources, String uniqueEntityId) {
        HashMap<String, Object> results = new HashMap<String, Object>(relatedResources.size());
        for (Map.Entry<String, ResourceWithMetadata> relation : relatedResources.entrySet()) {
            Object execResult = this.executeResource(api, params, uniqueEntityId, relation.getKey(), relation.getValue());
            if (execResult == null) continue;
            results.put(relation.getKey(), execResult);
        }
        return results;
    }

    private Object executeResource(Api api, Params params, String uniqueEntityId, String resourceKey, ResourceWithMetadata resource) {
        try {
            BeanPropertiesFilter paramFilter = null;
            Object[] resultOfExecution = new Object[1];
            Map<String, BeanPropertiesFilter> filters = params.getRelationsFilter();
            if (filters != null) {
                paramFilter = filters.get(resourceKey);
            }
            Params executionParams = Params.valueOf(paramFilter, uniqueEntityId, params.getRequest());
            WithResponse callBack = new WithResponse(200, ResponseWriter.DEFAULT_JSON_CONTENT, ResponseWriter.CACHE_NEVER);
            Object result = this.executor.executeAction(resource, executionParams, callBack);
            return this.processAdditionsToTheResponse(null, api, null, executionParams, result);
        }
        catch (NotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ignored error, cannot access the object so can't embed it ", (Throwable)((Object)e));
            }
        }
        catch (PermissionDeniedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ignored error, cannot access the object so can't embed it ", (Throwable)((Object)e));
            }
        }
        catch (Throwable throwable) {
            logger.warn((Object)("Failed to execute a RelatedResource for " + resourceKey + " " + throwable.getMessage()));
        }
        return null;
    }

    public void setLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    public void setExecutor(ActionExecutor executor) {
        this.executor = executor;
    }
}

