/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.web.scripts.RepositoryContainer;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class RepositoryContainerTest
extends BaseWebScriptTest {
    private static final Pattern HIDDEN_EXCEPTION_PATTERN = Pattern.compile("Server error \\(\\d{8}\\)\\.  Details can be found in the server logs\\.");
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private AuthenticationComponent authenticationComponent;
    private static final String USER_ONE = "RunAsOne";
    private static final String USER_TWO = "RunAsTwo";
    private static final String SUCCESS = "success";

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(5);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testRunAsAdmin() throws Exception {
        this.authenticationComponent.setCurrentUser(USER_ONE);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/test/runas"), 200);
        RepositoryContainerTest.assertEquals((String)USER_ONE, (String)response.getContentAsString());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/test/runasadmin"), 200);
        RepositoryContainerTest.assertEquals((String)USER_TWO, (String)response.getContentAsString());
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    public void testReset() throws Exception {
        RepositoryContainer repoContainer = (RepositoryContainer)this.getServer().getApplicationContext().getBean("webscripts.container");
        repoContainer.reset();
    }

    public void testLargeContentRequest() throws Exception {
        this.authenticationComponent.setCurrentUser(USER_ONE);
        byte[] content = new byte[0x500000];
        Arrays.fill(content, (byte)0);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/test/largecontenttest", content, "text/plain"), 200);
        RepositoryContainerTest.assertEquals((String)SUCCESS, (String)response.getContentAsString());
        CronTrigger webscriptsTempFileCleanerJobTrigger = (CronTrigger)this.getServer().getApplicationContext().getBean("webscripts.tempFileCleanerTrigger");
        Scheduler scheduler = (Scheduler)this.getServer().getApplicationContext().getBean("schedulerFactory");
        scheduler.triggerJob(webscriptsTempFileCleanerJobTrigger.getJobKey());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/test/largecontenttest", content, "text/plain"), 200);
        RepositoryContainerTest.assertEquals((String)SUCCESS, (String)response.getContentAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHideExceptions() throws Exception {
        String messageFormException = "Failed to persist field 'prop_cm_name'";
        String messageAuthenticationException = "Authentication failed for Web Script";
        RepositoryContainer repoContainer = (RepositoryContainer)this.getServer().getApplicationContext().getBean("webscripts.container");
        RepositoryContainer repoContainerMock = (RepositoryContainer)Mockito.spy((Object)repoContainer);
        Class[] defaultConfiguration = repoContainerMock.getNotPublicExceptions();
        try {
            LinkedList<Class<SQLException>> testExceptoins = new LinkedList<Class<SQLException>>();
            testExceptoins.add(SQLException.class);
            repoContainerMock.setNotPublicExceptions(testExceptoins);
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new AlfrescoRuntimeException("AlfrescoRuntimeException", (Throwable)new SQLException("SQLException"));
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertNull((String)"SQLException cause should be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{SQLException.class}));
                RepositoryContainerTest.assertTrue((String)"Details should be in the server logs.", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new AlfrescoRuntimeException("AlfrescoRuntimeException", (Throwable)new NullPointerException());
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertNotNull((String)"NullPointerException cause should be visible for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{NullPointerException.class}));
                RepositoryContainerTest.assertFalse((String)"Details should be available for client", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new RuntimeException("AlfrescoRuntimeException", new SQLException("SQLException"));
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertNull((String)"SQLException cause should be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{SQLException.class}));
                RepositoryContainerTest.assertTrue((String)"Details should be in the server logs.", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new FormException("Failed to persist field 'prop_cm_name'");
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertTrue((String)"FormException should be visible for client", (boolean)(e instanceof FormException));
                RepositoryContainerTest.assertFalse((String)"Details should be available for client", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
                RepositoryContainerTest.assertTrue((String)"Actual message should be available for client", (boolean)e.getMessage().contains("Failed to persist field 'prop_cm_name'"));
            }
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new WebScriptException(401, "Authentication failed for Web Script");
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertTrue((String)"WebScriptException should be visible for client", (boolean)(e instanceof WebScriptException));
                RepositoryContainerTest.assertFalse((String)"Details should be available for client", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
                RepositoryContainerTest.assertTrue((String)"Actual message should be available for client", (boolean)e.getMessage().contains("Authentication failed for Web Script"));
            }
        }
        finally {
            repoContainerMock.setNotPublicExceptions(Arrays.asList(defaultConfiguration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHideExceptionsConfiguration() throws Exception {
        final StringBuilder commandExecutionResult = new StringBuilder(128);
        commandExecutionResult.append("Execution result: \n").append("   os:         ").append(System.getProperty("os.name")).append("\n").append("   command:    <TEST_COMMAND>").append("   succeeded:  ").append(false).append("\n").append("   exit code:  ").append(1).append("\n").append("   out:        ").append("<EMPTY>").append("\n").append("   err:        ").append("ERROR");
        RepositoryContainer repoContainer = (RepositoryContainer)this.getServer().getApplicationContext().getBean("webscripts.container");
        RepositoryContainer repoContainerMock = (RepositoryContainer)Mockito.spy((Object)repoContainer);
        Class[] notPublicExceptions = repoContainerMock.getNotPublicExceptions();
        List<Class> defaultConfiguration = Arrays.asList(notPublicExceptions);
        LinkedList<Class> testExceptions = new LinkedList<Class>();
        testExceptions.add(SQLException.class);
        testExceptions.add(ContentIOException.class);
        repoContainerMock.setNotPublicExceptions(testExceptions);
        try {
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new ContentIOException(commandExecutionResult.toString());
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertNull((String)"'ContentIOException' cause should be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{ContentIOException.class}));
                RepositoryContainerTest.assertTrue((String)"Details should be in the server logs.", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new AlfrescoRuntimeException("AlfrescoRuntimeException", (Throwable)new ContentIOException(commandExecutionResult.toString()));
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertNull((String)"'ContentIOException' cause should be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{ContentIOException.class}));
                RepositoryContainerTest.assertTrue((String)"Details should be in the server logs.", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new AlfrescoRuntimeException("AlfrescoRuntimeException", (Throwable)new NullPointerException("NullPointerException"));
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertNotNull((String)"'NullPointerException' cause should be visible for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{NullPointerException.class}));
                RepositoryContainerTest.assertFalse((String)"Details should be available for client", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
            LinkedList<Class> updatedNotPublicExceptions = new LinkedList<Class>(defaultConfiguration);
            updatedNotPublicExceptions.add(NullPointerException.class);
            repoContainerMock.setNotPublicExceptions(updatedNotPublicExceptions);
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new AlfrescoRuntimeException("AlfrescoRuntimeException", (Throwable)new NullPointerException("NullPointerException"));
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertNull((String)"'NullPointerException' cause should be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{NullPointerException.class}));
                RepositoryContainerTest.assertTrue((String)"Details should be in the server logs.", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
            repoContainerMock.setNotPublicExceptions(null);
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new AlfrescoRuntimeException("AlfrescoRuntimeException", (Throwable)new ContentIOException(commandExecutionResult.toString(), (Throwable)new NullPointerException("NullPointerException")));
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertTrue((String)("'AlfrescoRuntimeException' cause should not be hidden for client. Exception class: " + e.getClass().getName()), (boolean)(e instanceof AlfrescoRuntimeException));
                RepositoryContainerTest.assertNotNull((String)"'ContentIOException' cause should not be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{ContentIOException.class}));
                RepositoryContainerTest.assertNotNull((String)"'NullPointerException' cause should not be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{NullPointerException.class}));
                RepositoryContainerTest.assertFalse((String)"Details should be available for client", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
            repoContainerMock.setNotPublicExceptions(defaultConfiguration);
            repoContainerMock.setNotPublicExceptions(new LinkedList());
            ((RepositoryContainer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    throw new AlfrescoRuntimeException("AlfrescoRuntimeException", (Throwable)new ContentIOException(commandExecutionResult.toString(), (Throwable)new NullPointerException("NullPointerException")));
                }
            }).when((Object)repoContainerMock)).executeScriptInternal((WebScriptRequest)ArgumentMatchers.nullable(WebScriptRequest.class), (WebScriptResponse)ArgumentMatchers.nullable(WebScriptResponse.class), (Authenticator)ArgumentMatchers.nullable(Authenticator.class));
            try {
                repoContainerMock.executeScript(null, null, null);
            }
            catch (Exception e) {
                RepositoryContainerTest.assertTrue((String)("'AlfrescoRuntimeException' cause should not be hidden for client. Exception class: " + e.getClass().getName()), (boolean)(e instanceof AlfrescoRuntimeException));
                RepositoryContainerTest.assertNotNull((String)"'ContentIOException' cause should not be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{ContentIOException.class}));
                RepositoryContainerTest.assertNotNull((String)"'NullPointerException' cause should not be hidden for client", (Object)ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{NullPointerException.class}));
                RepositoryContainerTest.assertFalse((String)"Details should be available for client", (boolean)HIDDEN_EXCEPTION_PATTERN.matcher(e.getMessage()).matches());
            }
        }
        finally {
            repoContainerMock.setNotPublicExceptions(defaultConfiguration);
        }
    }
}

