/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.workflow.api.tests.EnterpriseWorkflowTestApi;
import org.alfresco.rest.workflow.api.tests.WorkflowApiClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.http.HttpStatus;

public class ProcessDefinitionWorkflowApiTest
extends EnterpriseWorkflowTestApi {
    @Test
    public void testGetProcessDefinitions() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        PublicApiClient.ListResponse<org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitionsResponse = processDefinitionsClient.getProcessDefinitions(null);
        Map<String, org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitionMap = this.getProcessDefinitionMapByKey(processDefinitionsResponse.getList());
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReviewPooled"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelGroupReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)5L, (long)processDefinitionMap.size());
        String adhocKey = this.createProcessDefinitionKey("activitiAdhoc", requestContext);
        ProcessDefinition activitiDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(adhocKey).singleResult();
        Assert.assertNotNull((Object)activitiDefinition);
        org.alfresco.rest.workflow.api.model.ProcessDefinition adhocDefinitionRest = processDefinitionMap.get("activitiAdhoc");
        Assert.assertEquals((Object)activitiDefinition.getId(), (Object)adhocDefinitionRest.getId());
        Assert.assertEquals((Object)"activitiAdhoc", (Object)adhocDefinitionRest.getKey());
        Assert.assertEquals((Object)activitiDefinition.getDeploymentId(), (Object)adhocDefinitionRest.getDeploymentId());
        Assert.assertEquals((Object)activitiDefinition.getCategory(), (Object)adhocDefinitionRest.getCategory());
        Assert.assertEquals((Object)activitiDefinition.getName(), (Object)adhocDefinitionRest.getName());
        Assert.assertEquals((long)activitiDefinition.getVersion(), (long)adhocDefinitionRest.getVersion());
        Assert.assertEquals((Object)((ProcessDefinitionEntity)activitiDefinition).isGraphicalNotationDefined(), (Object)adhocDefinitionRest.isGraphicNotationDefined());
        Assert.assertEquals((Object)"wf:submitAdhocTask", (Object)adhocDefinitionRest.getStartFormResourceKey());
        Assert.assertEquals((Object)"New Task", (Object)adhocDefinitionRest.getTitle());
        Assert.assertEquals((Object)"Assign a new task to yourself or a colleague", (Object)adhocDefinitionRest.getDescription());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("maxItems", "2");
        JSONObject definitionListObject = processDefinitionsClient.getProcessDefinitionsWithRawResponse(params);
        Assert.assertNotNull((Object)definitionListObject);
        JSONObject paginationJSON = (JSONObject)definitionListObject.get((Object)"pagination");
        Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)true, (Object)paginationJSON.get((Object)"hasMoreItems"));
        params = new HashMap();
        definitionListObject = processDefinitionsClient.getProcessDefinitionsWithRawResponse(params);
        Assert.assertNotNull((Object)definitionListObject);
        paginationJSON = (JSONObject)definitionListObject.get((Object)"pagination");
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
        params = new HashMap();
        params.put("skipCount", "2");
        params.put("maxItems", "2");
        definitionListObject = processDefinitionsClient.getProcessDefinitionsWithRawResponse(params);
        Assert.assertNotNull((Object)definitionListObject);
        paginationJSON = (JSONObject)definitionListObject.get((Object)"pagination");
        Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)true, (Object)paginationJSON.get((Object)"hasMoreItems"));
        params = new HashMap();
        params.put("skipCount", "2");
        params.put("maxItems", "5");
        definitionListObject = processDefinitionsClient.getProcessDefinitionsWithRawResponse(params);
        Assert.assertNotNull((Object)definitionListObject);
        paginationJSON = (JSONObject)definitionListObject.get((Object)"pagination");
        Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
        params = new HashMap();
        params.put("skipCount", "0");
        params.put("maxItems", "7");
        definitionListObject = processDefinitionsClient.getProcessDefinitionsWithRawResponse(params);
        Assert.assertNotNull((Object)definitionListObject);
        paginationJSON = (JSONObject)definitionListObject.get((Object)"pagination");
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
    }

    @Test
    public void testGetProcessDefinitionsSorting() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String adhocKey = this.createProcessDefinitionKey("activitiAdhoc", requestContext);
        ProcessDefinition activitiDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(adhocKey).singleResult();
        Assert.assertNotNull((Object)activitiDefinition);
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        List<org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "name");
        Assert.assertEquals((long)5L, (long)processDefinitions.size());
        List<String> expectedNames = Arrays.asList("Adhoc Activiti Process", "Parallel Group Review And Approve Activiti Process", "Parallel Review And Approve Activiti Process", "Pooled Review And Approve Activiti Process", "Review And Approve Activiti Process");
        List<String> names = this.collect(processDefinitions, new Collector(){

            @Override
            public String collect(org.alfresco.rest.workflow.api.model.ProcessDefinition definition) {
                return definition.getName();
            }
        });
        Assert.assertEquals(expectedNames, names);
        processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "name DESC");
        Assert.assertEquals((long)5L, (long)processDefinitions.size());
        names = this.collect(processDefinitions, new Collector(){

            @Override
            public String collect(org.alfresco.rest.workflow.api.model.ProcessDefinition definition) {
                return definition.getName();
            }
        });
        Collections.reverse(expectedNames);
        Assert.assertEquals(expectedNames, names);
        processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "version DESC");
        Assert.assertEquals((long)5L, (long)processDefinitions.size());
        processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "id ASC");
        Assert.assertEquals((long)5L, (long)processDefinitions.size());
        List<String> ids = this.collect(processDefinitions, new Collector(){

            @Override
            public String collect(org.alfresco.rest.workflow.api.model.ProcessDefinition definition) {
                return definition.getId();
            }
        });
        ArrayList<String> sortedIds = new ArrayList<String>(ids);
        Collections.sort(sortedIds);
        Assert.assertEquals(sortedIds, ids);
        processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "category ASC");
        Assert.assertEquals((long)5L, (long)processDefinitions.size());
        processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "key DESC");
        Assert.assertEquals((long)5L, (long)processDefinitions.size());
        List<String> keys = this.collect(processDefinitions, new Collector(){

            @Override
            public String collect(org.alfresco.rest.workflow.api.model.ProcessDefinition definition) {
                return definition.getKey();
            }
        });
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        Collections.reverse(sortedKeys);
        Assert.assertEquals(sortedKeys, keys);
        processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "deploymentId ASC");
        Assert.assertEquals((long)5L, (long)processDefinitions.size());
        List<String> deploymentIds = this.collect(processDefinitions, new Collector(){

            @Override
            public String collect(org.alfresco.rest.workflow.api.model.ProcessDefinition definition) {
                return definition.getDeploymentId();
            }
        });
        ArrayList<String> sortedDeploymentIds = new ArrayList<String>(deploymentIds);
        Collections.sort(sortedDeploymentIds);
        Assert.assertEquals(sortedDeploymentIds, deploymentIds);
        try {
            processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "sausage ASC");
            Assert.fail((String)"Expected exception");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
            Assert.assertTrue((boolean)e.getMessage().contains("OrderBy sausage is not supported, supported items are"));
        }
        try {
            processDefinitions = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')", "deploymentId ASC, key");
            Assert.fail((String)"Expected exception");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
            Assert.assertTrue((boolean)e.getHttpResponse().getResponse().contains("Only one orderBy parameter is supported"));
        }
    }

    private List<String> collect(List<org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitions, Collector collector) {
        ArrayList<String> collected = new ArrayList<String>();
        for (org.alfresco.rest.workflow.api.model.ProcessDefinition definition : processDefinitions) {
            collected.add(collector.collect(definition));
        }
        return collected;
    }

    @Test
    public void testGetProcessDefinitionsWhereClause() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String adhocKey = this.createProcessDefinitionKey("activitiAdhoc", requestContext);
        ProcessDefinition activitiDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(adhocKey).singleResult();
        Assert.assertNotNull((Object)activitiDefinition);
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        Map<String, org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org')");
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReviewPooled"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelGroupReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)5L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(category = 'unexisting')");
        Assert.assertEquals((long)0L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(name = 'Adhoc Activiti Process')");
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)1L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(name = 'unexisting')");
        Assert.assertEquals((long)0L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(key='activitiAdhoc')");
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)1L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(key='unexisting')");
        Assert.assertEquals((long)0L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(version='1')");
        Assert.assertEquals((long)5L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(version='2')");
        Assert.assertEquals((long)0L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(deploymentId='" + activitiDefinition.getDeploymentId() + "')");
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)1L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(deploymentId='unexisting')");
        Assert.assertEquals((long)0L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(category matches('%alfresco.o%'))");
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReviewPooled"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelGroupReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)5L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(category matches('unexisting'))");
        Assert.assertEquals((long)0L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(name matches('Adhoc Activiti %'))");
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)1L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(name matches('unexisting'))");
        Assert.assertEquals((long)0L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(key matches('activitiAd%'))");
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)1L, (long)processDefinitionMap.size());
        processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org' AND name = 'Adhoc Activiti Process')");
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)1L, (long)processDefinitionMap.size());
        try {
            processDefinitionMap = this.getProcessDefinitions(processDefinitionsClient, "(category = 'http://alfresco.org' OR name = 'Adhoc Activiti Process')");
            Assert.fail((String)"Expected exception");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testGetProcessDefinitionById() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        String adhocKey = this.createProcessDefinitionKey("activitiAdhoc", requestContext);
        ProcessDefinition activitiDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(adhocKey).singleResult();
        Assert.assertNotNull((Object)activitiDefinition);
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        org.alfresco.rest.workflow.api.model.ProcessDefinition adhocDefinition = processDefinitionsClient.findProcessDefinitionById(activitiDefinition.getId());
        Assert.assertNotNull((Object)adhocDefinition);
        Assert.assertEquals((Object)activitiDefinition.getId(), (Object)adhocDefinition.getId());
        Assert.assertEquals((Object)"activitiAdhoc", (Object)adhocDefinition.getKey());
        Assert.assertEquals((Object)activitiDefinition.getDeploymentId(), (Object)adhocDefinition.getDeploymentId());
        Assert.assertEquals((Object)activitiDefinition.getCategory(), (Object)adhocDefinition.getCategory());
        Assert.assertEquals((Object)activitiDefinition.getName(), (Object)adhocDefinition.getName());
        Assert.assertEquals((long)activitiDefinition.getVersion(), (long)adhocDefinition.getVersion());
        Assert.assertEquals((Object)((ProcessDefinitionEntity)activitiDefinition).isGraphicalNotationDefined(), (Object)adhocDefinition.isGraphicNotationDefined());
        Assert.assertEquals((Object)"wf:submitAdhocTask", (Object)adhocDefinition.getStartFormResourceKey());
        this.publicApiClient.setRequestContext(adminContext);
        adhocDefinition = processDefinitionsClient.findProcessDefinitionById(activitiDefinition.getId());
        Assert.assertNotNull((Object)adhocDefinition);
        Assert.assertEquals((Object)activitiDefinition.getId(), (Object)adhocDefinition.getId());
        Assert.assertEquals((Object)"activitiAdhoc", (Object)adhocDefinition.getKey());
    }

    @Test
    public void testGetProcessDefinitionsImage() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        String adhocKey = this.createProcessDefinitionKey("activitiAdhoc", requestContext);
        ProcessDefinition activitiDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(adhocKey).singleResult();
        Assert.assertNotNull((Object)activitiDefinition);
        try {
            HttpResponse response = processDefinitionsClient.findImageById(activitiDefinition.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.INTERNAL_SERVER_ERROR.value(), (long)expected.getHttpResponse().getStatusCode());
            Assert.assertTrue((boolean)expected.getMessage().contains("No image available"));
        }
    }

    @Test
    public void testGetProcessDefinitionByIdUnexisting() throws Exception {
        this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        try {
            processDefinitionsClient.findProcessDefinitionById("unexisting");
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
            this.assertErrorSummary("The entity with id: unexisting was not found", expected.getHttpResponse());
        }
    }

    @Test
    public void testGetProcessDefinitionStartModel() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        String adhocKey = this.createProcessDefinitionKey("activitiAdhoc", requestContext);
        ProcessDefinition activitiDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(adhocKey).singleResult();
        Assert.assertNotNull((Object)activitiDefinition);
        JSONObject model = processDefinitionsClient.findStartFormModel(activitiDefinition.getId());
        Assert.assertNotNull((Object)model);
        JSONArray entries = (JSONArray)model.get((Object)"entries");
        Assert.assertNotNull((Object)entries);
        HashMap<String, JSONObject> modelFieldsByName = new HashMap<String, JSONObject>();
        JSONObject entry = null;
        for (int i = 0; i < entries.size(); ++i) {
            entry = (JSONObject)entries.get(i);
            Assert.assertNotNull((Object)entry);
            entry = (JSONObject)entry.get((Object)"entry");
            Assert.assertNotNull((Object)entry);
            modelFieldsByName.put((String)entry.get((Object)"name"), entry);
        }
        JSONObject modelEntry = (JSONObject)modelFieldsByName.get("bpm_workflowDescription");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Description", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}workflowDescription", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:text", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = (JSONObject)modelFieldsByName.get("bpm_completionDate");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Completion Date", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}completionDate", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:date", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = (JSONObject)modelFieldsByName.get("cm_owner");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Owner", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/content/1.0}owner", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:text", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = (JSONObject)modelFieldsByName.get("bpm_sendEMailNotifications");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Send Email Notifications", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}sendEMailNotifications", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:boolean", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = (JSONObject)modelFieldsByName.get("bpm_workflowPriority");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Workflow Priority", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}workflowPriority", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:int", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertEquals((Object)"2", (Object)modelEntry.get((Object)"defaultValue"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = (JSONObject)modelFieldsByName.get("bpm_package");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Content Package", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}package", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"bpm:workflowPackage", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = (JSONObject)modelFieldsByName.get("bpm_status");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Status", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}status", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:text", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertEquals((Object)"Not Yet Started", (Object)modelEntry.get((Object)"defaultValue"));
        Assert.assertTrue((boolean)((Boolean)modelEntry.get((Object)"required")));
        JSONArray allowedValues = (JSONArray)modelEntry.get((Object)"allowedValues");
        Assert.assertNotNull((Object)allowedValues);
        Assert.assertEquals((long)5L, (long)allowedValues.size());
        Assert.assertTrue((boolean)allowedValues.contains((Object)"Not Yet Started"));
        Assert.assertTrue((boolean)allowedValues.contains((Object)"In Progress"));
        Assert.assertTrue((boolean)allowedValues.contains((Object)"On Hold"));
        Assert.assertTrue((boolean)allowedValues.contains((Object)"Cancelled"));
        Assert.assertTrue((boolean)allowedValues.contains((Object)"Completed"));
        this.publicApiClient.setRequestContext(adminContext);
        model = processDefinitionsClient.findStartFormModel(activitiDefinition.getId());
        Assert.assertNotNull((Object)model);
        entries = (JSONArray)model.get((Object)"entries");
        Assert.assertNotNull((Object)entries);
        modelFieldsByName = new HashMap();
        for (int i = 0; i < entries.size(); ++i) {
            entry = (JSONObject)entries.get(i);
            Assert.assertNotNull((Object)entry);
            entry = (JSONObject)entry.get((Object)"entry");
            Assert.assertNotNull((Object)entry);
            modelFieldsByName.put((String)entry.get((Object)"name"), entry);
        }
        modelEntry = (JSONObject)modelFieldsByName.get("bpm_workflowDescription");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Description", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}workflowDescription", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:text", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = (JSONObject)modelFieldsByName.get("bpm_completionDate");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Completion Date", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}completionDate", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:date", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
    }

    @Test
    public void testGetProcessDefinitionStartModelUnexisting() throws Exception {
        this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        try {
            processDefinitionsClient.findStartFormModel("unexisting");
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
            this.assertErrorSummary("The entity with id: unexisting was not found", expected.getHttpResponse());
        }
    }

    @Test
    public void testMethodNotAllowedURIs() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        HttpResponse response = this.publicApiClient.get("public", "process-definitions", null, null, null, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.publicApiClient.post("public", "process-definitions", null, null, null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.publicApiClient.delete("public", "process-definitions", null, null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.publicApiClient.put("public", "process-definitions", null, null, null, null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        String adhocKey = this.createProcessDefinitionKey("activitiAdhoc", requestContext);
        ProcessDefinition processDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(adhocKey).singleResult();
        Assert.assertNotNull((Object)processDefinition);
        response = this.publicApiClient.get("public", "process-definitions", processDefinition.getId(), null, null, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.publicApiClient.post("public", "process-definitions", processDefinition.getId(), null, null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.publicApiClient.delete("public", "process-definitions", processDefinition.getId(), null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.publicApiClient.put("public", "process-definitions", processDefinition.getId(), null, null, null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.publicApiClient.get("public", "process-definitions", processDefinition.getId(), "start-form-model", null, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.publicApiClient.post("public", "process-definitions", processDefinition.getId(), "start-form-model", null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.publicApiClient.delete("public", "process-definitions", processDefinition.getId(), "start-form-model", null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.publicApiClient.put("public", "process-definitions", processDefinition.getId(), "start-form-model", null, null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
    }

    @Test
    public void testAuthenticationAndAuthorization() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        this.publicApiClient.setRequestContext(new RequestContext(requestContext.getNetworkId(), tenantAdmin));
        WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient = this.publicApiClient.processDefinitionsClient();
        PublicApiClient.ListResponse<org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitionsResponse = processDefinitionsClient.getProcessDefinitions(null);
        Map<String, org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitionMap = this.getProcessDefinitionMapByKey(processDefinitionsResponse.getList());
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReviewPooled"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelGroupReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)5L, (long)processDefinitionMap.size());
        RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
        tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
        RequestContext otherContext = new RequestContext(anotherNetwork.getId(), tenantAdmin);
        this.publicApiClient.setRequestContext(otherContext);
        processDefinitionsResponse = processDefinitionsClient.getProcessDefinitions(null);
        processDefinitionMap = this.getProcessDefinitionMapByKey(processDefinitionsResponse.getList());
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReviewPooled"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelGroupReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiParallelReview"));
        Assert.assertTrue((boolean)processDefinitionMap.containsKey("activitiAdhoc"));
        Assert.assertEquals((long)5L, (long)processDefinitionMap.size());
        this.publicApiClient.setRequestContext(requestContext);
        String adhocKey = this.createProcessDefinitionKey("activitiAdhoc", requestContext);
        ProcessDefinition activitiDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(adhocKey).singleResult();
        Assert.assertNotNull((Object)activitiDefinition);
        org.alfresco.rest.workflow.api.model.ProcessDefinition adhocDefinition = processDefinitionsClient.findProcessDefinitionById(activitiDefinition.getId());
        Assert.assertNotNull((Object)adhocDefinition);
        Assert.assertEquals((Object)activitiDefinition.getId(), (Object)adhocDefinition.getId());
        Assert.assertEquals((Object)"activitiAdhoc", (Object)adhocDefinition.getKey());
        Assert.assertEquals((Object)activitiDefinition.getDeploymentId(), (Object)adhocDefinition.getDeploymentId());
        Assert.assertEquals((Object)activitiDefinition.getCategory(), (Object)adhocDefinition.getCategory());
        Assert.assertEquals((Object)activitiDefinition.getName(), (Object)adhocDefinition.getName());
        Assert.assertEquals((long)activitiDefinition.getVersion(), (long)adhocDefinition.getVersion());
        Assert.assertEquals((Object)((ProcessDefinitionEntity)activitiDefinition).isGraphicalNotationDefined(), (Object)adhocDefinition.isGraphicNotationDefined());
        Assert.assertEquals((Object)"wf:submitAdhocTask", (Object)adhocDefinition.getStartFormResourceKey());
        this.publicApiClient.setRequestContext(otherContext);
        try {
            adhocDefinition = processDefinitionsClient.findProcessDefinitionById(activitiDefinition.getId());
            Assert.fail((String)"not found expected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(requestContext);
        JSONObject model = processDefinitionsClient.findStartFormModel(activitiDefinition.getId());
        Assert.assertNotNull((Object)model);
        JSONArray entries = (JSONArray)model.get((Object)"entries");
        Assert.assertNotNull((Object)entries);
        HashMap<String, JSONObject> modelFieldsByName = new HashMap<String, JSONObject>();
        JSONObject entry = null;
        for (int i = 0; i < entries.size(); ++i) {
            entry = (JSONObject)entries.get(i);
            Assert.assertNotNull((Object)entry);
            entry = (JSONObject)entry.get((Object)"entry");
            Assert.assertNotNull((Object)entry);
            modelFieldsByName.put((String)entry.get((Object)"name"), entry);
        }
        JSONObject modelEntry = (JSONObject)modelFieldsByName.get("bpm_workflowDescription");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Description", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}workflowDescription", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:text", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        this.publicApiClient.setRequestContext(otherContext);
        try {
            model = processDefinitionsClient.findStartFormModel(activitiDefinition.getId());
            Assert.fail((String)"not found expected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)e.getHttpResponse().getStatusCode());
        }
    }

    protected String createProcessDefinitionKey(String key, RequestContext requestContext) {
        return "@" + requestContext.getNetworkId() + "@" + key;
    }

    protected Map<String, org.alfresco.rest.workflow.api.model.ProcessDefinition> getProcessDefinitionMapByKey(List<org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitions) {
        HashMap<String, org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitionMap = new HashMap<String, org.alfresco.rest.workflow.api.model.ProcessDefinition>();
        for (org.alfresco.rest.workflow.api.model.ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionMap.put(processDefinition.getKey(), processDefinition);
        }
        return processDefinitionMap;
    }

    protected Map<String, org.alfresco.rest.workflow.api.model.ProcessDefinition> getProcessDefinitions(WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient, String whereClause) throws PublicApiException {
        Map<String, String> params = null;
        if (whereClause != null) {
            params = Collections.singletonMap("where", whereClause);
        }
        PublicApiClient.ListResponse<org.alfresco.rest.workflow.api.model.ProcessDefinition> processDefinitionsResponse = processDefinitionsClient.getProcessDefinitions(params);
        return this.getProcessDefinitionMapByKey(processDefinitionsResponse.getList());
    }

    protected List<org.alfresco.rest.workflow.api.model.ProcessDefinition> getProcessDefinitions(WorkflowApiClient.ProcessDefinitionsClient processDefinitionsClient, String whereClause, String sort) throws PublicApiException {
        Map<String, String> params = null;
        if (whereClause != null) {
            params = Collections.singletonMap("where", whereClause);
        }
        if (sort != null) {
            params = Collections.singletonMap("orderBy", sort);
        }
        return processDefinitionsClient.getProcessDefinitions(params).getList();
    }

    static interface Collector {
        public String collect(org.alfresco.rest.workflow.api.model.ProcessDefinition var1);
    }
}

