/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.alfresco.repo.web.scripts.content.StreamContent;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.util.TempFileProvider;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.FileCopyUtils;

public class WorkflowInstanceDiagramGet
extends StreamContent {
    protected WorkflowService workflowService;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        Map params = req.getServiceMatch().getTemplateVars();
        String workflowInstanceId = (String)params.get("workflow_instance_id");
        WorkflowInstance workflowInstance = this.workflowService.getWorkflowById(workflowInstanceId);
        if (workflowInstance == null) {
            throw new WebScriptException(404, "Unable to find workflow instance with id: " + workflowInstanceId);
        }
        if (!this.workflowService.hasWorkflowImage(workflowInstanceId)) {
            throw new WebScriptException(404, "Unable to find diagram for workflow instance with id: " + workflowInstanceId);
        }
        File file = TempFileProvider.createTempFile((String)"workflow-diagram-", (String)".png");
        InputStream imageData = this.workflowService.getWorkflowImage(workflowInstanceId);
        FileOutputStream os = new FileOutputStream(file);
        FileCopyUtils.copy((InputStream)imageData, (OutputStream)os);
        this.streamContent(req, res, file);
    }
}

