/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionException;
import org.alfresco.repo.quickshare.QuickShareServiceImpl;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.QuickShareLinks;
import org.alfresco.rest.api.Renditions;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.ContentInfo;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.QuickShareLink;
import org.alfresco.rest.api.model.QuickShareLinkEmailRequest;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.quickshare.InvalidSharedIdException;
import org.alfresco.service.cmr.quickshare.QuickShareDTO;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class QuickShareLinksImpl
implements QuickShareLinks,
RecognizedParamsExtractor,
InitializingBean {
    private static final Log logger = LogFactory.getLog(QuickShareLinksImpl.class);
    private static final String DISABLED = "QuickShare is disabled system-wide";
    private boolean enabled = true;
    private ServiceRegistry sr;
    private QuickShareService quickShareService;
    private Nodes nodes;
    private Renditions renditions;
    private NodeService nodeService;
    private PersonService personService;
    private MimetypeService mimeTypeService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private static final List<QName> EXCLUDED_PROPS = Arrays.asList(QuickShareModel.PROP_QSHARE_SHAREDBY, QuickShareModel.PROP_QSHARE_SHAREDID);
    private static final Set<String> FIND_SHARED_LINKS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("sharedByUser"));

    public void setServiceRegistry(ServiceRegistry sr) {
        this.sr = sr;
    }

    public void setQuickShareService(QuickShareService quickShareService) {
        this.quickShareService = quickShareService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setRenditions(Renditions renditions) {
        this.renditions = renditions;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"sr", (Object)this.sr);
        ParameterCheck.mandatory((String)"quickShareService", (Object)this.quickShareService);
        ParameterCheck.mandatory((String)"nodes", (Object)this.nodes);
        this.nodeService = this.sr.getNodeService();
        this.personService = this.sr.getPersonService();
        this.mimeTypeService = this.sr.getMimetypeService();
        this.searchService = this.sr.getSearchService();
        this.dictionaryService = this.sr.getDictionaryService();
        this.namespaceService = this.sr.getNamespaceService();
    }

    @Override
    public QuickShareLink readById(final String sharedId, final Parameters parameters) {
        this.checkEnabled();
        try {
            Pair pair = this.quickShareService.getTenantNodeRefFromSharedId(sharedId);
            String networkTenantDomain = (String)pair.getFirst();
            return (QuickShareLink)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<QuickShareLink>(){

                public QuickShareLink doWork() throws Exception {
                    return QuickShareLinksImpl.this.getQuickShareInfo(sharedId, true, parameters.getInclude());
                }
            }, (String)networkTenantDomain);
        }
        catch (InvalidSharedIdException ex) {
            logger.warn((Object)("Unable to find: " + sharedId));
            throw new EntityNotFoundException(sharedId);
        }
    }

    @Override
    public BinaryResource readProperty(String sharedId, String renditionId, Parameters parameters) throws EntityNotFoundException {
        this.checkEnabled();
        this.checkValidShareId(sharedId);
        try {
            Pair pair = this.quickShareService.getTenantNodeRefFromSharedId(sharedId);
            String networkTenantDomain = (String)pair.getFirst();
            NodeRef nodeRef = (NodeRef)pair.getSecond();
            return (BinaryResource)TenantUtil.runAsSystemTenant(() -> {
                if (!this.nodeService.hasAspect(nodeRef, QuickShareModel.ASPECT_QSHARE)) {
                    throw new InvalidNodeRefException(nodeRef);
                }
                if (renditionId != null) {
                    return this.renditions.getContent(nodeRef, renditionId, parameters);
                }
                return this.nodes.getContent(nodeRef, parameters, false);
            }, (String)networkTenantDomain);
        }
        catch (InvalidSharedIdException ex) {
            logger.warn((Object)("Unable to find: " + sharedId));
            throw new EntityNotFoundException(sharedId);
        }
        catch (InvalidNodeRefException inre) {
            logger.warn((Object)("Unable to find: " + sharedId + " [" + String.valueOf(inre.getNodeRef()) + "]"));
            throw new EntityNotFoundException(sharedId);
        }
    }

    @Override
    public void delete(String sharedId, Parameters parameters) {
        this.checkEnabled();
        this.checkValidShareId(sharedId);
        try {
            Pair pair = this.quickShareService.getTenantNodeRefFromSharedId(sharedId);
            String networkTenantDomain = (String)pair.getFirst();
            TenantUtil.runAsSystemTenant(() -> {
                this.checkIfCanDeleteSharedLink(sharedId);
                this.quickShareService.unshareContent(sharedId);
                return null;
            }, (String)networkTenantDomain);
        }
        catch (InvalidSharedIdException ex) {
            logger.warn((Object)("Unable to find: " + sharedId));
            throw new EntityNotFoundException(sharedId);
        }
        catch (InvalidNodeRefException inre) {
            logger.warn((Object)("Unable to find: " + sharedId + " [" + String.valueOf(inre.getNodeRef()) + "]"));
            throw new EntityNotFoundException(sharedId);
        }
    }

    @Override
    public List<QuickShareLink> create(List<QuickShareLink> nodeIds, Parameters parameters) {
        this.checkEnabled();
        ArrayList<QuickShareLink> result = new ArrayList<QuickShareLink>(nodeIds.size());
        List<String> includeParam = parameters != null ? parameters.getInclude() : Collections.emptyList();
        for (QuickShareLink qs : nodeIds) {
            String nodeId = qs.getNodeId();
            if (nodeId == null) {
                throw new InvalidArgumentException("A valid nodeId must be specified !");
            }
            NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
            try {
                String sharedId = (String)((Object)this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
                if (sharedId != null) {
                    throw new ConstraintViolatedException("sharedId already exists: " + nodeId + " [" + sharedId + "]");
                }
                try {
                    QuickShareDTO qsDto = this.quickShareService.shareContent(nodeRef, qs.getExpiresAt());
                    result.add(this.getQuickShareInfo(qsDto.getId(), false, includeParam));
                }
                catch (InvalidNodeRefException inre) {
                    throw new InvalidArgumentException("Unable to create shared link to non-file content: " + nodeId);
                }
                catch (QuickShareLinkExpiryActionException ex) {
                    throw new InvalidArgumentException(ex.getMessage());
                }
            }
            catch (AccessDeniedException ade) {
                throw new PermissionDeniedException("Unable to create shared link to node that does not exist: " + nodeId);
            }
            catch (InvalidNodeRefException inre) {
                logger.warn((Object)("Unable to create shared link: [" + String.valueOf(nodeRef) + "]"));
                throw new EntityNotFoundException(nodeId);
            }
        }
        return result;
    }

    @Override
    public void emailSharedLink(String sharedId, QuickShareLinkEmailRequest emailRequest, Parameters parameters) {
        this.checkEnabled();
        this.checkValidShareId(sharedId);
        this.validateEmailRequest(emailRequest);
        try {
            NodeRef nodeRef = (NodeRef)this.quickShareService.getTenantNodeRefFromSharedId(sharedId).getSecond();
            String sharedNodeName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            QuickShareServiceImpl.QuickShareEmailRequest request = new QuickShareServiceImpl.QuickShareEmailRequest();
            request.setSharedNodeName(sharedNodeName);
            request.setClient(emailRequest.getClient());
            request.setSharedId(sharedId);
            request.setSenderMessage(emailRequest.getMessage());
            request.setLocale(I18NUtil.parseLocale((String)emailRequest.getLocale()));
            request.setToEmails(emailRequest.getRecipientEmails());
            this.quickShareService.sendEmailNotification(request);
        }
        catch (InvalidSharedIdException ex) {
            throw new EntityNotFoundException(sharedId);
        }
        catch (InvalidNodeRefException inre) {
            logger.warn((Object)("Unable to find: " + sharedId + " [" + String.valueOf(inre.getNodeRef()) + "]"));
            throw new EntityNotFoundException(sharedId);
        }
    }

    private Parameters getParamsWithCreatedStatus() {
        String filterStatusCreated = "(status='" + String.valueOf((Object)Rendition.RenditionStatus.CREATED) + "')";
        Query whereQuery = this.getWhereClause(filterStatusCreated);
        Params.RecognizedParams recParams = new Params.RecognizedParams(null, null, null, null, null, null, whereQuery, null, false);
        Params params = Params.valueOf(recParams, null, null, null);
        return params;
    }

    @Override
    public Rendition getRendition(String sharedId, String renditionId) {
        this.checkEnabled();
        this.checkValidShareId(sharedId);
        try {
            Pair pair = this.quickShareService.getTenantNodeRefFromSharedId(sharedId);
            String networkTenantDomain = (String)pair.getFirst();
            NodeRef nodeRef = (NodeRef)pair.getSecond();
            return (Rendition)TenantUtil.runAsSystemTenant(() -> {
                Parameters params = this.getParamsWithCreatedStatus();
                return this.renditions.getRendition(nodeRef, renditionId, params);
            }, (String)networkTenantDomain);
        }
        catch (InvalidSharedIdException ex) {
            logger.warn((Object)("Unable to find: " + sharedId));
            throw new EntityNotFoundException(sharedId);
        }
        catch (InvalidNodeRefException inre) {
            logger.warn((Object)("Unable to find: " + sharedId + " [" + String.valueOf(inre.getNodeRef()) + "]"));
            throw new EntityNotFoundException(sharedId);
        }
    }

    @Override
    public CollectionWithPagingInfo<Rendition> getRenditions(String sharedId) {
        this.checkEnabled();
        this.checkValidShareId(sharedId);
        try {
            Pair pair = this.quickShareService.getTenantNodeRefFromSharedId(sharedId);
            String networkTenantDomain = (String)pair.getFirst();
            NodeRef nodeRef = (NodeRef)pair.getSecond();
            return (CollectionWithPagingInfo)TenantUtil.runAsSystemTenant(() -> {
                Parameters params = this.getParamsWithCreatedStatus();
                return this.renditions.getRenditions(nodeRef, params);
            }, (String)networkTenantDomain);
        }
        catch (InvalidSharedIdException ex) {
            logger.warn((Object)("Unable to find: " + sharedId));
            throw new EntityNotFoundException(sharedId);
        }
        catch (InvalidNodeRefException inre) {
            logger.warn((Object)("Unable to find: " + sharedId + " [" + String.valueOf(inre.getNodeRef()) + "]"));
            throw new EntityNotFoundException(sharedId);
        }
    }

    @Override
    public CollectionWithPagingInfo<QuickShareLink> findLinks(Parameters parameters) {
        this.checkEnabled();
        String queryString = "ASPECT:\"" + QuickShareModel.ASPECT_QSHARE.toString() + "\"";
        SearchParameters sp = new SearchParameters();
        Query q = parameters.getQuery();
        if (q != null) {
            MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(FIND_SHARED_LINKS_QUERY_PROPERTIES, null);
            QueryHelper.walk(q, propertyWalker);
            String sharedByUserId = propertyWalker.getProperty("sharedByUser", 8, String.class);
            if (sharedByUserId != null) {
                if ("-me-".equalsIgnoreCase(sharedByUserId)) {
                    sharedByUserId = AuthenticationUtil.getFullyAuthenticatedUser();
                }
                QueryParameterDefImpl qpd = new QueryParameterDefImpl(QuickShareModel.PROP_QSHARE_SHAREDBY, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, sharedByUserId);
                sp.addQueryParameterDefinition((QueryParameterDefinition)qpd);
                String qsharedBy = QuickShareModel.PROP_QSHARE_SHAREDBY.toPrefixString((NamespacePrefixResolver)this.namespaceService);
                queryString = queryString + " +@" + SearchLanguageConversion.escapeLuceneQuery((String)qsharedBy) + ":\"${" + qsharedBy + "}\"";
            }
        }
        sp.setLanguage("lucene");
        sp.setQuery(queryString);
        sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        Paging paging = parameters.getPaging();
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        sp.setSkipCount(pagingRequest.getSkipCount());
        sp.setMaxItems(pagingRequest.getMaxItems());
        sp.addSort("@" + String.valueOf(ContentModel.PROP_MODIFIED), false);
        ResultSet results = this.searchService.query(sp);
        ArrayList<QuickShareLink> qsLinks = new ArrayList<QuickShareLink>(results.length());
        List<String> includeParam = parameters.getInclude();
        for (ResultSetRow row : results) {
            NodeRef nodeRef = row.getNodeRef();
            qsLinks.add(this.getQuickShareInfo(nodeRef, false, includeParam));
        }
        results.close();
        return CollectionWithPagingInfo.asPaged(paging, qsLinks, results.hasMore(), Long.valueOf(results.getNumberFound()).intValue());
    }

    private QuickShareLink getQuickShareInfo(String sharedId, boolean noAuth, List<String> includeParam) {
        this.checkValidShareId(sharedId);
        Map map = (Map)this.quickShareService.getMetaData(sharedId).get("item");
        NodeRef nodeRef = new NodeRef((String)map.get("nodeRef"));
        return this.getQuickShareInfo(nodeRef, map, noAuth, includeParam);
    }

    private QuickShareLink getQuickShareInfo(NodeRef nodeRef, boolean noAuth, List<String> includeParam) {
        Map map = (Map)this.quickShareService.getMetaData(nodeRef).get("item");
        return this.getQuickShareInfo(nodeRef, map, noAuth, includeParam);
    }

    private QuickShareLink getQuickShareInfo(NodeRef nodeRef, Map<String, Object> map, boolean noAuth, List<String> includeParam) {
        String sharedId = (String)map.get("sharedId");
        try {
            Map nodeProps = this.nodeService.getProperties(nodeRef);
            ContentData cd = (ContentData)nodeProps.get(ContentModel.PROP_CONTENT);
            String mimeType = cd.getMimetype();
            String mimeTypeName = (String)this.mimeTypeService.getDisplaysByMimetype().get(mimeType);
            ContentInfo contentInfo = new ContentInfo(mimeType, mimeTypeName, cd.getSize(), cd.getEncoding());
            HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>(2);
            boolean displayNameOnly = noAuth;
            UserInfo modifiedByUser = Node.lookupUserInfo((String)nodeProps.get(ContentModel.PROP_MODIFIER), mapUserInfo, this.personService, displayNameOnly);
            String sharedByUserId = (String)nodeProps.get(QuickShareModel.PROP_QSHARE_SHAREDBY);
            UserInfo sharedByUser = Node.lookupUserInfo(sharedByUserId, mapUserInfo, this.personService, displayNameOnly);
            QuickShareLink qs = new QuickShareLink(sharedId, nodeRef.getId());
            qs.setName((String)map.get("name"));
            qs.setTitle((String)map.get("title"));
            qs.setDescription((String)map.get("description"));
            qs.setContent(contentInfo);
            qs.setModifiedAt((Date)map.get("modified"));
            qs.setModifiedByUser(modifiedByUser);
            qs.setSharedByUser(sharedByUser);
            qs.setExpiresAt((Date)map.get("expiryDate"));
            if (!noAuth) {
                Node doc = null;
                if (includeParam.contains("allowableOperations")) {
                    if (this.quickShareService.canDeleteSharedLink(nodeRef, sharedByUserId)) {
                        qs.setAllowableOperations(Collections.singletonList("delete"));
                    }
                    doc = this.getNode(nodeRef, includeParam, mapUserInfo);
                    List<String> allowableOps = doc.getAllowableOperations();
                    qs.setAllowableOperationsOnTarget(allowableOps);
                }
                if (includeParam.contains("path")) {
                    qs.setPath(this.nodes.lookupPathInfo(nodeRef, null));
                }
                if (includeParam.contains("properties")) {
                    if (doc == null) {
                        doc = this.getNode(nodeRef, includeParam, mapUserInfo);
                    }
                    Map<String, Object> filteredNodeProperties = this.filterProps(doc.getProperties(), EXCLUDED_PROPS);
                    qs.setProperties(filteredNodeProperties);
                }
                if (includeParam.contains("isFavorite")) {
                    if (doc == null) {
                        doc = this.getNode(nodeRef, includeParam, mapUserInfo);
                    }
                    qs.setIsFavorite(doc.getIsFavorite());
                }
                if (includeParam.contains("aspectNames")) {
                    if (doc == null) {
                        doc = this.getNode(nodeRef, includeParam, mapUserInfo);
                    }
                    qs.setAspectNames(doc.getAspectNames());
                }
            }
            return qs;
        }
        catch (InvalidSharedIdException ex) {
            logger.warn((Object)("Unable to find: " + sharedId));
            throw new EntityNotFoundException(sharedId);
        }
        catch (InvalidNodeRefException inre) {
            logger.warn((Object)("Unable to find: " + sharedId + " [" + String.valueOf(inre.getNodeRef()) + "]"));
            throw new EntityNotFoundException(sharedId);
        }
    }

    private Map<String, Object> filterProps(Map<String, Object> properties, List<QName> toRemove) {
        HashMap<String, Object> filteredProps = properties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(properties);
        List propsToRemove = toRemove.stream().map(e -> e.toPrefixString((NamespacePrefixResolver)this.namespaceService)).collect(Collectors.toList());
        filteredProps.keySet().removeAll(propsToRemove);
        return filteredProps;
    }

    private Node getNode(NodeRef nodeRef, List<String> includeParam, Map<String, UserInfo> mapUserInfo) {
        LinkedList<String> modifiedIncludeParams = new LinkedList<String>(includeParam);
        modifiedIncludeParams.remove("path");
        return this.nodes.getFolderOrDocument(nodeRef, null, null, modifiedIncludeParams, mapUserInfo);
    }

    private void checkEnabled() {
        if (!this.enabled) {
            throw new DisabledServiceException(DISABLED);
        }
    }

    private void checkValidShareId(String sharedId) {
        if (sharedId == null) {
            throw new InvalidArgumentException("A valid sharedId must be specified !");
        }
    }

    private void validateEmailRequest(QuickShareLinkEmailRequest emailRequest) {
        if (StringUtils.isEmpty((CharSequence)emailRequest.getClient())) {
            throw new InvalidArgumentException("A valid client must be specified.");
        }
        if (emailRequest.getRecipientEmails() == null || emailRequest.getRecipientEmails().isEmpty()) {
            throw new InvalidArgumentException("A valid recipientEmail must be specified.");
        }
    }

    private void checkIfCanDeleteSharedLink(String sharedId) {
        String sharedByUserId;
        NodeRef nodeRef = (NodeRef)this.quickShareService.getTenantNodeRefFromSharedId(sharedId).getSecond();
        if (!this.quickShareService.canDeleteSharedLink(nodeRef, sharedByUserId = (String)((Object)this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDBY)))) {
            throw new PermissionDeniedException("Can't perform unshare action: " + sharedId);
        }
    }
}

