/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.tenant;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Base64;

public class TenantAdminSystemTest
extends TestCase {
    private static Log logger = LogFactory.getLog(TenantAdminSystemTest.class);
    private static final String REPO = "http://localhost:8080/alfresco";
    private static final String WEBSCRIPT_ENDPOINT = "http://localhost:8080/alfresco/service";
    private static final String URL_TENANTS = "/api/tenants";
    private static final String ADMIN_USER = "admin";
    private static final String ADMIN_PW = "admin";
    private static final String TENANT_PREFIX = "t" + System.currentTimeMillis() + "-";
    private static final int T_CNT = 5;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLogin() throws Exception {
        String ticket = TenantAdminSystemTest.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        TenantAdminSystemTest.assertNotNull((Object)ticket);
    }

    public void testCreateTenants() throws Exception {
        TenantAdminSystemTest.runWorkers(1, 5, Op.CREATE_TENANT);
    }

    protected static void createTenant(String tenantDomain, String ticket) throws Exception {
        JSONObject tenant = new JSONObject();
        tenant.put("tenantDomain", (Object)tenantDomain);
        tenant.put("tenantAdminPassword", (Object)tenantDomain);
        String url = "http://localhost:8080/alfresco/service/api/tenants";
        String response = TenantAdminSystemTest.callPostWebScript(url, ticket, tenant.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createTenant: " + tenantDomain));
            logger.debug((Object)"----------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }

    public void testGetTenants() throws Exception {
        String ticket = TenantAdminSystemTest.callLoginWebScript(WEBSCRIPT_ENDPOINT, "admin", "admin");
        this.getTenants(ticket);
    }

    protected void getTenants(String ticket) throws Exception {
        String url = "http://localhost:8080/alfresco/service/api/tenants";
        String response = TenantAdminSystemTest.callGetWebScript(url, ticket);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getTenants:");
            logger.debug((Object)"-------");
            logger.debug((Object)url);
            logger.debug((Object)response);
        }
    }

    protected static String callGetWebScript(String urlString, String ticket) throws MalformedURLException, URISyntaxException, IOException {
        return TenantAdminSystemTest.callOutWebScript(urlString, "GET", ticket);
    }

    protected static String callDeleteWebScript(String urlString, String ticket) throws MalformedURLException, URISyntaxException, IOException {
        return TenantAdminSystemTest.callOutWebScript(urlString, "DELETE", ticket);
    }

    protected static String callPostWebScript(String urlString, String ticket, String data) throws MalformedURLException, URISyntaxException, IOException {
        return TenantAdminSystemTest.callInOutWebScript(urlString, "POST", ticket, data);
    }

    protected static String callPutWebScript(String urlString, String ticket, String data) throws MalformedURLException, URISyntaxException, IOException {
        return TenantAdminSystemTest.callInOutWebScript(urlString, "PUT", ticket, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String callOutWebScript(String urlString, String method, String ticket) throws MalformedURLException, URISyntaxException, IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        if (ticket != null) {
            conn.addRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])ticket.getBytes()));
        }
        String result = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            result = sb.toString();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    private static String callInOutWebScript(String urlString, String method, String ticket, String data) throws MalformedURLException, URISyntaxException, IOException {
        return TenantAdminSystemTest.callInOutWeb(urlString, method, ticket, data, "application/json", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String callInOutWeb(String urlString, String method, String ticket, String data, String contentType, String soapAction) throws MalformedURLException, URISyntaxException, IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-type", contentType);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        if (soapAction != null) {
            conn.setRequestProperty("SOAPAction", soapAction);
        }
        if (ticket != null) {
            conn.addRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])ticket.getBytes()));
        }
        String result = null;
        BufferedReader br = null;
        FilterOutputStream wr = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            os = conn.getOutputStream();
            wr = new DataOutputStream(os);
            wr.write(data.getBytes());
            ((DataOutputStream)wr).flush();
        }
        finally {
            if (wr != null) {
                wr.close();
            }
            if (os != null) {
                os.close();
            }
        }
        try {
            is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            result = sb.toString();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    protected static String callLoginWebScript(String serviceUrl, String username, String password) throws MalformedURLException, URISyntaxException, IOException {
        String ticketResult = TenantAdminSystemTest.callGetWebScript(serviceUrl + "/api/login?u=" + username + "&pw=" + password, null);
        if (ticketResult != null) {
            int startTag = ticketResult.indexOf("<ticket>");
            int endTag = ticketResult.indexOf("</ticket>");
            if (startTag != -1 && endTag != -1) {
                ticketResult = ticketResult.substring(startTag + "<ticket>".length(), endTag);
            }
        }
        return ticketResult;
    }

    private static void runWorkers(int threadCount, int threadBatch, Op mode) {
        logger.info((Object)("Start: Mode " + String.valueOf((Object)mode) + " [" + threadCount + "]"));
        long start = System.currentTimeMillis();
        Thread[] threads = new Thread[threadCount];
        Worker[] nesters = new Worker[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            Worker nester;
            int startId = i * threadBatch + 1;
            int endId = (i + 1) * threadBatch;
            nesters[i] = nester = new Worker(mode, startId, endId);
            threads[i] = new Thread(nester);
            threads[i].start();
        }
        int totalCnt = 0;
        long totalTime = 0L;
        for (int i = 0; i < threadCount; ++i) {
            try {
                threads[i].join();
                if (nesters[i].getErrorStackTrace() != null) {
                    throw new RuntimeException(nesters[i].getErrorStackTrace());
                }
                if (nesters[i].getOpTime() == null) continue;
                totalTime += nesters[i].getOpTime().longValue();
                ++totalCnt;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.info((Object)("Finish: Mode " + String.valueOf((Object)mode) + " [threadCount=" + threadCount + ", threadBatch=" + threadBatch + "] in " + (System.currentTimeMillis() - start) + " ms (avg per thread = " + totalTime / (long)totalCnt + " ms)"));
    }

    public static enum Op {
        CREATE_TENANT;

    }

    private static class Worker
    implements Runnable {
        private Op op;
        private int startId;
        private int endId;
        private String errorStackTrace = null;
        private Long opTime;

        Worker(Op mode, int startId, int endId) {
            this.op = mode;
            this.startId = startId;
            this.endId = endId;
        }

        public String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        public Long getOpTime() {
            return this.opTime;
        }

        @Override
        public void run() {
            String tenantDomain = null;
            try {
                long start = System.currentTimeMillis();
                logger.info((Object)("Start: Mode " + String.valueOf((Object)this.op) + " (" + this.startId + " to " + this.endId + ") [ThreadId=" + Thread.currentThread().getId() + "]"));
                block5: for (int i = this.startId; i <= this.endId; ++i) {
                    tenantDomain = TENANT_PREFIX + String.format("%05d", i);
                    switch (this.op) {
                        case CREATE_TENANT: {
                            String ticket = TenantAdminSystemTest.callLoginWebScript(TenantAdminSystemTest.WEBSCRIPT_ENDPOINT, "admin", "admin");
                            TenantAdminSystemTest.createTenant(TENANT_PREFIX + "--" + String.format("%05d", i), ticket);
                            continue block5;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported op type: " + String.valueOf((Object)this.op));
                        }
                    }
                }
                this.opTime = System.currentTimeMillis() - start;
                logger.info((Object)("Finish: Mode " + String.valueOf((Object)this.op) + " (" + this.startId + " to " + this.endId + ") [ThreadId=" + Thread.currentThread().getId() + "] in " + this.opTime + " ms"));
            }
            catch (Throwable t) {
                logger.error((Object)("End " + tenantDomain + " with error " + t.getMessage()));
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                this.errorStackTrace = sw.toString();
            }
        }
    }
}

