/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import org.alfresco.rest.api.ContentStorageInformation;
import org.alfresco.rest.api.model.ArchiveContentRequest;
import org.alfresco.rest.api.model.ContentStorageInfo;
import org.alfresco.rest.api.model.RestoreArchivedContentRequest;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="storage-info", entityResource=NodesEntityResource.class, title="Node's content storage information")
public class NodeStorageInfoRelation
implements RelationshipResourceAction.ReadById<ContentStorageInfo>,
InitializingBean {
    private final ContentStorageInformation storageInformation;

    public NodeStorageInfoRelation(ContentStorageInformation storageInformation) {
        this.storageInformation = storageInformation;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"storageInformation", (Object)this.storageInformation);
    }

    @Override
    @WebApiDescription(title="Get storage properties", description="Retrieves storage properties for given node's content", successStatus=200)
    public ContentStorageInfo readById(String nodeId, String contentPropName, Parameters parameters) throws RelationshipResourceNotFoundException {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.storageInformation.getStorageInfo(nodeRef, contentPropName, parameters);
    }

    @Operation(value="archive")
    @WebApiParam(name="archiveContentRequest", title="Request for archive content", description="Optional parameters for archive content", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request send content to archive", description="Submits a request to send content to archive", successStatus=200)
    public void requestArchiveContent(String nodeId, String contentPropName, ArchiveContentRequest archiveContentRequest, Parameters parameters, WithResponse withResponse) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        boolean result = this.storageInformation.requestArchiveContent(nodeRef, contentPropName, archiveContentRequest);
        if (result) {
            withResponse.setStatus(200);
        } else {
            withResponse.setStatus(501);
        }
    }

    @Operation(value="archive-restore")
    @WebApiParam(name="restoreArchivedContentRequest", title="Request for restore content from archive", description="Optional parameters for restore content from archive", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request restore content from archive", description="Submits a request to restore content from archive", successStatus=202)
    public void requestRestoreContentFromArchive(String nodeId, String contentPropName, RestoreArchivedContentRequest restoreArchivedContentRequest, Parameters parameters, WithResponse withResponse) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        boolean result = this.storageInformation.requestRestoreContentFromArchive(nodeRef, contentPropName, restoreArchivedContentRequest);
        if (result) {
            withResponse.setStatus(202);
        } else {
            withResponse.setStatus(501);
        }
    }
}

